#! /usr/bin/env python
from setuptools import setup

def linelist(text):
    """
    Returns each non-blank line in text enclosed in a list.
    """
    return [ l.strip() for l in text.strip().splitlines() if l.strip() ]
    

setup(
    name='intspan',
    version='0.701',
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description="Sets of integers like 1,3-7,33. Inspired by Perl's Set::IntSpan",
    long_description=open('README.rst').read(),
    url='https://bitbucket.org/jeunice/intspan',
    py_modules=['intspan'],
    install_requires=[],
    tests_require = ['tox', 'pytest'],
    zip_safe = True,
    keywords='integer set span range intspan intrange',
    classifiers=linelist("""
        Development Status :: 4 - Beta
        Operating System :: OS Independent
        License :: OSI Approved :: BSD License
        Intended Audience :: Developers
        Programming Language :: Python
        Programming Language :: Python :: 2.6
        Programming Language :: Python :: 2.7
        Programming Language :: Python :: 3
        Programming Language :: Python :: 3.2
        Programming Language :: Python :: 3.3
        Programming Language :: Python :: Implementation :: CPython
        Programming Language :: Python :: Implementation :: PyPy
        Topic :: Software Development :: Libraries :: Python Modules
    """)
)
