#!/usr/bin/env python

#
# Generated Fri Apr 16 19:44:07 2010 by generateDS.py version 1.20e.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node
import iodef.base

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def showIndentS( level):
    expStr = ''
    for idx in range(level):
        expStr += '    '
    return expStr
        
def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportS(self, level, name, namespace):
        expStr = ''
        if self.category == MixedContainer.CategoryText:
            expStr += self.value
        elif self.category == MixedContainer.CategorySimple:
            expStr += self.exportSimpleS( level, name)
        else:    # category == MixedContainer.CategoryComplex
            expStr += self.value.exportS( level, namespace,name)
        return expStr
    def exportSimpleS(self, level, name):
        expStr = ''
        if self.content_type == MixedContainer.TypeString:
            expStr += '<%s>%s</%s>' % (self.name, self.value, self.name)
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            expStr += '<%s>%d</%s>' % (self.name, self.value, self.name)
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            expStr += '<%s>%f</%s>' % (self.name, self.value, self.name)
        elif self.content_type == MixedContainer.TypeDouble:
            expStr += '<%s>%g</%s>' % (self.name, self.value, self.name)
        return expStr
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class PhraudReport(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ext_value=None, Version='1.0', FraudType=None, PhishNameRef=None, PhishNameLocalRef=None, FraudParameter=None, FraudedBrandName=None, LureSource=None, OriginatingSensor=None, EmailRecord=None, DCSite=None, TakeDownInfo=None, ArchivedData=None, RelatedData=None, CorrelationData=None, PRComments=None):
        self.ext_value = _cast(None, ext_value)
        self.Version = _cast(None, Version)
        self.FraudType = _cast(None, FraudType)
        self.PhishNameRef = PhishNameRef
        self.PhishNameLocalRef = PhishNameLocalRef
        self.FraudParameter = FraudParameter
        if FraudedBrandName is None:
            self.FraudedBrandName = []
        else:
            self.FraudedBrandName = FraudedBrandName
        if LureSource is None:
            self.LureSource = []
        else:
            self.LureSource = LureSource
        if OriginatingSensor is None:
            self.OriginatingSensor = []
        else:
            self.OriginatingSensor = OriginatingSensor
        self.EmailRecord = EmailRecord
        if DCSite is None:
            self.DCSite = []
        else:
            self.DCSite = DCSite
        if TakeDownInfo is None:
            self.TakeDownInfo = []
        else:
            self.TakeDownInfo = TakeDownInfo
        if ArchivedData is None:
            self.ArchivedData = []
        else:
            self.ArchivedData = ArchivedData
        if RelatedData is None:
            self.RelatedData = []
        else:
            self.RelatedData = RelatedData
        if CorrelationData is None:
            self.CorrelationData = []
        else:
            self.CorrelationData = CorrelationData
        self.PRComments = PRComments
    def factory(*args_, **kwargs_):
        if PhraudReport.subclass:
            return PhraudReport.subclass(*args_, **kwargs_)
        else:
            return PhraudReport(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PhishNameRef(self): return self.PhishNameRef
    def set_PhishNameRef(self, PhishNameRef): self.PhishNameRef = PhishNameRef
    def get_PhishNameLocalRef(self): return self.PhishNameLocalRef
    def set_PhishNameLocalRef(self, PhishNameLocalRef): self.PhishNameLocalRef = PhishNameLocalRef
    def get_FraudParameter(self): return self.FraudParameter
    def set_FraudParameter(self, FraudParameter): self.FraudParameter = FraudParameter
    def get_FraudedBrandName(self): return self.FraudedBrandName
    def set_FraudedBrandName(self, FraudedBrandName): self.FraudedBrandName = FraudedBrandName
    def add_FraudedBrandName(self, value): self.FraudedBrandName.append(value)
    def insert_FraudedBrandName(self, index, value): self.FraudedBrandName[index] = value
    def get_LureSource(self): return self.LureSource
    def set_LureSource(self, LureSource): self.LureSource = LureSource
    def add_LureSource(self, value): self.LureSource.append(value)
    def insert_LureSource(self, index, value): self.LureSource[index] = value
    def get_OriginatingSensor(self): return self.OriginatingSensor
    def set_OriginatingSensor(self, OriginatingSensor): self.OriginatingSensor = OriginatingSensor
    def add_OriginatingSensor(self, value): self.OriginatingSensor.append(value)
    def insert_OriginatingSensor(self, index, value): self.OriginatingSensor[index] = value
    def get_EmailRecord(self): return self.EmailRecord
    def set_EmailRecord(self, EmailRecord): self.EmailRecord = EmailRecord
    def get_DCSite(self): return self.DCSite
    def set_DCSite(self, DCSite): self.DCSite = DCSite
    def add_DCSite(self, value): self.DCSite.append(value)
    def insert_DCSite(self, index, value): self.DCSite[index] = value
    def get_TakeDownInfo(self): return self.TakeDownInfo
    def set_TakeDownInfo(self, TakeDownInfo): self.TakeDownInfo = TakeDownInfo
    def add_TakeDownInfo(self, value): self.TakeDownInfo.append(value)
    def insert_TakeDownInfo(self, index, value): self.TakeDownInfo[index] = value
    def get_ArchivedData(self): return self.ArchivedData
    def set_ArchivedData(self, ArchivedData): self.ArchivedData = ArchivedData
    def add_ArchivedData(self, value): self.ArchivedData.append(value)
    def insert_ArchivedData(self, index, value): self.ArchivedData[index] = value
    def get_RelatedData(self): return self.RelatedData
    def set_RelatedData(self, RelatedData): self.RelatedData = RelatedData
    def add_RelatedData(self, value): self.RelatedData.append(value)
    def insert_RelatedData(self, index, value): self.RelatedData[index] = value
    def get_CorrelationData(self): return self.CorrelationData
    def set_CorrelationData(self, CorrelationData): self.CorrelationData = CorrelationData
    def add_CorrelationData(self, value): self.CorrelationData.append(value)
    def insert_CorrelationData(self, index, value): self.CorrelationData[index] = value
    def get_PRComments(self): return self.PRComments
    def set_PRComments(self, PRComments): self.PRComments = PRComments
    def get_ext_value(self): return self.ext_value
    def set_ext_value(self, ext_value): self.ext_value = ext_value
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_FraudType(self): return self.FraudType
    def set_FraudType(self, FraudType): self.FraudType = FraudType
    def export(self, outfile, level, namespace_='phish:', name_='PhraudReport', namespacedef_='xmlns:phish="urn:ietf:params:xml:ns:iodef-phish-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PhraudReport')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='PhraudReport'):
        if self.ext_value is not None:
            outfile.write(' ext-value=%s' % (self.format_string(quote_attrib(self.ext_value).encode(ExternalEncoding), input_name='ext-value'), ))
        if self.Version is not None:
            outfile.write(' Version=%s' % (self.format_string(quote_attrib(self.Version).encode(ExternalEncoding), input_name='Version'), ))
        outfile.write(' FraudType=%s' % (quote_attrib(self.FraudType), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='PhraudReport'):
        if self.PhishNameRef is not None:
            showIndent(outfile, level)
            outfile.write('<%sPhishNameRef>%s</%sPhishNameRef>\n' % (namespace_, self.format_string(quote_xml(self.PhishNameRef).encode(ExternalEncoding), input_name='PhishNameRef'), namespace_))
        if self.PhishNameLocalRef is not None:
            showIndent(outfile, level)
            outfile.write('<%sPhishNameLocalRef>%s</%sPhishNameLocalRef>\n' % (namespace_, self.format_string(quote_xml(self.PhishNameLocalRef).encode(ExternalEncoding), input_name='PhishNameLocalRef'), namespace_))
        if self.FraudParameter is not None:
            showIndent(outfile, level)
            outfile.write('<%sFraudParameter>%s</%sFraudParameter>\n' % (namespace_, self.format_string(quote_xml(self.FraudParameter).encode(ExternalEncoding), input_name='FraudParameter'), namespace_))
        for FraudedBrandName_ in self.FraudedBrandName:
            showIndent(outfile, level)
            outfile.write('<%sFraudedBrandName>%s</%sFraudedBrandName>\n' % (namespace_, self.format_string(quote_xml(FraudedBrandName_).encode(ExternalEncoding), input_name='FraudedBrandName'), namespace_))
        for LureSource_ in self.LureSource:
            LureSource_.export(outfile, level, namespace_, name_='LureSource')
        for OriginatingSensor_ in self.OriginatingSensor:
            OriginatingSensor_.export(outfile, level, namespace_, name_='OriginatingSensor')
        if self.EmailRecord:
            self.EmailRecord.export(outfile, level, namespace_, name_='EmailRecord')
        for DCSite_ in self.DCSite:
            DCSite_.export(outfile, level, namespace_, name_='DCSite')
        for TakeDownInfo_ in self.TakeDownInfo:
            TakeDownInfo_.export(outfile, level, namespace_, name_='TakeDownInfo')
        for ArchivedData_ in self.ArchivedData:
            ArchivedData_.export(outfile, level, namespace_, name_='ArchivedData')
        for RelatedData_ in self.RelatedData:
            showIndent(outfile, level)
            outfile.write('<%sRelatedData>%s</%sRelatedData>\n' % (namespace_, self.format_string(quote_xml(RelatedData_).encode(ExternalEncoding), input_name='RelatedData'), namespace_))
        for CorrelationData_ in self.CorrelationData:
            showIndent(outfile, level)
            outfile.write('<%sCorrelationData>%s</%sCorrelationData>\n' % (namespace_, self.format_string(quote_xml(CorrelationData_).encode(ExternalEncoding), input_name='CorrelationData'), namespace_))
        if self.PRComments is not None:
            showIndent(outfile, level)
            outfile.write('<%sPRComments>%s</%sPRComments>\n' % (namespace_, self.format_string(quote_xml(self.PRComments).encode(ExternalEncoding), input_name='PRComments'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='PhraudReport', 
namespacedef_='xmlns:phish="urn:ietf:params:xml:ns:iodef-phish-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='PhraudReport')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='PhraudReport'):
        expStr = ''
        if self.ext_value is not None:
            expStr += ' ext-value=%s' % (self.format_string(quote_attrib(self.ext_value).encode(ExternalEncoding), input_name='ext-value'), )
        if self.Version is not None:
            expStr += ' Version=%s' % (self.format_string(quote_attrib(self.Version).encode(ExternalEncoding), input_name='Version'), )
        expStr += ' FraudType=%s' % (quote_attrib(self.FraudType), )
        return expStr
    def exportChildrenS(self, level, namespace_='phish:', name_='PhraudReport'):
        expStr = ''
        if self.PhishNameRef is not None:
            expStr += showIndentS( level)
            expStr += '<%sPhishNameRef>%s</%sPhishNameRef>\n' % (namespace_, self.format_string(quote_xml(self.PhishNameRef).encode(ExternalEncoding), input_name='PhishNameRef'), namespace_)
        if self.PhishNameLocalRef is not None:
            expStr += showIndentS( level)
            expStr += '<%sPhishNameLocalRef>%s</%sPhishNameLocalRef>\n' % (namespace_, self.format_string(quote_xml(self.PhishNameLocalRef).encode(ExternalEncoding), input_name='PhishNameLocalRef'), namespace_)
        if self.FraudParameter is not None:
            expStr += showIndentS( level)
            expStr += '<%sFraudParameter>%s</%sFraudParameter>\n' % (namespace_, self.format_string(quote_xml(self.FraudParameter).encode(ExternalEncoding), input_name='FraudParameter'), namespace_)
        for FraudedBrandName_ in self.FraudedBrandName:
            expStr += showIndentS( level)
            expStr += '<%sFraudedBrandName>%s</%sFraudedBrandName>\n' % (namespace_, self.format_string(quote_xml(FraudedBrandName_).encode(ExternalEncoding), input_name='FraudedBrandName'), namespace_)
        for LureSource_ in self.LureSource:
            expStr += LureSource_.exportS( level, namespace_, name_='LureSource')
        for OriginatingSensor_ in self.OriginatingSensor:
            expStr += OriginatingSensor_.exportS( level, namespace_, name_='OriginatingSensor')
        if self.EmailRecord:
            expStr += self.EmailRecord.exportS( level, namespace_, name_='EmailRecord')
        for DCSite_ in self.DCSite:
            expStr += DCSite_.exportS( level, namespace_, name_='DCSite')
        for TakeDownInfo_ in self.TakeDownInfo:
            expStr += TakeDownInfo_.exportS( level, namespace_, name_='TakeDownInfo')
        for ArchivedData_ in self.ArchivedData:
            expStr += ArchivedData_.exportS( level, namespace_, name_='ArchivedData')
        for RelatedData_ in self.RelatedData:
            expStr += showIndentS( level)
            expStr += '<%sRelatedData>%s</%sRelatedData>\n' % (namespace_, self.format_string(quote_xml(RelatedData_).encode(ExternalEncoding), input_name='RelatedData'), namespace_)
        for CorrelationData_ in self.CorrelationData:
            expStr += showIndentS( level)
            expStr += '<%sCorrelationData>%s</%sCorrelationData>\n' % (namespace_, self.format_string(quote_xml(CorrelationData_).encode(ExternalEncoding), input_name='CorrelationData'), namespace_)
        if self.PRComments is not None:
            expStr += showIndentS( level)
            expStr += '<%sPRComments>%s</%sPRComments>\n' % (namespace_, self.format_string(quote_xml(self.PRComments).encode(ExternalEncoding), input_name='PRComments'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.PhishNameRef is not None or
            self.PhishNameLocalRef is not None or
            self.FraudParameter is not None or
            self.FraudedBrandName or
            self.LureSource or
            self.OriginatingSensor or
            self.EmailRecord is not None or
            self.DCSite or
            self.TakeDownInfo or
            self.ArchivedData or
            self.RelatedData or
            self.CorrelationData or
            self.PRComments is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PhraudReport'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ext_value is not None:
            showIndent(outfile, level)
            outfile.write('ext_value = "%s",\n' % (self.ext_value,))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version = "%s",\n' % (self.Version,))
        if self.FraudType is not None:
            showIndent(outfile, level)
            outfile.write('FraudType = %s,\n' % (self.FraudType,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.PhishNameRef is not None:
            showIndent(outfile, level)
            outfile.write('PhishNameRef=%s,\n' % quote_python(self.PhishNameRef).encode(ExternalEncoding))
        if self.PhishNameLocalRef is not None:
            showIndent(outfile, level)
            outfile.write('PhishNameLocalRef=%s,\n' % quote_python(self.PhishNameLocalRef).encode(ExternalEncoding))
        if self.FraudParameter is not None:
            showIndent(outfile, level)
            outfile.write('FraudParameter=%s,\n' % quote_python(self.FraudParameter).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('FraudedBrandName=[\n')
        level += 1
        for FraudedBrandName_ in self.FraudedBrandName:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(FraudedBrandName_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('LureSource=[\n')
        level += 1
        for LureSource_ in self.LureSource:
            showIndent(outfile, level)
            outfile.write('model_.LureSource_type(\n')
            LureSource_.exportLiteral(outfile, level, name_='LureSource.type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('OriginatingSensor=[\n')
        level += 1
        for OriginatingSensor_ in self.OriginatingSensor:
            showIndent(outfile, level)
            outfile.write('model_.OriginatingSensor_type(\n')
            OriginatingSensor_.exportLiteral(outfile, level, name_='OriginatingSensor.type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.EmailRecord is not None:
            showIndent(outfile, level)
            outfile.write('EmailRecord=model_.EmailRecord_type(\n')
            self.EmailRecord.exportLiteral(outfile, level, name_='EmailRecord')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('DCSite=[\n')
        level += 1
        for DCSite_ in self.DCSite:
            showIndent(outfile, level)
            outfile.write('model_.DCSite_type(\n')
            DCSite_.exportLiteral(outfile, level, name_='DCSite.type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('TakeDownInfo=[\n')
        level += 1
        for TakeDownInfo_ in self.TakeDownInfo:
            showIndent(outfile, level)
            outfile.write('model_.TakeDownInfo(\n')
            TakeDownInfo_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ArchivedData=[\n')
        level += 1
        for ArchivedData_ in self.ArchivedData:
            showIndent(outfile, level)
            outfile.write('model_.ArchivedData(\n')
            ArchivedData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('RelatedData=[\n')
        level += 1
        for RelatedData_ in self.RelatedData:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(RelatedData_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('CorrelationData=[\n')
        level += 1
        for CorrelationData_ in self.CorrelationData:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(CorrelationData_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.PRComments is not None:
            showIndent(outfile, level)
            outfile.write('PRComments=%s,\n' % quote_python(self.PRComments).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ext-value'):
            self.ext_value = attrs.get('ext-value').value
        if attrs.get('Version'):
            self.Version = attrs.get('Version').value
        if attrs.get('FraudType'):
            self.FraudType = attrs.get('FraudType').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'PhishNameRef':
            PhishNameRef_ = ''
            for text__content_ in child_.childNodes:
                PhishNameRef_ += text__content_.nodeValue
            self.PhishNameRef = PhishNameRef_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'PhishNameLocalRef':
            PhishNameLocalRef_ = ''
            for text__content_ in child_.childNodes:
                PhishNameLocalRef_ += text__content_.nodeValue
            self.PhishNameLocalRef = PhishNameLocalRef_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'FraudParameter':
            FraudParameter_ = ''
            for text__content_ in child_.childNodes:
                FraudParameter_ += text__content_.nodeValue
            self.FraudParameter = FraudParameter_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'FraudedBrandName':
            FraudedBrandName_ = ''
            for text__content_ in child_.childNodes:
                FraudedBrandName_ += text__content_.nodeValue
            self.FraudedBrandName.append(FraudedBrandName_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'LureSource':
            obj_ = LureSource_type.factory()
            obj_.build(child_)
            self.LureSource.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'OriginatingSensor':
            obj_ = OriginatingSensor_type.factory()
            obj_.build(child_)
            self.OriginatingSensor.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'EmailRecord':
            obj_ = EmailRecord_type.factory()
            obj_.build(child_)
            self.set_EmailRecord(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DCSite':
            obj_ = DCSite_type.factory()
            obj_.build(child_)
            self.DCSite.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TakeDownInfo':
            obj_ = TakeDownInfo_type.factory()
            obj_.build(child_)
            self.TakeDownInfo.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'ArchivedData':
            obj_ = ArchivedData_type.factory()
            obj_.build(child_)
            self.ArchivedData.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'RelatedData':
            RelatedData_ = ''
            for text__content_ in child_.childNodes:
                RelatedData_ += text__content_.nodeValue
            self.RelatedData.append(RelatedData_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'CorrelationData':
            CorrelationData_ = ''
            for text__content_ in child_.childNodes:
                CorrelationData_ += text__content_.nodeValue
            self.CorrelationData.append(CorrelationData_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'PRComments':
            PRComments_ = ''
            for text__content_ in child_.childNodes:
                PRComments_ += text__content_.nodeValue
            self.PRComments = PRComments_
# end class PhraudReport


class LureSource_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, System=None, DomainData=None, IncludedMalware=None, FilesDownloaded=None, WindowsRegistryKeysModified=None):
        if System is None:
            self.System = []
        else:
            self.System = System
        if DomainData is None:
            self.DomainData = []
        else:
            self.DomainData = DomainData
        self.IncludedMalware = IncludedMalware
        self.FilesDownloaded = FilesDownloaded
        self.WindowsRegistryKeysModified = WindowsRegistryKeysModified
    def factory(*args_, **kwargs_):
        if LureSource_type.subclass:
            return LureSource_type.subclass(*args_, **kwargs_)
        else:
            return LureSource_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def add_System(self, value): self.System.append(value)
    def insert_System(self, index, value): self.System[index] = value
    def get_DomainData(self): return self.DomainData
    def set_DomainData(self, DomainData): self.DomainData = DomainData
    def add_DomainData(self, value): self.DomainData.append(value)
    def insert_DomainData(self, index, value): self.DomainData[index] = value
    def get_IncludedMalware(self): return self.IncludedMalware
    def set_IncludedMalware(self, IncludedMalware): self.IncludedMalware = IncludedMalware
    def get_FilesDownloaded(self): return self.FilesDownloaded
    def set_FilesDownloaded(self, FilesDownloaded): self.FilesDownloaded = FilesDownloaded
    def get_WindowsRegistryKeysModified(self): return self.WindowsRegistryKeysModified
    def set_WindowsRegistryKeysModified(self, WindowsRegistryKeysModified): self.WindowsRegistryKeysModified = WindowsRegistryKeysModified
    def export(self, outfile, level, namespace_='phish:', name_='LureSource.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='LureSource.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='LureSource'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='LureSource'):
        for System_ in self.System:
            System_.export(outfile, level, namespace_='iodef:', name_='System', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"')
        for DomainData_ in self.DomainData:
            DomainData_.export(outfile, level, namespace_, name_='DomainData')
        if self.IncludedMalware:
            self.IncludedMalware.export(outfile, level, namespace_, name_='IncludedMalware')
        if self.FilesDownloaded:
            self.FilesDownloaded.export(outfile, level, namespace_, name_='FilesDownloaded')
        if self.WindowsRegistryKeysModified:
            self.WindowsRegistryKeysModified.export(outfile, level, namespace_, name_='WindowsRegistryKeysModified')
    def exportS(self, level, namespace_='phish:', name_='LureSource', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='LureSource')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr      
    def exportAttributesS(self, level, namespace_='phish:', name_='LureSource'):
        return ''
    def exportChildrenS(self, level, namespace_='phish:', name_='LureSource'):
        expStr = ''
        for System_ in self.System:
            expStr += System_.exportS( level, namespace_='iodef:', name_='System')
        for DomainData_ in self.DomainData:
            expStr += DomainData_.exportS( level, namespace_, name_='DomainData')
        if self.IncludedMalware:
            expStr += self.IncludedMalware.exportS( level, namespace_, name_='IncludedMalware')
        if self.FilesDownloaded:
            expStr += self.FilesDownloaded.exportS( level, namespace_, name_='FilesDownloaded')
        if self.WindowsRegistryKeysModified:
            expStr += self.WindowsRegistryKeysModified.exportS( level, namespace_, name_='WindowsRegistryKeysModified')
        return expStr
    def hasContent_(self):
        if (
            self.System or
            self.DomainData or
            self.IncludedMalware is not None or
            self.FilesDownloaded is not None or
            self.WindowsRegistryKeysModified is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LureSource'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('System=[\n')
        level += 1
        for System_ in self.System:
            showIndent(outfile, level)
            outfile.write('model_.System(\n')
            System_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('DomainData=[\n')
        level += 1
        for DomainData_ in self.DomainData:
            showIndent(outfile, level)
            outfile.write('model_.DomainData(\n')
            DomainData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.IncludedMalware is not None:
            showIndent(outfile, level)
            outfile.write('IncludedMalware=model_.IncludedMalware_type(\n')
            self.IncludedMalware.exportLiteral(outfile, level, name_='IncludedMalware')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FilesDownloaded is not None:
            showIndent(outfile, level)
            outfile.write('FilesDownloaded=model_.FilesDownloaded(\n')
            self.FilesDownloaded.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.WindowsRegistryKeysModified is not None:
            showIndent(outfile, level)
            outfile.write('WindowsRegistryKeysModified=model_.WindowsRegistryKeysModified(\n')
            self.WindowsRegistryKeysModified.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'System':
            obj_ = System.factory()
            obj_.build(child_)
            self.System.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DomainData':
            obj_ = DomainData.factory()
            obj_.build(child_)
            self.DomainData.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'IncludedMalware':
            obj_ = IncludedMalware_type.factory()
            obj_.build(child_)
            self.set_IncludedMalware(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'FilesDownloaded':
            obj_ = FilesDownloaded.factory()
            obj_.build(child_)
            self.set_FilesDownloaded(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'WindowsRegistryKeysModified':
            obj_ = WindowsRegistryKeysModified.factory()
            obj_.build(child_)
            self.set_WindowsRegistryKeysModified(obj_)
# end class LureSource_type


class FilesDownloaded(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, File=None):
        self.File = File
    def factory(*args_, **kwargs_):
        if FilesDownloaded.subclass:
            return FilesDownloaded.subclass(*args_, **kwargs_)
        else:
            return FilesDownloaded(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def export(self, outfile, level, namespace_='phish:', name_='FilesDownloaded', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='FilesDownloaded')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='FilesDownloaded'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='FilesDownloaded'):
        if self.File is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile>%s</%sFile>\n' % (namespace_, self.format_string(quote_xml(self.File).encode(ExternalEncoding), input_name='File'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='FilesDownloaded', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='FilesDownloaded')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, outfile, level, namespace_='phish:', name_='FilesDownloaded'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='FilesDownloaded'):
        expStr = ''
        if self.File is not None:
            expStr += showIndentS( level)
            expStr += '<%sFile>%s</%sFile>\n' % (namespace_, self.format_string(quote_xml(self.File).encode(ExternalEncoding), input_name='File'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.File is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FilesDownloaded'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File is not None:
            showIndent(outfile, level)
            outfile.write('File=%s,\n' % quote_python(self.File).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File':
            File_ = ''
            for text__content_ in child_.childNodes:
                File_ += text__content_.nodeValue
            self.File = File_
# end class FilesDownloaded


class WindowsRegistryKeysModified(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Key=None):
        if Key is None:
            self.Key = []
        else:
            self.Key = Key
    def factory(*args_, **kwargs_):
        if WindowsRegistryKeysModified.subclass:
            return WindowsRegistryKeysModified.subclass(*args_, **kwargs_)
        else:
            return WindowsRegistryKeysModified(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def add_Key(self, value): self.Key.append(value)
    def insert_Key(self, index, value): self.Key[index] = value
    def export(self, outfile, level, namespace_='phish:', name_='WindowsRegistryKeysModified', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='WindowsRegistryKeysModified')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='WindowsRegistryKeysModified'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='WindowsRegistryKeysModified'):
        for Key_ in self.Key:
            Key_.export(outfile, level, namespace_, name_='Key')
    def exportS(self, level, namespace_='phish:', name_='WindowsRegistryKeysModified', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='WindowsRegistryKeysModified')
        if self.hasContent_():
            expStr +='>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr +=showIndentS( level)
            expStr +='</%s%s>\n' % (namespace_, name_)
        else:
            expStr +='/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='WindowsRegistryKeysModified'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='WindowsRegistryKeysModified'):
        expStr = ''
        for Key_ in self.Key:
            expStr += Key_.exportS( level, namespace_, name_='Key')
        return expStr
    def hasContent_(self):
        if (
            self.Key
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='WindowsRegistryKeysModified'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Key=[\n')
        level += 1
        for Key_ in self.Key:
            showIndent(outfile, level)
            outfile.write('model_.Key(\n')
            Key_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Key':
            obj_ = Key.factory()
            obj_.build(child_)
            self.Key.append(obj_)
# end class WindowsRegistryKeysModified


class Key(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if Key.subclass:
            return Key.subclass(*args_, **kwargs_)
        else:
            return Key(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='phish:', name_='Key', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Key')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Key'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Key'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue>%s</%sValue>\n' % (namespace_, self.format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='Key', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Key')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Key'):
        return ''
    def exportChildrenS(self, level, namespace_='phish:', name_='Key'):
        expStr = ''
        if self.Name is not None:
            expStr += showIndentS( level)
            expStr += '<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_)
        if self.Value is not None:
            expStr += showIndentS( level)
            expStr += '<%sValue>%s</%sValue>\n' % (namespace_, self.format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Key'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value':
            Value_ = ''
            for text__content_ in child_.childNodes:
                Value_ += text__content_.nodeValue
            self.Value = Value_
# end class Key


class IncludedMalware_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, Reference=None, Data=None):
        if Name is None:
            self.Name = []
        else:
            self.Name = Name
        self.Reference = Reference
        self.Data = Data
    def factory(*args_, **kwargs_):
        if IncludedMalware_type.subclass:
            return IncludedMalware_type.subclass(*args_, **kwargs_)
        else:
            return IncludedMalware_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def add_Name(self, value): self.Name.append(value)
    def insert_Name(self, index, value): self.Name[index] = value
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def get_Data(self): return self.Data
    def set_Data(self, Data): self.Data = Data
    def export(self, outfile, level, namespace_='phish:', name_='IncludedMalware.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='IncludedMalware.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='IncludedMalware.type'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='IncludedMalware.type'):
        for Name_ in self.Name:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(Name_).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Reference is not None:
            showIndent(outfile, level)
            outfile.write('<%sReference>%s</%sReference>\n' % (namespace_, self.format_string(quote_xml(self.Reference).encode(ExternalEncoding), input_name='Reference'), namespace_))
        if self.Data:
            self.Data.export(outfile, level, namespace_, name_='Data')
    def exportS(self, level, namespace_='phish:', name_='IncludedMalware.type', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributesS( level, namespace_, name_='IncludedMalware.type')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='IncludedMalware.type'):
        return ''
    def exportChildrenS(self, level, namespace_='phish:', name_='IncludedMalware.type'):
        expStr = ''
        for Name_ in self.Name:
            expStr += showIndentS( level)
            expStr += '<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(Name_).encode(ExternalEncoding), input_name='Name'), namespace_)
        if self.Reference is not None:
            expStr += showIndentS( level)
            expStr += '<%sReference>%s</%sReference>\n' % (namespace_, self.format_string(quote_xml(self.Reference).encode(ExternalEncoding), input_name='Reference'), namespace_)
        if self.Data:
            expStr += self.Data.exportS( level, namespace_, name_='Data')
        return expStr
    def hasContent_(self):
        if (
            self.Name or
            self.Reference is not None or
            self.Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IncludedMalware.type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Name=[\n')
        level += 1
        for Name_ in self.Name:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Name_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Reference is not None:
            showIndent(outfile, level)
            outfile.write('Reference=%s,\n' % quote_python(self.Reference).encode(ExternalEncoding))
        if self.Data is not None:
            showIndent(outfile, level)
            outfile.write('Data=model_.Data(\n')
            self.Data.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name.append(Name_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Reference':
            Reference_ = ''
            for text__content_ in child_.childNodes:
                Reference_ += text__content_.nodeValue
            self.Reference = Reference_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data':
            obj_ = Data.factory()
            obj_.build(child_)
            self.set_Data(obj_)
# end class IncludedMalware_type


class Data(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, XORPattern='55AA55AA55AA55BB', valueOf_=''):
        self.XORPattern = _cast(None, XORPattern)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Data.subclass:
            return Data.subclass(*args_, **kwargs_)
        else:
            return Data(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_XORPattern(self): return self.XORPattern
    def set_XORPattern(self, XORPattern): self.XORPattern = XORPattern
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='Data', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Data')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Data'):
        if self.XORPattern is not None:
            outfile.write(' XORPattern=%s' % (quote_attrib(self.XORPattern), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Data'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='Data', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Data')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Data'):
        if self.XORPattern is not None:
            return ' XORPattern=%s' % (quote_attrib(self.XORPattern), )
        return ''
    def exportChildrenS(self, level, namespace_='phish:', name_='Data'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.XORPattern is not None:
            showIndent(outfile, level)
            outfile.write('XORPattern = %s,\n' % (self.XORPattern,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('XORPattern'):
            self.XORPattern = attrs.get('XORPattern').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Data


class EmailRecord_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, EmailCount=None, EmailMessage=None, EmailComments=None):
        self.EmailCount = EmailCount
        self.EmailMessage = EmailMessage
        self.EmailComments = EmailComments
    def factory(*args_, **kwargs_):
        if EmailRecord_type.subclass:
            return EmailRecord_type.subclass(*args_, **kwargs_)
        else:
            return EmailRecord_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_EmailCount(self): return self.EmailCount
    def set_EmailCount(self, EmailCount): self.EmailCount = EmailCount
    def get_EmailMessage(self): return self.EmailMessage
    def set_EmailMessage(self, EmailMessage): self.EmailMessage = EmailMessage
    def get_EmailComments(self): return self.EmailComments
    def set_EmailComments(self, EmailComments): self.EmailComments = EmailComments
    def export(self, outfile, level, namespace_='phish:', name_='EmailRecord.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EmailRecord.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='EmailRecord.type'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='EmailRecord.type'):
        if self.EmailCount is not None:
            showIndent(outfile, level)
            outfile.write('<%sEmailCount>%s</%sEmailCount>\n' % (namespace_, self.format_integer(self.EmailCount, input_name='EmailCount'), namespace_))
        if self.EmailMessage is not None:
            showIndent(outfile, level)
            outfile.write('<%sEmailMessage>%s</%sEmailMessage>\n' % (namespace_, self.format_string(quote_xml(self.EmailMessage).encode(ExternalEncoding), input_name='EmailMessage'), namespace_))
        if self.EmailComments is not None:
            showIndent(outfile, level)
            outfile.write('<%sEmailComments>%s</%sEmailComments>\n' % (namespace_, self.format_string(quote_xml(self.EmailComments).encode(ExternalEncoding), input_name='EmailComments'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='EmailRecord.type', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributesS( level, namespace_, name_='EmailRecord.type')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='EmailRecord.type'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='EmailRecord.type'):
        expStr = ''
        if self.EmailCount is not None:
            expStr += showIndentS( level)
            expStr += '<%sEmailCount>%s</%sEmailCount>\n' % (namespace_, self.format_integer(self.EmailCount, input_name='EmailCount'), namespace_)
        if self.EmailMessage is not None:
            expStr += showIndentS( level)
            expStr += '<%sEmailMessage>%s</%sEmailMessage>\n' % (namespace_, self.format_string(quote_xml(self.EmailMessage).encode(ExternalEncoding), input_name='EmailMessage'), namespace_)
        if self.EmailComments is not None:
            expStr += showIndentS( level)
            expStr += '<%sEmailComments>%s</%sEmailComments>\n' % (namespace_, self.format_string(quote_xml(self.EmailComments).encode(ExternalEncoding), input_name='EmailComments'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.EmailCount is not None or
            self.EmailMessage is not None or
            self.EmailComments is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailRecord.type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.EmailCount is not None:
            showIndent(outfile, level)
            outfile.write('EmailCount=%d,\n' % self.EmailCount)
        if self.EmailMessage is not None:
            showIndent(outfile, level)
            outfile.write('EmailMessage=%s,\n' % quote_python(self.EmailMessage).encode(ExternalEncoding))
        if self.EmailComments is not None:
            showIndent(outfile, level)
            outfile.write('EmailComments=%s,\n' % quote_python(self.EmailComments).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'EmailCount':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (EmailCount): %s' % exp)
                self.EmailCount = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'EmailMessage':
            EmailMessage_ = ''
            for text__content_ in child_.childNodes:
                EmailMessage_ += text__content_.nodeValue
            self.EmailMessage = EmailMessage_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'EmailComments':
            EmailComments_ = ''
            for text__content_ in child_.childNodes:
                EmailComments_ += text__content_.nodeValue
            self.EmailComments = EmailComments_
# end class EmailRecord_type


class DCSite_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DCType=None, SiteURL=None, Domain=None, EmailSite=None, System=None, Unknown=None, Node=None, DomainData=None, Assessment=None):
        self.DCType = _cast(None, DCType)
        self.SiteURL = SiteURL
        self.Domain = Domain
        self.EmailSite = EmailSite
        self.System = System
        self.Unknown = Unknown
        if Node is None:
            self.Node = []
        else:
            self.Node = Node
        self.DomainData = DomainData
        self.Assessment = Assessment
    def factory(*args_, **kwargs_):
        if DCSite_type.subclass:
            return DCSite_type.subclass(*args_, **kwargs_)
        else:
            return DCSite_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SiteURL(self): return self.SiteURL
    def set_SiteURL(self, SiteURL): self.SiteURL = SiteURL
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_EmailSite(self): return self.EmailSite
    def set_EmailSite(self, EmailSite): self.EmailSite = EmailSite
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def get_Unknown(self): return self.Unknown
    def set_Unknown(self, Unknown): self.Unknown = Unknown
    def get_Node(self): return self.Node
    def set_Node(self, Node): self.Node = Node
    def add_Node(self, value): self.Node.append(value)
    def insert_Node(self, index, value): self.Node[index] = value
    def get_DomainData(self): return self.DomainData
    def set_DomainData(self, DomainData): self.DomainData = DomainData
    def get_Assessment(self): return self.Assessment
    def set_Assessment(self, Assessment): self.Assessment = Assessment
    def get_DCType(self): return self.DCType
    def set_DCType(self, DCType): self.DCType = DCType
    def export(self, outfile, level, namespace_='phish:', name_='DCSite.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DCSite.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='DCSite.type'):
        outfile.write(' DCType=%s' % (self.format_string(quote_attrib(self.DCType).encode(ExternalEncoding), input_name='DCType'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='DCSite.type'):
        if self.SiteURL:
            self.SiteURL.export(outfile, level, namespace_, name_='SiteURL', )
        if self.Domain:
            self.Domain.export(outfile, level, namespace_, name_='Domain', )
        if self.EmailSite:
            self.EmailSite.export(outfile, level, namespace_, name_='EmailSite', )
        if self.System:
            self.System.export(outfile, level, namespace_, name_='System', )
        if self.Unknown:
            self.Unknown.export(outfile, level, namespace_, name_='Unknown', )
        for Node_ in self.Node:
            showIndent(outfile, level)
            outfile.write('<%sNode>%s</%sNode>\n' % (namespace_, self.format_string(quote_xml(Node_).encode(ExternalEncoding), input_name='Node'), namespace_))
        if self.DomainData:
            self.DomainData.export(outfile, level, namespace_, name_='DomainData')
        if self.Assessment is not None:
            showIndent(outfile, level)
            outfile.write('<%sAssessment>%s</%sAssessment>\n' % (namespace_, self.format_string(quote_xml(self.Assessment).encode(ExternalEncoding), input_name='Assessment'), namespace_))
    def exportS(self,  level, namespace_='phish:', name_='DCSite', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='DCSite.type')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='DCSite'):
        return ' DCType=%s' % (self.format_string(quote_attrib(self.DCType).encode(ExternalEncoding), input_name='DCType'), )
    def exportChildrenS(self, level, namespace_='phish:', name_='DCSite.type'):
        expStr = ''
        if self.SiteURL:
            expStr += self.SiteURL.exportS( level, namespace_, name_='SiteURL', )
        if self.Domain:
            expStr += self.Domain.exportS( level, namespace_, name_='Domain', )
        if self.EmailSite:
            expStr += self.EmailSite.exportS( level, namespace_, name_='EmailSite', )
        if self.System:
            expStr += self.System.exportS( level, namespace_, name_='System', )
        if self.Unknown:
            expStr += self.Unknown.exportS( level, namespace_, name_='Unknown', )
        for Node_ in self.Node:
            expStr += showIndentS( level)
            expStr += '<%sNode>%s</%sNode>\n' % (namespace_, self.format_string(quote_xml(Node_).encode(ExternalEncoding), input_name='Node'), namespace_)
        if self.DomainData:
            expStr += self.DomainData.exportS( level, namespace_, name_='DomainData')
        if self.Assessment is not None:
            expStr += showIndentS( level)
            expStr += '<%sAssessment>%s</%sAssessment>\n' % (namespace_, self.format_string(quote_xml(self.Assessment).encode(ExternalEncoding), input_name='Assessment'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.SiteURL is not None or
            self.Domain is not None or
            self.EmailSite is not None or
            self.System is not None or
            self.Unknown is not None or
            self.Node or
            self.DomainData is not None or
            self.Assessment is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DCSite'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.DCType is not None:
            showIndent(outfile, level)
            outfile.write('DCType = "%s",\n' % (self.DCType,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.SiteURL is not None:
            showIndent(outfile, level)
            outfile.write('SiteURL=model_.SiteURL(\n')
            self.SiteURL.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.Domain(\n')
            self.Domain.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.EmailSite is not None:
            showIndent(outfile, level)
            outfile.write('EmailSite=model_.EmailSite(\n')
            self.EmailSite.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.System is not None:
            showIndent(outfile, level)
            outfile.write('System=model_.System(\n')
            self.System.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Unknown is not None:
            showIndent(outfile, level)
            outfile.write('Unknown=model_.Unknown(\n')
            self.Unknown.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Node=[\n')
        level += 1
        for Node_ in self.Node:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Node_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.DomainData is not None:
            showIndent(outfile, level)
            outfile.write('DomainData=model_.DomainData(\n')
            self.DomainData.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Assessment is not None:
            showIndent(outfile, level)
            outfile.write('Assessment=%s,\n' % quote_python(self.Assessment).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('DCType'):
            self.DCType = attrs.get('DCType').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'SiteURL':
            obj_ = SiteURL.factory()
            obj_.build(child_)
            self.set_SiteURL(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Domain':
            obj_ = Domain.factory()
            obj_.build(child_)
            self.set_Domain(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'EmailSite':
            obj_ = EmailSite.factory()
            obj_.build(child_)
            self.set_EmailSite(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'System':
            obj_ = System.factory()
            obj_.build(child_)
            self.set_System(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Unknown':
            obj_ = Unknown.factory()
            obj_.build(child_)
            self.set_Unknown(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Node':
            Node_ = ''
            for text__content_ in child_.childNodes:
                Node_ += text__content_.nodeValue
            self.Node.append(Node_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DomainData':
            obj_ = DomainData.factory()
            obj_.build(child_)
            self.set_DomainData(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Assessment':
            Assessment_ = ''
            for text__content_ in child_.childNodes:
                Assessment_ += text__content_.nodeValue
            self.Assessment = Assessment_
# end class DCSite_type


class SiteURL(iodef.base.MLStringType):
    subclass = None
    superclass = iodef.base.MLStringType
    def __init__(self, confidence=None, valueOf_=''):
        self.confidence = _cast(None, confidence)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SiteURL.subclass:
            return SiteURL.subclass(*args_, **kwargs_)
        else:
            return SiteURL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='SiteURL', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='SiteURL')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='SiteURL'):
        iodef.base.MLStringType.exportAttributes(self, outfile, level, 
namespace_, name_='SiteURL')
        if self.confidence is not None:
            outfile.write(' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='SiteURL'):
        iodef.base.MLStringType.exportChildren(self, outfile, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='SiteURL', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='SiteURL')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='SiteURL'):
        expStr = iodef.base.MLStringType.exportAttributesS(self, level, 
namespace_, name_='SiteURL')
        if self.confidence is not None:
            expStr += ' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), )
        return expStr
    def exportChildrenS(self, level, namespace_='phish:', name_='SiteURL'):
        expStr = iodef.base.MLStringType.exportChildrenS(self, level, 
namespace_, name_)
        #if self.valueOf_.find('![CDATA') > -1:
        #    value=quote_xml('%s' % self.valueOf_)
        #    value=value.replace('![CDATA','<![CDATA')
        #    value=value.replace(']]',']]>')
        #    expStr += value.encode(ExternalEncoding)
        #else:
        #    expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr     
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SiteURL'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write(' phish:confidence = "%s",\n' % (self.confidence,))
        iodef.base.MLStringType.exportLiteralAttributes(self, outfile, 
level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        iodef.base.MLStringType.exportLiteralChildren(self, outfile, 
level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('confidence'):
            self.confidence = attrs.get('confidence').value
        iodef.base.MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class SiteURL


class Domain(iodef.base.MLStringType):
    subclass = None
    superclass = None
    def __init__(self, confidence=None, valueOf_=''):
        self.confidence = _cast(None, confidence)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Domain.subclass:
            return Domain.subclass(*args_, **kwargs_)
        else:
            return Domain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='Domain', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Domain')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Domain'):
        iodef.base.MLStringType.exportAttributes(self, outfile, level, 
namespace_, name_='Domain')
        if self.confidence is not None:
            outfile.write(' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Domain'):
        iodef.base.MLStringType.exportChildren(self, outfile, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='Domain', namespacedef_=''):
        expStr = showIndent( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Domain')
        if self.hasContent_():
            expStr += '>'
            self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Domain'):
        expStr = iodef.base.MLStringType.exportAttributesS(self, level, 
namespace_, name_='Domain')
        if self.confidence is not None:
            expStr += ' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), )
        return expStr
    def exportChildrenS(self, level, namespace_='phish:', name_='Domain'):
        expStr = iodef.base.MLStringType.exportChildrenS(self, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Domain'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence = "%s",\n' % (self.confidence,))
        iodef.base.MLStringType.exportLiteralAttributes(self, outfile, 
level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        iodef.base.MLStringType.exportLiteralChildren(self, outfile, 
level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('confidence'):
            self.confidence = attrs.get('confidence').value
        iodef.base.MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Domain


class EmailSite(iodef.base.MLStringType):
    subclass = None
    superclass = None
    def __init__(self, confidence=None, valueOf_=''):
        self.confidence = _cast(None, confidence)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if EmailSite.subclass:
            return EmailSite.subclass(*args_, **kwargs_)
        else:
            return EmailSite(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='EmailSite', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EmailSite')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='EmailSite'):
        iodef.base.MLStringType.exportAttributes(self, outfile, level, 
namespace_, name_='EmailSite')
        if self.confidence is not None:
            outfile.write(' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='EmailSite'):
        iodef.base.MLStringType.exportChildren(self, outfile, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='EmailSite', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='EmailSite')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='EmailSite'):
        expStr = iodef.base.MLStringType.exportAttributesS(self, level, 
namespace_, name_='EmailSite')
        if self.confidence is not None:
            expStr += ' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), )
        return expStr
    def exportChildrenS(self, level, namespace_='phish:', name_='EmailSite'):
        expStr += iodef.base.MLStringType.exportChildrenS(self, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EmailSite'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence = "%s",\n' % (self.confidence,))
        iodef.base.MLStringType.exportLiteralAttributes(self, outfile, 
level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        iodef.base.MLStringType.exportLiteralChildren(self, outfile, 
level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('confidence'):
            self.confidence = attrs.get('confidence').value
        iodef.base.MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class EmailSite


class System(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, confidence=None, Address=None):
        self.confidence = _cast(None, confidence)
        self.Address = Address
    def factory(*args_, **kwargs_):
        if System.subclass:
            return System.subclass(*args_, **kwargs_)
        else:
            return System(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def export(self, outfile, level, namespace_='phish:', name_='System', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='System')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='System'):
        if self.confidence is not None:
            outfile.write(' confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='System'):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sAddress>%s</%sAddress>\n' % (namespace_, self.format_string(quote_xml(self.Address).encode(ExternalEncoding), input_name='Address'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='System', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='System')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='System'):
        if self.confidence is not None:
            return ' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), )
        return ''
    def exportChildrenS(self, level, namespace_='phish:', name_='System'):
        expStr = ''
        if self.Address is not None:
            expStr += showIndentS( level)
            expStr += '<%sAddress>%s</%sAddress>\n' % (namespace_, self.format_string(quote_xml(self.Address).encode(ExternalEncoding), input_name='Address'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='System'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence = "%s",\n' % (self.confidence,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=%s,\n' % quote_python(self.Address).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('confidence'):
            self.confidence = attrs.get('confidence').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Address':
            Address_ = ''
            for text__content_ in child_.childNodes:
                Address_ += text__content_.nodeValue
            self.Address = Address_
# end class System


class Unknown(iodef.base.MLStringType):
    subclass = None
    superclass = None
    def __init__(self, confidence=None, valueOf_=''):
        self.confidence = _cast(None, confidence)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Unknown.subclass:
            return Unknown.subclass(*args_, **kwargs_)
        else:
            return Unknown(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='Unknown', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Unknown')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Unknown'):
        iodef.base.MLStringType.exportAttributes(self, outfile, level, 
namespace_, name_='Unknown')
        if self.confidence is not None:
            outfile.write(' confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Unknown'):
        iodef.base.MLStringType.exportChildren(self, outfile, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='Unknown', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Unknown')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Unknown'):
        expStr += iodef.base.MLStringType.exportAttributesS(self, level, 
namespace_, name_='Unknown')
        if self.confidence is not None:
            expStr += ' phish:confidence=%s' % (self.format_string(quote_attrib(self.confidence).encode(ExternalEncoding), input_name='confidence'), )
        return expStr
    def exportChildrenS(self, level, namespace_='phish:', name_='Unknown'):
        expStr = iodef.base.MLStringType.exportChildrenS(self, level, 
namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Unknown'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence = "%s",\n' % (self.confidence,))
        iodef.base.MLStringType.exportLiteralAttributes(self, outfile, 
level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        iodef.base.MLStringType.exportLiteralChildren(self, outfile, 
level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('confidence'):
            self.confidence = attrs.get('confidence').value
        iodef.base.MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Unknown


class DomainData(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, SystemStatus=None, DomainStatus=None, Name=None, DateDomainWasChecked=None, RegistrationDate=None, ExpirationDate=None, Nameservers=None, SameDomainContact=None, Contact=None):
        self.SystemStatus = _cast(None, SystemStatus)
        self.DomainStatus = _cast(None, DomainStatus)
        self.Name = Name
        self.DateDomainWasChecked = DateDomainWasChecked
        self.RegistrationDate = RegistrationDate
        self.ExpirationDate = ExpirationDate
        if Nameservers is None:
            self.Nameservers = []
        else:
            self.Nameservers = Nameservers
        self.SameDomainContact = SameDomainContact
        if Contact is None:
            self.Contact = []
        else:
            self.Contact = Contact
    def factory(*args_, **kwargs_):
        if DomainData.subclass:
            return DomainData.subclass(*args_, **kwargs_)
        else:
            return DomainData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_DateDomainWasChecked(self): return self.DateDomainWasChecked
    def set_DateDomainWasChecked(self, DateDomainWasChecked): self.DateDomainWasChecked = DateDomainWasChecked
    def get_RegistrationDate(self): return self.RegistrationDate
    def set_RegistrationDate(self, RegistrationDate): self.RegistrationDate = RegistrationDate
    def get_ExpirationDate(self): return self.ExpirationDate
    def set_ExpirationDate(self, ExpirationDate): self.ExpirationDate = ExpirationDate
    def get_Nameservers(self): return self.Nameservers
    def set_Nameservers(self, Nameservers): self.Nameservers = Nameservers
    def add_Nameservers(self, value): self.Nameservers.append(value)
    def insert_Nameservers(self, index, value): self.Nameservers[index] = value
    def get_SameDomainContact(self): return self.SameDomainContact
    def set_SameDomainContact(self, SameDomainContact): self.SameDomainContact = SameDomainContact
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def add_Contact(self, value): self.Contact.append(value)
    def insert_Contact(self, index, value): self.Contact[index] = value
    def get_SystemStatus(self): return self.SystemStatus
    def set_SystemStatus(self, SystemStatus): self.SystemStatus = SystemStatus
    def get_DomainStatus(self): return self.DomainStatus
    def set_DomainStatus(self, DomainStatus): self.DomainStatus = DomainStatus
    def export(self, outfile, level, namespace_='phish:', name_='DomainData', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DomainData')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='DomainData'):
        if self.SystemStatus is not None:
            outfile.write(' SystemStatus=%s' % (self.format_string(quote_attrib(self.SystemStatus).encode(ExternalEncoding), input_name='SystemStatus'), ))
        if self.DomainStatus is not None:
            outfile.write(' DomainStatus=%s' % (self.format_string(quote_attrib(self.DomainStatus).encode(ExternalEncoding), input_name='DomainStatus'), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='DomainData'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.DateDomainWasChecked is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateDomainWasChecked>%s</%sDateDomainWasChecked>\n' % (namespace_, self.format_string(quote_xml(self.DateDomainWasChecked).encode(ExternalEncoding), input_name='DateDomainWasChecked'), namespace_))
        if self.RegistrationDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sRegistrationDate>%s</%sRegistrationDate>\n' % (namespace_, self.format_string(quote_xml(self.RegistrationDate).encode(ExternalEncoding), input_name='RegistrationDate'), namespace_))
        if self.ExpirationDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sExpirationDate>%s</%sExpirationDate>\n' % (namespace_, self.format_string(quote_xml(self.ExpirationDate).encode(ExternalEncoding), input_name='ExpirationDate'), namespace_))
        for Nameservers_ in self.Nameservers:
            Nameservers_.export(outfile, level, namespace_, name_='Nameservers')
        if self.SameDomainContact is not None:
            showIndent(outfile, level)
            outfile.write('<%sSameDomainContact>%s</%sSameDomainContact>\n' % (namespace_, self.format_string(quote_xml(self.SameDomainContact).encode(ExternalEncoding), input_name='SameDomainContact'), namespace_))
        for Contact_ in self.Contact:
            showIndent(outfile, level)
            outfile.write('<%sContact>%s</%sContact>\n' % (namespace_, self.format_string(quote_xml(Contact_).encode(ExternalEncoding), input_name='Contact'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='DomainData', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='DomainData')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr  
    def exportAttributesS(self, outfile, level, namespace_='phish:', name_='DomainData'):
        expStr = ''
        if self.SystemStatus is not None:
            expStr += ' SystemStatus=%s' % (self.format_string(quote_attrib(self.SystemStatus).encode(ExternalEncoding), input_name='SystemStatus'), )
        if self.DomainStatus is not None:
            expStr += ' DomainStatus=%s' % (self.format_string(quote_attrib(self.DomainStatus).encode(ExternalEncoding), input_name='DomainStatus'), )
        return expStr 
    def exportChildrenS(self, level, namespace_='phish:', name_='DomainData'):
        expStr = ''
        if self.Name is not None:
            expStr += showIndentS( level)
            expStr += '<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_)
        if self.DateDomainWasChecked is not None:
            expStr += showIndentS( level)
            expStr += '<%sDateDomainWasChecked>%s</%sDateDomainWasChecked>\n' % (namespace_, self.format_string(quote_xml(self.DateDomainWasChecked).encode(ExternalEncoding), input_name='DateDomainWasChecked'), namespace_)
        if self.RegistrationDate is not None:
            expStr += showIndentS( level)
            expStr += '<%sRegistrationDate>%s</%sRegistrationDate>\n' % (namespace_, self.format_string(quote_xml(self.RegistrationDate).encode(ExternalEncoding), input_name='RegistrationDate'), namespace_)
        if self.ExpirationDate is not None:
            expStr += showIndentS( level)
            expStr += '<%sExpirationDate>%s</%sExpirationDate>\n' % (namespace_, self.format_string(quote_xml(self.ExpirationDate).encode(ExternalEncoding), input_name='ExpirationDate'), namespace_)
        for Nameservers_ in self.Nameservers:
            expStr += Nameservers_.exportS( level, namespace_, name_='Nameservers')
        if self.SameDomainContact is not None:
            expStr += showIndentS( level)
            expStr += '<%sSameDomainContact>%s</%sSameDomainContact>\n' % (namespace_, self.format_string(quote_xml(self.SameDomainContact).encode(ExternalEncoding), input_name='SameDomainContact'), namespace_)
        for Contact_ in self.Contact:
            expStr += showIndentS( level)
            expStr += '<%sContact>%s</%sContact>\n' % (namespace_, self.format_string(quote_xml(Contact_).encode(ExternalEncoding), input_name='Contact'), namespace_)
        return expStr             
    def hasContent_(self):
        if (
            self.Name is not None or
            self.DateDomainWasChecked is not None or
            self.RegistrationDate is not None or
            self.ExpirationDate is not None or
            self.Nameservers or
            self.SameDomainContact is not None or
            self.Contact
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DomainData'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.SystemStatus is not None:
            showIndent(outfile, level)
            outfile.write('SystemStatus = "%s",\n' % (self.SystemStatus,))
        if self.DomainStatus is not None:
            showIndent(outfile, level)
            outfile.write('DomainStatus = "%s",\n' % (self.DomainStatus,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.DateDomainWasChecked is not None:
            showIndent(outfile, level)
            outfile.write('DateDomainWasChecked=%s,\n' % quote_python(self.DateDomainWasChecked).encode(ExternalEncoding))
        if self.RegistrationDate is not None:
            showIndent(outfile, level)
            outfile.write('RegistrationDate=%s,\n' % quote_python(self.RegistrationDate).encode(ExternalEncoding))
        if self.ExpirationDate is not None:
            showIndent(outfile, level)
            outfile.write('ExpirationDate=%s,\n' % quote_python(self.ExpirationDate).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Nameservers=[\n')
        level += 1
        for Nameservers_ in self.Nameservers:
            showIndent(outfile, level)
            outfile.write('model_.Nameservers(\n')
            Nameservers_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.SameDomainContact is not None:
            showIndent(outfile, level)
            outfile.write('SameDomainContact=%s,\n' % quote_python(self.SameDomainContact).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Contact=[\n')
        level += 1
        for Contact_ in self.Contact:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Contact_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('SystemStatus'):
            self.SystemStatus = attrs.get('SystemStatus').value
        if attrs.get('DomainStatus'):
            self.DomainStatus = attrs.get('DomainStatus').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DateDomainWasChecked':
            DateDomainWasChecked_ = ''
            for text__content_ in child_.childNodes:
                DateDomainWasChecked_ += text__content_.nodeValue
            self.DateDomainWasChecked = DateDomainWasChecked_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'RegistrationDate':
            RegistrationDate_ = ''
            for text__content_ in child_.childNodes:
                RegistrationDate_ += text__content_.nodeValue
            self.RegistrationDate = RegistrationDate_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'ExpirationDate':
            ExpirationDate_ = ''
            for text__content_ in child_.childNodes:
                ExpirationDate_ += text__content_.nodeValue
            self.ExpirationDate = ExpirationDate_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Nameservers':
            obj_ = Nameservers.factory()
            obj_.build(child_)
            self.Nameservers.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'SameDomainContact':
            SameDomainContact_ = ''
            for text__content_ in child_.childNodes:
                SameDomainContact_ += text__content_.nodeValue
            self.SameDomainContact = SameDomainContact_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            Contact_ = ''
            for text__content_ in child_.childNodes:
                Contact_ += text__content_.nodeValue
            self.Contact.append(Contact_)
# end class DomainData


class Nameservers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Server=None, Address=None):
        self.Server = Server
        if Address is None:
            self.Address = []
        else:
            self.Address = Address
    def factory(*args_, **kwargs_):
        if Nameservers.subclass:
            return Nameservers.subclass(*args_, **kwargs_)
        else:
            return Nameservers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Server(self): return self.Server
    def set_Server(self, Server): self.Server = Server
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def add_Address(self, value): self.Address.append(value)
    def insert_Address(self, index, value): self.Address[index] = value
    def export(self, outfile, level, namespace_='phish:', name_='Nameservers', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Nameservers')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Nameservers'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Nameservers'):
        if self.Server is not None:
            showIndent(outfile, level)
            outfile.write('<%sServer>%s</%sServer>\n' % (namespace_, self.format_string(quote_xml(self.Server).encode(ExternalEncoding), input_name='Server'), namespace_))
        for Address_ in self.Address:
            showIndent(outfile, level)
            outfile.write('<%sAddress>%s</%sAddress>\n' % (namespace_, self.format_string(quote_xml(Address_).encode(ExternalEncoding), input_name='Address'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='Nameservers', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributes(outfile, level, namespace_, name_='Nameservers')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Nameservers'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='Nameservers'):
        expStr = ''
        if self.Server is not None:
            expStr += showIndentS( level)
            expStr += '<%sServer>%s</%sServer>\n' % (namespace_, self.format_string(quote_xml(self.Server).encode(ExternalEncoding), input_name='Server'), namespace_)
        for Address_ in self.Address:
            expStr += showIndentS( level)
            expStr += '<%sAddress>%s</%sAddress>\n' % (namespace_, self.format_string(quote_xml(Address_).encode(ExternalEncoding), input_name='Address'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.Server is not None or
            self.Address
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nameservers'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Server is not None:
            showIndent(outfile, level)
            outfile.write('Server=%s,\n' % quote_python(self.Server).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Address=[\n')
        level += 1
        for Address_ in self.Address:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Address_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Server':
            Server_ = ''
            for text__content_ in child_.childNodes:
                Server_ += text__content_.nodeValue
            self.Server = Server_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Address':
            Address_ = ''
            for text__content_ in child_.childNodes:
                Address_ += text__content_.nodeValue
            self.Address.append(Address_)
# end class Nameservers


class Confidence(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Confidence.subclass:
            return Confidence.subclass(*args_, **kwargs_)
        else:
            return Confidence(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phish:', name_='Confidence', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Confidence')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='Confidence'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='Confidence'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='phish:', name_='Confidence', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributesS( level, namespace_, name_='Confidence')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='Confidence'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='Confidence'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Confidence'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Confidence


class OriginatingSensor_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, OriginatingSensorType=None, DateFirstSeen=None, System=None):
        self.OriginatingSensorType = _cast(None, OriginatingSensorType)
        self.DateFirstSeen = DateFirstSeen
        if System is None:
            self.System = []
        else:
            self.System = System
    def factory(*args_, **kwargs_):
        if OriginatingSensor_type.subclass:
            return OriginatingSensor_type.subclass(*args_, **kwargs_)
        else:
            return OriginatingSensor_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateFirstSeen(self): return self.DateFirstSeen
    def set_DateFirstSeen(self, DateFirstSeen): self.DateFirstSeen = DateFirstSeen
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def add_System(self, value): self.System.append(value)
    def insert_System(self, index, value): self.System[index] = value
    def get_OriginatingSensorType(self): return self.OriginatingSensorType
    def set_OriginatingSensorType(self, OriginatingSensorType): self.OriginatingSensorType = OriginatingSensorType
    def export(self, outfile, level, namespace_='phish:', name_='OriginatingSensor', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='OriginatingSensor')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='OriginatingSensor'):
        outfile.write(' OriginatingSensorType=%s' % (quote_attrib(self.OriginatingSensorType), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='OriginatingSensor'):
        if self.DateFirstSeen is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateFirstSeen>%s</%sDateFirstSeen>\n' % (namespace_, self.format_string(quote_xml(self.DateFirstSeen).encode(ExternalEncoding), input_name='DateFirstSeen'), namespace_))
        for System_ in self.System:
            System_.export(outfile, level, namespace_='iodef:', name_='System', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"')
    def exportS(self, level, namespace_='phish:', name_='OriginatingSensor', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='OriginatingSensor')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='OriginatingSensor'):
        return ' OriginatingSensorType=%s' % (quote_attrib(self.OriginatingSensorType), )
    def exportChildrenS(self, level, namespace_='phish:', name_='OriginatingSensor'):
        expStr = ''
        if self.DateFirstSeen is not None:
            expStr += showIndentS( level)
            expStr += '<%sDateFirstSeen>%s</%sDateFirstSeen>\n' % (namespace_, self.format_string(quote_xml(self.DateFirstSeen).encode(ExternalEncoding), input_name='DateFirstSeen'), namespace_)
        for System_ in self.System:
            expStr += System_.exportS( level, namespace_='iodef:', name_='System')
        return expStr
    def hasContent_(self):
        if (
            self.DateFirstSeen is not None or
            self.System
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OriginatingSensor'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.OriginatingSensorType is not None:
            showIndent(outfile, level)
            outfile.write('OriginatingSensorType = %s,\n' % (self.OriginatingSensorType,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DateFirstSeen is not None:
            showIndent(outfile, level)
            outfile.write('DateFirstSeen=%s,\n' % quote_python(self.DateFirstSeen).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('System=[\n')
        level += 1
        for System_ in self.System:
            showIndent(outfile, level)
            outfile.write('model_.System(\n')
            System_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('OriginatingSensorType'):
            self.OriginatingSensorType = attrs.get('OriginatingSensorType').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DateFirstSeen':
            DateFirstSeen_ = ''
            for text__content_ in child_.childNodes:
                DateFirstSeen_ += text__content_.nodeValue
            self.DateFirstSeen = DateFirstSeen_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'System':
            obj_ = System.factory()
            obj_.build(child_)
            self.System.append(obj_)
# end class OriginatingSensor_type


class TakeDownInfo_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, TakeDownDate=None, TakeDownAgency=None, TakeDownComments=None):
        self.TakeDownDate = TakeDownDate
        if TakeDownAgency is None:
            self.TakeDownAgency = []
        else:
            self.TakeDownAgency = TakeDownAgency
        if TakeDownComments is None:
            self.TakeDownComments = []
        else:
            self.TakeDownComments = TakeDownComments
    def factory(*args_, **kwargs_):
        if TakeDownInfo_type.subclass:
            return TakeDownInfo_type.subclass(*args_, **kwargs_)
        else:
            return TakeDownInfo_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TakeDownDate(self): return self.TakeDownDate
    def set_TakeDownDate(self, TakeDownDate): self.TakeDownDate = TakeDownDate
    def get_TakeDownAgency(self): return self.TakeDownAgency
    def set_TakeDownAgency(self, TakeDownAgency): self.TakeDownAgency = TakeDownAgency
    def add_TakeDownAgency(self, value): self.TakeDownAgency.append(value)
    def insert_TakeDownAgency(self, index, value): self.TakeDownAgency[index] = value
    def get_TakeDownComments(self): return self.TakeDownComments
    def set_TakeDownComments(self, TakeDownComments): self.TakeDownComments = TakeDownComments
    def add_TakeDownComments(self, value): self.TakeDownComments.append(value)
    def insert_TakeDownComments(self, index, value): self.TakeDownComments[index] = value
    def export(self, outfile, level, namespace_='phish:', name_='TakeDownInfo.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='TakeDownInfo.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='TakeDownInfo.type'):
        pass
    def exportChildren(self, outfile, level, namespace_='phish:', name_='TakeDownInfo.type'):
        if self.TakeDownDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sTakeDownDate>%s</%sTakeDownDate>\n' % (namespace_, self.format_string(quote_xml(self.TakeDownDate).encode(ExternalEncoding), input_name='TakeDownDate'), namespace_))
        for TakeDownAgency_ in self.TakeDownAgency:
            showIndent(outfile, level)
            outfile.write('<%sTakeDownAgency>%s</%sTakeDownAgency>\n' % (namespace_, self.format_string(quote_xml(TakeDownAgency_).encode(ExternalEncoding), input_name='TakeDownAgency'), namespace_))
        for TakeDownComments_ in self.TakeDownComments:
            showIndent(outfile, level)
            outfile.write('<%sTakeDownComments>%s</%sTakeDownComments>\n' % (namespace_, self.format_string(quote_xml(TakeDownComments_).encode(ExternalEncoding), input_name='TakeDownComments'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='TakeDownInfo.type', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributesS( level, namespace_, name_='TakeDownInfo.type')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='TakeDownInfo.type'):
        pass
    def exportChildrenS(self, level, namespace_='phish:', name_='TakeDownInfo.type'):
        expStr = ''
        if self.TakeDownDate is not None:
            expStr += showIndentS( level)
            expStr += '<%sTakeDownDate>%s</%sTakeDownDate>\n' % (namespace_, self.format_string(quote_xml(self.TakeDownDate).encode(ExternalEncoding), input_name='TakeDownDate'), namespace_)
        for TakeDownAgency_ in self.TakeDownAgency:
            expStr += showIndentS( level)
            expStr += '<%sTakeDownAgency>%s</%sTakeDownAgency>\n' % (namespace_, self.format_string(quote_xml(TakeDownAgency_).encode(ExternalEncoding), input_name='TakeDownAgency'), namespace_)
        for TakeDownComments_ in self.TakeDownComments:
            expStr += showIndentS( level)
            expStr += '<%sTakeDownComments>%s</%sTakeDownComments>\n' % (namespace_, self.format_string(quote_xml(TakeDownComments_).encode(ExternalEncoding), input_name='TakeDownComments'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.TakeDownDate is not None or
            self.TakeDownAgency or
            self.TakeDownComments
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TakeDownInfo.type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TakeDownDate is not None:
            showIndent(outfile, level)
            outfile.write('TakeDownDate=%s,\n' % quote_python(self.TakeDownDate).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('TakeDownAgency=[\n')
        level += 1
        for TakeDownAgency_ in self.TakeDownAgency:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(TakeDownAgency_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('TakeDownComments=[\n')
        level += 1
        for TakeDownComments_ in self.TakeDownComments:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(TakeDownComments_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TakeDownDate':
            TakeDownDate_ = ''
            for text__content_ in child_.childNodes:
                TakeDownDate_ += text__content_.nodeValue
            self.TakeDownDate = TakeDownDate_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TakeDownAgency':
            TakeDownAgency_ = ''
            for text__content_ in child_.childNodes:
                TakeDownAgency_ += text__content_.nodeValue
            self.TakeDownAgency.append(TakeDownAgency_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TakeDownComments':
            TakeDownComments_ = ''
            for text__content_ in child_.childNodes:
                TakeDownComments_ += text__content_.nodeValue
            self.TakeDownComments.append(TakeDownComments_)
# end class TakeDownInfo_type


class ArchivedData_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, URL=None, Comments=None, Data=None):
        self.type_ = _cast(None, type_)
        self.URL = URL
        self.Comments = Comments
        self.Data = Data
    def factory(*args_, **kwargs_):
        if ArchivedData_type.subclass:
            return ArchivedData_type.subclass(*args_, **kwargs_)
        else:
            return ArchivedData_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URL(self): return self.URL
    def set_URL(self, URL): self.URL = URL
    def get_Comments(self): return self.Comments
    def set_Comments(self, Comments): self.Comments = Comments
    def get_Data(self): return self.Data
    def set_Data(self, Data): self.Data = Data
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='phish:', name_='ArchivedData.type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ArchivedData.type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='phish:', name_='ArchivedData.type'):
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='phish:', name_='ArchivedData.type'):
        if self.URL is not None:
            showIndent(outfile, level)
            outfile.write('<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(self.URL).encode(ExternalEncoding), input_name='URL'), namespace_))
        if self.Comments is not None:
            showIndent(outfile, level)
            outfile.write('<%sComments>%s</%sComments>\n' % (namespace_, self.format_string(quote_xml(self.Comments).encode(ExternalEncoding), input_name='Comments'), namespace_))
        if self.Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sData>%s</%sData>\n' % (namespace_, self.format_string(quote_xml(self.Data).encode(ExternalEncoding), input_name='Data'), namespace_))
    def exportS(self, level, namespace_='phish:', name_='ArchivedData.type', namespacedef_=''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='ArchivedData.type')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='phish:', name_='ArchivedData.type'):
        return ' type=%s' % (quote_attrib(self.type_), )
    def exportChildrenS(self, level, namespace_='phish:', name_='ArchivedData.type'):
        expStr = ''
        if self.URL is not None:
            expStr += showIndentS( level)
            expStr += '<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(self.URL).encode(ExternalEncoding), input_name='URL'), namespace_)
        if self.Comments is not None:
            expStr += showIndentS( level)
            expStr += '<%sComments>%s</%sComments>\n' % (namespace_, self.format_string(quote_xml(self.Comments).encode(ExternalEncoding), input_name='Comments'), namespace_)
        if self.Data is not None:
            expStr += showIndentS( level)
            expStr += '<%sData>%s</%sData>\n' % (namespace_, self.format_string(quote_xml(self.Data).encode(ExternalEncoding), input_name='Data'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.URL is not None or
            self.Comments is not None or
            self.Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArchivedData.type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URL is not None:
            showIndent(outfile, level)
            outfile.write('URL=%s,\n' % quote_python(self.URL).encode(ExternalEncoding))
        if self.Comments is not None:
            showIndent(outfile, level)
            outfile.write('Comments=%s,\n' % quote_python(self.Comments).encode(ExternalEncoding))
        if self.Data is not None:
            showIndent(outfile, level)
            outfile.write('Data=%s,\n' % quote_python(self.Data).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'URL':
            URL_ = ''
            for text__content_ in child_.childNodes:
                URL_ += text__content_.nodeValue
            self.URL = URL_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Comments':
            Comments_ = ''
            for text__content_ in child_.childNodes:
                Comments_ += text__content_.nodeValue
            self.Comments = Comments_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data':
            Data_ = ''
            for text__content_ in child_.childNodes:
                Data_ += text__content_.nodeValue
            self.Data = Data_
# end class ArchivedData_type


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def parseToString(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = PhraudReport.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    return rootObj


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = PhraudReport.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="PhraudReport", 
        namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = PhraudReport.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="PhraudReport",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = PhraudReport.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from phish import *\n\n')
    sys.stdout.write('import phish as model_\n\n')
    sys.stdout.write('rootObj = model_.PhraudReport(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="PhraudReport")
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

