#!/usr/bin/env python

#
# Generated Mon Mar 15 16:32:43 2010 by generateDS.py version 1.20e.
#

import sys
import getopt
from string import lower as str_lower
import xml
from xml.dom import minidom
from xml.dom import Node

# imports for various EventData elements.
#from iodeflib.phish import phish

### Note: 'Node' is an iodef term; xml.dom.Node needs to be adequately
###       class-marked.

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile += '    '
def showIndentS(level):
    outfile = ''
    for idx in range(level):
        outfile += '    '
    return outfile

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class IODEF_Document(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, lang=None, formatid=None, version=None, Incident=None):
        self.lang = _cast(None, lang)
        self.formatid = _cast(None, formatid)
        self.version = _cast(None, version)
        if Incident is None:
            self.Incident = []
        else:
            self.Incident = Incident
    def factory(*args_, **kwargs_):
        if IODEF_Document.subclass:
            return IODEF_Document.subclass(*args_, **kwargs_)
        else:
            return IODEF_Document(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Incident(self): return self.Incident
    def set_Incident(self, Incident): self.Incident = Incident
    def add_Incident(self, value): self.Incident.append(value)
    def insert_Incident(self, index, value): self.Incident[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_formatid(self): return self.formatid
    def set_formatid(self, formatid): self.formatid = formatid
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def export(self, outfile, level, namespace_='iodef:', name_='IODEF-Document', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='IODEF-Document')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='IODEF-Document'):
        outfile.write(' lang=%s' % (quote_attrib(self.lang), ))
        if self.formatid is not None:
            outfile.write(' formatid=%s' % (self.format_string(quote_attrib(self.formatid).encode(ExternalEncoding), input_name='formatid'), ))
        if self.version is not None:
            outfile.write(' version=%s' % (self.format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='IODEF-Document'):
        for Incident_ in self.Incident:
            Incident_.export(outfile, level, namespace_, name_='Incident')
    def exportS(self, level, namespace_='iodef:', name_='IODEF-Document', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='IODEF-Document')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='IODEF-Document'):
        expStr = ' lang=%s' % (quote_attrib(self.lang), )
        if self.formatid is not None:
            expStr += ' formatid=%s' % (self.format_string(quote_attrib(self.formatid).encode(ExternalEncoding), input_name='formatid'), )
        if self.version is not None:
            expStr += ' version=%s' % (self.format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='IODEF-Document'):
        expStr = ''
        for Incident_ in self.Incident:
            expStr += Incident_.exportS( level, namespace_, name_='Incident')
        return expStr
    def hasContent_(self):
        if (
            self.Incident
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IODEF-Document'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.lang is not None:
            showIndent(outfile, level)
            outfile.write('lang = %s,\n' % (self.lang,))
        if self.formatid is not None:
            showIndent(outfile, level)
            outfile.write('formatid = "%s",\n' % (self.formatid,))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version = "%s",\n' % (self.version,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Incident=[\n')
        level += 1
        for Incident_ in self.Incident:
            showIndent(outfile, level)
            outfile.write('model_.Incident(\n')
            Incident_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('lang'):
            self.lang = attrs.get('lang').value
        if attrs.get('formatid'):
            self.formatid = attrs.get('formatid').value
        if attrs.get('version'):
            self.version = attrs.get('version').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Incident':
            obj_ = Incident.factory()
            obj_.build(child_)
            self.Incident.append(obj_)
# end class IODEF_Document


class Incident(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, lang=None, restriction='private', ext_purpose=None, purpose=None, IncidentID=None, AlternativeID=None, RelatedActivity=None, DetectTime=None, StartTime=None, EndTime=None, ReportTime=None, Description=None, Assessment=None, Method=None, Contact=None, EventData=None, History=None, AdditionalData=None):
        self.lang = _cast(None, lang)
        self.restriction = _cast(None, restriction)
        self.ext_purpose = _cast(None, ext_purpose)
        self.purpose = _cast(None, purpose)
        self.IncidentID = IncidentID
        self.AlternativeID = AlternativeID
        self.RelatedActivity = RelatedActivity
        self.DetectTime = DetectTime
        self.StartTime = StartTime
        self.EndTime = EndTime
        self.ReportTime = ReportTime
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if Assessment is None:
            self.Assessment = []
        else:
            self.Assessment = Assessment
        if Method is None:
            self.Method = []
        else:
            self.Method = Method
        if Contact is None:
            self.Contact = []
        else:
            self.Contact = Contact
        if EventData is None:
            self.EventData = []
        else:
            self.EventData = EventData
        self.History = History
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if Incident.subclass:
            return Incident.subclass(*args_, **kwargs_)
        else:
            return Incident(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IncidentID(self): return self.IncidentID
    def set_IncidentID(self, IncidentID): self.IncidentID = IncidentID
    def get_AlternativeID(self): return self.AlternativeID
    def set_AlternativeID(self, AlternativeID): self.AlternativeID = AlternativeID
    def get_RelatedActivity(self): return self.RelatedActivity
    def set_RelatedActivity(self, RelatedActivity): self.RelatedActivity = RelatedActivity
    def get_DetectTime(self): return self.DetectTime
    def set_DetectTime(self, DetectTime): self.DetectTime = DetectTime
    def get_StartTime(self): return self.StartTime
    def set_StartTime(self, StartTime): self.StartTime = StartTime
    def get_EndTime(self): return self.EndTime
    def set_EndTime(self, EndTime): self.EndTime = EndTime
    def get_ReportTime(self): return self.ReportTime
    def set_ReportTime(self, ReportTime): self.ReportTime = ReportTime
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_Assessment(self): return self.Assessment
    def set_Assessment(self, Assessment): self.Assessment = Assessment
    def add_Assessment(self, value): self.Assessment.append(value)
    def insert_Assessment(self, index, value): self.Assessment[index] = value
    def get_Method(self): return self.Method
    def set_Method(self, Method): self.Method = Method
    def add_Method(self, value): self.Method.append(value)
    def insert_Method(self, index, value): self.Method[index] = value
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def add_Contact(self, value): self.Contact.append(value)
    def insert_Contact(self, index, value): self.Contact[index] = value
    def get_EventData(self): return self.EventData
    def set_EventData(self, EventData): self.EventData = EventData
    def add_EventData(self, value): self.EventData.append(value)
    def insert_EventData(self, index, value): self.EventData[index] = value
    def get_History(self): return self.History
    def set_History(self, History): self.History = History
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_ext_purpose(self): return self.ext_purpose
    def set_ext_purpose(self, ext_purpose): self.ext_purpose = ext_purpose
    def get_purpose(self): return self.purpose
    def set_purpose(self, purpose): self.purpose = purpose
    def export(self, outfile, level, namespace_='iodef:', name_='Incident', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Incident')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Incident'):
        if self.lang is not None:
            outfile.write(' lang=%s' % (quote_attrib(self.lang), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.ext_purpose is not None:
            outfile.write(' ext-purpose=%s' % (self.format_string(quote_attrib(self.ext_purpose).encode(ExternalEncoding), input_name='ext-purpose'), ))
        outfile.write(' purpose=%s' % (quote_attrib(self.purpose), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Incident'):
        if self.IncidentID:
            self.IncidentID.export(outfile, level, namespace_, name_='IncidentID', )
        if self.AlternativeID:
            self.AlternativeID.export(outfile, level, namespace_, name_='AlternativeID')
        if self.RelatedActivity:
            self.RelatedActivity.export(outfile, level, namespace_, name_='RelatedActivity')
        if self.DetectTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sDetectTime>%s</%sDetectTime>\n' % (namespace_, self.format_string(quote_xml(self.DetectTime).encode(ExternalEncoding), input_name='DetectTime'), namespace_))
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_))
        if self.ReportTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sReportTime>%s</%sReportTime>\n' % (namespace_, self.format_string(quote_xml(self.ReportTime).encode(ExternalEncoding), input_name='ReportTime'), namespace_))
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        for Assessment_ in self.Assessment:
            Assessment_.export(outfile, level, namespace_, name_='Assessment')
        for Method_ in self.Method:
            Method_.export(outfile, level, namespace_, name_='Method')
        for Contact_ in self.Contact:
            Contact_.export(outfile, level, namespace_, name_='Contact')
        for EventData_ in self.EventData:
            EventData_.export(outfile, level, namespace_, name_='EventData')
        if self.History:
            self.History.export(outfile, level, namespace_, name_='History')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self,  level, namespace_='iodef:', name_='Incident', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Incident')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Incident'):
        expStr = ''
        if self.lang is not None:
            expStr += ' lang=%s' % (quote_attrib(self.lang), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.ext_purpose is not None:
            expStr += ' ext-purpose=%s' % (self.format_string(quote_attrib(self.ext_purpose).encode(ExternalEncoding), input_name='ext-purpose'), )
        expStr += ' purpose=%s' % (quote_attrib(self.purpose), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Incident'):
        expStr = ''
        if self.IncidentID:
            expStr += self.IncidentID.exportS( level, namespace_, name_='IncidentID', )
        if self.AlternativeID:
            expStr += self.AlternativeID.exportS( level, namespace_, name_='AlternativeID')
        if self.RelatedActivity:
            expStr += self.RelatedActivity.exportS( level, namespace_, name_='RelatedActivity')
        if self.DetectTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sDetectTime>%s</%sDetectTime>\n' % (namespace_, self.format_string(quote_xml(self.DetectTime).encode(ExternalEncoding), input_name='DetectTime'), namespace_)
        if self.StartTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_)
        if self.EndTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_)
        if self.ReportTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sReportTime>%s</%sReportTime>\n' % (namespace_, self.format_string(quote_xml(self.ReportTime).encode(ExternalEncoding), input_name='ReportTime'), namespace_)
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        for Assessment_ in self.Assessment:
            expStr += Assessment_.exportS( level, namespace_, name_='Assessment')
        for Method_ in self.Method:
            expStr += Method_.exportS( level, namespace_, name_='Method')
        for Contact_ in self.Contact:
            expStr += Contact_.exportS( level, namespace_, name_='Contact')
        for EventData_ in self.EventData:
            expStr += EventData_.exportS( level, namespace_, name_='EventData')
        if self.History:
            expStr += self.History.exportS( level, namespace_, name_='History')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.IncidentID is not None or
            self.AlternativeID is not None or
            self.RelatedActivity is not None or
            self.DetectTime is not None or
            self.StartTime is not None or
            self.EndTime is not None or
            self.ReportTime is not None or
            self.Description or
            self.Assessment or
            self.Method or
            self.Contact or
            self.EventData or
            self.History is not None or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Incident'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.lang is not None:
            showIndent(outfile, level)
            outfile.write('lang = %s,\n' % (self.lang,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.ext_purpose is not None:
            showIndent(outfile, level)
            outfile.write('ext_purpose = "%s",\n' % (self.ext_purpose,))
        if self.purpose is not None:
            showIndent(outfile, level)
            outfile.write('purpose = %s,\n' % (self.purpose,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.IncidentID is not None:
            showIndent(outfile, level)
            outfile.write('IncidentID=model_.IncidentID(\n')
            self.IncidentID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AlternativeID is not None:
            showIndent(outfile, level)
            outfile.write('AlternativeID=model_.AlternativeID(\n')
            self.AlternativeID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.RelatedActivity is not None:
            showIndent(outfile, level)
            outfile.write('RelatedActivity=model_.RelatedActivity(\n')
            self.RelatedActivity.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DetectTime is not None:
            showIndent(outfile, level)
            outfile.write('DetectTime=%s,\n' % quote_python(self.DetectTime).encode(ExternalEncoding))
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('StartTime=%s,\n' % quote_python(self.StartTime).encode(ExternalEncoding))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('EndTime=%s,\n' % quote_python(self.EndTime).encode(ExternalEncoding))
        if self.ReportTime is not None:
            showIndent(outfile, level)
            outfile.write('ReportTime=%s,\n' % quote_python(self.ReportTime).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Assessment=[\n')
        level += 1
        for Assessment_ in self.Assessment:
            showIndent(outfile, level)
            outfile.write('model_.Assessment(\n')
            Assessment_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Method=[\n')
        level += 1
        for Method_ in self.Method:
            showIndent(outfile, level)
            outfile.write('model_.Method(\n')
            Method_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Contact=[\n')
        level += 1
        for Contact_ in self.Contact:
            showIndent(outfile, level)
            outfile.write('model_.Contact(\n')
            Contact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('EventData=[\n')
        level += 1
        for EventData_ in self.EventData:
            showIndent(outfile, level)
            outfile.write('model_.EventData(\n')
            EventData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.History is not None:
            showIndent(outfile, level)
            outfile.write('History=model_.History(\n')
            self.History.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('lang'):
            self.lang = attrs.get('lang').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('ext-purpose'):
            self.ext_purpose = attrs.get('ext-purpose').value
        if attrs.get('purpose'):
            self.purpose = attrs.get('purpose').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'IncidentID':
            obj_ = IncidentIDType.factory()
            obj_.build(child_)
            self.set_IncidentID(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AlternativeID':
            obj_ = AlternativeID.factory()
            obj_.build(child_)
            self.set_AlternativeID(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'RelatedActivity':
            obj_ = RelatedActivity.factory()
            obj_.build(child_)
            self.set_RelatedActivity(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'DetectTime':
            DetectTime_ = ''
            for text__content_ in child_.childNodes:
                DetectTime_ += text__content_.nodeValue
            self.DetectTime = DetectTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'StartTime':
            StartTime_ = ''
            for text__content_ in child_.childNodes:
                StartTime_ += text__content_.nodeValue
            self.StartTime = StartTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'EndTime':
            EndTime_ = ''
            for text__content_ in child_.childNodes:
                EndTime_ += text__content_.nodeValue
            self.EndTime = EndTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ReportTime':
            ReportTime_ = ''
            for text__content_ in child_.childNodes:
                ReportTime_ += text__content_.nodeValue
            self.ReportTime = ReportTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Assessment':
            obj_ = Assessment.factory()
            obj_.build(child_)
            self.Assessment.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Method':
            obj_ = Method.factory()
            obj_.build(child_)
            self.Method.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            obj_ = Contact.factory()
            obj_.build(child_)
            self.Contact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'EventData':
            obj_ = EventData.factory()
            obj_.build(child_)
            self.EventData.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'History':
            obj_ = History.factory()
            obj_.build(child_)
            self.set_History(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class Incident


class IncidentIDType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, instance=None, name=None, restriction='public', valueOf_=''):
        self.instance = _cast(None, instance)
        self.name = _cast(None, name)
        self.restriction = _cast(None, restriction)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if IncidentIDType.subclass:
            return IncidentIDType.subclass(*args_, **kwargs_)
        else:
            return IncidentIDType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_instance(self): return self.instance
    def set_instance(self, instance): self.instance = instance
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='IncidentID', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        outfile.write( showIndent(outfile, level))
        outfile.write( '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        outfile.write( self.exportAttributes(level, namespace_, name_='IncidentIDType'))
        if self.hasContent_():
            outfile.write( '>')
            outfile.write( self.exportChildren( level + 1, namespace_, name_))
            outfile.write( '</' + namespace_ + name_ + '>\n')
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='IncidentIDType'):
        if self.instance is not None:
            outfile.write(' instance=%s' % (self.format_string(quote_attrib(self.instance).encode(ExternalEncoding), input_name='instance'), ))
        outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='IncidentIDType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write( value.encode(ExternalEncoding))
        else:
            outfile.write( quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='IncidentID', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        exportString = ''
        exportString +=  showIndentS(level)
        exportString += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        exportString += self.exportAttributesS( level, namespace_, name_='IncidentIDType')
        if self.hasContent_():
            exportString += '>'
            exportString += self.exportChildrenS( level + 1, namespace_, name_)
            exportString += '</' + namespace_ + name_ + '>\n'
        else:
            exportString += '/>\n'
        return exportString
    def exportAttributesS(self, level, namespace_='iodef:', name_='IncidentIDType'):
        outfile = ''
        if self.instance is not None:
            outfile += ' instance=%s' % (self.format_string(quote_attrib(self.instance).encode(ExternalEncoding), input_name='instance'), )
        outfile += ' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), )
        if self.restriction is not None:
            outfile += ' restriction=%s' % (quote_attrib(self.restriction), )
        return outfile
    def exportChildrenS(self, level, namespace_='iodef:', name_='IncidentIDType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IncidentIDType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.instance is not None:
            showIndent(outfile, level)
            outfile.write('instance = "%s",\n' % (self.instance,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('instance'):
            self.instance = attrs.get('instance').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'

    def toPython(self):
        out = {}
        out['name'] = self.get_name()
        out['restriction'] = self.get_restriction()
        out2 = {}
        out2['IncidentID'] = []
        out2['IncidentID'].append(out)
        out2['IncidentID'].append(self.getValueOf_())
        return out2

# end class IncidentIDType


class AlternativeID(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, IncidentID=None):
        self.restriction = _cast(None, restriction)
        if IncidentID is None:
            self.IncidentID = []
        else:
            self.IncidentID = IncidentID
    def factory(*args_, **kwargs_):
        if AlternativeID.subclass:
            return AlternativeID.subclass(*args_, **kwargs_)
        else:
            return AlternativeID(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IncidentID(self): return self.IncidentID
    def set_IncidentID(self, IncidentID): self.IncidentID = IncidentID
    def add_IncidentID(self, value): self.IncidentID.append(value)
    def insert_IncidentID(self, index, value): self.IncidentID[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='AlternativeID', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='AlternativeID')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='AlternativeID'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='AlternativeID'):
        for IncidentID_ in self.IncidentID:
            IncidentID_.export(outfile, level, namespace_, name_='IncidentID')
    def exportS(self, level, namespace_='iodef:', name_='AlternativeID', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        outfile = showIndentS( level)
        outfile += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        self.exportAttributesS( level, namespace_, name_='AlternativeID')
        if self.hasContent_():
            outfile += '>\n'
            self.exportChildrenS( level + 1, namespace_, name_)
            showIndentS( level)
            outfile += '</%s%s>\n' % (namespace_, name_)
        else:
            outfile += '/>\n'
        return outfile
    def exportAttributesS(self, level, namespace_='iodef:', name_='AlternativeID'):
        if self.restriction is not None:
            return(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildrenS(self, level, namespace_='iodef:', name_='AlternativeID'):
        expStr = ''
        for IncidentID_ in self.IncidentID:
            expStr += IncidentID_.exportS( level, namespace_, name_='IncidentID')
        return expStr
    def hasContent_(self):
        if (
            self.IncidentID
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AlternativeID'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('IncidentID=[\n')
        level += 1
        for IncidentID_ in self.IncidentID:
            showIndent(outfile, level)
            outfile.write('model_.IncidentID(\n')
            IncidentID_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'IncidentID':
            obj_ = IncidentIDType.factory()
            obj_.build(child_)
            self.IncidentID.append(obj_)
# end class AlternativeID


class RelatedActivity(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, IncidentID=None, URL=None):
        self.restriction = _cast(None, restriction)
        if IncidentID is None:
            self.IncidentID = []
        else:
            self.IncidentID = IncidentID
        if URL is None:
            self.URL = []
        else:
            self.URL = URL
    def factory(*args_, **kwargs_):
        if RelatedActivity.subclass:
            return RelatedActivity.subclass(*args_, **kwargs_)
        else:
            return RelatedActivity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IncidentID(self): return self.IncidentID
    def set_IncidentID(self, IncidentID): self.IncidentID = IncidentID
    def add_IncidentID(self, value): self.IncidentID.append(value)
    def insert_IncidentID(self, index, value): self.IncidentID[index] = value
    def get_URL(self): return self.URL
    def set_URL(self, URL): self.URL = URL
    def add_URL(self, value): self.URL.append(value)
    def insert_URL(self, index, value): self.URL[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='RelatedActivity', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='RelatedActivity')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='RelatedActivity'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='RelatedActivity'):
        for IncidentID_ in self.IncidentID:
            IncidentID_.export(outfile, level, namespace_, name_='IncidentID')
        for URL_ in self.URL:
            showIndent(outfile, level)
            outfile.write('<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(URL_).encode(ExternalEncoding), input_name='URL'), namespace_))
    def exportS(self, outfile, level, namespace_='iodef:', name_='RelatedActivity', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr +=self.exportAttributesS( level, namespace_, name_='RelatedActivity')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='RelatedActivity'):
        if self.restriction is not None:
            return ' restriction=%s' % (quote_attrib(self.restriction), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='RelatedActivity'):
        expStr = ''
        for IncidentID_ in self.IncidentID:
            expStr += IncidentID_.exportS( level, namespace_, name_='IncidentID')
        for URL_ in self.URL:
            expStr += showIndentS( level)
            expStr += '<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(URL_).encode(ExternalEncoding), input_name='URL'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.IncidentID or
            self.URL
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RelatedActivity'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('IncidentID=[\n')
        level += 1
        for IncidentID_ in self.IncidentID:
            showIndent(outfile, level)
            outfile.write('model_.IncidentID(\n')
            IncidentID_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('URL=[\n')
        level += 1
        for URL_ in self.URL:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(URL_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'IncidentID':
            obj_ = IncidentIDType.factory()
            obj_.build(child_)
            self.IncidentID.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'URL':
            URL_ = ''
            for text__content_ in child_.childNodes:
                URL_ += text__content_.nodeValue
            self.URL.append(URL_)
# end class RelatedActivity


class Contact(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, role=None, ext_type=None, ext_role=None, restriction=None, ContactName=None, Description=None, RegistryHandle=None, PostalAddress=None, Email=None, Telephone=None, Fax=None, Timezone=None, Contact=None, AdditionalData=None):
        self.type_ = _cast(None, type_)
        self.role = _cast(None, role)
        self.ext_type = _cast(None, ext_type)
        self.ext_role = _cast(None, ext_role)
        self.restriction = _cast(None, restriction)
        self.ContactName = ContactName
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if RegistryHandle is None:
            self.RegistryHandle = []
        else:
            self.RegistryHandle = RegistryHandle
        self.PostalAddress = PostalAddress
        if Email is None:
            self.Email = []
        else:
            self.Email = Email
        if Telephone is None:
            self.Telephone = []
        else:
            self.Telephone = Telephone
        self.Fax = Fax
        self.Timezone = Timezone
        if Contact is None:
            self.Contact = []
        else:
            self.Contact = Contact
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if Contact.subclass:
            return Contact.subclass(*args_, **kwargs_)
        else:
            return Contact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ContactName(self): return self.ContactName
    def set_ContactName(self, ContactName): self.ContactName = ContactName
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_RegistryHandle(self): return self.RegistryHandle
    def set_RegistryHandle(self, RegistryHandle): self.RegistryHandle = RegistryHandle
    def add_RegistryHandle(self, value): self.RegistryHandle.append(value)
    def insert_RegistryHandle(self, index, value): self.RegistryHandle[index] = value
    def get_PostalAddress(self): return self.PostalAddress
    def set_PostalAddress(self, PostalAddress): self.PostalAddress = PostalAddress
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def add_Email(self, value): self.Email.append(value)
    def insert_Email(self, index, value): self.Email[index] = value
    def get_Telephone(self): return self.Telephone
    def set_Telephone(self, Telephone): self.Telephone = Telephone
    def add_Telephone(self, value): self.Telephone.append(value)
    def insert_Telephone(self, index, value): self.Telephone[index] = value
    def get_Fax(self): return self.Fax
    def set_Fax(self, Fax): self.Fax = Fax
    def get_Timezone(self): return self.Timezone
    def set_Timezone(self, Timezone): self.Timezone = Timezone
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def add_Contact(self, value): self.Contact.append(value)
    def insert_Contact(self, index, value): self.Contact[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def get_ext_type(self): return self.ext_type
    def set_ext_type(self, ext_type): self.ext_type = ext_type
    def get_ext_role(self): return self.ext_role
    def set_ext_role(self, ext_role): self.ext_role = ext_role
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='Contact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Contact')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Contact'):
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        outfile.write(' role=%s' % (quote_attrib(self.role), ))
        if self.ext_type is not None:
            outfile.write(' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), ))
        if self.ext_role is not None:
            outfile.write(' ext-role=%s' % (self.format_string(quote_attrib(self.ext_role).encode(ExternalEncoding), input_name='ext-role'), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Contact'):
        if self.ContactName:
            self.ContactName.export(outfile, level, namespace_, name_='ContactName')
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        for RegistryHandle_ in self.RegistryHandle:
            RegistryHandle_.export(outfile, level, namespace_, name_='RegistryHandle')
        if self.PostalAddress:
            self.PostalAddress.export(outfile, level, namespace_, name_='PostalAddress')
        for Email_ in self.Email:
            Email_.export(outfile, level, namespace_, name_='Email')
        for Telephone_ in self.Telephone:
            Telephone_.export(outfile, level, namespace_, name_='Telephone')
        if self.Fax:
            self.Fax.export(outfile, level, namespace_, name_='Fax')
        if self.Timezone is not None:
            showIndent(outfile, level)
            outfile.write('<%sTimezone>%s</%sTimezone>\n' % (namespace_, self.format_string(quote_xml(self.Timezone).encode(ExternalEncoding), input_name='Timezone'), namespace_))
        for Contact_ in self.Contact:
            Contact_.export(outfile, level, namespace_, name_='Contact')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='Contact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Contact')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Contact'):
        expStr = ' type=%s' % (quote_attrib(self.type_), )
        expStr += ' role=%s' % (quote_attrib(self.role), )
        if self.ext_type is not None:
            expStr += ' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), )
        if self.ext_role is not None:
            expStr += ' ext-role=%s' % (self.format_string(quote_attrib(self.ext_role).encode(ExternalEncoding), input_name='ext-role'), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Contact'):
        expStr = ''
        if self.ContactName:
            expStr += self.ContactName.exportS( level, namespace_, name_='ContactName')
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        for RegistryHandle_ in self.RegistryHandle:
            expStr += RegistryHandle_.exportS( level, namespace_, name_='RegistryHandle')
        if self.PostalAddress:
            expStr += self.PostalAddress.exportS( level, namespace_, name_='PostalAddress')
        for Email_ in self.Email:
            expStr += Email_.exportS( level, namespace_, name_='Email')
        for Telephone_ in self.Telephone:
            expStr += Telephone_.exportS( level, namespace_, name_='Telephone')
        if self.Fax:
            expStr += self.Fax.exportS( level, namespace_, name_='Fax')
        if self.Timezone is not None:
            expStr += showIndentS( level)
            expStr += '<%sTimezone>%s</%sTimezone>\n' % (namespace_, self.format_string(quote_xml(self.Timezone).encode(ExternalEncoding), input_name='Timezone'), namespace_)
        for Contact_ in self.Contact:
            expStr += Contact_.exportS( level, namespace_, name_='Contact')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.ContactName is not None or
            self.Description or
            self.RegistryHandle or
            self.PostalAddress is not None or
            self.Email or
            self.Telephone or
            self.Fax is not None or
            self.Timezone is not None or
            self.Contact or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Contact'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.role is not None:
            showIndent(outfile, level)
            outfile.write('role = %s,\n' % (self.role,))
        if self.ext_type is not None:
            showIndent(outfile, level)
            outfile.write('ext_type = "%s",\n' % (self.ext_type,))
        if self.ext_role is not None:
            showIndent(outfile, level)
            outfile.write('ext_role = "%s",\n' % (self.ext_role,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ContactName is not None:
            showIndent(outfile, level)
            outfile.write('ContactName=model_.ContactName(\n')
            self.ContactName.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('RegistryHandle=[\n')
        level += 1
        for RegistryHandle_ in self.RegistryHandle:
            showIndent(outfile, level)
            outfile.write('model_.RegistryHandle(\n')
            RegistryHandle_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.PostalAddress is not None:
            showIndent(outfile, level)
            outfile.write('PostalAddress=model_.PostalAddress(\n')
            self.PostalAddress.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Email=[\n')
        level += 1
        for Email_ in self.Email:
            showIndent(outfile, level)
            outfile.write('model_.Email(\n')
            Email_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Telephone=[\n')
        level += 1
        for Telephone_ in self.Telephone:
            showIndent(outfile, level)
            outfile.write('model_.Telephone(\n')
            Telephone_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Fax is not None:
            showIndent(outfile, level)
            outfile.write('Fax=model_.Fax(\n')
            self.Fax.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Timezone is not None:
            showIndent(outfile, level)
            outfile.write('Timezone=%s,\n' % quote_python(self.Timezone).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Contact=[\n')
        level += 1
        for Contact_ in self.Contact:
            showIndent(outfile, level)
            outfile.write('model_.Contact(\n')
            Contact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('role'):
            self.role = attrs.get('role').value
        if attrs.get('ext-type'):
            self.ext_type = attrs.get('ext-type').value
        if attrs.get('ext-role'):
            self.ext_role = attrs.get('ext-role').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ContactName':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.set_ContactName(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'RegistryHandle':
            obj_ = RegistryHandle.factory()
            obj_.build(child_)
            self.RegistryHandle.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'PostalAddress':
            obj_ = PostalAddress.factory()
            obj_.build(child_)
            self.set_PostalAddress(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Email':
            obj_ = ContactMeansType.factory()
            obj_.build(child_)
            self.Email.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Telephone':
            obj_ = ContactMeansType.factory()
            obj_.build(child_)
            self.Telephone.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Fax':
            obj_ = ContactMeansType.factory()
            obj_.build(child_)
            self.set_Fax(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Timezone':
            Timezone_ = ''
            for text__content_ in child_.childNodes:
                Timezone_ += text__content_.nodeValue
            self.Timezone = Timezone_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            obj_ = Contact.factory()
            obj_.build(child_)
            self.Contact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class Contact


class RegistryHandle(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, registry=None, ext_registry=None, valueOf_=''):
        self.registry = _cast(None, registry)
        self.ext_registry = _cast(None, ext_registry)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if RegistryHandle.subclass:
            return RegistryHandle.subclass(*args_, **kwargs_)
        else:
            return RegistryHandle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_registry(self): return self.registry
    def set_registry(self, registry): self.registry = registry
    def get_ext_registry(self): return self.ext_registry
    def set_ext_registry(self, ext_registry): self.ext_registry = ext_registry
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='RegistryHandle', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='RegistryHandle')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='RegistryHandle'):
        if self.registry is not None:
            outfile.write(' registry=%s' % (quote_attrib(self.registry), ))
        if self.ext_registry is not None:
            outfile.write(' ext-registry=%s' % (self.format_string(quote_attrib(self.ext_registry).encode(ExternalEncoding), input_name='ext-registry'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='RegistryHandle'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self,  level, namespace_='iodef:', name_='RegistryHandle', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='RegistryHandle')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='RegistryHandle'):
        expStr = ''
        if self.registry is not None:
            expStr += ' registry=%s' % (quote_attrib(self.registry), )
        if self.ext_registry is not None:
            expStr += ' ext-registry=%s' % (self.format_string(quote_attrib(self.ext_registry).encode(ExternalEncoding), input_name='ext-registry'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='RegistryHandle'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RegistryHandle'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.registry is not None:
            showIndent(outfile, level)
            outfile.write('registry = %s,\n' % (self.registry,))
        if self.ext_registry is not None:
            showIndent(outfile, level)
            outfile.write('ext_registry = "%s",\n' % (self.ext_registry,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('registry'):
            self.registry = attrs.get('registry').value
        if attrs.get('ext-registry'):
            self.ext_registry = attrs.get('ext-registry').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class RegistryHandle


class ContactMeansType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, meaning=None, valueOf_=''):
        self.meaning = _cast(None, meaning)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ContactMeansType.subclass:
            return ContactMeansType.subclass(*args_, **kwargs_)
        else:
            return ContactMeansType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meaning(self): return self.meaning
    def set_meaning(self, meaning): self.meaning = meaning
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='ContactMeansType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ContactMeansType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='ContactMeansType'):
        if self.meaning is not None:
            outfile.write(' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='ContactMeansType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='ContactMeansType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='ContactMeansType')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='ContactMeansType'):
        if self.meaning is not None:
            return ' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), )
        return ''
    def exportChildrenS(self, level, namespace_='iodef:', name_='ContactMeansType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContactMeansType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.meaning is not None:
            showIndent(outfile, level)
            outfile.write('meaning = "%s",\n' % (self.meaning,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('meaning'):
            self.meaning = attrs.get('meaning').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class ContactMeansType


class History(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction='default', HistoryItem=None):
        self.restriction = _cast(None, restriction)
        if HistoryItem is None:
            self.HistoryItem = []
        else:
            self.HistoryItem = HistoryItem
    def factory(*args_, **kwargs_):
        if History.subclass:
            return History.subclass(*args_, **kwargs_)
        else:
            return History(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HistoryItem(self): return self.HistoryItem
    def set_HistoryItem(self, HistoryItem): self.HistoryItem = HistoryItem
    def add_HistoryItem(self, value): self.HistoryItem.append(value)
    def insert_HistoryItem(self, index, value): self.HistoryItem[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='History', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='History')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='History'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='History'):
        for HistoryItem_ in self.HistoryItem:
            HistoryItem_.export(outfile, level, namespace_, name_='HistoryItem')
    def exportS(self, level, namespace_='iodef:', name_='History', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='History')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='History'):
        if self.restriction is not None:
            return ' restriction=%s' % (quote_attrib(self.restriction), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='History'):
        expStr = ''
        for HistoryItem_ in self.HistoryItem:
            expStr += HistoryItem_.exportS( level, namespace_, name_='HistoryItem')
        return expStr
    def hasContent_(self):
        if (
            self.HistoryItem
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='History'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('HistoryItem=[\n')
        level += 1
        for HistoryItem_ in self.HistoryItem:
            showIndent(outfile, level)
            outfile.write('model_.HistoryItem(\n')
            HistoryItem_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'HistoryItem':
            obj_ = HistoryItem.factory()
            obj_.build(child_)
            self.HistoryItem.append(obj_)
# end class History


class HistoryItem(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, action=None, restriction=None, ext_action=None, DateTime=None, IncidentID=None, Contact=None, Description=None, AdditionalData=None):
        self.action = _cast(None, action)
        self.restriction = _cast(None, restriction)
        self.ext_action = _cast(None, ext_action)
        self.DateTime = DateTime
        self.IncidentID = IncidentID
        self.Contact = Contact
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if HistoryItem.subclass:
            return HistoryItem.subclass(*args_, **kwargs_)
        else:
            return HistoryItem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateTime(self): return self.DateTime
    def set_DateTime(self, DateTime): self.DateTime = DateTime
    def get_IncidentID(self): return self.IncidentID
    def set_IncidentID(self, IncidentID): self.IncidentID = IncidentID
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_ext_action(self): return self.ext_action
    def set_ext_action(self, ext_action): self.ext_action = ext_action
    def export(self, outfile, level, namespace_='iodef:', name_='HistoryItem', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='HistoryItem')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='HistoryItem'):
        outfile.write(' action=%s' % (quote_attrib(self.action), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.ext_action is not None:
            outfile.write(' ext-action=%s' % (self.format_string(quote_attrib(self.ext_action).encode(ExternalEncoding), input_name='ext-action'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='HistoryItem'):
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_))
        if self.IncidentID:
            self.IncidentID.export(outfile, level, namespace_, name_='IncidentID')
        if self.Contact:
            self.Contact.export(outfile, level, namespace_, name_='Contact')
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='HistoryItem', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='HistoryItem')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='HistoryItem'):
        expStr = ' action=%s' % (quote_attrib(self.action), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.ext_action is not None:
            expStr += ' ext-action=%s' % (self.format_string(quote_attrib(self.ext_action).encode(ExternalEncoding), input_name='ext-action'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='HistoryItem'):
        expStr = ''
        if self.DateTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_)
        if self.IncidentID:
            expStr += self.IncidentID.exportS( level, namespace_, name_='IncidentID')
        if self.Contact:
            expStr += self.Contact.exportS( level, namespace_, name_='Contact')
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.DateTime is not None or
            self.IncidentID is not None or
            self.Contact is not None or
            self.Description or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HistoryItem'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.action is not None:
            showIndent(outfile, level)
            outfile.write('action = %s,\n' % (self.action,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.ext_action is not None:
            showIndent(outfile, level)
            outfile.write('ext_action = "%s",\n' % (self.ext_action,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('DateTime=%s,\n' % quote_python(self.DateTime).encode(ExternalEncoding))
        if self.IncidentID is not None:
            showIndent(outfile, level)
            outfile.write('IncidentID=model_.IncidentID(\n')
            self.IncidentID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Contact is not None:
            showIndent(outfile, level)
            outfile.write('Contact=model_.Contact(\n')
            self.Contact.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('action'):
            self.action = attrs.get('action').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('ext-action'):
            self.ext_action = attrs.get('ext-action').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'DateTime':
            DateTime_ = ''
            for text__content_ in child_.childNodes:
                DateTime_ += text__content_.nodeValue
            self.DateTime = DateTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'IncidentID':
            obj_ = IncidentIDType.factory()
            obj_.build(child_)
            self.set_IncidentID(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            obj_ = Contact.factory()
            obj_.build(child_)
            self.set_Contact(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class HistoryItem


class Expectation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, action='other', restriction='default', ext_action=None, severity=None, Description=None, StartTime=None, EndTime=None, Contact=None):
        self.action = _cast(None, action)
        self.restriction = _cast(None, restriction)
        self.ext_action = _cast(None, ext_action)
        self.severity = _cast(None, severity)
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        self.StartTime = StartTime
        self.EndTime = EndTime
        self.Contact = Contact
    def factory(*args_, **kwargs_):
        if Expectation.subclass:
            return Expectation.subclass(*args_, **kwargs_)
        else:
            return Expectation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_StartTime(self): return self.StartTime
    def set_StartTime(self, StartTime): self.StartTime = StartTime
    def get_EndTime(self): return self.EndTime
    def set_EndTime(self, EndTime): self.EndTime = EndTime
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_ext_action(self): return self.ext_action
    def set_ext_action(self, ext_action): self.ext_action = ext_action
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def export(self, outfile, level, namespace_='iodef:', name_='Expectation', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Expectation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Expectation'):
        if self.action is not None:
            outfile.write(' action=%s' % (quote_attrib(self.action), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.ext_action is not None:
            outfile.write(' ext-action=%s' % (self.format_string(quote_attrib(self.ext_action).encode(ExternalEncoding), input_name='ext-action'), ))
        if self.severity is not None:
            outfile.write(' severity=%s' % (quote_attrib(self.severity), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Expectation'):
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_))
        if self.Contact:
            self.Contact.export(outfile, level, namespace_, name_='Contact')
    def exportS(self, level, namespace_='iodef:', name_='Expectation', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Expectation')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Expectation'):
        expStr = ''
        if self.action is not None:
            expStr += ' action=%s' % (quote_attrib(self.action), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.ext_action is not None:
            expStr += ' ext-action=%s' % (self.format_string(quote_attrib(self.ext_action).encode(ExternalEncoding), input_name='ext-action'), )
        if self.severity is not None:
            expStr += ' severity=%s' % (quote_attrib(self.severity), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Expectation'):
        expStr = ''
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        if self.StartTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_)
        if self.EndTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_)
        if self.Contact:
            expStr += self.Contact.exportS( level, namespace_, name_='Contact')
        return expStr
    def hasContent_(self):
        if (
            self.Description or
            self.StartTime is not None or
            self.EndTime is not None or
            self.Contact is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Expectation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.action is not None:
            showIndent(outfile, level)
            outfile.write('action = %s,\n' % (self.action,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.ext_action is not None:
            showIndent(outfile, level)
            outfile.write('ext_action = "%s",\n' % (self.ext_action,))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity = %s,\n' % (self.severity,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('StartTime=%s,\n' % quote_python(self.StartTime).encode(ExternalEncoding))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('EndTime=%s,\n' % quote_python(self.EndTime).encode(ExternalEncoding))
        if self.Contact is not None:
            showIndent(outfile, level)
            outfile.write('Contact=model_.Contact(\n')
            self.Contact.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('action'):
            self.action = attrs.get('action').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('ext-action'):
            self.ext_action = attrs.get('ext-action').value
        if attrs.get('severity'):
            self.severity = attrs.get('severity').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'StartTime':
            StartTime_ = ''
            for text__content_ in child_.childNodes:
                StartTime_ += text__content_.nodeValue
            self.StartTime = StartTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'EndTime':
            EndTime_ = ''
            for text__content_ in child_.childNodes:
                EndTime_ += text__content_.nodeValue
            self.EndTime = EndTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            obj_ = Contact.factory()
            obj_.build(child_)
            self.set_Contact(obj_)
# end class Expectation


class Method(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, Reference=None, Description=None, AdditionalData=None):
        self.restriction = _cast(None, restriction)
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if Method.subclass:
            return Method.subclass(*args_, **kwargs_)
        else:
            return Method(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def add_Reference(self, value): self.Reference.append(value)
    def insert_Reference(self, index, value): self.Reference[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='Method', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Method')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Method'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Method'):
        for Reference_ in self.Reference:
            Reference_.export(outfile, level, namespace_, name_='Reference')
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='Method', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Method')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Method'):
        if self.restriction is not None:
            return ' restriction=%s' % (quote_attrib(self.restriction), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='Method'):
        for Reference_ in self.Reference:
            expStr += Reference_.exportS( level, namespace_, name_='Reference')
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.Reference or
            self.Description or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Method'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Reference=[\n')
        level += 1
        for Reference_ in self.Reference:
            showIndent(outfile, level)
            outfile.write('model_.Reference(\n')
            Reference_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Reference':
            obj_ = Reference.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class Method


class Reference(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ReferenceName=None, URL=None, Description=None):
        self.ReferenceName = ReferenceName
        if URL is None:
            self.URL = []
        else:
            self.URL = URL
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
    def factory(*args_, **kwargs_):
        if Reference.subclass:
            return Reference.subclass(*args_, **kwargs_)
        else:
            return Reference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ReferenceName(self): return self.ReferenceName
    def set_ReferenceName(self, ReferenceName): self.ReferenceName = ReferenceName
    def get_URL(self): return self.URL
    def set_URL(self, URL): self.URL = URL
    def add_URL(self, value): self.URL.append(value)
    def insert_URL(self, index, value): self.URL[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def export(self, outfile, level, namespace_='iodef:', name_='Reference', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Reference')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Reference'):
        pass
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Reference'):
        if self.ReferenceName:
            self.ReferenceName.export(outfile, level, namespace_, name_='ReferenceName', )
        for URL_ in self.URL:
            showIndent(outfile, level)
            outfile.write('<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(URL_).encode(ExternalEncoding), input_name='URL'), namespace_))
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
    def exportS(self, level, namespace_='iodef:', name_='Reference', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Reference')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Reference'):
        pass
    def exportChildrenS(self, level, namespace_='iodef:', name_='Reference'):
        expStr = ''
        if self.ReferenceName:
            expStr += self.ReferenceName.exportS( level, namespace_, name_='ReferenceName', )
        for URL_ in self.URL:
            expStr += showIndentS( level)
            expStr += '<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(URL_).encode(ExternalEncoding), input_name='URL'), namespace_)
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        return expStr
    def hasContent_(self):
        if (
            self.ReferenceName is not None or
            self.URL or
            self.Description
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Reference'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ReferenceName is not None:
            showIndent(outfile, level)
            outfile.write('ReferenceName=model_.MLStringType(\n')
            self.ReferenceName.exportLiteral(outfile, level, name_='ReferenceName')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('URL=[\n')
        level += 1
        for URL_ in self.URL:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(URL_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ReferenceName':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.set_ReferenceName(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'URL':
            URL_ = ''
            for text__content_ in child_.childNodes:
                URL_ += text__content_.nodeValue
            self.URL.append(URL_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
# end class Reference


class Assessment(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, occurrence=None, Impact=None, TimeImpact=None, MonetaryImpact=None, Counter=None, Confidence=None, AdditionalData=None):
        self.restriction = _cast(None, restriction)
        self.occurrence = _cast(None, occurrence)
        if Impact is None:
            self.Impact = []
        else:
            self.Impact = Impact
        if TimeImpact is None:
            self.TimeImpact = []
        else:
            self.TimeImpact = TimeImpact
        if MonetaryImpact is None:
            self.MonetaryImpact = []
        else:
            self.MonetaryImpact = MonetaryImpact
        if Counter is None:
            self.Counter = []
        else:
            self.Counter = Counter
        self.Confidence = Confidence
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if Assessment.subclass:
            return Assessment.subclass(*args_, **kwargs_)
        else:
            return Assessment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Impact(self): return self.Impact
    def set_Impact(self, Impact): self.Impact = Impact
    def add_Impact(self, value): self.Impact.append(value)
    def insert_Impact(self, index, value): self.Impact[index] = value
    def get_TimeImpact(self): return self.TimeImpact
    def set_TimeImpact(self, TimeImpact): self.TimeImpact = TimeImpact
    def add_TimeImpact(self, value): self.TimeImpact.append(value)
    def insert_TimeImpact(self, index, value): self.TimeImpact[index] = value
    def get_MonetaryImpact(self): return self.MonetaryImpact
    def set_MonetaryImpact(self, MonetaryImpact): self.MonetaryImpact = MonetaryImpact
    def add_MonetaryImpact(self, value): self.MonetaryImpact.append(value)
    def insert_MonetaryImpact(self, index, value): self.MonetaryImpact[index] = value
    def get_Counter(self): return self.Counter
    def set_Counter(self, Counter): self.Counter = Counter
    def add_Counter(self, value): self.Counter.append(value)
    def insert_Counter(self, index, value): self.Counter[index] = value
    def get_Confidence(self): return self.Confidence
    def set_Confidence(self, Confidence): self.Confidence = Confidence
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_occurrence(self): return self.occurrence
    def set_occurrence(self, occurrence): self.occurrence = occurrence
    def export(self, outfile, level, namespace_='iodef:', name_='Assessment', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Assessment')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Assessment'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.occurrence is not None:
            outfile.write(' occurrence=%s' % (quote_attrib(self.occurrence), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Assessment'):
        for Impact_ in self.Impact:
            Impact_.export(outfile, level, namespace_, name_='Impact')
        for TimeImpact_ in self.TimeImpact:
            TimeImpact_.export(outfile, level, namespace_, name_='TimeImpact')
        for MonetaryImpact_ in self.MonetaryImpact:
            MonetaryImpact_.export(outfile, level, namespace_, name_='MonetaryImpact')
        for Counter_ in self.Counter:
            Counter_.export(outfile, level, namespace_, name_='Counter')
        if self.Confidence:
            self.Confidence.export(outfile, level, namespace_, name_='Confidence')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='Assessment', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Assessment')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Assessment'):
        expStr = ''
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.occurrence is not None:
            expStr += ' occurrence=%s' % (quote_attrib(self.occurrence), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Assessment'):
        expStr = ''
        for Impact_ in self.Impact:
            expStr += Impact_.exportS( level, namespace_, name_='Impact')
        for TimeImpact_ in self.TimeImpact:
            expStr += TimeImpact_.exportS( level, namespace_, name_='TimeImpact')
        for MonetaryImpact_ in self.MonetaryImpact:
            expStr += MonetaryImpact_.exportS( level, namespace_, name_='MonetaryImpact')
        for Counter_ in self.Counter:
            expStr += Counter_.exportS( level, namespace_, name_='Counter')
        if self.Confidence:
            expStr += self.Confidence.exportS( level, namespace_, name_='Confidence')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.Impact or
            self.TimeImpact or
            self.MonetaryImpact or
            self.Counter or
            self.Confidence is not None or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Assessment'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.occurrence is not None:
            showIndent(outfile, level)
            outfile.write('occurrence = %s,\n' % (self.occurrence,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Impact=[\n')
        level += 1
        for Impact_ in self.Impact:
            showIndent(outfile, level)
            outfile.write('model_.Impact(\n')
            Impact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('TimeImpact=[\n')
        level += 1
        for TimeImpact_ in self.TimeImpact:
            showIndent(outfile, level)
            outfile.write('model_.TimeImpact(\n')
            TimeImpact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('MonetaryImpact=[\n')
        level += 1
        for MonetaryImpact_ in self.MonetaryImpact:
            showIndent(outfile, level)
            outfile.write('model_.MonetaryImpact(\n')
            MonetaryImpact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Counter=[\n')
        level += 1
        for Counter_ in self.Counter:
            showIndent(outfile, level)
            outfile.write('model_.Counter(\n')
            Counter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Confidence is not None:
            showIndent(outfile, level)
            outfile.write('Confidence=model_.Confidence(\n')
            self.Confidence.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('occurrence'):
            self.occurrence = attrs.get('occurrence').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Impact':
            obj_ = Impact.factory()
            obj_.build(child_)
            self.Impact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'TimeImpact':
            obj_ = TimeImpact.factory()
            obj_.build(child_)
            self.TimeImpact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'MonetaryImpact':
            obj_ = MonetaryImpact.factory()
            obj_.build(child_)
            self.MonetaryImpact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Counter':
            obj_ = Counter.factory()
            obj_.build(child_)
            self.Counter.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.set_Confidence(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class Assessment


class TimeImpact(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ext_metric=None, duration=None, metric=None, severity=None, ext_duration=None, valueOf_=''):
        self.ext_metric = _cast(None, ext_metric)
        self.duration = _cast(None, duration)
        self.metric = _cast(None, metric)
        self.severity = _cast(None, severity)
        self.ext_duration = _cast(None, ext_duration)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TimeImpact.subclass:
            return TimeImpact.subclass(*args_, **kwargs_)
        else:
            return TimeImpact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ext_metric(self): return self.ext_metric
    def set_ext_metric(self, ext_metric): self.ext_metric = ext_metric
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_metric(self): return self.metric
    def set_metric(self, metric): self.metric = metric
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_ext_duration(self): return self.ext_duration
    def set_ext_duration(self, ext_duration): self.ext_duration = ext_duration
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='TimeImpact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='TimeImpact')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='TimeImpact'):
        if self.ext_metric is not None:
            outfile.write(' ext-metric=%s' % (self.format_string(quote_attrib(self.ext_metric).encode(ExternalEncoding), input_name='ext-metric'), ))
        if self.duration is not None:
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        outfile.write(' metric=%s' % (quote_attrib(self.metric), ))
        if self.severity is not None:
            outfile.write(' severity=%s' % (quote_attrib(self.severity), ))
        if self.ext_duration is not None:
            outfile.write(' ext-duration=%s' % (self.format_string(quote_attrib(self.ext_duration).encode(ExternalEncoding), input_name='ext-duration'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='TimeImpact'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='TimeImpact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='TimeImpact')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='TimeImpact'):
        expStr = ''
        if self.ext_metric is not None:
            expStr += ' ext-metric=%s' % (self.format_string(quote_attrib(self.ext_metric).encode(ExternalEncoding), input_name='ext-metric'), )
        if self.duration is not None:
            expStr += ' duration=%s' % (quote_attrib(self.duration), )
        expStr += ' metric=%s' % (quote_attrib(self.metric), )
        if self.severity is not None:
            expStr += ' severity=%s' % (quote_attrib(self.severity), )
        if self.ext_duration is not None:
            expStr += ' ext-duration=%s' % (self.format_string(quote_attrib(self.ext_duration).encode(ExternalEncoding), input_name='ext-duration'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='TimeImpact'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TimeImpact'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ext_metric is not None:
            showIndent(outfile, level)
            outfile.write('ext_metric = "%s",\n' % (self.ext_metric,))
        if self.duration is not None:
            showIndent(outfile, level)
            outfile.write('duration = %s,\n' % (self.duration,))
        if self.metric is not None:
            showIndent(outfile, level)
            outfile.write('metric = %s,\n' % (self.metric,))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity = %s,\n' % (self.severity,))
        if self.ext_duration is not None:
            showIndent(outfile, level)
            outfile.write('ext_duration = "%s",\n' % (self.ext_duration,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ext-metric'):
            self.ext_metric = attrs.get('ext-metric').value
        if attrs.get('duration'):
            self.duration = attrs.get('duration').value
        if attrs.get('metric'):
            self.metric = attrs.get('metric').value
        if attrs.get('severity'):
            self.severity = attrs.get('severity').value
        if attrs.get('ext-duration'):
            self.ext_duration = attrs.get('ext-duration').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class TimeImpact


class MonetaryImpact(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, currency=None, severity=None, valueOf_=''):
        self.currency = _cast(None, currency)
        self.severity = _cast(None, severity)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MonetaryImpact.subclass:
            return MonetaryImpact.subclass(*args_, **kwargs_)
        else:
            return MonetaryImpact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_currency(self): return self.currency
    def set_currency(self, currency): self.currency = currency
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='MonetaryImpact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MonetaryImpact')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='MonetaryImpact'):
        if self.currency is not None:
            outfile.write(' currency=%s' % (self.format_string(quote_attrib(self.currency).encode(ExternalEncoding), input_name='currency'), ))
        if self.severity is not None:
            outfile.write(' severity=%s' % (quote_attrib(self.severity), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='MonetaryImpact'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='MonetaryImpact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='MonetaryImpact')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='MonetaryImpact'):
        expStr = ''
        if self.currency is not None:
            expStr += ' currency=%s' % (self.format_string(quote_attrib(self.currency).encode(ExternalEncoding), input_name='currency'), )
        if self.severity is not None:
            expStr += ' severity=%s' % (quote_attrib(self.severity), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='MonetaryImpact'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MonetaryImpact'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.currency is not None:
            showIndent(outfile, level)
            outfile.write('currency = "%s",\n' % (self.currency,))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity = %s,\n' % (self.severity,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('currency'):
            self.currency = attrs.get('currency').value
        if attrs.get('severity'):
            self.severity = attrs.get('severity').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MonetaryImpact

class Confidence(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, rating=None, valueOf_='', mixedclass_=None, content_=None):
        self.rating = _cast(None, rating)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Confidence.subclass:
            return Confidence.subclass(*args_, **kwargs_)
        else:
            return Confidence(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rating(self): return self.rating
    def set_rating(self, rating): self.rating = rating
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='Confidence', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Confidence')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_)
        outfile.write('</%s%s>\n' % (namespace_, name_))
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Confidence'):
        outfile.write(' rating=%s' % (quote_attrib(self.rating), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Confidence'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='Confidence', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = ''
        expStr += showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Confidence')
        expStr += '>'
        expStr += self.exportChildrenS( level + 1, namespace_, name_)
        expStr += '</%s%s>\n' % (namespace_, name_)
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Confidence'):
        return ' rating=%s' % (quote_attrib(self.rating), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='Confidence'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Confidence'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.rating is not None:
            showIndent(outfile, level)
            outfile.write('rating = %s,\n' % (self.rating,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('rating'):
            self.rating = attrs.get('rating').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.nodeValue)
            self.content_.append(obj_)
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Confidence


class EventData(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction='default', Description=None, DetectTime=None, StartTime=None, EndTime=None, Contact=None, Assessment=None, Method=None, Flow=None, Expectation=None, Record=None, EventData=None, AdditionalData=None):
        self.restriction = _cast(None, restriction)
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        self.DetectTime = DetectTime
        self.StartTime = StartTime
        self.EndTime = EndTime
        if Contact is None:
            self.Contact = []
        else:
            self.Contact = Contact
        self.Assessment = Assessment
        if Method is None:
            self.Method = []
        else:
            self.Method = Method
        if Flow is None:
            self.Flow = []
        else:
            self.Flow = Flow
        if Expectation is None:
            self.Expectation = []
        else:
            self.Expectation = Expectation
        self.Record = Record
        if EventData is None:
            self.EventData = []
        else:
            self.EventData = EventData
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if EventData.subclass:
            return EventData.subclass(*args_, **kwargs_)
        else:
            return EventData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_DetectTime(self): return self.DetectTime
    def set_DetectTime(self, DetectTime): self.DetectTime = DetectTime
    def get_StartTime(self): return self.StartTime
    def set_StartTime(self, StartTime): self.StartTime = StartTime
    def get_EndTime(self): return self.EndTime
    def set_EndTime(self, EndTime): self.EndTime = EndTime
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def add_Contact(self, value): self.Contact.append(value)
    def insert_Contact(self, index, value): self.Contact[index] = value
    def get_Assessment(self): return self.Assessment
    def set_Assessment(self, Assessment): self.Assessment = Assessment
    def get_Method(self): return self.Method
    def set_Method(self, Method): self.Method = Method
    def add_Method(self, value): self.Method.append(value)
    def insert_Method(self, index, value): self.Method[index] = value
    def get_Flow(self): return self.Flow
    def set_Flow(self, Flow): self.Flow = Flow
    def add_Flow(self, value): self.Flow.append(value)
    def insert_Flow(self, index, value): self.Flow[index] = value
    def get_Expectation(self): return self.Expectation
    def set_Expectation(self, Expectation): self.Expectation = Expectation
    def add_Expectation(self, value): self.Expectation.append(value)
    def insert_Expectation(self, index, value): self.Expectation[index] = value
    def get_Record(self): return self.Record
    def set_Record(self, Record): self.Record = Record
    def get_EventData(self): return self.EventData
    def set_EventData(self, EventData): self.EventData = EventData
    def add_EventData(self, value): self.EventData.append(value)
    def insert_EventData(self, index, value): self.EventData[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='EventData', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EventData')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='EventData'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='EventData'):
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        if self.DetectTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sDetectTime>%s</%sDetectTime>\n' % (namespace_, self.format_string(quote_xml(self.DetectTime).encode(ExternalEncoding), input_name='DetectTime'), namespace_))
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_))
        for Contact_ in self.Contact:
            Contact_.export(outfile, level, namespace_, name_='Contact')
        if self.Assessment:
            self.Assessment.export(outfile, level, namespace_, name_='Assessment')
        for Method_ in self.Method:
            Method_.export(outfile, level, namespace_, name_='Method')
        for Flow_ in self.Flow:
            Flow_.export(outfile, level, namespace_, name_='Flow')
        for Expectation_ in self.Expectation:
            Expectation_.export(outfile, level, namespace_, name_='Expectation')
        if self.Record:
            self.Record.export(outfile, level, namespace_, name_='Record')
        for EventData_ in self.EventData:
            EventData_.export(outfile, level, namespace_, name_='EventData')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='EventData', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='EventData')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='EventData'):
        if self.restriction is not None:
            return ' restriction=%s' % (quote_attrib(self.restriction), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='EventData'):
        expStr = ''
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        if self.DetectTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sDetectTime>%s</%sDetectTime>\n' % (namespace_, self.format_string(quote_xml(self.DetectTime).encode(ExternalEncoding), input_name='DetectTime'), namespace_)
        if self.StartTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sStartTime>%s</%sStartTime>\n' % (namespace_, self.format_string(quote_xml(self.StartTime).encode(ExternalEncoding), input_name='StartTime'), namespace_)
        if self.EndTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sEndTime>%s</%sEndTime>\n' % (namespace_, self.format_string(quote_xml(self.EndTime).encode(ExternalEncoding), input_name='EndTime'), namespace_)
        for Contact_ in self.Contact:
            expStr += Contact_.exportS( level, namespace_, name_='Contact')
        if self.Assessment:
            expStr += self.Assessment.exportS( level, namespace_, name_='Assessment')
        for Method_ in self.Method:
            expStr += Method_.exportS( level, namespace_, name_='Method')
        for Flow_ in self.Flow:
            expStr += Flow_.exportS( level, namespace_, name_='Flow')
        for Expectation_ in self.Expectation:
            expStr += Expectation_.exportS( level, namespace_, name_='Expectation')
        if self.Record:
            expStr += self.Record.exportS( level, namespace_, name_='Record')
        for EventData_ in self.EventData:
            expStr += EventData_.exportS( level, namespace_, name_='EventData')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.Description or
            self.DetectTime is not None or
            self.StartTime is not None or
            self.EndTime is not None or
            self.Contact or
            self.Assessment is not None or
            self.Method or
            self.Flow or
            self.Expectation or
            self.Record is not None or
            self.EventData or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EventData'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.DetectTime is not None:
            showIndent(outfile, level)
            outfile.write('DetectTime=%s,\n' % quote_python(self.DetectTime).encode(ExternalEncoding))
        if self.StartTime is not None:
            showIndent(outfile, level)
            outfile.write('StartTime=%s,\n' % quote_python(self.StartTime).encode(ExternalEncoding))
        if self.EndTime is not None:
            showIndent(outfile, level)
            outfile.write('EndTime=%s,\n' % quote_python(self.EndTime).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Contact=[\n')
        level += 1
        for Contact_ in self.Contact:
            showIndent(outfile, level)
            outfile.write('model_.Contact(\n')
            Contact_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Assessment is not None:
            showIndent(outfile, level)
            outfile.write('Assessment=model_.Assessment(\n')
            self.Assessment.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Method=[\n')
        level += 1
        for Method_ in self.Method:
            showIndent(outfile, level)
            outfile.write('model_.Method(\n')
            Method_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Flow=[\n')
        level += 1
        for Flow_ in self.Flow:
            showIndent(outfile, level)
            outfile.write('model_.Flow(\n')
            Flow_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Expectation=[\n')
        level += 1
        for Expectation_ in self.Expectation:
            showIndent(outfile, level)
            outfile.write('model_.Expectation(\n')
            Expectation_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Record is not None:
            showIndent(outfile, level)
            outfile.write('Record=model_.Record(\n')
            self.Record.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('EventData=[\n')
        level += 1
        for EventData_ in self.EventData:
            showIndent(outfile, level)
            outfile.write('model_.EventData(\n')
            EventData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'DetectTime':
            DetectTime_ = ''
            for text__content_ in child_.childNodes:
                DetectTime_ += text__content_.nodeValue
            self.DetectTime = DetectTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'StartTime':
            StartTime_ = ''
            for text__content_ in child_.childNodes:
                StartTime_ += text__content_.nodeValue
            self.StartTime = StartTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'EndTime':
            EndTime_ = ''
            for text__content_ in child_.childNodes:
                EndTime_ += text__content_.nodeValue
            self.EndTime = EndTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Contact':
            obj_ = Contact.factory()
            obj_.build(child_)
            self.Contact.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Assessment':
            obj_ = Assessment.factory()
            obj_.build(child_)
            self.set_Assessment(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Method':
            obj_ = Method.factory()
            obj_.build(child_)
            self.Method.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Flow':
            obj_ = Flow.factory()
            obj_.build(child_)
            self.Flow.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Expectation':
            obj_ = Expectation.factory()
            obj_.build(child_)
            self.Expectation.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Record':
            obj_ = Record.factory()
            obj_.build(child_)
            self.set_Record(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'EventData':
            obj_ = EventData.factory()
            obj_.build(child_)
            self.EventData.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class EventData


class Flow(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, System=None):
        if System is None:
            self.System = []
        else:
            self.System = System
    def factory(*args_, **kwargs_):
        if Flow.subclass:
            return Flow.subclass(*args_, **kwargs_)
        else:
            return Flow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def add_System(self, value): self.System.append(value)
    def insert_System(self, index, value): self.System[index] = value
    def export(self, outfile, level, namespace_='iodef:', name_='Flow', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Flow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Flow'):
        pass
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Flow'):
        for System_ in self.System:
            System_.export(outfile, level, namespace_, name_='System')
    def exportS(self, level, namespace_='iodef:', name_='Flow', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Flow'):
        pass
    def exportChildrenS(self, level, namespace_='iodef:', name_='Flow'):
        expStr = ''
        for System_ in self.System:
            expStr += System_.exportS( level, namespace_, name_='System')
        return expStr
    def hasContent_(self):
        if (
            self.System
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Flow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('System=[\n')
        level += 1
        for System_ in self.System:
            showIndent(outfile, level)
            outfile.write('model_.System(\n')
            System_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'System':
            obj_ = System.factory()
            obj_.build(child_)
            self.System.append(obj_)
# end class Flow


class System(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, interface=None, restriction=None, ext_category=None, category=None, spoofed='unknown', Node=None, Service=None, OperatingSystem=None, Counter=None, Description=None, AdditionalData=None):
        self.interface = _cast(None, interface)
        self.restriction = _cast(None, restriction)
        self.ext_category = _cast(None, ext_category)
        self.category = _cast(None, category)
        self.spoofed = _cast(None, spoofed)
        self.Node = Node
        if Service is None:
            self.Service = []
        else:
            self.Service = Service
        if OperatingSystem is None:
            self.OperatingSystem = []
        else:
            self.OperatingSystem = OperatingSystem
        if Counter is None:
            self.Counter = []
        else:
            self.Counter = Counter
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if System.subclass:
            return System.subclass(*args_, **kwargs_)
        else:
            return System(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Node(self): return self.Node
    def set_Node(self, Node): self.Node = Node
    def get_Service(self): return self.Service
    def set_Service(self, Service): self.Service = Service
    def add_Service(self, value): self.Service.append(value)
    def insert_Service(self, index, value): self.Service[index] = value
    def get_OperatingSystem(self): return self.OperatingSystem
    def set_OperatingSystem(self, OperatingSystem): self.OperatingSystem = OperatingSystem
    def add_OperatingSystem(self, value): self.OperatingSystem.append(value)
    def insert_OperatingSystem(self, index, value): self.OperatingSystem[index] = value
    def get_Counter(self): return self.Counter
    def set_Counter(self, Counter): self.Counter = Counter
    def add_Counter(self, value): self.Counter.append(value)
    def insert_Counter(self, index, value): self.Counter[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_interface(self): return self.interface
    def set_interface(self, interface): self.interface = interface
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_ext_category(self): return self.ext_category
    def set_ext_category(self, ext_category): self.ext_category = ext_category
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_spoofed(self): return self.spoofed
    def set_spoofed(self, spoofed): self.spoofed = spoofed
    def export(self, outfile, level, namespace_='iodef:', name_='System', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='System')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='System'):
        if self.interface is not None:
            outfile.write(' interface=%s' % (self.format_string(quote_attrib(self.interface).encode(ExternalEncoding), input_name='interface'), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.ext_category is not None:
            outfile.write(' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), ))
        if self.category is not None:
            outfile.write(' category=%s' % (quote_attrib(self.category), ))
        if self.spoofed is not None:
            outfile.write(' spoofed=%s' % (quote_attrib(self.spoofed), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='System'):
        if self.Node:
            self.Node.export(outfile, level, namespace_, name_='Node', )
        for Service_ in self.Service:
            Service_.export(outfile, level, namespace_, name_='Service')
        for OperatingSystem_ in self.OperatingSystem:
            OperatingSystem_.export(outfile, level, namespace_, name_='OperatingSystem')
        for Counter_ in self.Counter:
            Counter_.export(outfile, level, namespace_, name_='Counter')
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='System', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='System')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='System'):
        expStr = ''
        if self.interface is not None:
            expStr += ' interface=%s' % (self.format_string(quote_attrib(self.interface).encode(ExternalEncoding), input_name='interface'), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.ext_category is not None:
            expStr += ' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), )
        if self.category is not None:
            expStr += ' category=%s' % (quote_attrib(self.category), )
        if self.spoofed is not None:
            expStr += ' spoofed=%s' % (quote_attrib(self.spoofed), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='System'):
        expStr = ''
        if self.Node:
            expStr += self.Node.exportS( level, namespace_, name_='Node', )
        for Service_ in self.Service:
            expStr += Service_.exportS( level, namespace_, name_='Service')
        for OperatingSystem_ in self.OperatingSystem:
            expStr += OperatingSystem_.exportS( level, namespace_, name_='OperatingSystem')
        for Counter_ in self.Counter:
            expStr += Counter_.exportS( level, namespace_, name_='Counter')
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.Node is not None or
            self.Service or
            self.OperatingSystem or
            self.Counter or
            self.Description or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='System'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.interface is not None:
            showIndent(outfile, level)
            outfile.write('interface = "%s",\n' % (self.interface,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.ext_category is not None:
            showIndent(outfile, level)
            outfile.write('ext_category = "%s",\n' % (self.ext_category,))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category = %s,\n' % (self.category,))
        if self.spoofed is not None:
            showIndent(outfile, level)
            outfile.write('spoofed = %s,\n' % (self.spoofed,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Node is not None:
            showIndent(outfile, level)
            outfile.write('Node=model_.Node(\n')
            self.Node.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Service=[\n')
        level += 1
        for Service_ in self.Service:
            showIndent(outfile, level)
            outfile.write('model_.Service(\n')
            Service_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('OperatingSystem=[\n')
        level += 1
        for OperatingSystem_ in self.OperatingSystem:
            showIndent(outfile, level)
            outfile.write('model_.OperatingSystem(\n')
            OperatingSystem_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Counter=[\n')
        level += 1
        for Counter_ in self.Counter:
            showIndent(outfile, level)
            outfile.write('model_.Counter(\n')
            Counter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('interface'):
            self.interface = attrs.get('interface').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('ext-category'):
            self.ext_category = attrs.get('ext-category').value
        if attrs.get('category'):
            self.category = attrs.get('category').value
        if attrs.get('spoofed'):
            self.spoofed = attrs.get('spoofed').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Node':
            obj_ = Node.factory()
            obj_.build(child_)
            self.set_Node(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Service':
            obj_ = Service.factory()
            obj_.build(child_)
            self.Service.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'OperatingSystem':
            obj_ = SoftwareType.factory()
            obj_.build(child_)
            self.OperatingSystem.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Counter':
            obj_ = Counter.factory()
            obj_.build(child_)
            self.Counter.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class System


class Node(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, NodeName=None, Address=None, Location=None, DateTime=None, NodeRole=None, Counter=None):
        if NodeName is None:
            self.NodeName = []
        else:
            self.NodeName = NodeName
        if Address is None:
            self.Address = []
        else:
            self.Address = Address
        self.Location = Location
        self.DateTime = DateTime
        if NodeRole is None:
            self.NodeRole = []
        else:
            self.NodeRole = NodeRole
        if Counter is None:
            self.Counter = []
        else:
            self.Counter = Counter
    def factory(*args_, **kwargs_):
        if Node.subclass:
            return Node.subclass(*args_, **kwargs_)
        else:
            return Node(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NodeName(self): return self.NodeName
    def set_NodeName(self, NodeName): self.NodeName = NodeName
    def add_NodeName(self, value): self.NodeName.append(value)
    def insert_NodeName(self, index, value): self.NodeName[index] = value
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def add_Address(self, value): self.Address.append(value)
    def insert_Address(self, index, value): self.Address[index] = value
    def get_Location(self): return self.Location
    def set_Location(self, Location): self.Location = Location
    def get_DateTime(self): return self.DateTime
    def set_DateTime(self, DateTime): self.DateTime = DateTime
    def get_NodeRole(self): return self.NodeRole
    def set_NodeRole(self, NodeRole): self.NodeRole = NodeRole
    def add_NodeRole(self, value): self.NodeRole.append(value)
    def insert_NodeRole(self, index, value): self.NodeRole[index] = value
    def get_Counter(self): return self.Counter
    def set_Counter(self, Counter): self.Counter = Counter
    def add_Counter(self, value): self.Counter.append(value)
    def insert_Counter(self, index, value): self.Counter[index] = value
    def export(self, outfile, level, namespace_='iodef:', name_='Node', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Node')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Node'):
        pass
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Node'):
        for NodeName_ in self.NodeName:
            NodeName_.export(outfile, level, namespace_, name_='NodeName')
        for Address_ in self.Address:
            Address_.export(outfile, level, namespace_, name_='Address')
        if self.Location:
            self.Location.export(outfile, level, namespace_, name_='Location')
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_))
        for NodeRole_ in self.NodeRole:
            NodeRole_.export(outfile, level, namespace_, name_='NodeRole')
        for Counter_ in self.Counter:
            Counter_.export(outfile, level, namespace_, name_='Counter')
    def exportS(self, level, namespace_='iodef:', name_='Node', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        #expStr += self.exportAttributesS( level, namespace_, name_='Node')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, outfile, level, namespace_='iodef:', name_='Node'):
        pass
    def exportChildrenS(self, level, namespace_='iodef:', name_='Node'):
        expStr = ''
        for NodeName_ in self.NodeName:
            expStr += NodeName_.exportS( level, namespace_, name_='NodeName')
        for Address_ in self.Address:
            expStr += Address_.exportS( level, namespace_, name_='Address')
        if self.Location:
            expStr += self.Location.exportS( level, namespace_, name_='Location')
        if self.DateTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_)
        for NodeRole_ in self.NodeRole:
            expStr += NodeRole_.exportS( level, namespace_, name_='NodeRole')
        for Counter_ in self.Counter:
            expStr += Counter_.exportS( level, namespace_, name_='Counter')
        return expStr
    def hasContent_(self):
        if (
            self.NodeName or
            self.Address or
            self.Location is not None or
            self.DateTime is not None or
            self.NodeRole or
            self.Counter
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Node'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('NodeName=[\n')
        level += 1
        for NodeName_ in self.NodeName:
            showIndent(outfile, level)
            outfile.write('model_.MLStringType(\n')
            NodeName_.exportLiteral(outfile, level, name_='MLStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Address=[\n')
        level += 1
        for Address_ in self.Address:
            showIndent(outfile, level)
            outfile.write('model_.Address(\n')
            Address_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Location is not None:
            showIndent(outfile, level)
            outfile.write('Location=model_.Location(\n')
            self.Location.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('DateTime=%s,\n' % quote_python(self.DateTime).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('NodeRole=[\n')
        level += 1
        for NodeRole_ in self.NodeRole:
            showIndent(outfile, level)
            outfile.write('model_.NodeRole(\n')
            NodeRole_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Counter=[\n')
        level += 1
        for Counter_ in self.Counter:
            showIndent(outfile, level)
            outfile.write('model_.Counter(\n')
            Counter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'NodeName':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.NodeName.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Address':
            obj_ = Address.factory()
            obj_.build(child_)
            self.Address.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Location':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.set_Location(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'DateTime':
            DateTime_ = ''
            for text__content_ in child_.childNodes:
                DateTime_ += text__content_.nodeValue
            self.DateTime = DateTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'NodeRole':
            obj_ = NodeRole.factory()
            obj_.build(child_)
            self.NodeRole.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Counter':
            obj_ = Counter.factory()
            obj_.build(child_)
            self.Counter.append(obj_)
# end class Node


class Address(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, category='ipv4-addr', vlan_name=None, ext_category=None, vlan_num=None, valueOf_=''):
        self.category = _cast(None, category)
        self.vlan_name = _cast(None, vlan_name)
        self.ext_category = _cast(None, ext_category)
        self.vlan_num = _cast(int, vlan_num)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_vlan_name(self): return self.vlan_name
    def set_vlan_name(self, vlan_name): self.vlan_name = vlan_name
    def get_ext_category(self): return self.ext_category
    def set_ext_category(self, ext_category): self.ext_category = ext_category
    def get_vlan_num(self): return self.vlan_num
    def set_vlan_num(self, vlan_num): self.vlan_num = vlan_num
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='Address', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Address')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Address'):
        if self.category is not None:
            outfile.write(' category=%s' % (quote_attrib(self.category), ))
        if self.vlan_name is not None:
            outfile.write(' vlan-name=%s' % (self.format_string(quote_attrib(self.vlan_name).encode(ExternalEncoding), input_name='vlan-name'), ))
        if self.ext_category is not None:
            outfile.write(' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), ))
        if self.vlan_num is not None:
            outfile.write(' vlan-num="%s"' % self.format_integer(self.vlan_num, input_name='vlan-num'))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Address'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='Address', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Address')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Address'):
        expStr = ''
        if self.category is not None:
            expStr += ' category=%s' % (quote_attrib(self.category), )
        if self.vlan_name is not None:
            expStr += ' vlan-name=%s' % (self.format_string(quote_attrib(self.vlan_name).encode(ExternalEncoding), input_name='vlan-name'), )
        if self.ext_category is not None:
            expStr += ' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), )
        if self.vlan_num is not None:
            expStr += ' vlan-num="%s"' % self.format_integer(self.vlan_num, input_name='vlan-num')
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Address'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Address'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category = %s,\n' % (self.category,))
        if self.vlan_name is not None:
            showIndent(outfile, level)
            outfile.write('vlan_name = "%s",\n' % (self.vlan_name,))
        if self.ext_category is not None:
            showIndent(outfile, level)
            outfile.write('ext_category = "%s",\n' % (self.ext_category,))
        if self.vlan_num is not None:
            showIndent(outfile, level)
            outfile.write('vlan_num = %d,\n' % (self.vlan_num,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('category'):
            self.category = attrs.get('category').value
        if attrs.get('vlan-name'):
            self.vlan_name = attrs.get('vlan-name').value
        if attrs.get('ext-category'):
            self.ext_category = attrs.get('ext-category').value
        if attrs.get('vlan-num'):
            try:
                self.vlan_num = int(attrs.get('vlan-num').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (vlan-num): %s' % exp)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Address


class Service(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ip_protocol=None, Port=None, Portlist=None, ProtoType=None, ProtoCode=None, ProtoField=None, Application=None):
        self.ip_protocol = _cast(int, ip_protocol)
        self.Port = Port
        self.Portlist = Portlist
        self.ProtoType = ProtoType
        self.ProtoCode = ProtoCode
        self.ProtoField = ProtoField
        self.Application = Application
    def factory(*args_, **kwargs_):
        if Service.subclass:
            return Service.subclass(*args_, **kwargs_)
        else:
            return Service(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def get_Portlist(self): return self.Portlist
    def set_Portlist(self, Portlist): self.Portlist = Portlist
    def validate_Portlist(self, value):
        # validate type Portlist
        pass
    def get_ProtoType(self): return self.ProtoType
    def set_ProtoType(self, ProtoType): self.ProtoType = ProtoType
    def get_ProtoCode(self): return self.ProtoCode
    def set_ProtoCode(self, ProtoCode): self.ProtoCode = ProtoCode
    def get_ProtoField(self): return self.ProtoField
    def set_ProtoField(self, ProtoField): self.ProtoField = ProtoField
    def get_Application(self): return self.Application
    def set_Application(self, Application): self.Application = Application
    def get_ip_protocol(self): return self.ip_protocol
    def set_ip_protocol(self, ip_protocol): self.ip_protocol = ip_protocol
    def export(self, outfile, level, namespace_='iodef:', name_='Service', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Service')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Service'):
        outfile.write(' ip_protocol="%s"' % self.format_integer(self.ip_protocol, input_name='ip_protocol'))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Service'):
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sPort>%s</%sPort>\n' % (namespace_, self.format_integer(self.Port, input_name='Port'), namespace_))
        if self.Portlist is not None:
            showIndent(outfile, level)
            outfile.write('<%sPortlist>%s</%sPortlist>\n' % (namespace_, self.format_string(quote_xml(self.Portlist).encode(ExternalEncoding), input_name='Portlist'), namespace_))
        if self.ProtoType is not None:
            showIndent(outfile, level)
            outfile.write('<%sProtoType>%s</%sProtoType>\n' % (namespace_, self.format_integer(self.ProtoType, input_name='ProtoType'), namespace_))
        if self.ProtoCode is not None:
            showIndent(outfile, level)
            outfile.write('<%sProtoCode>%s</%sProtoCode>\n' % (namespace_, self.format_integer(self.ProtoCode, input_name='ProtoCode'), namespace_))
        if self.ProtoField is not None:
            showIndent(outfile, level)
            outfile.write('<%sProtoField>%s</%sProtoField>\n' % (namespace_, self.format_integer(self.ProtoField, input_name='ProtoField'), namespace_))
        if self.Application:
            self.Application.export(outfile, level, namespace_, name_='Application')
    def exportS(self, level, namespace_='iodef:', name_='Service', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Service')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Service'):
        return ' ip_protocol="%s"' % self.format_integer(self.ip_protocol, input_name='ip_protocol')
    def exportChildrenS(self, level, namespace_='iodef:', name_='Service'):
        expStr = ''
        if self.Port is not None:
            expStr += showIndentS( level)
            expStr += '<%sPort>%s</%sPort>\n' % (namespace_, self.format_integer(self.Port, input_name='Port'), namespace_)
        if self.Portlist is not None:
            expStr += showIndentS( level)
            expStr += '<%sPortlist>%s</%sPortlist>\n' % (namespace_, self.format_string(quote_xml(self.Portlist).encode(ExternalEncoding), input_name='Portlist'), namespace_)
        if self.ProtoType is not None:
            expStr += showIndentS( level)
            expStr += '<%sProtoType>%s</%sProtoType>\n' % (namespace_, self.format_integer(self.ProtoType, input_name='ProtoType'), namespace_)
        if self.ProtoCode is not None:
            expStr += showIndentS( level)
            expStr += '<%sProtoCode>%s</%sProtoCode>\n' % (namespace_, self.format_integer(self.ProtoCode, input_name='ProtoCode'), namespace_)
        if self.ProtoField is not None:
            expStr += showIndentS( level)
            expStr += '<%sProtoField>%s</%sProtoField>\n' % (namespace_, self.format_integer(self.ProtoField, input_name='ProtoField'), namespace_)
        if self.Application:
            expStr += self.Application.exportS( level, namespace_, name_='Application')
        return expStr
    def hasContent_(self):
        if (
            self.Port is not None or
            self.Portlist is not None or
            self.ProtoType is not None or
            self.ProtoCode is not None or
            self.ProtoField is not None or
            self.Application is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Service'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ip_protocol is not None:
            showIndent(outfile, level)
            outfile.write('ip_protocol = %d,\n' % (self.ip_protocol,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=%d,\n' % self.Port)
        if self.Portlist is not None:
            showIndent(outfile, level)
            outfile.write('Portlist=%s,\n' % quote_python(self.Portlist).encode(ExternalEncoding))
        if self.ProtoType is not None:
            showIndent(outfile, level)
            outfile.write('ProtoType=%d,\n' % self.ProtoType)
        if self.ProtoCode is not None:
            showIndent(outfile, level)
            outfile.write('ProtoCode=%d,\n' % self.ProtoCode)
        if self.ProtoField is not None:
            showIndent(outfile, level)
            outfile.write('ProtoField=%d,\n' % self.ProtoField)
        if self.Application is not None:
            showIndent(outfile, level)
            outfile.write('Application=model_.Application(\n')
            self.Application.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ip_protocol'):
            try:
                self.ip_protocol = int(attrs.get('ip_protocol').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (ip_protocol): %s' % exp)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Port':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (Port): %s' % exp)
                self.Port = ival_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Portlist':
            Portlist_ = ''
            for text__content_ in child_.childNodes:
                Portlist_ += text__content_.nodeValue
            self.Portlist = Portlist_
            self.validate_Portlist(self.Portlist)    # validate type Portlist
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ProtoType':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (ProtoType): %s' % exp)
                self.ProtoType = ival_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ProtoCode':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (ProtoCode): %s' % exp)
                self.ProtoCode = ival_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'ProtoField':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (ProtoField): %s' % exp)
                self.ProtoField = ival_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Application':
            obj_ = SoftwareType.factory()
            obj_.build(child_)
            self.set_Application(obj_)
# end class Service


class Counter(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, duration=None, meaning=None, type_=None, ext_duration=None, ext_type=None, valueOf_=''):
        self.duration = _cast(None, duration)
        self.meaning = _cast(None, meaning)
        self.type_ = _cast(None, type_)
        self.ext_duration = _cast(None, ext_duration)
        self.ext_type = _cast(None, ext_type)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Counter.subclass:
            return Counter.subclass(*args_, **kwargs_)
        else:
            return Counter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_meaning(self): return self.meaning
    def set_meaning(self, meaning): self.meaning = meaning
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_ext_duration(self): return self.ext_duration
    def set_ext_duration(self, ext_duration): self.ext_duration = ext_duration
    def get_ext_type(self): return self.ext_type
    def set_ext_type(self, ext_type): self.ext_type = ext_type
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='Counter', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Counter')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Counter'):
        if self.duration is not None:
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.meaning is not None:
            outfile.write(' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), ))
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.ext_duration is not None:
            outfile.write(' ext-duration=%s' % (self.format_string(quote_attrib(self.ext_duration).encode(ExternalEncoding), input_name='ext-duration'), ))
        if self.ext_type is not None:
            outfile.write(' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Counter'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='Counter', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Counter')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Counter'):
        expStr = ''
        if self.duration is not None:
            expStr += ' duration=%s' % (quote_attrib(self.duration), )
        if self.meaning is not None:
            expStr += ' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), )
        expStr += ' type=%s' % (quote_attrib(self.type_), )
        if self.ext_duration is not None:
            expStr += ' ext-duration=%s' % (self.format_string(quote_attrib(self.ext_duration).encode(ExternalEncoding), input_name='ext-duration'), )
        if self.ext_type is not None:
            expStr += ' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Counter'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Counter'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.duration is not None:
            showIndent(outfile, level)
            outfile.write('duration = %s,\n' % (self.duration,))
        if self.meaning is not None:
            showIndent(outfile, level)
            outfile.write('meaning = "%s",\n' % (self.meaning,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.ext_duration is not None:
            showIndent(outfile, level)
            outfile.write('ext_duration = "%s",\n' % (self.ext_duration,))
        if self.ext_type is not None:
            showIndent(outfile, level)
            outfile.write('ext_type = "%s",\n' % (self.ext_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('duration'):
            self.duration = attrs.get('duration').value
        if attrs.get('meaning'):
            self.meaning = attrs.get('meaning').value
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('ext-duration'):
            self.ext_duration = attrs.get('ext-duration').value
        if attrs.get('ext-type'):
            self.ext_type = attrs.get('ext-type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Counter


class Record(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, RecordData=None):
        self.restriction = _cast(None, restriction)
        if RecordData is None:
            self.RecordData = []
        else:
            self.RecordData = RecordData
    def factory(*args_, **kwargs_):
        if Record.subclass:
            return Record.subclass(*args_, **kwargs_)
        else:
            return Record(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_RecordData(self): return self.RecordData
    def set_RecordData(self, RecordData): self.RecordData = RecordData
    def add_RecordData(self, value): self.RecordData.append(value)
    def insert_RecordData(self, index, value): self.RecordData[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='Record', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Record')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Record'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Record'):
        for RecordData_ in self.RecordData:
            RecordData_.export(outfile, level, namespace_, name_='RecordData')
    def exportS(self, level, namespace_='iodef:', name_='Record', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr += showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Record')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, outfile, level, namespace_='iodef:', name_='Record'):
        if self.restriction is not None:
            return ' restriction=%s' % (quote_attrib(self.restriction), )
    def exportChildrenS(self, level, namespace_='iodef:', name_='Record'):
        expStr = ''
        for RecordData_ in self.RecordData:
            expStr += RecordData_.exportS( level, namespace_, name_='RecordData')
        return expStr
    def hasContent_(self):
        if (
            self.RecordData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Record'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('RecordData=[\n')
        level += 1
        for RecordData_ in self.RecordData:
            showIndent(outfile, level)
            outfile.write('model_.RecordData(\n')
            RecordData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'RecordData':
            obj_ = RecordData.factory()
            obj_.build(child_)
            self.RecordData.append(obj_)
# end class Record


class RecordData(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, restriction=None, DateTime=None, Description=None, Application=None, RecordPattern=None, RecordItem=None, AdditionalData=None):
        self.restriction = _cast(None, restriction)
        self.DateTime = DateTime
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        self.Application = Application
        if RecordPattern is None:
            self.RecordPattern = []
        else:
            self.RecordPattern = RecordPattern
        if RecordItem is None:
            self.RecordItem = []
        else:
            self.RecordItem = RecordItem
        if AdditionalData is None:
            self.AdditionalData = []
        else:
            self.AdditionalData = AdditionalData
    def factory(*args_, **kwargs_):
        if RecordData.subclass:
            return RecordData.subclass(*args_, **kwargs_)
        else:
            return RecordData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateTime(self): return self.DateTime
    def set_DateTime(self, DateTime): self.DateTime = DateTime
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def add_Description(self, value): self.Description.append(value)
    def insert_Description(self, index, value): self.Description[index] = value
    def get_Application(self): return self.Application
    def set_Application(self, Application): self.Application = Application
    def get_RecordPattern(self): return self.RecordPattern
    def set_RecordPattern(self, RecordPattern): self.RecordPattern = RecordPattern
    def add_RecordPattern(self, value): self.RecordPattern.append(value)
    def insert_RecordPattern(self, index, value): self.RecordPattern[index] = value
    def get_RecordItem(self): return self.RecordItem
    def set_RecordItem(self, RecordItem): self.RecordItem = RecordItem
    def add_RecordItem(self, value): self.RecordItem.append(value)
    def insert_RecordItem(self, index, value): self.RecordItem[index] = value
    def get_AdditionalData(self): return self.AdditionalData
    def set_AdditionalData(self, AdditionalData): self.AdditionalData = AdditionalData
    def add_AdditionalData(self, value): self.AdditionalData.append(value)
    def insert_AdditionalData(self, index, value): self.AdditionalData[index] = value
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def export(self, outfile, level, namespace_='iodef:', name_='RecordData', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='RecordData')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='RecordData'):
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='RecordData'):
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_))
        for Description_ in self.Description:
            Description_.export(outfile, level, namespace_, name_='Description')
        if self.Application:
            self.Application.export(outfile, level, namespace_, name_='Application')
        for RecordPattern_ in self.RecordPattern:
            RecordPattern_.export(outfile, level, namespace_, name_='RecordPattern')
        for RecordItem_ in self.RecordItem:
            RecordItem_.export(outfile, level, namespace_, name_='RecordItem')
        for AdditionalData_ in self.AdditionalData:
            AdditionalData_.export(outfile, level, namespace_, name_='AdditionalData')
    def exportS(self, level, namespace_='iodef:', name_='RecordData', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='RecordData')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, outfile, namespace_='iodef:', name_='RecordData'):
        expStr = ''
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='RecordData'):
        expStr = ''
        if self.DateTime is not None:
            expStr += showIndentS( level)
            expStr += '<%sDateTime>%s</%sDateTime>\n' % (namespace_, self.format_string(quote_xml(self.DateTime).encode(ExternalEncoding), input_name='DateTime'), namespace_)
        for Description_ in self.Description:
            expStr += Description_.exportS( level, namespace_, name_='Description')
        if self.Application:
            expStr += self.Application.exportS( level, namespace_, name_='Application')
        for RecordPattern_ in self.RecordPattern:
            expStr += RecordPattern_.exportS( level, namespace_, name_='RecordPattern')
        for RecordItem_ in self.RecordItem:
            expStr += RecordItem_.exportS( level, namespace_, name_='RecordItem')
        for AdditionalData_ in self.AdditionalData:
            expStr += AdditionalData_.exportS( level, namespace_, name_='AdditionalData')
        return expStr
    def hasContent_(self):
        if (
            self.DateTime is not None or
            self.Description or
            self.Application is not None or
            self.RecordPattern or
            self.RecordItem or
            self.AdditionalData
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RecordData'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DateTime is not None:
            showIndent(outfile, level)
            outfile.write('DateTime=%s,\n' % quote_python(self.DateTime).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Description=[\n')
        level += 1
        for Description_ in self.Description:
            showIndent(outfile, level)
            outfile.write('model_.Description(\n')
            Description_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Application is not None:
            showIndent(outfile, level)
            outfile.write('Application=model_.Application(\n')
            self.Application.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('RecordPattern=[\n')
        level += 1
        for RecordPattern_ in self.RecordPattern:
            showIndent(outfile, level)
            outfile.write('model_.RecordPattern(\n')
            RecordPattern_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('RecordItem=[\n')
        level += 1
        for RecordItem_ in self.RecordItem:
            showIndent(outfile, level)
            outfile.write('model_.RecordItem(\n')
            RecordItem_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('AdditionalData=[\n')
        level += 1
        for AdditionalData_ in self.AdditionalData:
            showIndent(outfile, level)
            outfile.write('model_.AdditionalData(\n')
            AdditionalData_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'DateTime':
            DateTime_ = ''
            for text__content_ in child_.childNodes:
                DateTime_ += text__content_.nodeValue
            self.DateTime = DateTime_
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = MLStringType.factory()
            obj_.build(child_)
            self.Description.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'Application':
            obj_ = SoftwareType.factory()
            obj_.build(child_)
            self.set_Application(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'RecordPattern':
            obj_ = RecordPattern.factory()
            obj_.build(child_)
            self.RecordPattern.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'RecordItem':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.RecordItem.append(obj_)
        elif child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'AdditionalData':
            obj_ = ExtensionType.factory()
            obj_.build(child_)
            self.AdditionalData.append(obj_)
# end class RecordData


class RecordPattern(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, offsetunit='line', instance=None, ext_type=None, offset=None, ext_offsetunit=None, type_=None, valueOf_=''):
        self.offsetunit = _cast(None, offsetunit)
        self.instance = _cast(int, instance)
        self.ext_type = _cast(None, ext_type)
        self.offset = _cast(int, offset)
        self.ext_offsetunit = _cast(None, ext_offsetunit)
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if RecordPattern.subclass:
            return RecordPattern.subclass(*args_, **kwargs_)
        else:
            return RecordPattern(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_offsetunit(self): return self.offsetunit
    def set_offsetunit(self, offsetunit): self.offsetunit = offsetunit
    def get_instance(self): return self.instance
    def set_instance(self, instance): self.instance = instance
    def get_ext_type(self): return self.ext_type
    def set_ext_type(self, ext_type): self.ext_type = ext_type
    def get_offset(self): return self.offset
    def set_offset(self, offset): self.offset = offset
    def get_ext_offsetunit(self): return self.ext_offsetunit
    def set_ext_offsetunit(self, ext_offsetunit): self.ext_offsetunit = ext_offsetunit
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='RecordPattern', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='RecordPattern')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='RecordPattern'):
        if self.offsetunit is not None:
            outfile.write(' offsetunit=%s' % (quote_attrib(self.offsetunit), ))
        if self.instance is not None:
            outfile.write(' instance="%s"' % self.format_integer(self.instance, input_name='instance'))
        if self.ext_type is not None:
            outfile.write(' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), ))
        if self.offset is not None:
            outfile.write(' offset="%s"' % self.format_integer(self.offset, input_name='offset'))
        if self.ext_offsetunit is not None:
            outfile.write(' ext-offsetunit=%s' % (self.format_string(quote_attrib(self.ext_offsetunit).encode(ExternalEncoding), input_name='ext-offsetunit'), ))
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='RecordPattern'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='RecordPattern', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='RecordPattern')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='RecordPattern'):
        expStr = ''
        if self.offsetunit is not None:
            expStr += ' offsetunit=%s' % (quote_attrib(self.offsetunit), )
        if self.instance is not None:
            expStr += ' instance="%s"' % self.format_integer(self.instance, input_name='instance')
        if self.ext_type is not None:
            expStr += ' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), )
        if self.offset is not None:
            expStr += ' offset="%s"' % self.format_integer(self.offset, input_name='offset')
        if self.ext_offsetunit is not None:
            expStr += ' ext-offsetunit=%s' % (self.format_string(quote_attrib(self.ext_offsetunit).encode(ExternalEncoding), input_name='ext-offsetunit'), )
        expStr += ' type=%s' % (quote_attrib(self.type_), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='RecordPattern'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RecordPattern'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.offsetunit is not None:
            showIndent(outfile, level)
            outfile.write('offsetunit = %s,\n' % (self.offsetunit,))
        if self.instance is not None:
            showIndent(outfile, level)
            outfile.write('instance = %d,\n' % (self.instance,))
        if self.ext_type is not None:
            showIndent(outfile, level)
            outfile.write('ext_type = "%s",\n' % (self.ext_type,))
        if self.offset is not None:
            showIndent(outfile, level)
            outfile.write('offset = %d,\n' % (self.offset,))
        if self.ext_offsetunit is not None:
            showIndent(outfile, level)
            outfile.write('ext_offsetunit = "%s",\n' % (self.ext_offsetunit,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('offsetunit'):
            self.offsetunit = attrs.get('offsetunit').value
        if attrs.get('instance'):
            try:
                self.instance = int(attrs.get('instance').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (instance): %s' % exp)
        if attrs.get('ext-type'):
            self.ext_type = attrs.get('ext-type').value
        if attrs.get('offset'):
            try:
                self.offset = int(attrs.get('offset').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (offset): %s' % exp)
        if attrs.get('ext-offsetunit'):
            self.ext_offsetunit = attrs.get('ext-offsetunit').value
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class RecordPattern


class SoftwareType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vendor=None, name=None, family=None, swid='0', patch=None, version=None, configid='0', URL=None):
        self.vendor = _cast(None, vendor)
        self.name = _cast(None, name)
        self.family = _cast(None, family)
        self.swid = _cast(None, swid)
        self.patch = _cast(None, patch)
        self.version = _cast(None, version)
        self.configid = _cast(None, configid)
        self.URL = URL
    def factory(*args_, **kwargs_):
        if SoftwareType.subclass:
            return SoftwareType.subclass(*args_, **kwargs_)
        else:
            return SoftwareType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URL(self): return self.URL
    def set_URL(self, URL): self.URL = URL
    def get_vendor(self): return self.vendor
    def set_vendor(self, vendor): self.vendor = vendor
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_family(self): return self.family
    def set_family(self, family): self.family = family
    def get_swid(self): return self.swid
    def set_swid(self, swid): self.swid = swid
    def get_patch(self): return self.patch
    def set_patch(self, patch): self.patch = patch
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_configid(self): return self.configid
    def set_configid(self, configid): self.configid = configid
    def export(self, outfile, level, namespace_='iodef:', name_='SoftwareType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='SoftwareType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='SoftwareType'):
        if self.vendor is not None:
            outfile.write(' vendor=%s' % (self.format_string(quote_attrib(self.vendor).encode(ExternalEncoding), input_name='vendor'), ))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.family is not None:
            outfile.write(' family=%s' % (self.format_string(quote_attrib(self.family).encode(ExternalEncoding), input_name='family'), ))
        if self.swid is not None:
            outfile.write(' swid=%s' % (self.format_string(quote_attrib(self.swid).encode(ExternalEncoding), input_name='swid'), ))
        if self.patch is not None:
            outfile.write(' patch=%s' % (self.format_string(quote_attrib(self.patch).encode(ExternalEncoding), input_name='patch'), ))
        if self.version is not None:
            outfile.write(' version=%s' % (self.format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.configid is not None:
            outfile.write(' configid=%s' % (self.format_string(quote_attrib(self.configid).encode(ExternalEncoding), input_name='configid'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='SoftwareType'):
        if self.URL is not None:
            showIndent(outfile, level)
            outfile.write('<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(self.URL).encode(ExternalEncoding), input_name='URL'), namespace_))
    def exportS(self, level, namespace_='iodef:', name_='SoftwareType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='SoftwareType')
        if self.hasContent_():
            expStr += '>\n'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += showIndentS( level)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='SoftwareType'):
        expStr = ''
        if self.vendor is not None:
            expStr += ' vendor=%s' % (self.format_string(quote_attrib(self.vendor).encode(ExternalEncoding), input_name='vendor'), )
        if self.name is not None:
            expStr += ' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), )
        if self.family is not None:
            expStr += ' family=%s' % (self.format_string(quote_attrib(self.family).encode(ExternalEncoding), input_name='family'), )
        if self.swid is not None:
            expStr += ' swid=%s' % (self.format_string(quote_attrib(self.swid).encode(ExternalEncoding), input_name='swid'), )
        if self.patch is not None:
            expStr += ' patch=%s' % (self.format_string(quote_attrib(self.patch).encode(ExternalEncoding), input_name='patch'), )
        if self.version is not None:
            expStr += ' version=%s' % (self.format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), )
        if self.configid is not None:
            expStr += ' configid=%s' % (self.format_string(quote_attrib(self.configid).encode(ExternalEncoding), input_name='configid'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='SoftwareType'):
        expStr = ''
        if self.URL is not None:
            expStr += showIndentS( level)
            expStr += '<%sURL>%s</%sURL>\n' % (namespace_, self.format_string(quote_xml(self.URL).encode(ExternalEncoding), input_name='URL'), namespace_)
        return expStr
    def hasContent_(self):
        if (
            self.URL is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SoftwareType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.vendor is not None:
            showIndent(outfile, level)
            outfile.write('vendor = "%s",\n' % (self.vendor,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.family is not None:
            showIndent(outfile, level)
            outfile.write('family = "%s",\n' % (self.family,))
        if self.swid is not None:
            showIndent(outfile, level)
            outfile.write('swid = "%s",\n' % (self.swid,))
        if self.patch is not None:
            showIndent(outfile, level)
            outfile.write('patch = "%s",\n' % (self.patch,))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version = "%s",\n' % (self.version,))
        if self.configid is not None:
            showIndent(outfile, level)
            outfile.write('configid = "%s",\n' % (self.configid,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URL is not None:
            showIndent(outfile, level)
            outfile.write('URL=%s,\n' % quote_python(self.URL).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('vendor'):
            self.vendor = attrs.get('vendor').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
        if attrs.get('family'):
            self.family = attrs.get('family').value
        if attrs.get('swid'):
            self.swid = attrs.get('swid').value
        if attrs.get('patch'):
            self.patch = attrs.get('patch').value
        if attrs.get('version'):
            self.version = attrs.get('version').value
        if attrs.get('configid'):
            self.configid = attrs.get('configid').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.ELEMENT_NODE and \
            nodeName_ == 'URL':
            URL_ = ''
            for text__content_ in child_.childNodes:
                URL_ += text__content_.nodeValue
            self.URL = URL_
# end class SoftwareType


class MLStringType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, lang=None, valueOf_=''):
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MLStringType.subclass:
            return MLStringType.subclass(*args_, **kwargs_)
        else:
            return MLStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='MLStringType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MLStringType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='MLStringType'):
        if self.lang is not None:
            outfile.write(' lang=%s' % (quote_attrib(self.lang), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='MLStringType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='MLStringType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='MLStringType')
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='MLStringType'):
        if self.lang is not None:
            return ' lang=%s' % (quote_attrib(self.lang), )
        return ''
    def exportChildrenS(self, level, namespace_='iodef:', name_='MLStringType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            return value.encode(ExternalEncoding)
        else:
            return quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MLStringType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.lang is not None:
            showIndent(outfile, level)
            outfile.write('lang = %s,\n' % (self.lang,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('lang'):
            self.lang = attrs.get('lang').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MLStringType


class ExtensionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dtype=None, meaning=None, restriction=None, formatid=None, ext_dtype=None, valueOf_='', mixedclass_=None, content_=None):
        self.dtype = _cast(None, dtype)
        self.meaning = _cast(None, meaning)
        self.restriction = _cast(None, restriction)
        self.formatid = _cast(None, formatid)
        self.ext_dtype = _cast(None, ext_dtype)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ExtensionType.subclass:
            return ExtensionType.subclass(*args_, **kwargs_)
        else:
            return ExtensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dtype(self): return self.dtype
    def set_dtype(self, dtype): self.dtype = dtype
    def get_meaning(self): return self.meaning
    def set_meaning(self, meaning): self.meaning = meaning
    def get_restriction(self): return self.restriction
    def set_restriction(self, restriction): self.restriction = restriction
    def get_formatid(self): return self.formatid
    def set_formatid(self, formatid): self.formatid = formatid
    def get_ext_dtype(self): return self.ext_dtype
    def set_ext_dtype(self, ext_dtype): self.ext_dtype = ext_dtype
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='ExtensionType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ExtensionType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_)
        outfile.write('</%s%s>\n' % (namespace_, name_))
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='ExtensionType'):
        outfile.write(' dtype=%s' % (quote_attrib(self.dtype), ))
        if self.meaning is not None:
            outfile.write(' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), ))
        if self.restriction is not None:
            outfile.write(' restriction=%s' % (quote_attrib(self.restriction), ))
        if self.formatid is not None:
            outfile.write(' formatid=%s' % (self.format_string(quote_attrib(self.formatid).encode(ExternalEncoding), input_name='formatid'), ))
        if self.ext_dtype is not None:
            outfile.write(' ext-dtype=%s' % (self.format_string(quote_attrib(self.ext_dtype).encode(ExternalEncoding), input_name='ext-dtype'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='ExtensionType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='ExtensionType', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='ExtensionType')
        expStr += '>'
        expStr += self.exportChildrenS( level + 1, namespace_, name_)
        expStr += '</%s%s>\n' % (namespace_, name_)
        return expStr 
    def exportAttributesS(self, level, namespace_='iodef:', name_='ExtensionType'):
        expStr = ' dtype=%s' % (quote_attrib(self.dtype), )
        if self.meaning is not None:
            expStr += ' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), )
        if self.restriction is not None:
            expStr += ' restriction=%s' % (quote_attrib(self.restriction), )
        if self.formatid is not None:
            expStr += ' formatid=%s' % (self.format_string(quote_attrib(self.formatid).encode(ExternalEncoding), input_name='formatid'), )
        if self.ext_dtype is not None:
            expStr += ' ext-dtype=%s' % (self.format_string(quote_attrib(self.ext_dtype).encode(ExternalEncoding), input_name='ext-dtype'), )
        return expStr 
    def exportChildrenS(self, level, namespace_='iodef:', name_='ExtensionType'):
        # This method *MUST* be updated for new types of structures. 
        # An auxilliary file is used to figure out what extensions we have
        # found. The auxilliary file could get quite complex.

        expStr = showIndentS( level)
        from iodef.phish import phish
        if isinstance(self.getValueOf_(),phish.PhraudReport):
          preport = self.getValueOf_()
          expStr += preport.exportS(level, namespace_='phish:', name_='PhraudReport')
        
        if expStr is '':
          if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            exStr = value.encode(ExternalEncoding)
          else:
            expStr = quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExtensionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.dtype is not None:
            showIndent(outfile, level)
            outfile.write('dtype = %s,\n' % (self.dtype,))
        if self.meaning is not None:
            showIndent(outfile, level)
            outfile.write('meaning = "%s",\n' % (self.meaning,))
        if self.restriction is not None:
            showIndent(outfile, level)
            outfile.write('restriction = %s,\n' % (self.restriction,))
        if self.formatid is not None:
            showIndent(outfile, level)
            outfile.write('formatid = "%s",\n' % (self.formatid,))
        if self.ext_dtype is not None:
            showIndent(outfile, level)
            outfile.write('ext_dtype = "%s",\n' % (self.ext_dtype,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('dtype'):
            self.dtype = attrs.get('dtype').value
        if attrs.get('meaning'):
            self.meaning = attrs.get('meaning').value
        if attrs.get('restriction'):
            self.restriction = attrs.get('restriction').value
        if attrs.get('formatid'):
            self.formatid = attrs.get('formatid').value
        if attrs.get('ext-dtype'):
            self.ext_dtype = attrs.get('ext-dtype').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.nodeValue)
            self.content_.append(obj_)
        if child_.nodeType == xml.dom.Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == xml.dom.Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class ExtensionType


class NodeRole(MLStringType):
    subclass = None
    superclass = MLStringType
    def __init__(self, lang=None, category=None, ext_category=None, valueOf_=''):
        MLStringType.__init__(self, lang, valueOf_)
        self.category = _cast(None, category)
        self.ext_category = _cast(None, ext_category)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if NodeRole.subclass:
            return NodeRole.subclass(*args_, **kwargs_)
        else:
            return NodeRole(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_ext_category(self): return self.ext_category
    def set_ext_category(self, ext_category): self.ext_category = ext_category
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='NodeRole', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='NodeRole')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="NodeRole"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='NodeRole'):
        MLStringType.exportAttributes(self, outfile, level, namespace_, name_='NodeRole')
        outfile.write(' category=%s' % (quote_attrib(self.category), ))
        if self.ext_category is not None:
            outfile.write(' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='NodeRole'):
        MLStringType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='NodeRole', namespacedef_ =''):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='NodeRole')
#        expStr += ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'
#        expStr += ' xsi:type="NodeRole"'
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='NodeRole'):
        expStr = MLStringType.exportAttributesS(self, level, namespace_, name_='NodeRole')
        expStr += ' category=%s' % (quote_attrib(self.category), )
        if self.ext_category is not None:
            expStr += ' ext-category=%s' % (self.format_string(quote_attrib(self.ext_category).encode(ExternalEncoding), input_name='ext-category'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='NodeRole'):
        expStr = MLStringType.exportChildrenS(self, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NodeRole'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category = %s,\n' % (self.category,))
        if self.ext_category is not None:
            showIndent(outfile, level)
            outfile.write('ext_category = "%s",\n' % (self.ext_category,))
        MLStringType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        MLStringType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('category'):
            self.category = attrs.get('category').value
        if attrs.get('ext-category'):
            self.ext_category = attrs.get('ext-category').value
        MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        MLStringType.buildChildren(self, child_, nodeName_)
# end class NodeRole


class Impact(MLStringType):
    subclass = None
    superclass = MLStringType
    def __init__(self, lang=None, completion=None, type_='unknown', severity=None, ext_type=None, valueOf_=''):
        MLStringType.__init__(self, lang, valueOf_)
        self.completion = _cast(None, completion)
        self.type_ = _cast(None, type_)
        self.severity = _cast(None, severity)
        self.ext_type = _cast(None, ext_type)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Impact.subclass:
            return Impact.subclass(*args_, **kwargs_)
        else:
            return Impact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_completion(self): return self.completion
    def set_completion(self, completion): self.completion = completion
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_ext_type(self): return self.ext_type
    def set_ext_type(self, ext_type): self.ext_type = ext_type
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='Impact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Impact')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="Impact"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='Impact'):
        MLStringType.exportAttributes(self, outfile, level, namespace_, name_='Impact')
        if self.completion is not None:
            outfile.write(' completion=%s' % (quote_attrib(self.completion), ))
        if self.type_ is not None:
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.severity is not None:
            outfile.write(' severity=%s' % (quote_attrib(self.severity), ))
        if self.ext_type is not None:
            outfile.write(' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='Impact'):
        MLStringType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='Impact', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='Impact')
#        expStr += ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'
#        expStr += ' xsi:type="Impact"'
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='Impact'):
        expStr = MLStringType.exportAttributesS(self, level, namespace_, name_='Impact')
        if self.completion is not None:
            expStr += ' completion=%s' % (quote_attrib(self.completion), )
        if self.type_ is not None:
            expStr += ' type=%s' % (quote_attrib(self.type_), )
        if self.severity is not None:
            expStr += ' severity=%s' % (quote_attrib(self.severity), )
        if self.ext_type is not None:
            expStr += ' ext-type=%s' % (self.format_string(quote_attrib(self.ext_type).encode(ExternalEncoding), input_name='ext-type'), )
        return expStr
    def exportChildrenS(self, level, namespace_='iodef:', name_='Impact'):
        expStr = MLStringType.exportChildrenS(self, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Impact'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.completion is not None:
            showIndent(outfile, level)
            outfile.write('completion = %s,\n' % (self.completion,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.severity is not None:
            showIndent(outfile, level)
            outfile.write('severity = %s,\n' % (self.severity,))
        if self.ext_type is not None:
            showIndent(outfile, level)
            outfile.write('ext_type = "%s",\n' % (self.ext_type,))
        MLStringType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        MLStringType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('completion'):
            self.completion = attrs.get('completion').value
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('severity'):
            self.severity = attrs.get('severity').value
        if attrs.get('ext-type'):
            self.ext_type = attrs.get('ext-type').value
        MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        MLStringType.buildChildren(self, child_, nodeName_)
# end class Impact


class PostalAddress(MLStringType):
    subclass = None
    superclass = MLStringType
    def __init__(self, lang=None, meaning=None, valueOf_=''):
        MLStringType.__init__(self, lang, valueOf_)
        self.meaning = _cast(None, meaning)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PostalAddress.subclass:
            return PostalAddress.subclass(*args_, **kwargs_)
        else:
            return PostalAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meaning(self): return self.meaning
    def set_meaning(self, meaning): self.meaning = meaning
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='iodef:', name_='PostalAddress', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PostalAddress')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="PostalAddress"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='iodef:', name_='PostalAddress'):
        MLStringType.exportAttributes(self, outfile, level, namespace_, name_='PostalAddress')
        if self.meaning is not None:
            outfile.write(' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), ))
    def exportChildren(self, outfile, level, namespace_='iodef:', name_='PostalAddress'):
        MLStringType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def exportS(self, level, namespace_='iodef:', name_='PostalAddress', namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"'):
        expStr = showIndentS( level)
        expStr += '<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', )
        expStr += self.exportAttributesS( level, namespace_, name_='PostalAddress')
#        expStr += ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'
#        expStr += ' xsi:type="PostalAddress"'
        if self.hasContent_():
            expStr += '>'
            expStr += self.exportChildrenS( level + 1, namespace_, name_)
            expStr += '</%s%s>\n' % (namespace_, name_)
        else:
            expStr += '/>\n'
        return expStr
    def exportAttributesS(self, level, namespace_='iodef:', name_='PostalAddress'):
        expStr = MLStringType.exportAttributesS(self, level, namespace_, name_='PostalAddress')
        if self.meaning is not None:
            expStr += ' meaning=%s' % (self.format_string(quote_attrib(self.meaning).encode(ExternalEncoding), input_name='meaning'), )
        return expStr                      
    def exportChildrenS(self, level, namespace_='iodef:', name_='PostalAddress'):
        expStr = MLStringType.exportChildrenS(self, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            expStr += value.encode(ExternalEncoding)
        else:
            expStr += quote_xml('%s' % self.valueOf_.encode(ExternalEncoding))
        return expStr
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PostalAddress'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.meaning is not None:
            showIndent(outfile, level)
            outfile.write('meaning = "%s",\n' % (self.meaning,))
        MLStringType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        MLStringType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('meaning'):
            self.meaning = attrs.get('meaning').value
        MLStringType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        MLStringType.buildChildren(self, child_, nodeName_)
# end class PostalAddress


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def parseToString(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = IODEF_Document.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    return rootObj

def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = IODEF_Document.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="IODEF-Document", 
        namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = IODEF_Document.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="IODEF-Document",
        namespacedef_='xmlns:iodef="urn:ietf:params:xml:ns:iodef-1.0"')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = IODEF_Document.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from iodef import *\n\n')
    sys.stdout.write('import iodef as model_\n\n')
    sys.stdout.write('rootObj = model_.IODEF_Document(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="IODEF_Document")
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

