# IPA Zounds, a sound change engine with support for the IPA.
# Copyright (C) 2003 Jamie Norrish
#
# This file is part of IPA Zounds.
#
# IPA Zounds is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPA Zounds is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPA Zounds; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

ipa_base_chars = ('p', 'b', 't', 'd',
                  u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                  u'\N{LATIN SMALL LETTER D WITH TAIL}',
                  'c',
                  u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                  'k', 'g', 'q',
                  u'\N{LATIN LETTER SMALL CAPITAL G}',
                  u'\N{LATIN LETTER GLOTTAL STOP}',
                  'm',
                  u'\N{LATIN SMALL LETTER M WITH HOOK}',
                  'n',
                  u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                  u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                  u'\N{LATIN SMALL LETTER ENG}',
                  u'\N{LATIN LETTER SMALL CAPITAL N}',
                  u'\N{LATIN LETTER SMALL CAPITAL B}',
                  'r',
                  u'\N{LATIN LETTER SMALL CAPITAL R}',
                  u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                  u'\N{LATIN SMALL LETTER R WITH TAIL}',
                  u'\N{LATIN SMALL LETTER PHI}',
                  u'\N{GREEK SMALL LETTER BETA}',
                  'f', 'v',
                  u'\N{GREEK SMALL LETTER THETA}',
                  u'\N{LATIN SMALL LETTER ETH}',
                  's', 'z',
                  u'\N{LATIN SMALL LETTER ESH}',
                  u'\N{LATIN SMALL LETTER EZH}',
                  u'\N{LATIN SMALL LETTER S WITH HOOK}',
                  u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                  u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                  u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                  'x',
                  u'\N{LATIN SMALL LETTER GAMMA}',
                  u'\N{GREEK SMALL LETTER CHI}',
                  u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                  u'\N{LATIN SMALL LETTER H WITH STROKE}',
                  u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                  'h',
                  u'\N{LATIN SMALL LETTER H WITH HOOK}',
                  u'\N{LATIN SMALL LETTER L WITH BELT}',
                  u'\N{LATIN SMALL LETTER LEZH}',
                  u'\N{LATIN SMALL LETTER V WITH HOOK}',
                  u'\N{LATIN SMALL LETTER TURNED R}',
                  u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                  'j',
                  u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                  'l',
                  u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                  u'\N{LATIN SMALL LETTER TURNED Y}',
                  u'\N{LATIN LETTER SMALL CAPITAL L}',
                  'i', 'y',
                  u'\N{LATIN SMALL LETTER I WITH STROKE}',
                  u'\N{LATIN SMALL LETTER U BAR}',
                  u'\N{LATIN SMALL LETTER TURNED M}',
                  'u', 'e',
                  u'\N{LATIN SMALL LETTER O WITH STROKE}',
                  u'\N{LATIN SMALL LETTER REVERSED E}',
                  u'\N{LATIN SMALL LETTER BARRED O}',
                  u'\N{LATIN SMALL LETTER RAMS HORN}',
                  'o',
                  u'\N{LATIN SMALL LETTER SCHWA}',
                  u'\N{LATIN SMALL LETTER OPEN E}',
                  u'\N{LATIN SMALL LIGATURE OE}',
                  u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                  u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                  u'\N{LATIN SMALL LETTER TURNED V}',
                  u'\N{LATIN SMALL LETTER OPEN O}',
                  'a',
                  u'\N{LATIN LETTER SMALL CAPITAL OE}',
                  u'\N{LATIN SMALL LETTER ALPHA}',
                  u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                  u'\N{LATIN LETTER BILABIAL CLICK}',
                  u'\N{LATIN LETTER DENTAL CLICK}',
                  u'\N{LATIN LETTER RETROFLEX CLICK}',
                  u'\N{LATIN LETTER LATERAL CLICK}',
                  u'\N{LATIN SMALL LETTER B WITH HOOK}',
                  u'\N{LATIN SMALL LETTER D WITH HOOK}',
                  u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                  u'\N{LATIN SMALL LETTER G WITH HOOK}',
                  u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                  u'\N{LATIN SMALL LETTER TURNED W}',
                  'w',
                  u'\N{LATIN SMALL LETTER TURNED H}',
                  u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                  u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                  u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                  u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                  u'\N{LATIN SMALL LETTER TESH DIGRAPH}')

ipa_space_chars = (u'\N{MODIFIER LETTER TRIANGULAR COLON}',
                   u'\N{MODIFIER LETTER SMALL H}',
                   u'\N{RIGHT SINGLE QUOTATION MARK}')

ipa_diacritics = (u'\N{COMBINING BRIDGE BELOW}',
                  u'\N{COMBINING CARON}',
                  u'\N{COMBINING GRAVE ACCENT}',
                  u'\N{COMBINING GRAVE ACCENT BELOW}',
                  u'\N{COMBINING ACUTE ACCENT}',
                  u'\N{COMBINING ACUTE ACCENT BELOW}',
                  u'\N{COMBINING MACRON}',
                  u'\N{COMBINING MACRON BELOW}',
                  u'\N{COMBINING TILDE}',
                  u'\N{COMBINING CIRCUMFLEX ACCENT}',
                  u'\N{COMBINING RING BELOW}',
                  u'\N{COMBINING CARON BELOW}',
                  u'\N{COMBINING RIGHT HALF RING BELOW}',
                  u'\N{COMBINING LEFT HALF RING BELOW}',
                  u'\N{COMBINING DIAERESIS}',
                  u'\N{COMBINING VERTICAL LINE BELOW}',
                  u'\N{COMBINING INVERTED BREVE BELOW}')

ipa_supra_segmentals = ('.',
                        u'\N{MODIFIER LETTER VERTICAL LINE}',
                        u'\N{MODIFIER LETTER LOW VERTICAL LINE}',
                        '|',
                        u'\N{DOUBLE VERTICAL LINE}')

# Using a dictionary here is a hack to get around the fact that
# Python's name tokens are limited to ASCII characters.
homorganic_variables = {u'\N{GREEK SMALL LETTER ALPHA}': 'alpha',
                        u'\N{GREEK SMALL LETTER BETA}': 'betta',
                        u'\N{GREEK SMALL LETTER GAMMA}': 'gamma',
                        u'\N{GREEK SMALL LETTER DELTA}': 'delta',
                        u'\N{GREEK SMALL LETTER EPSILON}': 'epslon',
                        u'\N{GREEK SMALL LETTER ZETA}': 'zetta',
                        u'\N{GREEK SMALL LETTER ETA}': 'eta',
                        u'\N{GREEK SMALL LETTER THETA}': 'thetta',
                        u'\N{GREEK SMALL LETTER IOTA}': 'iota',
                        u'\N{GREEK SMALL LETTER KAPPA}': 'kappa',
                        u'\N{GREEK SMALL LETTER LAMDA}': 'lamda',
                        u'\N{GREEK SMALL LETTER MU}': 'mu',
                        u'\N{GREEK SMALL LETTER NU}': 'nu',
                        u'\N{GREEK SMALL LETTER XI}': 'xi',
                        u'\N{GREEK SMALL LETTER OMICRON}': 'omicron',
                        u'\N{GREEK SMALL LETTER PI}': 'pi',
                        u'\N{GREEK SMALL LETTER RHO}': 'rho',
                        u'\N{GREEK SMALL LETTER SIGMA}': 'sigma',
                        u'\N{GREEK SMALL LETTER TAU}': 'tau',
                        u'\N{GREEK SMALL LETTER UPSILON}': 'upslon',
                        u'\N{GREEK SMALL LETTER PHI}': 'phi',
                        u'\N{GREEK SMALL LETTER CHI}': 'chi',
                        u'\N{GREEK SMALL LETTER PSI}': 'psi',
                        u'\N{GREEK SMALL LETTER OMEGA}': 'omega'
                        }

ipa_map = {
    'anterior': {'description':
                 'Covers bilabials, labiodentals, dentals, alveolars, and retroflexes.',
                 'plus': ('p', 'b', 't', 'd',
                          u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH TAIL}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          'r',
                          u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                          u'\N{LATIN SMALL LETTER R WITH TAIL}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{GREEK SMALL LETTER THETA}',
                          u'\N{LATIN SMALL LETTER ETH}',
                          's', 'z',
                          u'\N{LATIN SMALL LETTER S WITH HOOK}',
                          u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER L WITH BELT}',
                          u'\N{LATIN SMALL LETTER LEZH}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'l',
                          u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                          u'\N{LATIN LETTER BILABIAL CLICK}',
                          u'\N{LATIN LETTER DENTAL CLICK}',
                          u'\N{LATIN LETTER RETROFLEX CLICK}',
                          u'\N{LATIN LETTER LATERAL CLICK}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                          u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TS DIGRAPH}'),
                 'minus': ('c',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                           'k', 'g', 'q',
                           u'\N{LATIN LETTER SMALL CAPITAL G}',
                           u'\N{LATIN LETTER GLOTTAL STOP}',
                           u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                           u'\N{LATIN SMALL LETTER ENG}',
                           u'\N{LATIN LETTER SMALL CAPITAL N}',
                           u'\N{LATIN LETTER SMALL CAPITAL R}',
                           u'\N{LATIN SMALL LETTER ESH}',
                           u'\N{LATIN SMALL LETTER EZH}',
                           u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                           u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                           'x',
                           u'\N{LATIN SMALL LETTER GAMMA}',
                           u'\N{GREEK SMALL LETTER CHI}',
                           u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                           u'\N{LATIN SMALL LETTER H WITH STROKE}',
                           u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                           'h',
                           u'\N{LATIN SMALL LETTER H WITH HOOK}',
                           'j',
                           u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                           u'\N{LATIN SMALL LETTER TURNED Y}',
                           u'\N{LATIN LETTER SMALL CAPITAL L}',
                           'i', 'y',
                           u'\N{LATIN SMALL LETTER I WITH STROKE}',
                           u'\N{LATIN SMALL LETTER U BAR}',
                           u'\N{LATIN SMALL LETTER TURNED M}',
                           'u', 'e',
                           u'\N{LATIN SMALL LETTER O WITH STROKE}',
                           u'\N{LATIN SMALL LETTER REVERSED E}',
                           u'\N{LATIN SMALL LETTER BARRED O}',
                           u'\N{LATIN SMALL LETTER RAMS HORN}',
                           'o',
                           u'\N{LATIN SMALL LETTER SCHWA}',
                           u'\N{LATIN SMALL LETTER OPEN E}',
                           u'\N{LATIN SMALL LIGATURE OE}',
                           u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                           u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                           u'\N{LATIN SMALL LETTER TURNED V}',
                           u'\N{LATIN SMALL LETTER OPEN O}',
                           'a',
                           u'\N{LATIN LETTER SMALL CAPITAL OE}',
                           u'\N{LATIN SMALL LETTER ALPHA}',
                           u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                           u'\N{LATIN SMALL LETTER G WITH HOOK}',
                           u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED W}',
                           'w',
                           u'\N{LATIN SMALL LETTER TURNED H}',
                           u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'aspirated': {'plus': (u'\N{MODIFIER LETTER SMALL H}',),
                  'minus': ipa_base_chars},
    'back': {'description':
             'Covers velars, uvulars and pharyngeals, and back vowels.',
             'plus': ('k', 'g', 'q',
                      u'\N{LATIN LETTER SMALL CAPITAL G}',
                      u'\N{LATIN SMALL LETTER ENG}',
                      u'\N{LATIN LETTER SMALL CAPITAL N}',
                      u'\N{LATIN LETTER SMALL CAPITAL R}',
                      'x',
                      u'\N{LATIN SMALL LETTER GAMMA}',
                      u'\N{GREEK SMALL LETTER CHI}',
                      u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                      u'\N{LATIN SMALL LETTER H WITH STROKE}',
                      u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                      u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                      u'\N{LATIN LETTER SMALL CAPITAL L}',
                      u'\N{LATIN SMALL LETTER TURNED M}',
                      'u',
                      u'\N{LATIN SMALL LETTER RAMS HORN}',
                      'o',
                      u'\N{LATIN SMALL LETTER TURNED V}',
                      u'\N{LATIN SMALL LETTER OPEN O}',
                      u'\N{LATIN SMALL LETTER ALPHA}',
                      u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                      u'\N{LATIN SMALL LETTER G WITH HOOK}',
                      u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED W}',
                      'w'),
             'minus': ('p', 'b', 't', 'd',
                       u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH TAIL}',
                       'c',
                       u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                       u'\N{LATIN LETTER GLOTTAL STOP}',
                       'm',
                       u'\N{LATIN SMALL LETTER M WITH HOOK}',
                       'n',
                       u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                       u'\N{LATIN LETTER SMALL CAPITAL B}',
                       'r',
                       u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                       u'\N{LATIN SMALL LETTER R WITH TAIL}',
                       u'\N{LATIN SMALL LETTER PHI}',
                       u'\N{GREEK SMALL LETTER BETA}',
                       'f', 'v',
                       u'\N{GREEK SMALL LETTER THETA}',
                       u'\N{LATIN SMALL LETTER ETH}',
                       's', 'z',
                       u'\N{LATIN SMALL LETTER ESH}',
                       u'\N{LATIN SMALL LETTER EZH}',
                       u'\N{LATIN SMALL LETTER S WITH HOOK}',
                       u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                       u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                       'h',
                       u'\N{LATIN SMALL LETTER H WITH HOOK}',
                       u'\N{LATIN SMALL LETTER L WITH BELT}',
                       u'\N{LATIN SMALL LETTER LEZH}',
                       u'\N{LATIN SMALL LETTER V WITH HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED R}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                       'j',
                       'l',
                       u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED Y}',
                       'i', 'y',
                       u'\N{LATIN SMALL LETTER I WITH STROKE}',
                       u'\N{LATIN SMALL LETTER U BAR}',
                       'e',
                       u'\N{LATIN SMALL LETTER O WITH STROKE}',
                       u'\N{LATIN SMALL LETTER REVERSED E}',
                       u'\N{LATIN SMALL LETTER BARRED O}',
                       u'\N{LATIN SMALL LETTER SCHWA}',
                       u'\N{LATIN SMALL LETTER OPEN E}',
                       u'\N{LATIN SMALL LIGATURE OE}',
                       u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                       u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                       'a',
                       u'\N{LATIN LETTER SMALL CAPITAL OE}',
                       u'\N{LATIN LETTER BILABIAL CLICK}',
                       u'\N{LATIN LETTER DENTAL CLICK}',
                       u'\N{LATIN LETTER RETROFLEX CLICK}',
                       u'\N{LATIN LETTER LATERAL CLICK}',
                       u'\N{LATIN SMALL LETTER B WITH HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH HOOK}',
                       u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED H}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                       u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                       u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                       u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                       u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'central': {'description':
                u'Used to mark vowels as central (back and front vowels are both \N{MINUS SIGN}central).',
                'plus': (u'\N{LATIN SMALL LETTER I WITH STROKE}',
                         u'\N{LATIN SMALL LETTER U BAR}',
                         u'\N{LATIN SMALL LETTER REVERSED E}',
                         u'\N{LATIN SMALL LETTER BARRED O}',
                         u'\N{LATIN SMALL LETTER SCHWA}',
                         u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                         u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                         u'\N{COMBINING DIAERESIS}'),
                'minus': ('p', 'b', 't', 'd',
                          u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH TAIL}',
                          'c',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                          'k', 'g', 'q',
                          u'\N{LATIN LETTER SMALL CAPITAL G}',
                          u'\N{LATIN LETTER GLOTTAL STOP}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          'r',
                          u'\N{LATIN LETTER SMALL CAPITAL R}',
                          u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                          u'\N{LATIN SMALL LETTER R WITH TAIL}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{GREEK SMALL LETTER THETA}',
                          u'\N{LATIN SMALL LETTER ETH}',
                          's', 'z',
                          u'\N{LATIN SMALL LETTER ESH}',
                          u'\N{LATIN SMALL LETTER EZH}',
                          u'\N{LATIN SMALL LETTER S WITH HOOK}',
                          u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                          u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                          'x',
                          u'\N{LATIN SMALL LETTER GAMMA}',
                          u'\N{GREEK SMALL LETTER CHI}',
                          u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                          u'\N{LATIN SMALL LETTER H WITH STROKE}',
                          u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                          'h',
                          u'\N{LATIN SMALL LETTER H WITH HOOK}',
                          u'\N{LATIN SMALL LETTER L WITH BELT}',
                          u'\N{LATIN SMALL LETTER LEZH}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          'l',
                          u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED Y}',
                          u'\N{LATIN LETTER SMALL CAPITAL L}',
                          'i', 'y',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{LATIN LETTER BILABIAL CLICK}',
                          u'\N{LATIN LETTER DENTAL CLICK}',
                          u'\N{LATIN LETTER RETROFLEX CLICK}',
                          u'\N{LATIN LETTER LATERAL CLICK}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH HOOK}',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                          u'\N{LATIN SMALL LETTER G WITH HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED W}',
                          'w',
                          u'\N{LATIN SMALL LETTER TURNED H}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                          u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                          u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'consonantal': {'description':
                    'Covers consonants, but not semi-vowels.',
                    'plus': ('p', 'b', 't', 'd',
                             u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                             u'\N{LATIN SMALL LETTER D WITH TAIL}',
                             'c',
                             u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                             'k', 'g', 'q',
                             u'\N{LATIN LETTER SMALL CAPITAL G}',
                             u'\N{LATIN LETTER GLOTTAL STOP}',
                             'm',
                             u'\N{LATIN SMALL LETTER M WITH HOOK}',
                             'n',
                             u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                             u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                             u'\N{LATIN SMALL LETTER ENG}',
                             u'\N{LATIN LETTER SMALL CAPITAL N}',
                             u'\N{LATIN LETTER SMALL CAPITAL B}',
                             'r',
                             u'\N{LATIN LETTER SMALL CAPITAL R}',
                             u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                             u'\N{LATIN SMALL LETTER R WITH TAIL}',
                             u'\N{LATIN SMALL LETTER PHI}',
                             u'\N{GREEK SMALL LETTER BETA}',
                             'f', 'v',
                             u'\N{GREEK SMALL LETTER THETA}',
                             u'\N{LATIN SMALL LETTER ETH}',
                             's', 'z',
                             u'\N{LATIN SMALL LETTER ESH}',
                             u'\N{LATIN SMALL LETTER EZH}',
                             u'\N{LATIN SMALL LETTER S WITH HOOK}',
                             u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                             u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                             u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                             'x',
                             u'\N{LATIN SMALL LETTER GAMMA}',
                             u'\N{GREEK SMALL LETTER CHI}',
                             u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                             u'\N{LATIN SMALL LETTER H WITH STROKE}',
                             u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                             'h',
                             u'\N{LATIN SMALL LETTER H WITH HOOK}',
                             u'\N{LATIN SMALL LETTER L WITH BELT}',
                             u'\N{LATIN SMALL LETTER LEZH}',
                             u'\N{LATIN SMALL LETTER V WITH HOOK}',
                             u'\N{LATIN SMALL LETTER TURNED R}',
                             u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                             'j',
                             u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                             'l',
                             u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                             u'\N{LATIN SMALL LETTER TURNED Y}',
                             u'\N{LATIN LETTER SMALL CAPITAL L}',
                             u'\N{LATIN LETTER BILABIAL CLICK}',
                             u'\N{LATIN LETTER DENTAL CLICK}',
                             u'\N{LATIN LETTER RETROFLEX CLICK}',
                             u'\N{LATIN LETTER LATERAL CLICK}',
                             u'\N{LATIN SMALL LETTER B WITH HOOK}',
                             u'\N{LATIN SMALL LETTER D WITH HOOK}',
                             u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                             u'\N{LATIN SMALL LETTER G WITH HOOK}',
                             u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                             u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                             u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                             u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                             u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                             u'\N{LATIN SMALL LETTER TESH DIGRAPH}'),
                    'minus': ('i', 'y',
                              u'\N{LATIN SMALL LETTER I WITH STROKE}',
                              u'\N{LATIN SMALL LETTER U BAR}',
                              u'\N{LATIN SMALL LETTER TURNED M}',
                              'u', 'e',
                              u'\N{LATIN SMALL LETTER O WITH STROKE}',
                              u'\N{LATIN SMALL LETTER REVERSED E}',
                              u'\N{LATIN SMALL LETTER BARRED O}',
                              u'\N{LATIN SMALL LETTER RAMS HORN}',
                              'o',
                              u'\N{LATIN SMALL LETTER SCHWA}',
                              u'\N{LATIN SMALL LETTER OPEN E}',
                              u'\N{LATIN SMALL LIGATURE OE}',
                              u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                              u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                              u'\N{LATIN SMALL LETTER TURNED V}',
                              u'\N{LATIN SMALL LETTER OPEN O}',
                              'a',
                              u'\N{LATIN LETTER SMALL CAPITAL OE}',
                              u'\N{LATIN SMALL LETTER ALPHA}',
                              u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                              u'\N{LATIN SMALL LETTER TURNED W}',
                              'w',
                              u'\N{LATIN SMALL LETTER TURNED H}')},
    'continuant': {'description':
                   'Covers nasals, fricatives, approximants, and vowels.',
                   'plus': ('m',
                            u'\N{LATIN SMALL LETTER M WITH HOOK}',
                            'n',
                            u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                            u'\N{LATIN SMALL LETTER ENG}',
                            u'\N{LATIN LETTER SMALL CAPITAL N}',
                            u'\N{LATIN SMALL LETTER PHI}',
                            u'\N{GREEK SMALL LETTER BETA}',
                            'f', 'v',
                            u'\N{GREEK SMALL LETTER THETA}',
                            u'\N{LATIN SMALL LETTER ETH}',
                            's', 'z',
                            u'\N{LATIN SMALL LETTER ESH}',
                            u'\N{LATIN SMALL LETTER EZH}',
                            u'\N{LATIN SMALL LETTER S WITH HOOK}',
                            u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                            u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                            'x',
                            u'\N{LATIN SMALL LETTER GAMMA}',
                            u'\N{GREEK SMALL LETTER CHI}',
                            u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                            u'\N{LATIN SMALL LETTER H WITH STROKE}',
                            u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                            'h',
                            u'\N{LATIN SMALL LETTER H WITH HOOK}',
                            u'\N{LATIN SMALL LETTER L WITH BELT}',
                            u'\N{LATIN SMALL LETTER LEZH}',
                            u'\N{LATIN SMALL LETTER V WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED R}',
                            u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                            'j',
                            u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                            'l',
                            u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED Y}',
                            u'\N{LATIN LETTER SMALL CAPITAL L}',
                            'i', 'y',
                            u'\N{LATIN SMALL LETTER I WITH STROKE}',
                            u'\N{LATIN SMALL LETTER U BAR}',
                            u'\N{LATIN SMALL LETTER TURNED M}',
                            'u', 'e',
                            u'\N{LATIN SMALL LETTER O WITH STROKE}',
                            u'\N{LATIN SMALL LETTER REVERSED E}',
                            u'\N{LATIN SMALL LETTER BARRED O}',
                            u'\N{LATIN SMALL LETTER RAMS HORN}',
                            'o',
                            u'\N{LATIN SMALL LETTER SCHWA}',
                            u'\N{LATIN SMALL LETTER OPEN E}',
                            u'\N{LATIN SMALL LIGATURE OE}',
                            u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER TURNED V}',
                            u'\N{LATIN SMALL LETTER OPEN O}',
                            'a',
                            u'\N{LATIN LETTER SMALL CAPITAL OE}',
                            u'\N{LATIN SMALL LETTER ALPHA}',
                            u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                            u'\N{LATIN SMALL LETTER TURNED W}',
                            'w',
                            u'\N{LATIN SMALL LETTER TURNED H}'),
                   'minus': ('p', 'b', 't', 'd',
                             u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                             u'\N{LATIN SMALL LETTER D WITH TAIL}',
                             'c',
                             u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                             'k', 'g', 'q',
                             u'\N{LATIN LETTER SMALL CAPITAL G}',
                             u'\N{LATIN LETTER GLOTTAL STOP}',
                             u'\N{LATIN LETTER SMALL CAPITAL B}',
                             'r',
                             u'\N{LATIN LETTER SMALL CAPITAL R}',
                             u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                             u'\N{LATIN SMALL LETTER R WITH TAIL}',
                             u'\N{LATIN LETTER BILABIAL CLICK}',
                             u'\N{LATIN LETTER DENTAL CLICK}',
                             u'\N{LATIN LETTER RETROFLEX CLICK}',
                             u'\N{LATIN LETTER LATERAL CLICK}',
                             u'\N{LATIN SMALL LETTER B WITH HOOK}',
                             u'\N{LATIN SMALL LETTER D WITH HOOK}',
                             u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                             u'\N{LATIN SMALL LETTER G WITH HOOK}',
                             u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                             u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                             u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                             u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                             u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                             u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'coronal': {'description':
                'Covers dentals, alveolars, postalveolars and retroflexes.',
                'plus': ('t', 'd',
                         u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER D WITH TAIL}',
                         'n',
                         u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                         'r',
                         u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                         u'\N{LATIN SMALL LETTER R WITH TAIL}',
                         u'\N{GREEK SMALL LETTER THETA}',
                         u'\N{LATIN SMALL LETTER ETH}',
                         's', 'z',
                         u'\N{LATIN SMALL LETTER ESH}',
                         u'\N{LATIN SMALL LETTER EZH}',
                         u'\N{LATIN SMALL LETTER S WITH HOOK}',
                         u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER L WITH BELT}',
                         u'\N{LATIN SMALL LETTER LEZH}',
                         u'\N{LATIN SMALL LETTER TURNED R}',
                         u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                         'l',
                         u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                         u'\N{LATIN LETTER DENTAL CLICK}',
                         u'\N{LATIN LETTER RETROFLEX CLICK}',
                         u'\N{LATIN LETTER LATERAL CLICK}',
                         u'\N{LATIN SMALL LETTER D WITH HOOK}',
                         u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                         u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                         u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                         u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                         u'\N{LATIN SMALL LETTER TESH DIGRAPH}'),
                'minus': ('p', 'b',
                          'c',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                          'k', 'g', 'q',
                          u'\N{LATIN LETTER SMALL CAPITAL G}',
                          u'\N{LATIN LETTER GLOTTAL STOP}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          u'\N{LATIN LETTER SMALL CAPITAL R}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                          u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                          'x',
                          u'\N{LATIN SMALL LETTER GAMMA}',
                          u'\N{GREEK SMALL LETTER CHI}',
                          u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                          u'\N{LATIN SMALL LETTER H WITH STROKE}',
                          u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                          'h',
                          u'\N{LATIN SMALL LETTER H WITH HOOK}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          u'\N{LATIN SMALL LETTER TURNED Y}',
                          u'\N{LATIN LETTER SMALL CAPITAL L}',
                          'i', 'y',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER U BAR}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER BARRED O}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{LATIN LETTER BILABIAL CLICK}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                          u'\N{LATIN SMALL LETTER G WITH HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED W}',
                          'w',
                          u'\N{LATIN SMALL LETTER TURNED H}')},
    'delayedrelease': {'description': 'Covers affricates.',
                       'plus': (u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                                u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                                u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                                u'\N{LATIN SMALL LETTER TESH DIGRAPH}'),
                       'minus': ('p', 'b', 't', 'd',
                                 u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                                 u'\N{LATIN SMALL LETTER D WITH TAIL}',
                                 'c',
                                 u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                                 'k', 'g', 'q',
                                 u'\N{LATIN LETTER SMALL CAPITAL G}',
                                 u'\N{LATIN LETTER GLOTTAL STOP}',
                                 'm',
                                 u'\N{LATIN SMALL LETTER M WITH HOOK}',
                                 'n',
                                 u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                                 u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                                 u'\N{LATIN SMALL LETTER ENG}',
                                 u'\N{LATIN LETTER SMALL CAPITAL N}',
                                 u'\N{LATIN LETTER SMALL CAPITAL B}',
                                 'r',
                                 u'\N{LATIN LETTER SMALL CAPITAL R}',
                                 u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                                 u'\N{LATIN SMALL LETTER R WITH TAIL}',
                                 u'\N{LATIN SMALL LETTER PHI}',
                                 u'\N{GREEK SMALL LETTER BETA}',
                                 'f', 'v',
                                 u'\N{GREEK SMALL LETTER THETA}',
                                 u'\N{LATIN SMALL LETTER ETH}',
                                 's', 'z',
                                 u'\N{LATIN SMALL LETTER ESH}',
                                 u'\N{LATIN SMALL LETTER EZH}',
                                 u'\N{LATIN SMALL LETTER S WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                                 u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                                 u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                                 'x',
                                 u'\N{LATIN SMALL LETTER GAMMA}',
                                 u'\N{GREEK SMALL LETTER CHI}',
                                 u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                                 u'\N{LATIN SMALL LETTER H WITH STROKE}',
                                 u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                                 'h',
                                 u'\N{LATIN SMALL LETTER H WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER L WITH BELT}',
                                 u'\N{LATIN SMALL LETTER LEZH}',
                                 u'\N{LATIN SMALL LETTER V WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER TURNED R}',
                                 u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                                 'j',
                                 u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                                 'l',
                                 u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                                 u'\N{LATIN SMALL LETTER TURNED Y}',
                                 u'\N{LATIN LETTER SMALL CAPITAL L}',
                                 'i', 'y',
                                 u'\N{LATIN SMALL LETTER I WITH STROKE}',
                                 u'\N{LATIN SMALL LETTER U BAR}',
                                 u'\N{LATIN SMALL LETTER TURNED M}',
                                 'u', 'e',
                                 u'\N{LATIN SMALL LETTER O WITH STROKE}',
                                 u'\N{LATIN SMALL LETTER REVERSED E}',
                                 u'\N{LATIN SMALL LETTER BARRED O}',
                                 u'\N{LATIN SMALL LETTER RAMS HORN}',
                                 'o',
                                 u'\N{LATIN SMALL LETTER SCHWA}',
                                 u'\N{LATIN SMALL LETTER OPEN E}',
                                 u'\N{LATIN SMALL LIGATURE OE}',
                                 u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                                 u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                                 u'\N{LATIN SMALL LETTER TURNED V}',
                                 u'\N{LATIN SMALL LETTER OPEN O}',
                                 'a',
                                 u'\N{LATIN LETTER SMALL CAPITAL OE}',
                                 u'\N{LATIN SMALL LETTER ALPHA}',
                                 u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                                 u'\N{LATIN LETTER BILABIAL CLICK}',
                                 u'\N{LATIN LETTER DENTAL CLICK}',
                                 u'\N{LATIN LETTER RETROFLEX CLICK}',
                                 u'\N{LATIN LETTER LATERAL CLICK}',
                                 u'\N{LATIN SMALL LETTER B WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER D WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                                 u'\N{LATIN SMALL LETTER G WITH HOOK}',
                                 u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                                 u'\N{LATIN SMALL LETTER TURNED W}',
                                 'w',
                                 u'\N{LATIN SMALL LETTER TURNED H}',
                                 u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}')},
    'dental': {'description':
               "Covers labiodentals and dentals.",
               'plus': (u'\N{LATIN SMALL LETTER M WITH HOOK}',
                        'f', 'v',
                        u'\N{GREEK SMALL LETTER THETA}',
                        u'\N{LATIN SMALL LETTER ETH}',
                        u'\N{LATIN SMALL LETTER V WITH HOOK}',
                        u'\N{LATIN LETTER DENTAL CLICK}',
                        u'\N{COMBINING BRIDGE BELOW}'),
               'minus': ('p', 'b', 't', 'd',
                         u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER D WITH TAIL}',
                         'c',
                         u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                         'k', 'g', 'q',
                         u'\N{LATIN LETTER SMALL CAPITAL G}',
                         u'\N{LATIN LETTER GLOTTAL STOP}',
                         'm',
                         'n',
                         u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                         u'\N{LATIN SMALL LETTER ENG}',
                         u'\N{LATIN LETTER SMALL CAPITAL N}',
                         u'\N{LATIN LETTER SMALL CAPITAL B}',
                         'r',
                         u'\N{LATIN LETTER SMALL CAPITAL R}',
                         u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                         u'\N{LATIN SMALL LETTER R WITH TAIL}',
                         u'\N{LATIN SMALL LETTER PHI}',
                         u'\N{GREEK SMALL LETTER BETA}',
                         's', 'z',
                         u'\N{LATIN SMALL LETTER ESH}',
                         u'\N{LATIN SMALL LETTER EZH}',
                         u'\N{LATIN SMALL LETTER S WITH HOOK}',
                         u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                         u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                         'x',
                         u'\N{LATIN SMALL LETTER GAMMA}',
                         u'\N{GREEK SMALL LETTER CHI}',
                         u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                         u'\N{LATIN SMALL LETTER H WITH STROKE}',
                         u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                         'h',
                         u'\N{LATIN SMALL LETTER H WITH HOOK}',
                         u'\N{LATIN SMALL LETTER L WITH BELT}',
                         u'\N{LATIN SMALL LETTER LEZH}',
                         u'\N{LATIN SMALL LETTER TURNED R}',
                         u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                         'j',
                         u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                         'l',
                         u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER TURNED Y}',
                         u'\N{LATIN LETTER SMALL CAPITAL L}',
                         'i', 'y',
                         u'\N{LATIN SMALL LETTER I WITH STROKE}',
                         u'\N{LATIN SMALL LETTER U BAR}',
                         u'\N{LATIN SMALL LETTER TURNED M}',
                         'u', 'e',
                         u'\N{LATIN SMALL LETTER O WITH STROKE}',
                         u'\N{LATIN SMALL LETTER REVERSED E}',
                         u'\N{LATIN SMALL LETTER BARRED O}',
                         u'\N{LATIN SMALL LETTER RAMS HORN}',
                         'o',
                         u'\N{LATIN SMALL LETTER SCHWA}',
                         u'\N{LATIN SMALL LETTER OPEN E}',
                         u'\N{LATIN SMALL LIGATURE OE}',
                         u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                         u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                         u'\N{LATIN SMALL LETTER TURNED V}',
                         u'\N{LATIN SMALL LETTER OPEN O}',
                         'a',
                         u'\N{LATIN LETTER SMALL CAPITAL OE}',
                         u'\N{LATIN SMALL LETTER ALPHA}',
                         u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                         u'\N{LATIN LETTER BILABIAL CLICK}',
                         u'\N{LATIN LETTER RETROFLEX CLICK}',
                         u'\N{LATIN LETTER LATERAL CLICK}',
                         u'\N{LATIN SMALL LETTER B WITH HOOK}',
                         u'\N{LATIN SMALL LETTER D WITH HOOK}',
                         u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                         u'\N{LATIN SMALL LETTER G WITH HOOK}',
                         u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                         u'\N{LATIN SMALL LETTER TURNED W}',
                         'w',
                         u'\N{LATIN SMALL LETTER TURNED H}',
                         u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                         u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                         u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                         u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                         u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'egressive': {'description':
                  u'Clicks and implosives are \N{MINUS SIGN}egressive.',
                  'plus': ('p', 'b', 't', 'd',
                           u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH TAIL}',
                           'c',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                           'k', 'g', 'q',
                           u'\N{LATIN LETTER SMALL CAPITAL G}',
                           u'\N{LATIN LETTER GLOTTAL STOP}',
                           'm',
                           u'\N{LATIN SMALL LETTER M WITH HOOK}',
                           'n',
                           u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                           u'\N{LATIN SMALL LETTER ENG}',
                           u'\N{LATIN LETTER SMALL CAPITAL N}',
                           u'\N{LATIN LETTER SMALL CAPITAL B}',
                           'r',
                           u'\N{LATIN LETTER SMALL CAPITAL R}',
                           u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                           u'\N{LATIN SMALL LETTER R WITH TAIL}',
                           u'\N{LATIN SMALL LETTER PHI}',
                           u'\N{GREEK SMALL LETTER BETA}',
                           'f', 'v',
                           u'\N{GREEK SMALL LETTER THETA}',
                           u'\N{LATIN SMALL LETTER ETH}',
                           's', 'z',
                           u'\N{LATIN SMALL LETTER ESH}',
                           u'\N{LATIN SMALL LETTER EZH}',
                           u'\N{LATIN SMALL LETTER S WITH HOOK}',
                           u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                           u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                           'x',
                           u'\N{LATIN SMALL LETTER GAMMA}',
                           u'\N{GREEK SMALL LETTER CHI}',
                           u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                           u'\N{LATIN SMALL LETTER H WITH STROKE}',
                           u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                           'h',
                           u'\N{LATIN SMALL LETTER H WITH HOOK}',
                           u'\N{LATIN SMALL LETTER L WITH BELT}',
                           u'\N{LATIN SMALL LETTER LEZH}',
                           u'\N{LATIN SMALL LETTER V WITH HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED R}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                           'j',
                           u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                           'l',
                           u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED Y}',
                           u'\N{LATIN LETTER SMALL CAPITAL L}',
                           'i', 'y',
                           u'\N{LATIN SMALL LETTER I WITH STROKE}',
                           u'\N{LATIN SMALL LETTER U BAR}',
                           u'\N{LATIN SMALL LETTER TURNED M}',
                           'u', 'e',
                           u'\N{LATIN SMALL LETTER O WITH STROKE}',
                           u'\N{LATIN SMALL LETTER REVERSED E}',
                           u'\N{LATIN SMALL LETTER BARRED O}',
                           u'\N{LATIN SMALL LETTER RAMS HORN}',
                           'o',
                           u'\N{LATIN SMALL LETTER SCHWA}',
                           u'\N{LATIN SMALL LETTER OPEN E}',
                           u'\N{LATIN SMALL LIGATURE OE}',
                           u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                           u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                           u'\N{LATIN SMALL LETTER TURNED V}',
                           u'\N{LATIN SMALL LETTER OPEN O}',
                           'a',
                           u'\N{LATIN LETTER SMALL CAPITAL OE}',
                           u'\N{LATIN SMALL LETTER ALPHA}',
                           u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                           u'\N{LATIN SMALL LETTER TURNED W}',
                           'w',
                           u'\N{LATIN SMALL LETTER TURNED H}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                           u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                           u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TESH DIGRAPH}'),
                  'minus': (u'\N{LATIN LETTER BILABIAL CLICK}',
                            u'\N{LATIN LETTER DENTAL CLICK}',
                            u'\N{LATIN LETTER RETROFLEX CLICK}',
                            u'\N{LATIN LETTER LATERAL CLICK}',
                            u'\N{LATIN SMALL LETTER B WITH HOOK}',
                            u'\N{LATIN SMALL LETTER D WITH HOOK}',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                            u'\N{LATIN SMALL LETTER G WITH HOOK}',
                            u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',)},
    'fallingrisingtone': {'plus': (u'\N{COMBINING CARON}'),
                          'minus': ipa_base_chars},
    'fallingtone': {'plus': (u'\N{COMBINING GRAVE ACCENT}',),
                    'minus': ipa_base_chars},
    'glottalic': {'description':
                  'Covers implosives and ejectives.',
                  'plus': (u'\N{LATIN SMALL LETTER B WITH HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH HOOK}',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                           u'\N{LATIN SMALL LETTER G WITH HOOK}',
                           u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                           u'\N{RIGHT SINGLE QUOTATION MARK}'),
                  'minus': ('p', 'b', 't', 'd',
                            u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER D WITH TAIL}',
                            'c',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                            'k', 'g', 'q',
                            u'\N{LATIN LETTER SMALL CAPITAL G}',
                            u'\N{LATIN LETTER GLOTTAL STOP}',
                            'm',
                            u'\N{LATIN SMALL LETTER M WITH HOOK}',
                            'n',
                            u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                            u'\N{LATIN SMALL LETTER ENG}',
                            u'\N{LATIN LETTER SMALL CAPITAL N}',
                            u'\N{LATIN LETTER SMALL CAPITAL B}',
                            'r',
                            u'\N{LATIN LETTER SMALL CAPITAL R}',
                            u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                            u'\N{LATIN SMALL LETTER R WITH TAIL}',
                            u'\N{LATIN SMALL LETTER PHI}',
                            u'\N{GREEK SMALL LETTER BETA}',
                            'f', 'v',
                            u'\N{GREEK SMALL LETTER THETA}',
                            u'\N{LATIN SMALL LETTER ETH}',
                            's', 'z',
                            u'\N{LATIN SMALL LETTER ESH}',
                            u'\N{LATIN SMALL LETTER EZH}',
                            u'\N{LATIN SMALL LETTER S WITH HOOK}',
                            u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                            u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                            'x',
                            u'\N{LATIN SMALL LETTER GAMMA}',
                            u'\N{GREEK SMALL LETTER CHI}',
                            u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                            u'\N{LATIN SMALL LETTER H WITH STROKE}',
                            u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                            'h',
                            u'\N{LATIN SMALL LETTER H WITH HOOK}',
                            u'\N{LATIN SMALL LETTER L WITH BELT}',
                            u'\N{LATIN SMALL LETTER LEZH}',
                            u'\N{LATIN SMALL LETTER V WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED R}',
                            u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                            'j',
                            u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                            'l',
                            u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED Y}',
                            u'\N{LATIN LETTER SMALL CAPITAL L}',
                            'i', 'y',
                            u'\N{LATIN SMALL LETTER I WITH STROKE}',
                            u'\N{LATIN SMALL LETTER U BAR}',
                            u'\N{LATIN SMALL LETTER TURNED M}',
                            'u', 'e',
                            u'\N{LATIN SMALL LETTER O WITH STROKE}',
                            u'\N{LATIN SMALL LETTER REVERSED E}',
                            u'\N{LATIN SMALL LETTER BARRED O}',
                            u'\N{LATIN SMALL LETTER RAMS HORN}',
                            'o',
                            u'\N{LATIN SMALL LETTER SCHWA}',
                            u'\N{LATIN SMALL LETTER OPEN E}',
                            u'\N{LATIN SMALL LIGATURE OE}',
                            u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER TURNED V}',
                            u'\N{LATIN SMALL LETTER OPEN O}',
                            'a',
                            u'\N{LATIN LETTER SMALL CAPITAL OE}',
                            u'\N{LATIN SMALL LETTER ALPHA}',
                            u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                            u'\N{LATIN LETTER BILABIAL CLICK}',
                            u'\N{LATIN LETTER DENTAL CLICK}',
                            u'\N{LATIN LETTER RETROFLEX CLICK}',
                            u'\N{LATIN LETTER LATERAL CLICK}',
                            u'\N{LATIN SMALL LETTER TURNED W}',
                            'w',
                            u'\N{LATIN SMALL LETTER TURNED H}',
                            u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                            u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                            u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'high': {'description':
             'Covers high vowels and postalveolars, palatals and velars.',
             'plus': ('c',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                      'k', 'g',
                      u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                      u'\N{LATIN SMALL LETTER ENG}',
                      u'\N{LATIN SMALL LETTER ESH}',
                      u'\N{LATIN SMALL LETTER EZH}',
                      u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                      u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                      'x',
                      u'\N{LATIN SMALL LETTER GAMMA}',
                      'j',
                      u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                      u'\N{LATIN SMALL LETTER TURNED Y}',
                      u'\N{LATIN LETTER SMALL CAPITAL L}',
                      'i', 'y',
                      u'\N{LATIN SMALL LETTER I WITH STROKE}',
                      u'\N{LATIN SMALL LETTER U BAR}',
                      u'\N{LATIN SMALL LETTER TURNED M}',
                      'u', 'e',
                      u'\N{LATIN SMALL LETTER O WITH STROKE}',
                      u'\N{LATIN SMALL LETTER REVERSED E}',
                      u'\N{LATIN SMALL LETTER BARRED O}',
                      u'\N{LATIN SMALL LETTER RAMS HORN}',
                      'o',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                      u'\N{LATIN SMALL LETTER G WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED W}',
                      'w',
                      u'\N{LATIN SMALL LETTER TURNED H}',
                      u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                      u'\N{LATIN SMALL LETTER TESH DIGRAPH}'),
             'minus': ('p', 'b', 't', 'd',
                       u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH TAIL}',
                       'q',
                       u'\N{LATIN LETTER SMALL CAPITAL G}',
                       u'\N{LATIN LETTER GLOTTAL STOP}',
                       'm',
                       u'\N{LATIN SMALL LETTER M WITH HOOK}',
                       'n',
                       u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                       u'\N{LATIN LETTER SMALL CAPITAL N}',
                       u'\N{LATIN LETTER SMALL CAPITAL B}',
                       'r',
                       u'\N{LATIN LETTER SMALL CAPITAL R}',
                       u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                       u'\N{LATIN SMALL LETTER R WITH TAIL}',
                       u'\N{LATIN SMALL LETTER PHI}',
                       u'\N{GREEK SMALL LETTER BETA}',
                       'f', 'v',
                       u'\N{GREEK SMALL LETTER THETA}',
                       u'\N{LATIN SMALL LETTER ETH}',
                       's', 'z',
                       u'\N{LATIN SMALL LETTER S WITH HOOK}',
                       u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                       u'\N{GREEK SMALL LETTER CHI}',
                       u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                       u'\N{LATIN SMALL LETTER H WITH STROKE}',
                       u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                       'h',
                       u'\N{LATIN SMALL LETTER H WITH HOOK}',
                       u'\N{LATIN SMALL LETTER L WITH BELT}',
                       u'\N{LATIN SMALL LETTER LEZH}',
                       u'\N{LATIN SMALL LETTER V WITH HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED R}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                       'l',
                       u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER SCHWA}',
                       u'\N{LATIN SMALL LETTER OPEN E}',
                       u'\N{LATIN SMALL LIGATURE OE}',
                       u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                       u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                       u'\N{LATIN SMALL LETTER TURNED V}',
                       u'\N{LATIN SMALL LETTER OPEN O}',
                       'a',
                       u'\N{LATIN LETTER SMALL CAPITAL OE}',
                       u'\N{LATIN SMALL LETTER ALPHA}',
                       u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                       u'\N{LATIN LETTER BILABIAL CLICK}',
                       u'\N{LATIN LETTER DENTAL CLICK}',
                       u'\N{LATIN LETTER RETROFLEX CLICK}',
                       u'\N{LATIN LETTER LATERAL CLICK}',
                       u'\N{LATIN SMALL LETTER B WITH HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH HOOK}',
                       u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                       u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                       u'\N{LATIN SMALL LETTER TS DIGRAPH}')},
    'hightone': {'plus': (u'\N{COMBINING MACRON}',),
                 'minus': ipa_base_chars},
    'lateral': {'plus': (u'\N{LATIN SMALL LETTER L WITH BELT}',
                         u'\N{LATIN SMALL LETTER LEZH}',
                         'l',
                         u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                         u'\N{LATIN SMALL LETTER TURNED Y}',
                         u'\N{LATIN LETTER SMALL CAPITAL L}',
                         u'\N{LATIN LETTER LATERAL CLICK}',
                         u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}'),
                'minus': ('p', 'b', 't', 'd',
                          u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH TAIL}',
                          'c',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                          'k', 'g', 'q',
                          u'\N{LATIN LETTER SMALL CAPITAL G}',
                          u'\N{LATIN LETTER GLOTTAL STOP}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          'r',
                          u'\N{LATIN LETTER SMALL CAPITAL R}',
                          u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                          u'\N{LATIN SMALL LETTER R WITH TAIL}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{GREEK SMALL LETTER THETA}',
                          u'\N{LATIN SMALL LETTER ETH}',
                          's', 'z',
                          u'\N{LATIN SMALL LETTER ESH}',
                          u'\N{LATIN SMALL LETTER EZH}',
                          u'\N{LATIN SMALL LETTER S WITH HOOK}',
                          u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                          u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                          'x',
                          u'\N{LATIN SMALL LETTER GAMMA}',
                          u'\N{GREEK SMALL LETTER CHI}',
                          u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                          u'\N{LATIN SMALL LETTER H WITH STROKE}',
                          u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                          'h',
                          u'\N{LATIN SMALL LETTER H WITH HOOK}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          'i', 'y',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER U BAR}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER BARRED O}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{LATIN LETTER BILABIAL CLICK}',
                          u'\N{LATIN LETTER DENTAL CLICK}',
                          u'\N{LATIN LETTER RETROFLEX CLICK}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH HOOK}',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                          u'\N{LATIN SMALL LETTER G WITH HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED W}',
                          'w',
                          u'\N{LATIN SMALL LETTER TURNED H}',
                          u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                          u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'long': {'description': 'Covers trills and lengthened sounds.',
             'plus': (u'\N{LATIN LETTER SMALL CAPITAL B}',
                      'r',
                      u'\N{LATIN LETTER SMALL CAPITAL R}',
                      u'\N{MODIFIER LETTER TRIANGULAR COLON}',),
             'minus': ('p', 'b', 't', 'd',
                       u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH TAIL}',
                       'c',
                       u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                       'k', 'g', 'q',
                       u'\N{LATIN LETTER SMALL CAPITAL G}',
                       u'\N{LATIN LETTER GLOTTAL STOP}',
                       'm',
                       u'\N{LATIN SMALL LETTER M WITH HOOK}',
                       'n',
                       u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                       u'\N{LATIN SMALL LETTER ENG}',
                       u'\N{LATIN LETTER SMALL CAPITAL N}',
                       u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                       u'\N{LATIN SMALL LETTER R WITH TAIL}',
                       u'\N{LATIN SMALL LETTER PHI}',
                       u'\N{GREEK SMALL LETTER BETA}',
                       'f', 'v',
                       u'\N{GREEK SMALL LETTER THETA}',
                       u'\N{LATIN SMALL LETTER ETH}',
                       's', 'z',
                       u'\N{LATIN SMALL LETTER ESH}',
                       u'\N{LATIN SMALL LETTER EZH}',
                       u'\N{LATIN SMALL LETTER S WITH HOOK}',
                       u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                       u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                       'x',
                       u'\N{LATIN SMALL LETTER GAMMA}',
                       u'\N{GREEK SMALL LETTER CHI}',
                       u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                       u'\N{LATIN SMALL LETTER H WITH STROKE}',
                       u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                       'h',
                       u'\N{LATIN SMALL LETTER H WITH HOOK}',
                       u'\N{LATIN SMALL LETTER L WITH BELT}',
                       u'\N{LATIN SMALL LETTER LEZH}',
                       u'\N{LATIN SMALL LETTER V WITH HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED R}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                       'j',
                       u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                       'l',
                       u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED Y}',
                       u'\N{LATIN LETTER SMALL CAPITAL L}',
                       'i', 'y',
                       u'\N{LATIN SMALL LETTER I WITH STROKE}',
                       u'\N{LATIN SMALL LETTER U BAR}',
                       u'\N{LATIN SMALL LETTER TURNED M}',
                       'u', 'e',
                       u'\N{LATIN SMALL LETTER O WITH STROKE}',
                       u'\N{LATIN SMALL LETTER REVERSED E}',
                       u'\N{LATIN SMALL LETTER BARRED O}',
                       u'\N{LATIN SMALL LETTER RAMS HORN}',
                       'o',
                       u'\N{LATIN SMALL LETTER SCHWA}',
                       u'\N{LATIN SMALL LETTER OPEN E}',
                       u'\N{LATIN SMALL LIGATURE OE}',
                       u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                       u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                       u'\N{LATIN SMALL LETTER TURNED V}',
                       u'\N{LATIN SMALL LETTER OPEN O}',
                       'a',
                       u'\N{LATIN LETTER SMALL CAPITAL OE}',
                       u'\N{LATIN SMALL LETTER ALPHA}',
                       u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                       u'\N{LATIN LETTER BILABIAL CLICK}',
                       u'\N{LATIN LETTER DENTAL CLICK}',
                       u'\N{LATIN LETTER RETROFLEX CLICK}',
                       u'\N{LATIN LETTER LATERAL CLICK}',
                       u'\N{LATIN SMALL LETTER B WITH HOOK}',
                       u'\N{LATIN SMALL LETTER D WITH HOOK}',
                       u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                       u'\N{LATIN SMALL LETTER G WITH HOOK}',
                       u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                       u'\N{LATIN SMALL LETTER TURNED W}',
                       'w',
                       u'\N{LATIN SMALL LETTER TURNED H}',
                       u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                       u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                       u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                       u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                       u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'low': {'description': 'Covers low vowels and pharyngeals.',
            'plus': (u'\N{LATIN SMALL LETTER H WITH STROKE}',
                     u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                     u'\N{LATIN SMALL LETTER OPEN E}',
                     u'\N{LATIN SMALL LIGATURE OE}',
                     u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                     u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                     u'\N{LATIN SMALL LETTER TURNED V}',
                     u'\N{LATIN SMALL LETTER OPEN O}',
                     'a',
                     u'\N{LATIN LETTER SMALL CAPITAL OE}',
                     u'\N{LATIN SMALL LETTER ALPHA}',
                     u'\N{LATIN SMALL LETTER TURNED ALPHA}'),
            'minus': ('p', 'b', 't', 'd',
                      u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER D WITH TAIL}',
                      'c',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                      'k', 'g', 'q',
                      u'\N{LATIN LETTER SMALL CAPITAL G}',
                      u'\N{LATIN LETTER GLOTTAL STOP}',
                      'm',
                      u'\N{LATIN SMALL LETTER M WITH HOOK}',
                      'n',
                      u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                      u'\N{LATIN SMALL LETTER ENG}',
                      u'\N{LATIN LETTER SMALL CAPITAL N}',
                      u'\N{LATIN LETTER SMALL CAPITAL B}',
                      'r',
                      u'\N{LATIN LETTER SMALL CAPITAL R}',
                      u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                      u'\N{LATIN SMALL LETTER R WITH TAIL}',
                      u'\N{LATIN SMALL LETTER PHI}',
                      u'\N{GREEK SMALL LETTER BETA}',
                      'f', 'v',
                      u'\N{GREEK SMALL LETTER THETA}',
                      u'\N{LATIN SMALL LETTER ETH}',
                      's', 'z',
                      u'\N{LATIN SMALL LETTER ESH}',
                      u'\N{LATIN SMALL LETTER EZH}',
                      u'\N{LATIN SMALL LETTER S WITH HOOK}',
                      u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                      u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                      'x',
                      u'\N{LATIN SMALL LETTER GAMMA}',
                      u'\N{GREEK SMALL LETTER CHI}',
                      u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                      'h',
                      u'\N{LATIN SMALL LETTER H WITH HOOK}',
                      u'\N{LATIN SMALL LETTER L WITH BELT}',
                      u'\N{LATIN SMALL LETTER LEZH}',
                      u'\N{LATIN SMALL LETTER V WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED R}',
                      u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                      'j',
                      u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                      'l',
                      u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED Y}',
                      u'\N{LATIN LETTER SMALL CAPITAL L}',
                      'i', 'y',
                      u'\N{LATIN SMALL LETTER I WITH STROKE}',
                      u'\N{LATIN SMALL LETTER U BAR}',
                      u'\N{LATIN SMALL LETTER TURNED M}',
                      'u', 'e',
                      u'\N{LATIN SMALL LETTER O WITH STROKE}',
                      u'\N{LATIN SMALL LETTER REVERSED E}',
                      u'\N{LATIN SMALL LETTER BARRED O}',
                      u'\N{LATIN SMALL LETTER RAMS HORN}',
                      'o',
                      u'\N{LATIN SMALL LETTER SCHWA}',
                      u'\N{LATIN LETTER BILABIAL CLICK}',
                      u'\N{LATIN LETTER DENTAL CLICK}',
                      u'\N{LATIN LETTER RETROFLEX CLICK}',
                      u'\N{LATIN LETTER LATERAL CLICK}',
                      u'\N{LATIN SMALL LETTER B WITH HOOK}',
                      u'\N{LATIN SMALL LETTER D WITH HOOK}',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                      u'\N{LATIN SMALL LETTER G WITH HOOK}',
                      u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED W}',
                      'w',
                      u'\N{LATIN SMALL LETTER TURNED H}',
                      u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                      u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                      u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                      u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                      u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'lowtone': {'plus': (u'\N{COMBINING MACRON BELOW}'),
                'minus': ipa_base_chars},
    'mid': {'description':
            'Covers three levels of mid height vowels. +high +mid, +mid, and +low +mid.',
            'plus': ('e',
                     u'\N{LATIN SMALL LETTER O WITH STROKE}',
                     u'\N{LATIN SMALL LETTER REVERSED E}',
                     u'\N{LATIN SMALL LETTER BARRED O}',
                     u'\N{LATIN SMALL LETTER RAMS HORN}',
                     'o',
                     u'\N{LATIN SMALL LETTER SCHWA}',
                     u'\N{LATIN SMALL LETTER OPEN E}',
                     u'\N{LATIN SMALL LIGATURE OE}',
                     u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                     u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                     u'\N{LATIN SMALL LETTER TURNED V}',
                     u'\N{LATIN SMALL LETTER OPEN O}'),
            'minus': ('p', 'b', 't', 'd',
                      u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER D WITH TAIL}',
                      'c',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                      'k', 'g', 'q',
                      u'\N{LATIN LETTER SMALL CAPITAL G}',
                      u'\N{LATIN LETTER GLOTTAL STOP}',
                      'm',
                      u'\N{LATIN SMALL LETTER M WITH HOOK}',
                      'n',
                      u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                      u'\N{LATIN SMALL LETTER ENG}',
                      u'\N{LATIN LETTER SMALL CAPITAL N}',
                      u'\N{LATIN LETTER SMALL CAPITAL B}',
                      'r',
                      u'\N{LATIN LETTER SMALL CAPITAL R}',
                      u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                      u'\N{LATIN SMALL LETTER R WITH TAIL}',
                      u'\N{LATIN SMALL LETTER PHI}',
                      u'\N{GREEK SMALL LETTER BETA}',
                      'f', 'v',
                      u'\N{GREEK SMALL LETTER THETA}',
                      u'\N{LATIN SMALL LETTER ETH}',
                      's', 'z',
                      u'\N{LATIN SMALL LETTER ESH}',
                      u'\N{LATIN SMALL LETTER EZH}',
                      u'\N{LATIN SMALL LETTER S WITH HOOK}',
                      u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                      u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                      'x',
                      u'\N{LATIN SMALL LETTER GAMMA}',
                      u'\N{GREEK SMALL LETTER CHI}',
                      u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                      u'\N{LATIN SMALL LETTER H WITH STROKE}',
                      u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                      'h',
                      u'\N{LATIN SMALL LETTER H WITH HOOK}',
                      u'\N{LATIN SMALL LETTER L WITH BELT}',
                      u'\N{LATIN SMALL LETTER LEZH}',
                      u'\N{LATIN SMALL LETTER V WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED R}',
                      u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                      'j',
                      u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                      'l',
                      u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED Y}',
                      u'\N{LATIN LETTER SMALL CAPITAL L}',
                      'i', 'y',
                      u'\N{LATIN SMALL LETTER I WITH STROKE}',
                      u'\N{LATIN SMALL LETTER U BAR}',
                      u'\N{LATIN SMALL LETTER TURNED M}',
                      'u',
                      'a',
                      u'\N{LATIN LETTER SMALL CAPITAL OE}',
                      u'\N{LATIN SMALL LETTER ALPHA}',
                      u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                      u'\N{LATIN LETTER BILABIAL CLICK}',
                      u'\N{LATIN LETTER DENTAL CLICK}',
                      u'\N{LATIN LETTER RETROFLEX CLICK}',
                      u'\N{LATIN LETTER LATERAL CLICK}',
                      u'\N{LATIN SMALL LETTER B WITH HOOK}',
                      u'\N{LATIN SMALL LETTER D WITH HOOK}',
                      u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                      u'\N{LATIN SMALL LETTER G WITH HOOK}',
                      u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                      u'\N{LATIN SMALL LETTER TURNED W}',
                      'w',
                      u'\N{LATIN SMALL LETTER TURNED H}',
                      u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                      u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                      u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                      u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                      u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'nasal': {'plus': ('m',
                       u'\N{LATIN SMALL LETTER M WITH HOOK}',
                       'n',
                       u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                       u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                       u'\N{LATIN SMALL LETTER ENG}',
                       u'\N{LATIN LETTER SMALL CAPITAL N}',
                       u'\N{COMBINING TILDE}'),
              'minus': ('p', 'b', 't', 'd',
                        u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER D WITH TAIL}',
                        'c',
                        u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                        'k', 'g', 'q',
                        u'\N{LATIN LETTER SMALL CAPITAL G}',
                        u'\N{LATIN LETTER GLOTTAL STOP}',
                        u'\N{LATIN LETTER SMALL CAPITAL B}',
                        'r',
                        u'\N{LATIN LETTER SMALL CAPITAL R}',
                        u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                        u'\N{LATIN SMALL LETTER R WITH TAIL}',
                        u'\N{LATIN SMALL LETTER PHI}',
                        u'\N{GREEK SMALL LETTER BETA}',
                        'f', 'v',
                        u'\N{GREEK SMALL LETTER THETA}',
                        u'\N{LATIN SMALL LETTER ETH}',
                        's', 'z',
                        u'\N{LATIN SMALL LETTER ESH}',
                        u'\N{LATIN SMALL LETTER EZH}',
                        u'\N{LATIN SMALL LETTER S WITH HOOK}',
                        u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                        u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                        'x',
                        u'\N{LATIN SMALL LETTER GAMMA}',
                        u'\N{GREEK SMALL LETTER CHI}',
                        u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                        u'\N{LATIN SMALL LETTER H WITH STROKE}',
                        u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                        'h',
                        u'\N{LATIN SMALL LETTER H WITH HOOK}',
                        u'\N{LATIN SMALL LETTER L WITH BELT}',
                        u'\N{LATIN SMALL LETTER LEZH}',
                        u'\N{LATIN SMALL LETTER V WITH HOOK}',
                        u'\N{LATIN SMALL LETTER TURNED R}',
                        u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                        'j',
                        u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                        'l',
                        u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER TURNED Y}',
                        u'\N{LATIN LETTER SMALL CAPITAL L}',
                        'i', 'y',
                        u'\N{LATIN SMALL LETTER I WITH STROKE}',
                        u'\N{LATIN SMALL LETTER U BAR}',
                        u'\N{LATIN SMALL LETTER TURNED M}',
                        'u', 'e',
                        u'\N{LATIN SMALL LETTER O WITH STROKE}',
                        u'\N{LATIN SMALL LETTER REVERSED E}',
                        u'\N{LATIN SMALL LETTER BARRED O}',
                        u'\N{LATIN SMALL LETTER RAMS HORN}',
                        'o',
                        u'\N{LATIN SMALL LETTER SCHWA}',
                        u'\N{LATIN SMALL LETTER OPEN E}',
                        u'\N{LATIN SMALL LIGATURE OE}',
                        u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                        u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                        u'\N{LATIN SMALL LETTER TURNED V}',
                        u'\N{LATIN SMALL LETTER OPEN O}',
                        'a',
                        u'\N{LATIN LETTER SMALL CAPITAL OE}',
                        u'\N{LATIN SMALL LETTER ALPHA}',
                        u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                        u'\N{LATIN LETTER BILABIAL CLICK}',
                        u'\N{LATIN LETTER DENTAL CLICK}',
                        u'\N{LATIN LETTER RETROFLEX CLICK}',
                        u'\N{LATIN LETTER LATERAL CLICK}',
                        u'\N{LATIN SMALL LETTER B WITH HOOK}',
                        u'\N{LATIN SMALL LETTER D WITH HOOK}',
                        u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                        u'\N{LATIN SMALL LETTER G WITH HOOK}',
                        u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                        u'\N{LATIN SMALL LETTER TURNED W}',
                        'w',
                        u'\N{LATIN SMALL LETTER TURNED H}',
                        u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                        u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                        u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                        u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                        u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'retroflex': {'plus': (u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH TAIL}',
                           u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER R WITH TAIL}',
                           u'\N{LATIN SMALL LETTER S WITH HOOK}',
                           u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                           u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                           u'\N{LATIN LETTER RETROFLEX CLICK}'),
                  'minus': ('p', 'b', 't', 'd',
                            'c',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                            'k', 'g', 'q',
                            u'\N{LATIN LETTER SMALL CAPITAL G}',
                            u'\N{LATIN LETTER GLOTTAL STOP}',
                            'm',
                            u'\N{LATIN SMALL LETTER M WITH HOOK}',
                            'n',
                            u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                            u'\N{LATIN SMALL LETTER ENG}',
                            u'\N{LATIN LETTER SMALL CAPITAL N}',
                            u'\N{LATIN LETTER SMALL CAPITAL B}',
                            'r',
                            u'\N{LATIN LETTER SMALL CAPITAL R}',
                            u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                            u'\N{LATIN SMALL LETTER PHI}',
                            u'\N{GREEK SMALL LETTER BETA}',
                            'f', 'v',
                            u'\N{GREEK SMALL LETTER THETA}',
                            u'\N{LATIN SMALL LETTER ETH}',
                            's', 'z',
                            u'\N{LATIN SMALL LETTER ESH}',
                            u'\N{LATIN SMALL LETTER EZH}',
                            u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                            u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                            'x',
                            u'\N{LATIN SMALL LETTER GAMMA}',
                            u'\N{GREEK SMALL LETTER CHI}',
                            u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                            u'\N{LATIN SMALL LETTER H WITH STROKE}',
                            u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                            'h',
                            u'\N{LATIN SMALL LETTER H WITH HOOK}',
                            u'\N{LATIN SMALL LETTER L WITH BELT}',
                            u'\N{LATIN SMALL LETTER LEZH}',
                            u'\N{LATIN SMALL LETTER V WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED R}',
                            'j',
                            u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                            'l',
                            u'\N{LATIN SMALL LETTER TURNED Y}',
                            u'\N{LATIN LETTER SMALL CAPITAL L}',
                            'i', 'y',
                            u'\N{LATIN SMALL LETTER I WITH STROKE}',
                            u'\N{LATIN SMALL LETTER U BAR}',
                            u'\N{LATIN SMALL LETTER TURNED M}',
                            'u', 'e',
                            u'\N{LATIN SMALL LETTER O WITH STROKE}',
                            u'\N{LATIN SMALL LETTER REVERSED E}',
                            u'\N{LATIN SMALL LETTER BARRED O}',
                            u'\N{LATIN SMALL LETTER RAMS HORN}',
                            'o',
                            u'\N{LATIN SMALL LETTER SCHWA}',
                            u'\N{LATIN SMALL LETTER OPEN E}',
                            u'\N{LATIN SMALL LIGATURE OE}',
                            u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER TURNED V}',
                            u'\N{LATIN SMALL LETTER OPEN O}',
                            'a',
                            u'\N{LATIN LETTER SMALL CAPITAL OE}',
                            u'\N{LATIN SMALL LETTER ALPHA}',
                            u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                            u'\N{LATIN LETTER BILABIAL CLICK}',
                            u'\N{LATIN LETTER DENTAL CLICK}',
                            u'\N{LATIN LETTER LATERAL CLICK}',
                            u'\N{LATIN SMALL LETTER B WITH HOOK}',
                            u'\N{LATIN SMALL LETTER D WITH HOOK}',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                            u'\N{LATIN SMALL LETTER G WITH HOOK}',
                            u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED W}',
                            'w',
                            u'\N{LATIN SMALL LETTER TURNED H}',
                            u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                            u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                            u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'risingfallingtone': {'plus': (u'\N{COMBINING CIRCUMFLEX ACCENT}'),
                          'minus': ipa_base_chars},
    'risingtone': {'plus': (u'\N{COMBINING ACUTE ACCENT}',),
                   'minus': ipa_base_chars},
    'rounded': {'description': 'Covers rounded vowels and some labials.',
                'plus': ('y',
                         u'\N{LATIN SMALL LETTER U BAR}',
                         'u',
                         u'\N{LATIN SMALL LETTER O WITH STROKE}',
                         u'\N{LATIN SMALL LETTER BARRED O}',
                         'o',
                         u'\N{LATIN SMALL LIGATURE OE}',
                         u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                         u'\N{LATIN SMALL LETTER OPEN O}',
                         u'\N{LATIN LETTER SMALL CAPITAL OE}',
                         u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                         u'\N{LATIN SMALL LETTER TURNED W}',
                         'w',
                         u'\N{LATIN SMALL LETTER TURNED H}',
                         u'\N{COMBINING RIGHT HALF RING BELOW}'),
                'minus': ('p', 'b', 't', 'd',
                          u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH TAIL}',
                          'c',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                          'k', 'g', 'q',
                          u'\N{LATIN LETTER SMALL CAPITAL G}',
                          u'\N{LATIN LETTER GLOTTAL STOP}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          'r',
                          u'\N{LATIN LETTER SMALL CAPITAL R}',
                          u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                          u'\N{LATIN SMALL LETTER R WITH TAIL}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{GREEK SMALL LETTER THETA}',
                          u'\N{LATIN SMALL LETTER ETH}',
                          's', 'z',
                          u'\N{LATIN SMALL LETTER ESH}',
                          u'\N{LATIN SMALL LETTER EZH}',
                          u'\N{LATIN SMALL LETTER S WITH HOOK}',
                          u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                          u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                          'x',
                          u'\N{LATIN SMALL LETTER GAMMA}',
                          u'\N{GREEK SMALL LETTER CHI}',
                          u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                          u'\N{LATIN SMALL LETTER H WITH STROKE}',
                          u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                          'h',
                          u'\N{LATIN SMALL LETTER H WITH HOOK}',
                          u'\N{LATIN SMALL LETTER L WITH BELT}',
                          u'\N{LATIN SMALL LETTER LEZH}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          'l',
                          u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED Y}',
                          u'\N{LATIN LETTER SMALL CAPITAL L}',
                          'i',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'e',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          'a',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN LETTER BILABIAL CLICK}',
                          u'\N{LATIN LETTER DENTAL CLICK}',
                          u'\N{LATIN LETTER RETROFLEX CLICK}',
                          u'\N{LATIN LETTER LATERAL CLICK}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH HOOK}',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                          u'\N{LATIN SMALL LETTER G WITH HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                          u'\N{COMBINING LEFT HALF RING BELOW}',
                          u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                          u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'sonorant': {'description': 'Covers nasals, approximants and vowels.',
                 'plus': ('m',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          'l',
                          u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED Y}',
                          u'\N{LATIN LETTER SMALL CAPITAL L}',
                          'i', 'y',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER U BAR}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER BARRED O}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED W}',
                          'w',
                          u'\N{LATIN SMALL LETTER TURNED H}'),
                 'minus': ('p', 'b', 't', 'd',
                           u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH TAIL}',
                           'c',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                           'k', 'g', 'q',
                           u'\N{LATIN LETTER SMALL CAPITAL G}',
                           u'\N{LATIN LETTER GLOTTAL STOP}',
                           u'\N{LATIN LETTER SMALL CAPITAL B}',
                           'r',
                           u'\N{LATIN LETTER SMALL CAPITAL R}',
                           u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                           u'\N{LATIN SMALL LETTER R WITH TAIL}',
                           u'\N{LATIN SMALL LETTER PHI}',
                           u'\N{GREEK SMALL LETTER BETA}',
                           'f', 'v',
                           u'\N{GREEK SMALL LETTER THETA}',
                           u'\N{LATIN SMALL LETTER ETH}',
                           's', 'z',
                           u'\N{LATIN SMALL LETTER ESH}',
                           u'\N{LATIN SMALL LETTER EZH}',
                           u'\N{LATIN SMALL LETTER S WITH HOOK}',
                           u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                           u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                           'x',
                           u'\N{LATIN SMALL LETTER GAMMA}',
                           u'\N{GREEK SMALL LETTER CHI}',
                           u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                           u'\N{LATIN SMALL LETTER H WITH STROKE}',
                           u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                           'h',
                           u'\N{LATIN SMALL LETTER H WITH HOOK}',
                           u'\N{LATIN SMALL LETTER L WITH BELT}',
                           u'\N{LATIN SMALL LETTER LEZH}',
                           u'\N{LATIN LETTER BILABIAL CLICK}',
                           u'\N{LATIN LETTER DENTAL CLICK}',
                           u'\N{LATIN LETTER RETROFLEX CLICK}',
                           u'\N{LATIN LETTER LATERAL CLICK}',
                           u'\N{LATIN SMALL LETTER B WITH HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH HOOK}',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                           u'\N{LATIN SMALL LETTER G WITH HOOK}',
                           u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                           u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                           u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'syllabic': {'description': 'Covers vowels.',
                 'plus': ('i', 'y',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER U BAR}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER BARRED O}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{COMBINING VERTICAL LINE BELOW}'),
                 'minus': ('p', 'b', 't', 'd',
                           u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH TAIL}',
                           'c',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                           'k', 'g', 'q',
                           u'\N{LATIN LETTER SMALL CAPITAL G}',
                           u'\N{LATIN LETTER GLOTTAL STOP}',
                           'm',
                           u'\N{LATIN SMALL LETTER M WITH HOOK}',
                           'n',
                           u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                           u'\N{LATIN SMALL LETTER ENG}',
                           u'\N{LATIN LETTER SMALL CAPITAL N}',
                           u'\N{LATIN LETTER SMALL CAPITAL B}',
                           'r',
                           u'\N{LATIN LETTER SMALL CAPITAL R}',
                           u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                           u'\N{LATIN SMALL LETTER R WITH TAIL}',
                           u'\N{LATIN SMALL LETTER PHI}',
                           u'\N{GREEK SMALL LETTER BETA}',
                           'f', 'v',
                           u'\N{GREEK SMALL LETTER THETA}',
                           u'\N{LATIN SMALL LETTER ETH}',
                           's', 'z',
                           u'\N{LATIN SMALL LETTER ESH}',
                           u'\N{LATIN SMALL LETTER EZH}',
                           u'\N{LATIN SMALL LETTER S WITH HOOK}',
                           u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                           u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                           'x',
                           u'\N{LATIN SMALL LETTER GAMMA}',
                           u'\N{GREEK SMALL LETTER CHI}',
                           u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                           u'\N{LATIN SMALL LETTER H WITH STROKE}',
                           u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                           'h',
                           u'\N{LATIN SMALL LETTER H WITH HOOK}',
                           u'\N{LATIN SMALL LETTER L WITH BELT}',
                           u'\N{LATIN SMALL LETTER LEZH}',
                           u'\N{LATIN SMALL LETTER V WITH HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED R}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                           'j',
                           u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                           'l',
                           u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED Y}',
                           u'\N{LATIN LETTER SMALL CAPITAL L}',
                           u'\N{LATIN LETTER BILABIAL CLICK}',
                           u'\N{LATIN LETTER DENTAL CLICK}',
                           u'\N{LATIN LETTER RETROFLEX CLICK}',
                           u'\N{LATIN LETTER LATERAL CLICK}',
                           u'\N{LATIN SMALL LETTER B WITH HOOK}',
                           u'\N{LATIN SMALL LETTER D WITH HOOK}',
                           u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                           u'\N{LATIN SMALL LETTER G WITH HOOK}',
                           u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                           u'\N{LATIN SMALL LETTER TURNED W}',
                           'w',
                           u'\N{LATIN SMALL LETTER TURNED H}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                           u'\N{COMBINING INVERTED BREVE BELOW}',
                           u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                           u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                           u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'velaric': {'description': 'Covers clicks.',
                'plus': (u'\N{LATIN LETTER BILABIAL CLICK}',
                         u'\N{LATIN LETTER DENTAL CLICK}',
                         u'\N{LATIN LETTER RETROFLEX CLICK}',
                         u'\N{LATIN LETTER LATERAL CLICK}'),
                'minus': ('p', 'b', 't', 'd',
                          u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH TAIL}',
                          'c',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                          'k', 'g', 'q',
                          u'\N{LATIN LETTER SMALL CAPITAL G}',
                          u'\N{LATIN LETTER GLOTTAL STOP}',
                          'm',
                          u'\N{LATIN SMALL LETTER M WITH HOOK}',
                          'n',
                          u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                          u'\N{LATIN SMALL LETTER ENG}',
                          u'\N{LATIN LETTER SMALL CAPITAL N}',
                          u'\N{LATIN LETTER SMALL CAPITAL B}',
                          'r',
                          u'\N{LATIN LETTER SMALL CAPITAL R}',
                          u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                          u'\N{LATIN SMALL LETTER R WITH TAIL}',
                          u'\N{LATIN SMALL LETTER PHI}',
                          u'\N{GREEK SMALL LETTER BETA}',
                          'f', 'v',
                          u'\N{GREEK SMALL LETTER THETA}',
                          u'\N{LATIN SMALL LETTER ETH}',
                          's', 'z',
                          u'\N{LATIN SMALL LETTER ESH}',
                          u'\N{LATIN SMALL LETTER EZH}',
                          u'\N{LATIN SMALL LETTER S WITH HOOK}',
                          u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                          u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                          'x',
                          u'\N{LATIN SMALL LETTER GAMMA}',
                          u'\N{GREEK SMALL LETTER CHI}',
                          u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                          u'\N{LATIN SMALL LETTER H WITH STROKE}',
                          u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                          'h',
                          u'\N{LATIN SMALL LETTER H WITH HOOK}',
                          u'\N{LATIN SMALL LETTER L WITH BELT}',
                          u'\N{LATIN SMALL LETTER LEZH}',
                          u'\N{LATIN SMALL LETTER V WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED R}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                          'j',
                          u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                          'l',
                          u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED Y}',
                          u'\N{LATIN LETTER SMALL CAPITAL L}',
                          'i', 'y',
                          u'\N{LATIN SMALL LETTER I WITH STROKE}',
                          u'\N{LATIN SMALL LETTER U BAR}',
                          u'\N{LATIN SMALL LETTER TURNED M}',
                          'u', 'e',
                          u'\N{LATIN SMALL LETTER O WITH STROKE}',
                          u'\N{LATIN SMALL LETTER REVERSED E}',
                          u'\N{LATIN SMALL LETTER BARRED O}',
                          u'\N{LATIN SMALL LETTER RAMS HORN}',
                          'o',
                          u'\N{LATIN SMALL LETTER SCHWA}',
                          u'\N{LATIN SMALL LETTER OPEN E}',
                          u'\N{LATIN SMALL LIGATURE OE}',
                          u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                          u'\N{LATIN SMALL LETTER TURNED V}',
                          u'\N{LATIN SMALL LETTER OPEN O}',
                          'a',
                          u'\N{LATIN LETTER SMALL CAPITAL OE}',
                          u'\N{LATIN SMALL LETTER ALPHA}',
                          u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                          u'\N{LATIN SMALL LETTER B WITH HOOK}',
                          u'\N{LATIN SMALL LETTER D WITH HOOK}',
                          u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                          u'\N{LATIN SMALL LETTER G WITH HOOK}',
                          u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                          u'\N{LATIN SMALL LETTER TURNED W}',
                          'w',
                          u'\N{LATIN SMALL LETTER TURNED H}',
                          u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                          u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                          u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                          u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'vibration': {'description': 'Covers trills and taps/flaps.',
                  'plus': (u'\N{LATIN LETTER SMALL CAPITAL B}',
                           'r',
                           u'\N{LATIN LETTER SMALL CAPITAL R}',
                           u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                           u'\N{LATIN SMALL LETTER R WITH TAIL}',
                           u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}'),
                  'minus': ('p', 'b', 't', 'd',
                            u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER D WITH TAIL}',
                            'c',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                            'k', 'g', 'q',
                            u'\N{LATIN LETTER SMALL CAPITAL G}',
                            u'\N{LATIN LETTER GLOTTAL STOP}',
                            'm',
                            u'\N{LATIN SMALL LETTER M WITH HOOK}',
                            'n',
                            u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                            u'\N{LATIN SMALL LETTER ENG}',
                            u'\N{LATIN LETTER SMALL CAPITAL N}',
                            u'\N{LATIN SMALL LETTER PHI}',
                            u'\N{GREEK SMALL LETTER BETA}',
                            'f', 'v',
                            u'\N{GREEK SMALL LETTER THETA}',
                            u'\N{LATIN SMALL LETTER ETH}',
                            's', 'z',
                            u'\N{LATIN SMALL LETTER ESH}',
                            u'\N{LATIN SMALL LETTER EZH}',
                            u'\N{LATIN SMALL LETTER S WITH HOOK}',
                            u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                            u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                            'x',
                            u'\N{LATIN SMALL LETTER GAMMA}',
                            u'\N{GREEK SMALL LETTER CHI}',
                            u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                            u'\N{LATIN SMALL LETTER H WITH STROKE}',
                            u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                            'h',
                            u'\N{LATIN SMALL LETTER H WITH HOOK}',
                            u'\N{LATIN SMALL LETTER L WITH BELT}',
                            u'\N{LATIN SMALL LETTER LEZH}',
                            u'\N{LATIN SMALL LETTER V WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED R}',
                            u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                            'j',
                            u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                            'l',
                            u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED Y}',
                            u'\N{LATIN LETTER SMALL CAPITAL L}',
                            'i', 'y',
                            u'\N{LATIN SMALL LETTER I WITH STROKE}',
                            u'\N{LATIN SMALL LETTER U BAR}',
                            u'\N{LATIN SMALL LETTER TURNED M}',
                            'u', 'e',
                            u'\N{LATIN SMALL LETTER O WITH STROKE}',
                            u'\N{LATIN SMALL LETTER REVERSED E}',
                            u'\N{LATIN SMALL LETTER BARRED O}',
                            u'\N{LATIN SMALL LETTER RAMS HORN}',
                            'o',
                            u'\N{LATIN SMALL LETTER SCHWA}',
                            u'\N{LATIN SMALL LETTER OPEN E}',
                            u'\N{LATIN SMALL LIGATURE OE}',
                            u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                            u'\N{LATIN SMALL LETTER TURNED V}',
                            u'\N{LATIN SMALL LETTER OPEN O}',
                            'a',
                            u'\N{LATIN LETTER SMALL CAPITAL OE}',
                            u'\N{LATIN SMALL LETTER ALPHA}',
                            u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                            u'\N{LATIN LETTER BILABIAL CLICK}',
                            u'\N{LATIN LETTER DENTAL CLICK}',
                            u'\N{LATIN LETTER RETROFLEX CLICK}',
                            u'\N{LATIN LETTER LATERAL CLICK}',
                            u'\N{LATIN SMALL LETTER B WITH HOOK}',
                            u'\N{LATIN SMALL LETTER D WITH HOOK}',
                            u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                            u'\N{LATIN SMALL LETTER G WITH HOOK}',
                            u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                            u'\N{LATIN SMALL LETTER TURNED W}',
                            'w',
                            u'\N{LATIN SMALL LETTER TURNED H}',
                            u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                            u'\N{LATIN SMALL LETTER DEZH DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                            u'\N{LATIN SMALL LETTER TESH DIGRAPH}')},
    'voiced': {'plus': ('b', 'd',
                        u'\N{LATIN SMALL LETTER D WITH TAIL}',
                        u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE}',
                        'g',
                        u'\N{LATIN LETTER SMALL CAPITAL G}',
                        'm',
                        u'\N{LATIN SMALL LETTER M WITH HOOK}',
                        'n',
                        u'\N{LATIN SMALL LETTER N WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER N WITH LEFT HOOK}',
                        u'\N{LATIN SMALL LETTER ENG}',
                        u'\N{LATIN LETTER SMALL CAPITAL N}',
                        u'\N{LATIN LETTER SMALL CAPITAL B}',
                        'r',
                        u'\N{LATIN LETTER SMALL CAPITAL R}',
                        u'\N{LATIN SMALL LETTER R WITH FISHHOOK}',
                        u'\N{LATIN SMALL LETTER R WITH TAIL}',
                        u'\N{GREEK SMALL LETTER BETA}',
                        'v',
                        u'\N{LATIN SMALL LETTER ETH}',
                        'z',
                        u'\N{LATIN SMALL LETTER EZH}',
                        u'\N{LATIN SMALL LETTER Z WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER J WITH CROSSED-TAIL}',
                        u'\N{LATIN SMALL LETTER GAMMA}',
                        u'\N{LATIN LETTER SMALL CAPITAL INVERTED R}',
                        u'\N{LATIN LETTER PHARYNGEAL VOICED FRICATIVE}',
                        u'\N{LATIN SMALL LETTER H WITH HOOK}',
                        u'\N{LATIN SMALL LETTER LEZH}',
                        u'\N{LATIN SMALL LETTER V WITH HOOK}',
                        u'\N{LATIN SMALL LETTER TURNED R}',
                        u'\N{LATIN SMALL LETTER TURNED R WITH HOOK}',
                        'j',
                        u'\N{LATIN SMALL LETTER TURNED M WITH LONG LEG}',
                        'l',
                        u'\N{LATIN SMALL LETTER L WITH RETROFLEX HOOK}',
                        u'\N{LATIN SMALL LETTER TURNED Y}',
                        u'\N{LATIN LETTER SMALL CAPITAL L}',
                        'i', 'y',
                        u'\N{LATIN SMALL LETTER I WITH STROKE}',
                        u'\N{LATIN SMALL LETTER U BAR}',
                        u'\N{LATIN SMALL LETTER TURNED M}',
                        'u', 'e',
                        u'\N{LATIN SMALL LETTER O WITH STROKE}',
                        u'\N{LATIN SMALL LETTER REVERSED E}',
                        u'\N{LATIN SMALL LETTER BARRED O}',
                        u'\N{LATIN SMALL LETTER RAMS HORN}',
                        'o',
                        u'\N{LATIN SMALL LETTER SCHWA}',
                        u'\N{LATIN SMALL LETTER OPEN E}',
                        u'\N{LATIN SMALL LIGATURE OE}',
                        u'\N{LATIN SMALL LETTER REVERSED OPEN E}',
                        u'\N{LATIN SMALL LETTER CLOSED REVERSED OPEN E}',
                        u'\N{LATIN SMALL LETTER TURNED V}',
                        u'\N{LATIN SMALL LETTER OPEN O}',
                        'a',
                        u'\N{LATIN LETTER SMALL CAPITAL OE}',
                        u'\N{LATIN SMALL LETTER ALPHA}',
                        u'\N{LATIN SMALL LETTER TURNED ALPHA}',
                        u'\N{LATIN SMALL LETTER B WITH HOOK}',
                        u'\N{LATIN SMALL LETTER D WITH HOOK}',
                        u'\N{LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK}',
                        u'\N{LATIN SMALL LETTER G WITH HOOK}',
                        u'\N{LATIN LETTER SMALL CAPITAL G WITH HOOK}',
                        'w',
                        u'\N{LATIN SMALL LETTER TURNED H}',
                        u'\N{LATIN SMALL LETTER TURNED R WITH LONG LEG}',
                        u'\N{COMBINING CARON BELOW}',
                        u'\N{LATIN SMALL LETTER DZ DIGRAPH}',
                        u'\N{LATIN SMALL LETTER DEZH DIGRAPH}'),
               'minus': ('p', 't',
                         u'\N{LATIN SMALL LETTER T WITH RETROFLEX HOOK}',
                         'c',
                         'k', 'q',
                         u'\N{LATIN LETTER GLOTTAL STOP}',
                         u'\N{LATIN SMALL LETTER PHI}',
                         'f',
                         u'\N{GREEK SMALL LETTER THETA}',
                         's',
                         u'\N{LATIN SMALL LETTER ESH}',
                         u'\N{LATIN SMALL LETTER S WITH HOOK}',
                         u'\N{LATIN SMALL LETTER C WITH CEDILLA}',
                         'x',
                         u'\N{GREEK SMALL LETTER CHI}',
                         u'\N{LATIN SMALL LETTER H WITH STROKE}',
                         'h',
                         u'\N{LATIN SMALL LETTER L WITH BELT}',
                         u'\N{LATIN LETTER BILABIAL CLICK}',
                         u'\N{LATIN LETTER DENTAL CLICK}',
                         u'\N{LATIN LETTER RETROFLEX CLICK}',
                         u'\N{LATIN LETTER LATERAL CLICK}',
                         u'\N{LATIN SMALL LETTER TURNED W}',
                         u'\N{COMBINING RING BELOW}',
                         u'\N{LATIN SMALL LETTER TS DIGRAPH}',
                         u'\N{LATIN SMALL LETTER TESH DIGRAPH}')}
    }

ipa_ss_map = {
    # Phrase boundary
    'pb': {'description': 'Phrase boundary',
               'plus': ('|',
                        u'\N{DOUBLE VERTICAL LINE}'),
               'minus': ('.',
                         u'\N{MODIFIER LETTER VERTICAL LINE}',
                         u'\N{MODIFIER LETTER LOW VERTICAL LINE}')
               },
    # Syllable break
    'sb': {'description': 'Syllable break',
           'plus': ('.',
                    u'\N{MODIFIER LETTER VERTICAL LINE}',
                    u'\N{MODIFIER LETTER LOW VERTICAL LINE}',
                    '|',
                    u'\N{DOUBLE VERTICAL LINE}'),
           'minus': ()
           },

    # Stress marker
    'sm': {'description': 'Stress marker',
           'plus': (u'\N{MODIFIER LETTER VERTICAL LINE}',
                     u'\N{MODIFIER LETTER LOW VERTICAL LINE}'),
           'minus': ('.',
                     '|',
                     u'\N{DOUBLE VERTICAL LINE}')
           }
    }
