# IPA Zounds, a sound change engine with support for the IPA.
# Copyright (C) 2003 Jamie Norrish
#
# This file is part of IPA Zounds.
#
# IPA Zounds is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPA Zounds is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPA Zounds; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

xsampa_map = {
    ' ': ' ',
    'a': 'a',
    'b': 'b',
    'c': 'c',
    'd': 'd',
    'e': 'e',
    'f': 'f',
    'g': 'g',
    'h': 'h',
    'i': 'i',
    'j': 'j',
    'k': 'k',
    'l': 'l',
    'm': 'm',
    'n': 'n',
    'o': 'o',
    'p': 'p',
    'q': 'q',
    'r': 'r',
    's': 's',
    't': 't',
    'u': 'u',
    'v': 'v',
    'w': 'w',
    'x': 'x',
    'y': 'y',
    'z': 'z',
    't`': u'\u0288',
    'd`': u'\u0256',
    'F': u'\u0271',
    'n`': u'\u0273',
    'J': u'\u0272',
    'N': u'\u014B',
    'N\\': u'\u0274',
    'B\\': u'\u0299',
    'R\\': u'\u0280',
    '4': u'\u027E',
    'r`': u'\u027D',
    'p\\': u'\u0278',
    'B': u'\u03B2',
    'T': u'\u03B8',
    'D': u'\u00F0',
    'S': u'\u0283',
    'Z': u'\u0292',
    's`': u'\u0282',
    'z`': u'\u0290',
    'C': u'\u00E7',
    'j\\': u'\u029D',
    'G': u'\u0263',
    'X': u'\u03C7',
    'R': u'\u0281',
    'X\\': u'\u0127',
    '?\\': u'\u0295',
    'h\\': u'\u0266',
    'K': u'\u026C',
    'K\\': u'\u026E',
    'P': u'\u028B',
    'v\\': u'\u028B',
    'r\\': u'\u0279',
    'r\\`': u'\u027B',
    'M\\': u'\u0270',
    'l`': u'\u026D',
    'L': u'\u028E',
    'L\\': u'\u029F',
    'O\\': u'\u0298',
    '|\\': u'\u01C0',
    '!\\': u'\u01C3',
    '=\\': u'\u01C2',
    '|\\|\\': u'\u01C1',
    '_>': u'\u2019',
    'b_<': u'\u0253',
    'M': u'\u026F',
    '1': u'\u0268',
    '}': u'\u0289',
    'I': u'\u026A',
    'Y': u'\u028F',
    'U': u'\u028A',
    '2': u'\u00F8',
    '@\\': u'\u0258',
    '8': u'\u0275',
    '7': u'\u0264',
    '@': u'\u0259',
    'E': u'\u025B',
    '9': u'\u0276',
    '3': u'\u025C',
    '3\\': u'\u025E',
    'V': u'\u028C',
    'O': u'\u0254',
    '{': u'\u00E6',
    '6': u'\u0250',
    '&': u'\u0276',
    'A': u'\u0251',
    'Q': u'\u0252',
    'W': u'\u028D',
    'H': u'\u0265',
    'H\\': u'\u029C',
    '<\\': u'\u02A2',
    '>\\': u'\u02A1',
    's\\': u'\u0255',
    'z\\': u'\u0291',
    'l\\': u'\u027A',
    'x\\': u'\u0267',
    '_': u'\u0361',
    '"': u'\u02C8',
    '%': u'\u02CC',
    ':': u'\u02D0',
    ':\\': u'\u02D1',
    '_X': u'\u0306',
    '.': u'.',
    '-\\': u'\u203F',
    '_T': u'\u030B',
    '_H': u'\u0301',
    '_M': u'\u0304',
    '_L': u'\u0300',
    '_B': u'\u030F',
    '!': u'\u2193',
    '^': u'\u2191',
    '_R': u'\u02E9\u02E5',
    '_F': u'\u02E5\u02E9',
    '_H_T': u'\u02E6\u02E5',
    '_B_L': u'\u02E9\u02E8',
    '_R_F': u'\u02E6\u02E5\u02E6',
    '<R>': u'\u2197',
    '<F>': u'\u2198',
    '_0': u'\u0325',
    '_v': u'\u032C',
    '_h': u'\u02B0',
    '_O': u'\u0339',
    '_c': u'\u031C',
    '_+': u'\u031F',
    '_-': u'\u0320',
    '_"': u'\u0308',
    '=': u'\u0329',
    '_=': u'\u0329',
    '_^': u'\u032F',
    '`': u'\u02DE',
    '_t': u'\u0324',
    '_k': u'\u0330',
    '_N': u'\u033C',
    '_w': u'\u02B7',
    '\'': u'\u02B2',
    '_j': u'\u02B2',
    '_G': u'\u02E0',
    '_?\\': u'\u02E4',
    '_d': u'\u032A',
    '_a': u'\u033A',
    '_m': u'\u033B',
    '~': u'\u0303',
    '_~': u'\u0303',
    '_n': u'\u207F',
    '_l': u'\u02E1',
    '_}': u'\u031A',
    '_e': u'\u0334',
    #'5': u'\u0',
    '_r': u'\u031D',
    '_o': u'\u031E',
    '_A': u'\u0318',
    '_q': u'\u0319',
    # Rule characters
    ';': '_',
    '#': '#',
    '(': '(',
    ')': ')',
    '*': '*',
}

ipa_map = {
    ' ': ' ',
    'a': 'a',
    'b': 'b',
    'c': 'c',
    'd': 'd',
    'e': 'e',
    'f': 'f',
    'g': 'g',
    'h': 'h',
    'i': 'i',
    'j': 'j',
    'k': 'k',
    'l': 'l',
    'm': 'm',
    'n': 'n',
    'o': 'o',
    'p': 'p',
    'q': 'q',
    'r': 'r',
    's': 's',
    't': 't',
    'u': 'u',
    'v': 'v',
    'w': 'w',
    'x': 'x',
    'y': 'y',
    'z': 'z',
    u'\u0288': 't`',
    u'\u0256': 'd`',
    u'\u0271': 'F',
    u'\u0273': 'n`',
    u'\u0272': 'J',
    u'\u014B': 'N',
    u'\u0274': 'N\\',
    u'\u0299': 'B\\',
    u'\u0280': 'R\\',
    u'\u027E': '4',
    u'\u027D': 'r`',
    u'\u0278': 'p\\',
    u'\u03B2': 'B',
    u'\u03B8': 'T',
    u'\u00F0': 'D',
    u'\u0283': 'S',
    u'\u0292': 'Z',
    u'\u0282': 's`',
    u'\u0290': 'z`',
    u'\u00E7': 'C',
    u'\u029D': 'j\\',
    u'\u0263': 'G',
    u'\u03C7': 'X',
    u'\u0281': 'R',
    u'\u0127': 'X\\',
    u'\u0295': '?\\',
    u'\u0266': 'h\\',
    u'\u026C': 'K',
    u'\u026E': 'K\\',
    u'\u028B': 'P',
    #u'\u028B': 'v\\', Duplicate XSAMPA code for IPA char
    u'\u0279': 'r\\',
    u'\u027B': 'r\\`',
    u'\u0270': 'M\\',
    u'\u026D': 'l`',
    u'\u028E': 'L',
    u'\u029F': 'L\\',
    u'\u0298': 'O\\',
    u'\u01C0': '|\\',
    u'\u01C3': '!\\',
    u'\u01C2': '=\\',
    u'\u01C1': '|\\|\\',
    u'\u2019': '_>',
    u'\u0253': 'b_<',
    u'\u026F': 'M',
    u'\u0268': '1',
    u'\u0289': '}',
    u'\u026A': 'I',
    u'\u028F': 'Y',
    u'\u028A': 'U',
    u'\u00F8': '2',
    u'\u0258': '@\\',
    u'\u0275': '8',
    u'\u0264': '7',
    u'\u0259': '@',
    u'\u025B': 'E',
    u'\u0276': '9',
    u'\u025C': '3',
    u'\u025E': '3\\',
    u'\u028C': 'V',
    u'\u0254': 'O',
    u'\u00E6': '{',
    u'\u0250': '6',
    #u'\u0276': '&', Duplicate XSAMPA code for IPA char
    u'\u0251': 'A',
    u'\u0252': 'Q',
    u'\u028D': 'W',
    u'\u0265': 'H',
    u'\u029C': 'H\\',
    u'\u02A2': '<\\',
    u'\u02A1': '>\\',
    u'\u0255': 's\\',
    u'\u0291': 'z\\',
    u'\u027A': 'l\\',
    u'\u0267': 'x\\',
    u'\u0361': '_',
    u'\u02C8': '"',
    u'\u02CC': '%',
    u'\u02D0': ':',
    u'\u02D1': ':\\',
    u'\u0306': '_X',
    u'.': '.',
    u'\u203F': '-\\',
    u'\u030B': '_T',
    u'\u0301': '_H',
    u'\u0304': '_M',
    u'\u0300': '_L',
    u'\u030F': '_B',
    u'\u2193': '!',
    u'\u2191': '^',
    u'\u02E9\u02E5': '_R',
    u'\u02E5\u02E9': '_F',
    u'\u02E6\u02E5': '_H_T',
    u'\u02E9\u02E8': '_B_L',
    u'\u02E6\u02E5\u02E6': '_R_F',
    u'\u2197': '<R>',
    u'\u2198': '<F>',
    u'\u0325': '_0',
    u'\u032C': '_v',
    u'\u02B0': '_h',
    u'\u0339': '_O',
    u'\u031C': '_c',
    u'\u031F': '_+',
    u'\u0320': '_-',
    u'\u0308': '_"',
    u'\u0329': '=',
    #u'\u0329': '_=', Duplicate XSAMPA code for IPA char
    u'\u032F': '_^',
    u'\u02DE': '`',
    u'\u0324': '_t',
    u'\u0330': '_k',
    u'\u033C': '_N',
    u'\u02B7': '_w',
    u'\u02B2': '\'',
    #u'\u02B2': '_j', Duplicate XSAMPA code for IPA char
    u'\u02E0': '_G',
    u'\u02E4': '_?\\',
    u'\u032A': '_d',
    u'\u033A': '_a',
    u'\u033B': '_m',
    u'\u0303': '~',
    #u'\u0303': '_~', Duplicate XSAMPA code for IPA char
    u'\u207F': '_n',
    u'\u02E1': '_l',
    u'\u031A': '_}',
    u'\u0334': '_e',
    #u'\u0': '5',
    u'\u031D': '_r',
    u'\u031E': '_o',
    u'\u0318': '_A',
    u'\u0319': '_q',
    # Rule characters
    '_': ';',
    '#': '#',
    '(': '(',
    ')': ')',
    '*': '*',
}

open_brackets = {'ssf': '<', 'bf': '['}
close_brackets = {'ssf': '>', 'bf': ']'}
rule_divider = '/'
