from distutils.core import setup
import iptdump as iptd

setup(
	name = 'iptdump',
	version = iptd.__version__,
	license = 'AGPLv3',
	description ='describes firewall rules and dump it out',
	long_description = '''
About
=====

This package allows you to describes firewall rules and dump it out, there is support for
iptables and ip6tables.

Example Usage
=============

::

    >>> import iptdump
    >>> ipt = iptdump.Iptables()
    >>> chain = ipt.table(iptdump.TABLE_FILTER).chain(iptdump.CHAIN_INPUT)
    >>> chain.new().src('192.168.23.0/24').target(iptdump.TARGET_DROP)
    <iptdump.Rule instance at 0x7f922dfb8cb0>
    >>> print ipt.dump()
    # Generated by python-iptdump v1b1 on Mon Dec  3 18:25:27 2012
    *filter
    :INPUT ACCEPT [0:0]
    -A INPUT -s 192.168.23.0/24 -j DROP
    COMMIT
    # Completed on Mon Dec  3 18:25:27 2012
    >>> ipt = iptdump.Ip6tables()
    >>> chain = ipt.table(iptdump.TABLE_FILTER).chain(iptdump.CHAIN_INPUT)
    >>> chain.new().src('fe80::/64').target(iptdump.TARGET_DROP)
    <iptdump.Rule instance at 0x7f7ed18a1b48>
    >>> print ipt.dump()
    # Generated by python-iptdump v1b1 on Mon Dec  3 18:25:32 2012
    *filter
    :INPUT ACCEPT [0:0]
    -A INPUT -s fe80::/64 -j DROP
    COMMIT
    # Completed on Mon Dec  3 18:25:32 2012

''',
	platforms = 'OS Independent',
	classifiers = (
		'Development Status :: 4 - Beta',
		'Environment :: Console',
		'Intended Audience :: Developers',
		'Intended Audience :: Information Technology',
		'Intended Audience :: System Administrators',
		'Intended Audience :: Telecommunications Industry',
		'License :: OSI Approved :: GNU Affero General Public License v3',
		'Natural Language :: English',
		'Operating System :: OS Independent',
		'Programming Language :: Python',
		'Topic :: Communications',
		'Topic :: Internet',
		'Topic :: Software Development',
		'Topic :: Software Development :: Libraries',
		'Topic :: Software Development :: Libraries :: Python Modules',
		'Topic :: System :: Networking',
		'Topic :: System :: Networking :: Firewalls',
		'Topic :: Utilities',
	),
	author = 'Martin Ness',
	author_email = 'm.ness@martin89.de',
	url = 'https://gitorious.org/iptdump',
	packages = ('iptdump', 'iptdump.extension'),
)
