c = get_config()
app = c.InteractiveShellApp

# This can be used at any point in a config file to load a sub config
# and merge it into the current one.
load_subconfig('ipython_config.py', profile='default')

lines = """
from __future__ import division
from sympy import *
x, y, z, t = symbols('x y z t')
k, m, n = symbols('k m n', integer=True)
f, g, h = symbols('f g h', cls=Function)
"""

app.exec_lines.append(lines)

# Load the sympy_printing extension to enable nice printing of sympy expr's.
app.extensions.append('sympy.interactive.ipythonprinting')

