#!/usr/bin/python
import sys
import os
import cv2.cv as cv
from optparse import OptionParser
from Xlib.display import Display
from Xlib.ext import xtest
from Xlib import X

min_size = (20, 20)
image_scale = 2
haar_scale = 1.2
min_neighbors = 2
haar_flags = 0

display = Display()
root = display.screen().root
anchopantalla = root.get_geometry().width
altopantalla = root.get_geometry().height 
timer = 10
cont = 0
conta = 0

def detect_and_draw(img, cascade):
    global cont
    global conta
    # allocate temporary images
    gray = cv.CreateImage((img.width,img.height), 8, 1)
    small_img = cv.CreateImage((cv.Round(img.width / image_scale),
			       cv.Round (img.height / image_scale)), 8, 1)

    # convert color input image to grayscale
    cv.CvtColor(img, gray, cv.CV_BGR2GRAY)

    # scale input image for faster processing
    cv.Resize(gray, small_img, cv.CV_INTER_LINEAR)

    cv.EqualizeHist(small_img, small_img)

    if(cascade):
        t = cv.GetTickCount()
        faces = cv.HaarDetectObjects(small_img, cascade, cv.CreateMemStorage(0),
                                     haar_scale, min_neighbors, haar_flags, min_size)
        t = cv.GetTickCount() - t
        #print "detection time = %gms" % (t/(cv.GetTickFrequency()*1000.))
        if faces:
            #print 'Hay Sujeto'
	    conta = conta + 1
	    if conta == 20:
                print "Hay sujeto"
                #os.system('totem --play-pause')
                dete = comprobar()
                os.system('gnome-screensaver-command -d') #Desbloquear la computadora
                if dete == 0:
                    os.system('totem --play') #Para reproducir el video
                cont = 0
	         
            for ((x, y, w, h), n) in faces:
                pt1 = (int(x * image_scale), int(y * image_scale))
                pt2 = (int((x + w) * image_scale), int((y + h) * image_scale))
                cv.Rectangle(img, pt1, pt2, cv.RGB(255, 0, 0), 3, 8, 0)
		centro = (pt1[0]+pt2[0],pt1[1]+pt2[1])
		a,b = pt1[0],pt1[1]
		#print str(a) +' | '+str(b)
		c,d = pt2[0],pt2[1]
		#print str(c) +' * '+str(d)
		e = c - a
		f = d - b
		mediax = e/2.0
		mediay = f/2.0
		pcx = a + (e/2)
		pcy = b + (f/2)
		pc = (pcx,pcy)
		cv.Rectangle(img,pc,(pc[0]+5,pc[1]+5),cv.RGB(0,255,0),3,8,0)
		anchoapp = img.width - (2*mediax)
		altoapp = img.height - (2*mediay)
		proporcionX = anchopantalla / anchoapp
    		proporcionY = altopantalla / altoapp
		root.warp_pointer(pcx * proporcionX, pcy * proporcionY)
    		display.sync()

	else:
		#print "no hay sujeto"
		cont = cont + 1
		if cont == 20:
                    print "no hay sujeto"
                    dete = comprobar()
                    if dete == 0:
                        os.system('totem --pause') #Para pausar el video
                    os.system('gnome-screensaver-command -l') #Bloquear la computadora
                    conta = 0

    cv.ShowImage("result", img)

def comprobar(): #Si detecta que el totem se encuentra ejecutando regresa 0, si no regresa otra cosa
    compro = os.system('ps -A| grep totem && echo $?')
    compro = int(str(compro)[:3])
    return compro

if __name__ == '__main__':

    parser = OptionParser(usage = "usage: %prog [options] [filename|camera_index]")
    parser.add_option("-c", "--cascade", action="store", dest="cascade", type="str", help="Haar cascade file, default %default", default = "haarcascade_frontalface_alt.xml")
    (options, args) = parser.parse_args()

    cascade = cv.Load(options.cascade)
    
    if len(args) != 1:
        parser.print_help()
        sys.exit(1)

    input_name = args[0]
    if input_name.isdigit():
        capture = cv.CreateCameraCapture(int(input_name))
    else:
        capture = None

    cv.NamedWindow("result", 1)

    if capture:
        frame_copy = None
        while True:
            frame = cv.QueryFrame(capture)
            if not frame:
                cv.WaitKey(0)
                break
            if not frame_copy:
                frame_copy = cv.CreateImage((frame.width,frame.height),
                                            cv.IPL_DEPTH_8U, frame.nChannels)
            if frame.origin == cv.IPL_ORIGIN_TL:
                cv.Copy(frame, frame_copy)
            else:
                cv.Flip(frame, frame_copy, 0)
            
            detect_and_draw(frame_copy, cascade)
            if cv.WaitKey(10) >= 0:
                break
    else:
        image = cv.LoadImage(input_name, 1)
        detect_and_draw(image, cascade)
        cv.WaitKey(0)

    cv.DestroyWindow("result")
