#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
from isbnlib import quiet_errors
from isbnlib.dev.webservice import query


URL = 'http://dx.doi.org/{DOI}'
UA = 'doi2tex (gzip)'


def usage():
    print('Usage: isbn_doi2tex DOI')


def main():
    sys.excepthook = quiet_errors
    try:
        print(query(URL.format(DOI=sys.argv[1]), UA, None, 
                    {'Accept': 'application/x-bibtex; charset=utf-8'}))
    except:
        usage()
