#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
from isbnlib import quiet_errors
from isbnlib.dev.webservice import query
from isbnlib.config import setsocketstimeout


URL = 'http://dx.doi.org/{DOI}'
UA = 'doi2tex (gzip)'
TO = 25

doi = sys.argv[1]

def usage():
    print('Usage: isbn_doi2tex DOI')

def wdata(doi):
    return query(URL.format(DOI=doi), UA, None, 
                 {'Accept': 'application/x-bibtex; charset=utf-8'})

def main():
    sys.excepthook = quiet_errors
    setsocketstimeout(TO)
    try:
        print(wdata(doi))
    except:
        usage()
