/*
 * Decompiled with CFR 0.152.
 */
package bruma.examples;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.master.Subfield;

public class DumpDbII {
    private static void usage() {
        System.err.println("usage: DumpDbII <dbname> [<encoding>]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 1) {
            DumpDbII.usage();
        }
        String encoding = args.length > 1 ? args[1] : "ISO-8859-1";
        Master mst = MasterFactory.getInstance(args[0]).setEncoding(encoding).open();
        for (Record rec : mst) {
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            System.out.println("mfn=" + rec.getMfn());
            for (Field field : rec) {
                System.out.println("tag=" + field.getId());
                for (Subfield subfield : field) {
                    System.out.println("sub id=" + subfield.getId());
                    System.out.println("sub content=" + subfield.getContent());
                }
            }
            System.out.println();
        }
        mst.close();
    }
}

