/*
 * Decompiled with CFR 0.152.
 */
package bruma.examples;

import bruma.BrumaException;
import bruma.master.Leader;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;

public class DumpDbIII {
    private static void usage() {
        System.err.println("usage: DumpDbIII <dbFrom> [--from=<mfn>] [--to=<mfn>] [--encoding=<charSet>][--showLeader]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 1) {
            DumpDbIII.usage();
        }
        int from = 1;
        int to = -1;
        String encoding = "ISO-8859-1 or IBM850";
        boolean showLeader = false;
        for (int idx = 1; idx < args.length; ++idx) {
            if (args[idx].startsWith("--from=")) {
                from = Integer.parseInt(args[idx].substring(7));
                continue;
            }
            if (args[idx].startsWith("--to=")) {
                to = Integer.parseInt(args[idx].substring(5));
                continue;
            }
            if (args[idx].startsWith("--encoding=")) {
                encoding = args[idx].substring(11);
                continue;
            }
            if (args[idx].equals("--showLeader")) {
                showLeader = true;
                continue;
            }
            DumpDbIII.usage();
        }
        Master mst = MasterFactory.getInstance(args[0]).setEncoding(encoding).open();
        if (to == -1) {
            to = mst.getControlRecord().getNxtmfn() - 1;
        }
        if (to < from) {
            throw new IllegalArgumentException("to[" + to + "] < from[" + from + "]");
        }
        for (int mfn = from; mfn <= to; ++mfn) {
            Record rec = mst.getRecord(mfn);
            Record.Status status = rec.getStatus();
            System.out.println("--------------------------- " + mfn + (status != Record.Status.ACTIVE ? " <deleted> " : " ---------") + "-------------------------\n");
            if (status != Record.Status.ACTIVE && status != Record.Status.LOGDEL) continue;
            if (showLeader) {
                Leader leader = rec.getLeader(mst.getEncoding(), mst.isFFI());
                System.out.println("mfn=" + mfn + " status=" + (Object)((Object)leader.getStatus()) + " len=" + leader.getMfrl());
            }
            System.out.println(rec);
        }
        mst.close();
    }
}

