/*
 * Decompiled with CFR 0.152.
 */
package bruma.examples;

import bruma.BrumaException;
import bruma.iterator.AbstractRecordIterator;
import bruma.iterator.ISO2709RecordIterator;
import bruma.iterator.IdFileRecordIterator;
import bruma.iterator.IsisRecordIterator;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.io.File;

public class ImportMaster {
    private static void usage() {
        System.err.println("usage: ImportMaster {isis|iso|id}=<filename> <encoding> <toDbname>");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length != 3) {
            ImportMaster.usage();
        }
        AbstractRecordIterator iterator = null;
        if (args[0].startsWith("isis=")) {
            iterator = new IsisRecordIterator(args[0].substring(5), args[1]);
        } else if (args[0].startsWith("iso=")) {
            iterator = new ISO2709RecordIterator(args[0].substring(4), args[1]);
        } else if (args[0].startsWith("id=")) {
            iterator = new IdFileRecordIterator(new File(args[0].substring(3)), args[1]);
        } else {
            ImportMaster.usage();
        }
        Master to = MasterFactory.getInstance(args[2]).setEncoding(args[1]).create();
        for (Record rec : iterator) {
            to.writeRecord(rec);
        }
        iterator.close();
    }
}

