/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.master.Control;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.utils.Util;
import bruma.utils.ZeFDT;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public abstract class AbstractMasterExport {
    protected final Master mst;
    protected final String outEncoding;
    protected final Map<Integer, String> tags;
    private final String outFile;

    public AbstractMasterExport(Master mst, String outFile, String outputEncoding, boolean useFdt) throws BrumaException {
        if (mst == null) {
            throw new BrumaException("null Master object");
        }
        if (outFile == null) {
            throw new NullPointerException("output file");
        }
        String inputEncoding = mst.getEncoding();
        String fileName = Util.changeFileExtension(mst.getMasterName(), "fdt");
        boolean hasFdt = new File(fileName).isFile();
        this.mst = mst;
        this.outFile = outFile;
        Map<Integer, String> map = this.tags = useFdt && hasFdt ? new ZeFDT().fromFile(mst.getMasterName()).getFieldDescriptionMap() : null;
        this.outEncoding = outputEncoding == null ? (inputEncoding == null ? "ISO-8859-1" : inputEncoding) : outputEncoding;
    }

    public void export(int tell) throws BrumaException {
        this.export(1, Integer.MAX_VALUE, tell);
    }

    public void export(int from, int to, int tell) throws BrumaException {
        int xfrom = from <= 0 ? 1 : from;
        int xtell = tell <= 0 ? Integer.MAX_VALUE : tell;
        Writer writer = null;
        Master master = null;
        int cur = 0;
        try {
            master = MasterFactory.getInstance(this.mst.getMasterName()).setDataAlignment(this.mst.getDataAlignment()).setEncoding(this.mst.getEncoding()).setFFI(this.mst.isFFI()).setMaxGigaSize(this.mst.getGigaSize()).setSwapped(this.mst.isSwapped()).open();
            Control ctl = master.getControlRecord();
            int xto = Math.min(to, ctl.getNxtmfn() - 1);
            if (xto < xfrom) {
                throw new BrumaException("xto < xfrom");
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), this.outEncoding));
            writer.write(this.prologue());
            for (int mfn = xfrom; mfn <= xto; ++mfn) {
                String buff;
                Record rec;
                if (++cur % xtell == 0) {
                    System.out.println("++" + cur);
                }
                if ((rec = master.getRecord(mfn)) == null || rec.getStatus() != Record.Status.ACTIVE || (buff = this.getRecord(rec)) == null || buff.isEmpty()) continue;
                writer.write(buff);
            }
            writer.write(this.epilogue());
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        finally {
            if (master != null) {
                master.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected String prologue() {
        return "";
    }

    protected String epilogue() {
        return "";
    }

    protected abstract String getRecord(Record var1) throws BrumaException;
}

