/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.impexp.AbstractMasterExport;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.Record;

public class DelimMasterExport
extends AbstractMasterExport {
    private final StringBuilder builder;
    private final String tagDelim;
    private final String fieldDelim;
    private final String recDelim;

    public DelimMasterExport(Master mst, String outFile, String outEncoding, String tagDelim, String fieldDelim, String recDelim, boolean useFdt) throws BrumaException {
        super(mst, outFile, outEncoding, useFdt);
        if (fieldDelim == null) {
            throw new NullPointerException("field delimiter");
        }
        if (recDelim == null) {
            throw new NullPointerException("record delimiter");
        }
        this.builder = new StringBuilder();
        this.tagDelim = tagDelim;
        this.fieldDelim = fieldDelim;
        this.recDelim = recDelim;
    }

    protected String getRecord(Record rec) throws BrumaException {
        assert (rec != null);
        this.builder.setLength(0);
        for (Field fld : rec) {
            if (this.tagDelim != null) {
                if (this.tags == null) {
                    this.builder.append(fld.getId());
                } else {
                    this.builder.append((String)this.tags.get(fld.getId()));
                }
                this.builder.append(this.tagDelim);
            }
            this.builder.append(fld.getContent());
            this.builder.append(this.fieldDelim);
        }
        this.builder.append(this.recDelim);
        return this.builder.toString();
    }
}

