/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.impexp.MyWriter;
import bruma.master.DirEntry;
import bruma.master.Field;
import bruma.master.Record;

public class ISO2709E {
    private static final int ISO_LEADER_LENGHT = 24;
    private static final int ISO_TAG_LENGHT = 3;
    private static final int ISO_FLDLEN_LENGHT = 4;
    private static final int ISO_FLDLOC_LENGHT = 5;
    private static final int ISO_DIRECTORY_LENGHT = 12;
    private static final char ISO_FLDSEP = '#';
    private static final int ISO_FLDSEP_LENGHT = 1;
    private static final char ISO_RECSEP = '#';
    private static final int ISO_RECSEP_LENGHT = 1;
    private static final int ISO_LINE_LENGHT = 80;

    public static String exportRecord(Record rec) throws BrumaException {
        DirEntry dirE;
        int idx;
        if (rec == null) {
            throw new BrumaException("exportRecord/null document");
        }
        MyWriter writer = new MyWriter(80);
        int nvf = rec.getNvf();
        int total_dir = nvf * 12;
        int total_data = 0;
        int total_record = 0;
        int base_address = 24 + total_dir + 1;
        int tag = 0;
        int pos = 0;
        int len = 0;
        String aux = null;
        for (idx = 0; idx < nvf; ++idx) {
            dirE = rec.getDirectoryEntry(idx);
            total_data += dirE.getLen() + 1;
        }
        total_record = base_address + total_data + 1;
        aux = String.format("%1$05d0000002%2$05d000%3$01d%4$01d00", total_record, base_address, 4, 5);
        writer.write(aux);
        for (idx = 0; idx < nvf; ++idx) {
            dirE = rec.getDirectoryEntry(idx);
            tag = dirE.getTag();
            if (tag == 1000) {
                tag = 1;
            }
            if (tag > 999) {
                tag %= 1000;
            }
            len = dirE.getLen() + 1;
            aux = String.format("%1$03d%2$04d%3$05d", tag, len, pos);
            pos += len;
            writer.write(aux);
        }
        writer.write('#');
        for (Field field : rec) {
            writer.write(field.getContent());
            writer.write('#');
        }
        writer.write('#');
        writer.newLine();
        return writer.toString();
    }
}

