/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.impexp.MyReader;
import bruma.master.Record;
import java.io.IOException;

public class ISO2709I {
    private static final int LEADER_LENGTH = 24;
    private final MyReader mr;
    private int nvf;
    private int dirEntrySize;
    private boolean eof;
    private int recordLength;
    private int recordStatus;
    private int implementationCodes;
    private int indicatorLength;
    private int subfieldIndicatorLength;
    private int baseAddressData;
    private int forUserSystems;
    private int lengthLengthEntryField;
    private int lengthStartingCharacterPosition;
    private int forFutureUse;
    private char[] dir;
    private char[] fields;

    public ISO2709I(String isoFileName) throws BrumaException {
        this(isoFileName, null);
    }

    public ISO2709I(String isoFileName, String encoding) throws BrumaException {
        if (isoFileName == null) {
            throw new BrumaException("null iso file name");
        }
        try {
            this.mr = new MyReader(isoFileName, encoding);
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        this.dir = null;
        this.fields = null;
        this.nvf = 0;
        this.dirEntrySize = 0;
        this.eof = false;
    }

    public void close() throws BrumaException {
        if (this.mr != null) {
            try {
                this.mr.close();
            }
            catch (IOException ioe) {
                throw new BrumaException(ioe);
            }
        }
    }

    private int parseInt(char[] buffer, int offset, int length) throws BrumaException {
        assert (buffer != null);
        assert (offset >= 0);
        assert (length > 0);
        int ret = 0;
        for (int index = 0; index < length; ++index) {
            char c = buffer[offset + index];
            if (c < '0' || c > '9') {
                throw new BrumaException("parseInt/ (c < '0') || (c > '9')");
            }
            ret *= 10;
            ret += c - 48;
        }
        return ret;
    }

    private void readLeader() throws BrumaException {
        try {
            char[] leader = new char[24];
            int len = this.mr.read(leader, 0, 24);
            if (len == 0) {
                this.eof = true;
            } else {
                if (len != 24) {
                    throw new BrumaException("readLeader/read");
                }
                this.recordLength = this.parseInt(leader, 0, 5);
                this.recordStatus = this.parseInt(leader, 5, 1);
                this.implementationCodes = this.parseInt(leader, 6, 4);
                this.indicatorLength = this.parseInt(leader, 10, 1);
                this.subfieldIndicatorLength = this.parseInt(leader, 11, 1);
                this.baseAddressData = this.parseInt(leader, 12, 5);
                this.forUserSystems = this.parseInt(leader, 17, 3);
                this.lengthLengthEntryField = this.parseInt(leader, 20, 1);
                this.lengthStartingCharacterPosition = this.parseInt(leader, 21, 1);
                this.forFutureUse = this.parseInt(leader, 22, 2);
                this.eof = false;
            }
        }
        catch (IOException ex) {
            throw new BrumaException(ex);
        }
    }

    private void readDirectory() throws BrumaException {
        try {
            int dirLength = this.baseAddressData - 24 - 1;
            if (this.dir == null || this.dir.length < dirLength) {
                this.dir = new char[dirLength];
            }
            if (this.mr.read(this.dir, 0, dirLength) != dirLength) {
                throw new BrumaException("readDirectory/dirLength");
            }
            this.dirEntrySize = 3 + this.lengthLengthEntryField + this.lengthStartingCharacterPosition;
            this.nvf = dirLength / this.dirEntrySize;
        }
        catch (IOException ex) {
            throw new BrumaException(ex);
        }
    }

    private void readFields() throws BrumaException {
        try {
            int fieldsLength = this.recordLength - this.baseAddressData + 1;
            int read = 0;
            if (this.fields == null || this.fields.length < fieldsLength) {
                this.fields = new char[fieldsLength];
            }
            if ((read = this.mr.read(this.fields, 0, fieldsLength)) != fieldsLength) {
                throw new BrumaException("readFields/fieldsLength [" + read + " < " + fieldsLength + "]");
            }
            this.mr.readBreak();
        }
        catch (IOException ex) {
            throw new BrumaException(ex);
        }
    }

    public Record readRecord() throws BrumaException {
        Record record = null;
        this.readLeader();
        if (!this.eof) {
            this.readDirectory();
            this.readFields();
            record = new Record();
            for (int index = 0; index < this.nvf; ++index) {
                int dpos = index * this.dirEntrySize;
                int tag = this.parseInt(this.dir, dpos, 3);
                if (tag <= 0 || tag > 9999) {
                    throw new BrumaException("readRecord/tag[" + tag + "]");
                }
                int len = this.parseInt(this.dir, dpos += 3, this.lengthLengthEntryField);
                if (len < 0) {
                    throw new BrumaException("readRecord/len < 0");
                }
                int pos = this.parseInt(this.dir, dpos += this.lengthLengthEntryField, this.lengthStartingCharacterPosition);
                if (pos < 0) {
                    throw new BrumaException("readRecord/pos < 0");
                }
                String content = new String(this.fields, pos + 1, len - 1);
                record.addField(tag, content);
            }
        }
        return record;
    }
}

