/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.impexp.AbstractMasterExport;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.Record;

public class IdMasterExport
extends AbstractMasterExport {
    private static final String ZEROS = "000000";
    private final StringBuilder builder = new StringBuilder();

    public IdMasterExport(Master mst, String outFile, String outEncoding) throws BrumaException {
        super(mst, outFile, outEncoding, false);
    }

    protected String getRecord(Record rec) throws BrumaException {
        assert (rec != null);
        this.builder.setLength(0);
        this.builder.append("!ID ");
        this.builder.append(this.prefix(rec.getMfn(), 7));
        for (Field fld : rec) {
            this.builder.append("\n");
            this.builder.append("!v");
            this.builder.append(this.prefix(fld.getId(), 3));
            this.builder.append("!");
            this.builder.append(fld.getContent());
        }
        this.builder.append("\n");
        return this.builder.toString();
    }

    private String prefix(int val, int finalSize) {
        assert (finalSize > 0);
        String sval = Integer.toString(val);
        int difLen = finalSize - sval.length();
        return difLen > 0 ? ZEROS.substring(0, difLen) + sval : sval;
    }
}

