/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import bruma.BrumaException;
import bruma.impexp.AbstractMasterExport;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;

public class IsisMasterExport
extends AbstractMasterExport {
    private final String toMstName;
    private final boolean isToFFI;
    private final int toDataAlignment;
    private final String toEncoding;
    private final int toMaxGigaSize;
    private final boolean isToSwapped;
    private final boolean exportDeleted;

    public IsisMasterExport(Master mst, String toMstName, boolean isToFFI, int toDataAlignment, int toMaxGigaSize) throws BrumaException {
        this(mst, toMstName, isToFFI, -1, null, toMaxGigaSize, true, true);
    }

    public IsisMasterExport(Master mst, String toMstName, boolean isToFFI, int toDataAlignment, String toEncoding, int toMaxGigaSize, boolean isToSwapped, boolean exportDeleted) throws BrumaException {
        super(mst, "", null, false);
        if (toMstName == null) {
            throw new BrumaException("null toMstName parameter");
        }
        this.toMstName = toMstName;
        this.isToFFI = isToFFI;
        this.toDataAlignment = toDataAlignment >= 0 ? toDataAlignment : mst.getDataAlignment();
        this.toEncoding = toEncoding == null ? mst.getEncoding() : toEncoding;
        this.toMaxGigaSize = toMaxGigaSize >= 0 ? toMaxGigaSize : mst.getGigaSize();
        this.isToSwapped = isToSwapped;
        this.exportDeleted = exportDeleted;
    }

    public void export(int tell) throws BrumaException {
        int xtell = tell <= 0 ? Integer.MAX_VALUE : tell;
        Master fromMst = MasterFactory.getInstance(this.mst.getMasterName()).setDataAlignment(this.mst.getDataAlignment()).setEncoding(this.mst.getEncoding()).setFFI(this.mst.isFFI()).setMaxGigaSize(this.mst.getGigaSize()).setSwapped(this.mst.isSwapped()).open();
        Master toMst = MasterFactory.getInstance(this.toMstName).setFFI(this.isToFFI).setDataAlignment(this.toDataAlignment).setEncoding(this.toEncoding).setMaxGigaSize(this.toMaxGigaSize).setSwapped(this.isToSwapped).create();
        int mfn = 0;
        int cur = 0;
        for (Record rec : fromMst) {
            if (++cur % xtell == 0) {
                System.out.println("++" + cur);
            }
            if (this.exportDeleted) {
                toMst.writeRecord(rec);
                continue;
            }
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            rec.setMfn(++mfn);
            toMst.writeRecord(rec);
        }
        fromMst.close();
        toMst.close();
    }

    protected String getRecord(Record rec) throws BrumaException {
        return null;
    }
}

