/*
 * Decompiled with CFR 0.152.
 */
package bruma.impexp;

import java.io.StringWriter;

class MyWriter
extends StringWriter {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private int lineSize;
    private int curPos;

    MyWriter(int lineSize) {
        this.lineSize = lineSize;
        this.curPos = 1;
    }

    MyWriter(int lineSize, int initialSize) {
        super(initialSize);
        this.lineSize = lineSize + 1;
        this.curPos = 1;
    }

    public void write(char c) {
        if (this.curPos == this.lineSize + 1) {
            super.write(SEPARATOR);
            this.curPos = 1;
        }
        super.write(c);
        ++this.curPos;
    }

    public void write(String str) {
        int pos = 0;
        int size = str.length();
        int rem = this.lineSize - this.curPos + 1;
        while (size > 0) {
            if (rem == 0) {
                super.write(SEPARATOR);
                this.curPos = 1;
                rem = this.lineSize;
                continue;
            }
            if (rem >= size) {
                super.write(str.substring(pos, pos + size));
                this.curPos += size;
                rem -= size;
                size = 0;
                continue;
            }
            super.write(str.substring(pos, pos + rem));
            pos += rem;
            size -= rem;
            rem = 0;
        }
    }

    void newLine() {
        super.write(SEPARATOR);
        this.curPos = 1;
    }
}

