/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import bruma.iterator.MyReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISO2709 {
    private static final int LEADER_LENGTH = 24;
    private final MyReader mr;
    private String errMessage;
    private int nvf;
    private int dirEntrySize;
    private boolean eof;
    private int recordLength;
    private int recordStatus;
    private int implementationCodes;
    private int indicatorLength;
    private int subfieldIndicatorLength;
    private int baseAddressData;
    private int forUserSystems;
    private int lengthLengthEntryField;
    private int lengthStartingCharacterPosition;
    private int forFutureUse;
    private byte[] dir;
    private byte[] fields;

    public ISO2709(String isoFileName) throws IOException {
        this(isoFileName, null);
    }

    public ISO2709(String isoFileName, String encoding) throws IOException {
        if (isoFileName == null) {
            throw new IllegalArgumentException("null iso file name");
        }
        this.errMessage = null;
        this.mr = new MyReader(isoFileName, encoding);
        this.dir = null;
        this.fields = null;
        this.nvf = 0;
        this.dirEntrySize = 0;
        this.eof = false;
    }

    public void close() throws IOException {
        if (this.mr != null) {
            this.mr.close();
        }
    }

    public String getErrorMessage() {
        return this.errMessage != null ? new String(this.errMessage) : null;
    }

    private int parseInt(byte[] buffer, int offset, int length) {
        assert (buffer != null);
        assert (offset >= 0);
        assert (length > 0);
        int ret = 0;
        for (int index = 0; index < length; ++index) {
            char c = (char)buffer[offset + index];
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException("parseInt/ (c < '0') || (c > '9')");
            }
            ret *= 10;
            ret += c - 48;
        }
        return ret;
    }

    private boolean readLeader() {
        byte[] leader = new byte[24];
        boolean ret = false;
        try {
            int len = this.mr.read(leader, 0, 24);
            if (len == 0) {
                this.eof = true;
            } else if (len != 24) {
                this.errMessage = "readLeader/read";
            } else {
                this.recordLength = this.parseInt(leader, 0, 5);
                this.recordStatus = this.parseInt(leader, 5, 1);
                this.implementationCodes = this.parseInt(leader, 6, 4);
                this.indicatorLength = this.parseInt(leader, 10, 1);
                this.subfieldIndicatorLength = this.parseInt(leader, 11, 1);
                this.baseAddressData = this.parseInt(leader, 12, 5);
                this.forUserSystems = this.parseInt(leader, 17, 3);
                this.lengthLengthEntryField = this.parseInt(leader, 20, 1);
                this.lengthStartingCharacterPosition = this.parseInt(leader, 21, 1);
                this.forFutureUse = this.parseInt(leader, 22, 2);
                this.eof = false;
                ret = true;
            }
        }
        catch (Exception ex) {
            this.errMessage = "readLeader/" + ex.toString();
        }
        return ret;
    }

    private boolean readDirectory() {
        boolean ret = false;
        try {
            int dirLength = this.baseAddressData - 24 - 1;
            if (this.dir == null || this.dir.length < dirLength) {
                this.dir = new byte[dirLength];
            }
            if (this.mr.read(this.dir, 0, dirLength) == dirLength) {
                this.dirEntrySize = 3 + this.lengthLengthEntryField + this.lengthStartingCharacterPosition;
                this.nvf = dirLength / this.dirEntrySize;
                ret = true;
            } else {
                this.errMessage = "readDirectory/dirLength";
            }
        }
        catch (Exception ex) {
            this.errMessage = "readDirectory/" + ex.toString();
        }
        return ret;
    }

    private boolean readFields() {
        boolean ret = false;
        try {
            int fieldsLength = this.recordLength - this.baseAddressData + 1;
            int read = 0;
            if (this.fields == null || this.fields.length < fieldsLength) {
                this.fields = new byte[fieldsLength];
            }
            if ((read = this.mr.read(this.fields, 0, fieldsLength)) == fieldsLength) {
                this.mr.readBreak();
                ret = true;
            } else {
                this.errMessage = "readFields/fieldsLength [" + read + " < " + fieldsLength + "]";
            }
        }
        catch (Exception ex) {
            this.errMessage = "readFields/" + ex.toString();
        }
        return ret;
    }

    private boolean insertField(List<Field> record, int tag, String content) {
        assert (record != null);
        assert (tag >= 0);
        assert (content != null);
        int endIndex = record.size() - 1;
        int beginIndex = 0;
        int curIndex = endIndex;
        Field field = null;
        boolean found = false;
        boolean ret = false;
        if (tag <= 0) {
            this.errMessage = "insertField/tag[" + tag + " <= 0";
        } else if (content == null) {
            this.errMessage = "insertField/field content is null";
        } else {
            while (beginIndex <= endIndex) {
                curIndex = beginIndex + (endIndex - beginIndex) / 2;
                field = record.get(curIndex);
                if (tag > field.getTag()) {
                    beginIndex = curIndex + 1;
                    continue;
                }
                if (tag < field.getTag()) {
                    endIndex = curIndex - 1;
                    continue;
                }
                found = true;
                break;
            }
            if (field == null || !found) {
                field = new Field(tag);
                field.add(content);
                if (tag < field.getTag()) {
                    record.add(endIndex - 1, field);
                } else {
                    record.add(endIndex + 1, field);
                }
            } else {
                field.add(content);
            }
            ret = true;
        }
        return ret;
    }

    public List<Field> getNextIsoRecord() {
        ArrayList<Field> record = new ArrayList<Field>();
        this.errMessage = null;
        if (!this.readLeader() && !this.eof) {
            this.errMessage = "getNextIsoRecord/" + this.errMessage;
            record = null;
        } else if (!this.readDirectory()) {
            this.errMessage = "getNextIsoRecord/" + this.errMessage;
            record = null;
        } else if (!this.readFields()) {
            this.errMessage = "getNextIsoRecord/" + this.errMessage;
            record = null;
        } else {
            record = new ArrayList();
            for (int index = 0; index < this.nvf; ++index) {
                int dpos = index * this.dirEntrySize;
                int tag = this.parseInt(this.dir, dpos, 3);
                if (tag <= 0 || tag > 9999) {
                    this.errMessage = "getNextIsoRecord/tag" + this.errMessage;
                    record = null;
                    break;
                }
                int len = this.parseInt(this.dir, dpos += 3, this.lengthLengthEntryField);
                if (len < 0) {
                    this.errMessage = "getNextIsoRecord/len" + this.errMessage;
                    record = null;
                    break;
                }
                int pos = this.parseInt(this.dir, dpos += this.lengthLengthEntryField, this.lengthStartingCharacterPosition);
                if (pos < 0) {
                    this.errMessage = "getNextIsoRecord/pos" + this.errMessage;
                    record = null;
                    break;
                }
                try {
                    String content = new String(this.fields, pos + 1, len - 1, "ISO-8859-1");
                    if (this.insertField(record, tag, content)) continue;
                    this.errMessage = "getNextIsoRecord/" + this.errMessage;
                    record = null;
                }
                catch (UnsupportedEncodingException ueex) {
                    this.errMessage = "getNextIsoRecord" + ueex.toString();
                    record = null;
                }
                break;
            }
        }
        return record;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Field {
        private final int tag;
        private final List<String> field;

        Field(int tag) {
            this.tag = tag;
            this.field = new ArrayList<String>();
        }

        void add(String content) {
            if (content != null) {
                this.field.add(content);
            }
        }

        public int getTag() {
            return this.tag;
        }

        public List<String> getFields() {
            return this.field;
        }
    }
}

