/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import bruma.BrumaException;
import bruma.impexp.ISO2709I;
import bruma.iterator.AbstractRecordIterator;
import bruma.master.Record;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ISO2709RecordIterator
extends AbstractRecordIterator {
    private ISO2709I iso;

    public ISO2709RecordIterator(String isoName) {
        this(isoName, null);
    }

    public ISO2709RecordIterator(String isoName, String encoding) {
        try {
            this.iso = new ISO2709I(isoName, encoding);
            this.getNextRecord();
        }
        catch (BrumaException ex) {
            Logger.getLogger(ISO2709RecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void close() {
        try {
            if (this.iso != null) {
                this.iso.close();
                this.iso = null;
            }
        }
        catch (BrumaException ex) {
            Logger.getLogger(ISO2709RecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Record getNextRecord() {
        try {
            this.record = this.iso.readRecord();
        }
        catch (BrumaException ex) {
            Logger.getLogger(ISO2709RecordIterator.class.getName()).log(Level.SEVERE, null, ex);
            this.record = null;
        }
        return this.record;
    }

    private static void usage() {
        System.err.println("usage: ISO2709RecordIterator <dbname>");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            ISO2709RecordIterator.usage();
        }
        ISO2709RecordIterator iterator = new ISO2709RecordIterator(args[0]);
        for (Record rec : iterator) {
            System.out.println(rec);
        }
        ((AbstractRecordIterator)iterator).close();
    }
}

