/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import bruma.iterator.AbstractRecordIterator;
import bruma.master.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdFileRecordIterator
extends AbstractRecordIterator {
    private Matcher mat;
    private BufferedReader reader;
    private String lastLine;

    public IdFileRecordIterator(File fname) {
        this(fname, null);
    }

    public IdFileRecordIterator(File fname, String encoding) {
        String encod = encoding == null ? "ISO-8859-1" : encoding;
        this.mat = Pattern.compile("\\!v(\\d{1,9})\\!(.*)").matcher("");
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fname), encod));
            this.lastLine = null;
            this.getNextRecord();
        }
        catch (IOException ex) {
            Logger.getLogger(IdFileRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public IdFileRecordIterator(String idString) {
        this.mat = Pattern.compile("\\!v(\\d{1,9})\\!(.*)").matcher("");
        this.reader = new BufferedReader(new StringReader(idString));
        this.lastLine = null;
        this.getNextRecord();
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(IdFileRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Record getNextRecord() {
        assert (this.reader != null);
        StringBuilder builder = new StringBuilder();
        int fldId = 0;
        boolean readId = false;
        boolean insideField = false;
        this.record = null;
        try {
            while (true) {
                String line;
                if (this.lastLine == null) {
                    line = this.reader.readLine();
                    if (line == null) {
                        break;
                    }
                } else {
                    line = this.lastLine;
                    this.lastLine = null;
                }
                if (line.startsWith("!ID")) {
                    if (readId) {
                        this.lastLine = line;
                        break;
                    }
                    int id = Integer.parseInt(line.substring(4));
                    this.record = new Record();
                    this.record.setMfn(id);
                    readId = true;
                    insideField = false;
                    continue;
                }
                if (!readId) {
                    throw new IllegalArgumentException("missing record id");
                }
                this.lastLine = null;
                this.mat.reset(line);
                if (this.mat.matches()) {
                    insideField = true;
                    if (builder.length() > 0) {
                        this.record.addField(fldId, builder.toString());
                        builder.setLength(0);
                    }
                    fldId = Integer.parseInt(this.mat.group(1));
                    builder.append(this.mat.group(2));
                    continue;
                }
                if (!insideField) {
                    throw new IllegalArgumentException("missing field id");
                }
                builder.append(line);
            }
            if (builder.length() > 0) {
                this.record.addField(fldId, builder.toString());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(IdFileRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.record;
    }

    private static void usage() {
        System.err.println("usage: IdFileRecordIterator <idFileName>");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            IdFileRecordIterator.usage();
        }
        IdFileRecordIterator iterator = new IdFileRecordIterator(args[0]);
        for (Record rec : iterator) {
            System.out.println(rec);
        }
        ((AbstractRecordIterator)iterator).close();
    }
}

