/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import bruma.BrumaException;
import bruma.iterator.AbstractRecordIterator;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IsisRecordIterator
extends AbstractRecordIterator {
    private Master master;
    private int id;
    private int last;

    public IsisRecordIterator(String dbName) {
        this(dbName, null);
    }

    public IsisRecordIterator(String dbName, String encoding) {
        try {
            String encod = encoding == null ? "ISO-8859-1" : encoding;
            this.id = 0;
            this.master = MasterFactory.getInstance(dbName).setEncoding(encod).open();
            this.last = this.master.getControlRecord().getNxtmfn() - 1;
            this.getNextRecord();
        }
        catch (BrumaException ex) {
            Logger.getLogger(IsisRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void close() {
        if (this.master != null) {
            try {
                this.master.close();
            }
            catch (BrumaException ex) {
                Logger.getLogger(IsisRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.master = null;
        }
    }

    public boolean isFFI() {
        return this.master.isFFI();
    }

    public int getGigaSize() {
        return this.master.getGigaSize();
    }

    public String getEncoding() {
        return this.master.getEncoding();
    }

    public Record getNextRecord() {
        assert (this.master != null);
        Record rec = null;
        this.record = null;
        try {
            while (++this.id <= this.last) {
                rec = this.master.getRecord(this.id);
                if (rec.getStatus() != Record.Status.ACTIVE) continue;
                this.record = rec;
                break;
            }
        }
        catch (BrumaException ex) {
            Logger.getLogger(IsisRecordIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.record;
    }

    private static void usage() {
        System.err.println("usage: IsisRecordIterator <dbname> [<encoding>]");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            IsisRecordIterator.usage();
        }
        String encoding = args.length > 1 ? args[1] : null;
        IsisRecordIterator iterator = new IsisRecordIterator(args[0], encoding);
        for (Record rec : iterator) {
            System.out.println(rec);
        }
        ((AbstractRecordIterator)iterator).close();
    }
}

