/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class MyReader {
    private static final int LINE_LENGTH = 80;
    private final int lineLength;
    private final BufferedReader reader;
    private int linePos;

    MyReader(String fileName) throws IOException {
        this(fileName, 80, null);
    }

    MyReader(String fileName, String encoding) throws IOException {
        this(fileName, 80, null);
    }

    MyReader(String fileName, int lineLength, String encoding) throws IOException {
        assert (lineLength > 0);
        String encod = encoding == null ? "ISO-8859-1" : encoding;
        this.lineLength = lineLength > 0 ? lineLength : 80;
        this.linePos = 0;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encod));
    }

    void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    void readBreak() throws IOException {
        int c = this.reader.read();
        if (c == 13) {
            c = this.reader.read();
        }
        this.linePos = 0;
    }

    int read(byte[] cbuf, int off, int len) throws IOException {
        assert (cbuf != null);
        assert (off >= 0);
        assert (len > 0);
        int c = 0;
        int total = 0;
        while (total < len) {
            if (this.linePos == this.lineLength) {
                this.readBreak();
            }
            if (c == -1) {
                return total;
            }
            while (total < len && this.linePos < this.lineLength) {
                c = this.reader.read();
                if (c == -1) {
                    return total;
                }
                cbuf[total++] = (byte)c;
                ++this.linePos;
            }
        }
        return total;
    }
}

