/*
 * Decompiled with CFR 0.152.
 */
package bruma.iterator;

import bruma.BrumaException;
import bruma.iterator.AbstractRecordIterator;
import bruma.master.Record;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpIterator
extends AbstractRecordIterator {
    static final String NEWLINESEPARATOR = "\\r?\\n";
    static final String PIPESEPARATOR = "\\|";
    final Matcher fldDelim;
    final Scanner recDelim;

    public RegExpIterator(String source) {
        this(source, PIPESEPARATOR, NEWLINESEPARATOR);
    }

    public RegExpIterator(File source, String encoding) throws BrumaException {
        this(source, encoding, PIPESEPARATOR, NEWLINESEPARATOR);
    }

    public RegExpIterator(String source, String fieldDelimRE, String recordDelimRE) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (fieldDelimRE == null) {
            throw new NullPointerException("fieldDelimRE");
        }
        if (recordDelimRE == null) {
            throw new NullPointerException("recordDelimRE");
        }
        this.fldDelim = Pattern.compile(fieldDelimRE).matcher("");
        this.recDelim = new Scanner(source);
        this.getNextRecord();
    }

    public RegExpIterator(File source, String encoding, String fieldDelimRE, String recordDelimRE) throws BrumaException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (fieldDelimRE == null) {
            throw new NullPointerException("fieldDelimRE");
        }
        if (recordDelimRE == null) {
            throw new NullPointerException("recordDelimRE");
        }
        this.fldDelim = Pattern.compile(fieldDelimRE).matcher("");
        try {
            this.recDelim = new Scanner(source, encoding == null ? "ISO-8859-1" : encoding);
            this.recDelim.useDelimiter(recordDelimRE);
            this.getNextRecord();
        }
        catch (FileNotFoundException ex) {
            throw new BrumaException(ex.fillInStackTrace());
        }
    }

    protected Record getNextRecord() {
        this.record = null;
        if (this.recDelim.hasNext()) {
            String buffer = this.recDelim.next();
            int tag = 1;
            int beginFldPos = 0;
            this.fldDelim.reset(buffer);
            while (this.fldDelim.find()) {
                String field = buffer.substring(beginFldPos, this.fldDelim.start());
                beginFldPos = this.fldDelim.end();
                try {
                    if (this.record == null) {
                        this.record = new Record();
                    }
                    this.record.addField(tag++, field);
                }
                catch (BrumaException ex) {
                    Logger.getLogger(RegExpIterator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return this.record;
    }

    public void close() {
        this.recDelim.close();
    }
}

