/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.XrfFile;
import java.io.IOException;
import java.util.Arrays;

public class BufferedXrfFile
extends XrfFile {
    private final int[] buffer;
    private int lastMfn;
    private boolean modified;
    private boolean autoCommit;

    BufferedXrfFile(String dbasename, int shift, boolean swapped, boolean create, int lastMfn) throws BrumaException {
        this(dbasename, shift, swapped, create, lastMfn, false);
    }

    BufferedXrfFile(String dbasename, int shift, boolean swapped, boolean create, int lastMfn, boolean autoCommit) throws BrumaException {
        super(dbasename, shift, swapped, create);
        if (lastMfn < 0) {
            throw new BrumaException("BufferedXrfFile/lastMfn < 0");
        }
        this.lastMfn = lastMfn;
        this.autoCommit = autoCommit;
        this.buffer = new int[128];
        this.modified = false;
    }

    void close() throws BrumaException {
        try {
            this.writeBuffer();
        }
        catch (IOException ioe) {
            throw new BrumaException("close/" + ioe.getMessage());
        }
        super.close();
    }

    void reset() throws BrumaException {
        super.reset();
        this.initializeBuffer(1);
    }

    public XrfFile.XrfInfo readXrfInfo(int mfn) throws BrumaException {
        int packedMfp = this.buffer[this.getBufferPos(mfn)];
        return this.readXrfInfoAux(mfn, packedMfp);
    }

    public int writeXrfInfo(XrfFile.XrfInfo info) throws BrumaException {
        if (info == null) {
            throw new BrumaException("writeXrfInfo/null info");
        }
        int block = Math.abs(info.getBlock());
        int bmax = 2 << 21 + this.shift - 1;
        int lshift = 11 - this.shift;
        int packedMfp = (block << lshift) + (info.getOffset() >>> this.shift);
        if (info.getBlock() < 0) {
            packedMfp = -packedMfp;
        }
        if (block > bmax) {
            throw new BrumaException("writeXrfInfo/block[" + block + "]");
        }
        this.buffer[this.getBufferPos((int)info.getMfn())] = packedMfp;
        this.modified = true;
        try {
            if (this.autoCommit) {
                this.writeBuffer();
            }
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        return packedMfp;
    }

    private void initializeBuffer(int bNum) {
        assert (bNum > 0);
        if (this.buffer != null) {
            Arrays.fill(this.buffer, 0);
            this.buffer[0] = -bNum;
        }
        this.modified = false;
    }

    private int getBufferPos(int mfn) throws BrumaException {
        assert (mfn > 0);
        if (mfn <= 0 || mfn > this.lastMfn + 1) {
            throw new BrumaException("getBufferPos/mfn[" + mfn + "] out of range");
        }
        boolean newBlock = false;
        int cBlock = mfn / 127;
        int pos = mfn % 127;
        if (mfn == this.lastMfn + 1) {
            ++this.lastMfn;
            boolean bl = newBlock = pos == 1;
        }
        if (pos == 0) {
            pos = 127;
        } else {
            ++cBlock;
        }
        if (cBlock != Math.abs(this.buffer[0])) {
            try {
                this.fillBuffer(cBlock, newBlock);
            }
            catch (IOException ioe) {
                throw new BrumaException(ioe);
            }
        }
        assert (pos > 0);
        return pos;
    }

    private void fillBuffer(int bNum, boolean newBlock) throws IOException {
        assert (bNum > 0);
        if (this.modified) {
            this.writeBuffer();
        }
        if (newBlock) {
            this.initializeBuffer(bNum);
        } else {
            this.readBuffer(bNum);
        }
    }

    private void readBuffer(int bNum) throws IOException {
        assert (bNum > 0);
        this.fc.position((bNum - 1) * 512);
        this.bBuffer.clear();
        this.fc.read(this.bBuffer);
        this.bBuffer.rewind();
        this.bBuffer.asIntBuffer().get(this.buffer);
        this.modified = false;
    }

    private void writeBuffer() throws IOException {
        if (this.modified) {
            this.fc.position((Math.abs(this.buffer[0]) - 1) * 512);
            this.bBuffer.clear();
            this.bBuffer.asIntBuffer().put(this.buffer);
            this.bBuffer.rewind();
            this.fc.write(this.bBuffer);
            this.modified = false;
        }
    }
}

