/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Record;
import bruma.master.XrfFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class DbType {
    private final FileChannel fc;
    private final boolean swapped;
    private ByteBuffer bBuffer;

    DbType(FileChannel fc) throws IOException {
        assert (fc != null);
        long size = fc.size();
        this.fc = fc;
        this.bBuffer = ByteBuffer.allocateDirect(22).order(ByteOrder.LITTLE_ENDIAN);
        this.bBuffer.clear();
        this.bBuffer.limit(6);
        fc.position(8L);
        if (fc.read(this.bBuffer) != 6) {
            throw new IOException("DbType/swapped read error");
        }
        this.bBuffer.rewind();
        int block = this.bBuffer.getInt();
        if (block < 1) {
            throw new IOException("DbType/block[" + block + "] < 1");
        }
        short pos = this.bBuffer.getShort();
        if (pos < 1) {
            throw new IOException("DbType/pos[" + pos + "] < 1");
        }
        long fpos = (long)(pos == 1 ? block - 1 : block) * 512L;
        if (size >= fpos - 512L && size <= fpos + 512L) {
            this.swapped = true;
        } else {
            this.bBuffer = ByteBuffer.allocateDirect(22).order(ByteOrder.BIG_ENDIAN);
            this.bBuffer.clear();
            this.bBuffer.limit(6);
            fc.position(8L);
            if (fc.read(this.bBuffer) != 6) {
                throw new IOException("DbType/swapped read error");
            }
            this.bBuffer.rewind();
            block = this.bBuffer.getInt();
            pos = this.bBuffer.getShort();
            fpos = (long)(pos == 1 ? block - 1 : block) * 512L;
            if (size >= fpos - 512L && size <= fpos + 512L) {
                this.swapped = false;
            } else {
                throw new IOException("DbType/invalid master block number");
            }
        }
    }

    boolean isSwapped() {
        return this.swapped;
    }

    Type getType(XrfFile xrf) throws BrumaException, IOException {
        assert (xrf != null);
        Type ret = new Type();
        XrfFile xrfFile = xrf;
        xrfFile.getClass();
        XrfFile.XrfInfo info = new XrfFile.XrfInfo(xrfFile, 1, 0, 0, Record.Status.ACTIVE, Record.ActiveStatus.NORMAL);
        info.setMfn(0);
        while (!ret.recognized) {
            info.setMfn(info.getMfn() + 1);
            long position = this.getNextRecPos(xrf, info);
            if (position == -1L) break;
            this.bBuffer.clear();
            this.fc.position(position);
            if (this.fc.read(this.bBuffer) != 22) {
                throw new IOException("swapped read error");
            }
            if (this.readIsisAlign0(this.bBuffer)) {
                ret.recognized = true;
                ret.IsisStandard = true;
                ret.align = 0;
                continue;
            }
            if (this.readIsisAlign2(this.bBuffer)) {
                ret.recognized = true;
                ret.IsisStandard = true;
                ret.align = 2;
                continue;
            }
            if (this.readFfiAlign0(this.bBuffer)) {
                ret.recognized = true;
                ret.IsisStandard = false;
                ret.align = 0;
                continue;
            }
            if (!this.readFfiAlign2(this.bBuffer)) continue;
            ret.recognized = true;
            ret.IsisStandard = false;
            ret.align = 2;
        }
        ret.swapped = this.swapped;
        return ret;
    }

    private long getNextRecPos(XrfFile xrf, XrfFile.XrfInfo xinfo) throws BrumaException {
        int lastMfn;
        assert (xrf != null);
        assert (xinfo.getMfn() > 0);
        long position = -1L;
        try {
            this.bBuffer.clear();
            this.bBuffer.limit(4);
            this.fc.position(4L);
            if (this.fc.read(this.bBuffer) != 4) {
                throw new BrumaException("lastMfn read error");
            }
            this.bBuffer.rewind();
            lastMfn = this.bBuffer.getInt() - 1;
            assert (lastMfn >= 0);
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        for (int mfn = xinfo.getMfn(); mfn <= lastMfn; ++mfn) {
            XrfFile.XrfInfo auxInfo = xrf.readXrfInfo(mfn);
            if (auxInfo.getStatus() == Record.Status.PHYDEL) continue;
            long auxPos = Math.abs(auxInfo.getBlock()) - 1;
            position = (auxPos *= 512L) + (long)(auxInfo.getOffset() & 0x1FF);
            xinfo.setActStatus(auxInfo.getActStatus());
            xinfo.setBlock(auxInfo.getBlock());
            xinfo.setOffset(auxInfo.getOffset());
            xinfo.setStatus(auxInfo.getStatus());
            break;
        }
        return position;
    }

    private boolean readIsisAlign0(ByteBuffer bBuffer) throws IOException, BrumaException {
        assert (bBuffer != null);
        boolean ret = false;
        bBuffer.rewind();
        bBuffer.getInt();
        bBuffer.getShort();
        bBuffer.getInt();
        bBuffer.getShort();
        short base = bBuffer.getShort();
        short nvf = bBuffer.getShort();
        if (nvf > 0) {
            int auxBase = 18 + nvf * 6;
            ret = base == auxBase;
        }
        return ret;
    }

    private boolean readIsisAlign2(ByteBuffer bBuffer) throws IOException, BrumaException {
        assert (bBuffer != null);
        boolean ret = false;
        bBuffer.rewind();
        bBuffer.getInt();
        bBuffer.getShort();
        bBuffer.getShort();
        bBuffer.getInt();
        bBuffer.getShort();
        short base = bBuffer.getShort();
        short nvf = bBuffer.getShort();
        if (nvf > 0) {
            int auxBase = 20 + nvf * 6;
            ret = base == auxBase;
        }
        return ret;
    }

    private boolean readFfiAlign0(ByteBuffer bBuffer) throws IOException, BrumaException {
        assert (bBuffer != null);
        boolean ret = false;
        bBuffer.rewind();
        bBuffer.getInt();
        bBuffer.getInt();
        bBuffer.getInt();
        bBuffer.getShort();
        int base = bBuffer.getInt();
        short nvf = bBuffer.getShort();
        if (nvf > 0) {
            int auxBase = 22 + nvf * 10;
            ret = base == auxBase;
        }
        return ret;
    }

    private boolean readFfiAlign2(ByteBuffer bBuffer) throws IOException, BrumaException {
        assert (bBuffer != null);
        boolean ret = false;
        bBuffer.rewind();
        bBuffer.getInt();
        bBuffer.getInt();
        bBuffer.getInt();
        bBuffer.getShort();
        bBuffer.getShort();
        int base = bBuffer.getInt();
        short nvf = bBuffer.getShort();
        if (nvf > 0) {
            int auxBase = 24 + nvf * 12;
            ret = base == auxBase;
        }
        return ret;
    }

    class Type {
        boolean recognized;
        boolean IsisStandard;
        boolean swapped;
        int align;

        Type() {
        }
    }
}

