/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Subfield;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
implements Iterable<Subfield>,
Comparable<Field> {
    private final int tag;
    private final String tagStr;
    private final String content;
    private List<Subfield> subfields;
    private final Matcher matcher;

    public Field(int tag, String content) throws BrumaException {
        if (tag <= 0 || tag > 99999) {
            throw new BrumaException("Field/tag[" + tag + "] parameter out of range[1, 99999]");
        }
        if (content == null) {
            throw new BrumaException("Field/null content");
        }
        this.tag = tag;
        this.tagStr = null;
        this.content = content;
        this.subfields = null;
        this.matcher = Pattern.compile("(\\^(\\w))?([^\\^]+)").matcher("");
    }

    public Field(String tagStr, String content) throws BrumaException {
        if (tagStr == null) {
            throw new BrumaException("Field/null strId");
        }
        if (content == null) {
            throw new BrumaException("Field/null content");
        }
        this.tag = -1;
        this.tagStr = tagStr;
        this.content = content;
        this.subfields = null;
        this.matcher = Pattern.compile("(\\^(\\w))?([^\\^]+)").matcher("");
    }

    public int getId() {
        return this.tag;
    }

    public String getTagStr() {
        return this.tagStr;
    }

    public String getContent() {
        String ret;
        if (this.subfields == null) {
            ret = this.content;
        } else {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (Subfield subfield : this.subfields) {
                if (first) {
                    if (subfield.getId() == '_') {
                        builder.append(subfield);
                    } else {
                        builder.append("^");
                        builder.append(subfield.getId());
                        builder.append(subfield.getContent());
                    }
                    first = false;
                    continue;
                }
                builder.append("^");
                builder.append(subfield.getId());
                builder.append(subfield.getContent());
            }
            ret = builder.toString();
        }
        return ret;
    }

    @Override
    public Iterator<Subfield> iterator() {
        Iterator<Subfield> ret;
        try {
            ret = this.getSubfields().iterator();
        }
        catch (BrumaException ze) {
            ret = null;
        }
        return ret;
    }

    public List<Subfield> getSubfields() throws BrumaException {
        if (this.subfields == null) {
            char id = '_';
            this.matcher.reset(this.content);
            this.subfields = new ArrayList<Subfield>();
            while (this.matcher.find()) {
                String sid = this.matcher.group(2);
                if (sid != null && !sid.isEmpty()) {
                    id = sid.charAt(0);
                }
                String subfield = this.matcher.group(3);
                this.subfields.add(new Subfield(id, subfield));
            }
            if (this.subfields.isEmpty()) {
                this.subfields.add(new Subfield(id, this.content));
            }
        }
        return this.subfields;
    }

    public List<Subfield> getTagSubfields(char id) throws BrumaException {
        ArrayList<Subfield> ret = new ArrayList<Subfield>();
        this.matcher.reset(this.content);
        while (this.matcher.find()) {
            char id2;
            String sid = this.matcher.group(2);
            if (sid == null || sid.isEmpty() || id != (id2 = sid.charAt(0))) continue;
            String subfield = this.matcher.group(3);
            ret.add(new Subfield(id, subfield));
        }
        return ret;
    }

    public Subfield getSubfield(char id, int occ) throws BrumaException {
        if (occ <= 0) {
            throw new BrumaException("subfield occ[" + occ + "] out of range <= 0");
        }
        Subfield ret = null;
        int xocc = 0;
        for (Subfield subfield : this.getSubfields()) {
            if (subfield.getId() != id || ++xocc != occ) continue;
            ret = subfield;
            break;
        }
        return ret;
    }

    @Override
    public int compareTo(Field other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return this.tag >= 0 ? this.getId() - other.getId() : this.tagStr.compareTo(other.getTagStr());
    }

    public String toXML() {
        String cont = this.getContent().replace("<", "&lt;").replace(">", "&gt;");
        StringBuilder sb = new StringBuilder();
        if (this.tag >= 0) {
            sb.append("<field tag='");
            sb.append(this.tag);
            sb.append("'>");
            sb.append(cont);
            sb.append("</field>");
        } else {
            sb.append("<");
            sb.append(this.tagStr);
            sb.append(">");
            sb.append(cont);
            sb.append("</");
            sb.append(this.tagStr);
            sb.append(">");
        }
        return sb.toString();
    }

    public String toString() {
        String cont = this.getContent();
        StringBuilder sb = new StringBuilder();
        if (this.tagStr == null) {
            sb.append("<");
            sb.append(this.tag);
            sb.append(">");
            sb.append(cont);
            sb.append("</");
            sb.append(this.tag);
            sb.append(">");
        } else {
            sb.append("<");
            sb.append(this.tagStr);
            sb.append(">");
            sb.append(cont);
            sb.append("</");
            sb.append(this.tagStr);
            sb.append(">");
        }
        return sb.toString();
    }
}

