/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.GregorianCalendar;

public class Lock {
    public static final int LOCK_FIELD = 9999;
    private static final int SEGMENT_CONTROL_POS = 24;
    private static final int SEGMENT_LENGTH = 8;
    private static final int DEFAULT_SEGMENT_TIMES = 3000;
    private static final int DEFAULT_DEEWL_TIMES = 3000;
    private static final int DEFAULT_RECORDL_TIMES = 3000;
    private static long lockcount = 0L;
    private final FileChannel fc;
    private final ByteOrder order;
    private final Master mst;
    private final boolean FFI;
    private final int segmentTimes;
    private final Object fileSync;
    private int deewlTimes;
    private int reclTimes;

    public Lock(Master mst) throws BrumaException {
        if (mst == null) {
            throw new BrumaException("Lock/null master file");
        }
        try {
            this.mst = mst;
            this.FFI = mst.isFFI();
            this.segmentTimes = 3000;
            this.deewlTimes = 3000;
            this.reclTimes = 3000;
            this.fc = new RandomAccessFile(mst.getMasterName() + ".mst", "rw").getChannel();
            this.order = mst.isSwapped() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            this.fileSync = new Object();
        }
        catch (Exception ex) {
            throw new BrumaException(ex.toString());
        }
    }

    public void setDbTimes(int deewl_times) {
        this.deewlTimes = deewl_times < 1 ? 3000 : deewl_times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentLock lockSegment(long pos, int len, boolean shared) throws BrumaException {
        if (pos < 0L) {
            throw new BrumaException("lockSegment/pos < 0");
        }
        if (len < 0) {
            throw new BrumaException("lockSegment/len < 0");
        }
        SegmentLock ret = new SegmentLock(pos, len);
        try {
            for (int counter = 0; counter < this.segmentTimes; ++counter) {
                Object object = this.fileSync;
                synchronized (object) {
                    ret.lock = this.fc.tryLock(pos, len, shared);
                }
                if (ret.lock == null) {
                    Thread.sleep(50L);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new BrumaException("lockSegment/" + ex.toString());
        }
        if (ret.lock == null) {
            throw new BrumaException("lockSegment/segment is locked by another");
        }
        assert (!ret.isUnlocked()) : "lockSegment/isUnlocked()";
        return ret;
    }

    public void releaseLockSegment(SegmentLock sLock) throws BrumaException {
        if (sLock == null || sLock.lock == null) {
            throw new BrumaException("releaseLockSegment/invalid SegmentLock");
        }
        try {
            if (sLock.lock != null) {
                sLock.lock.release();
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("releaseLockSegment/ " + ioe.toString());
        }
        finally {
            sLock.reset();
        }
        assert (sLock.isUnlocked()) : "releaseLockSegment/isUnlocked() == false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentLock readLockSegment(long pos) throws BrumaException {
        assert (pos >= 0L) : "readLockSegment/pos < 0";
        if (pos < 0L) {
            throw new BrumaException("readLockSegment/pos < 0");
        }
        ByteBuffer bb = ByteBuffer.allocate(8).order(this.order);
        SegmentLock segLock = this.lockSegment(pos, 8, true);
        try {
            Object object = this.fileSync;
            synchronized (object) {
                this.fc.position(pos);
                if (this.fc.read(bb) != 8) {
                    throw new BrumaException("readLockSegment/file read failed");
                }
            }
            bb.rewind();
            segLock.val1 = bb.getInt();
            if (pos == 24L || this.FFI) {
                segLock.val2 = bb.getInt();
            } else {
                segLock.val2 = bb.getShort();
            }
        }
        catch (IOException ioe) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("readLockSegment/" + ioe.toString());
        }
        return segLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockSegment(SegmentLock segLock) throws BrumaException {
        assert (segLock != null) : "writeUnlockSegment/segLock == null";
        long pos = segLock.pos;
        ByteBuffer bb = ByteBuffer.allocate(8).order(this.order);
        try {
            bb.putInt(segLock.val1);
            if (pos == 24L || this.FFI) {
                bb.putInt(segLock.val2);
            } else {
                bb.putShort((short)segLock.val2);
            }
            bb.rewind();
            Object object = this.fileSync;
            synchronized (object) {
                this.fc.position(pos);
                this.fc.write(bb);
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("writeUnlockSegment/" + ioe.toString());
        }
        finally {
            this.releaseLockSegment(segLock);
        }
        assert (segLock.isUnlocked()) : "writeUnlockSegment/isUnlocked() == false";
    }

    public void setDataEntryLock() throws BrumaException {
        int counter = 0;
        SegmentLock segLock = null;
        while (counter++ < this.deewlTimes) {
            segLock = this.readLockSegment(24L);
            if (segLock.val1 < 0) {
                this.releaseLockSegment(segLock);
                throw new BrumaException("setDataEntryLock/DEL_Flag[" + segLock.val1 + "] < 0");
            }
            if (segLock.val2 == 0) break;
            this.releaseLockSegment(segLock);
        }
        if (segLock.val2 != 0) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("setDataEntryLock/EWL_Flag[" + segLock.val2 + "] != 0");
        }
        segLock.val1++;
        this.writeUnlockSegment(segLock);
    }

    public void resetDataEntryLock() throws BrumaException {
        int counter = 0;
        SegmentLock segLock = null;
        while (counter++ < this.deewlTimes) {
            segLock = this.readLockSegment(24L);
            if (segLock.val1 <= 0) {
                this.releaseLockSegment(segLock);
                throw new BrumaException("resetDataEntryLock/DEL_Flag[" + segLock.val1 + "] <= 0");
            }
            if (segLock.val2 == 0) break;
            this.releaseLockSegment(segLock);
        }
        if (segLock.val2 != 0) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("(resetDataEntryLock/EWL_Flag[" + segLock.val2 + "] != 0)");
        }
        segLock.val1--;
        this.writeUnlockSegment(segLock);
    }

    public EWLock setExclusiveWriteLock() throws BrumaException {
        int counter = 0;
        SegmentLock segLock = null;
        while (counter++ < this.deewlTimes && ((segLock = this.readLockSegment(24L)).val1 != 0 || segLock.val2 != 0)) {
            this.releaseLockSegment(segLock);
        }
        if (segLock.val1 != 0) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("setExclusiveWriteLock/DEL_Flag[" + segLock.val1 + "] < 0");
        }
        if (segLock.val2 != 0) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("setExclusiveWriteLock/EWL_Flag[" + segLock.val2 + "] != 0)");
        }
        segLock.val2++;
        this.writeUnlockSegment(segLock);
        return new EWLock();
    }

    public void resetExclusiveWriteLock(EWLock lock) throws BrumaException {
        if (lock == null) {
            throw new BrumaException("resetExclusiveWriteLock/does not has EWL onwership");
        }
        if (!lock.isUnlocked()) {
            throw new BrumaException("resetExclusiveWriteLock/does not has EWL onwership");
        }
        SegmentLock segLock = this.readLockSegment(24L);
        if (segLock.val1 != 0) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("resetExclusiveWriteLock/DEL_Flag[" + segLock.val1 + "] != 0");
        }
        if (segLock.val2 != 1) {
            this.releaseLockSegment(segLock);
            throw new BrumaException("resetExclusiveWriteLock/EWL_Flag[" + segLock.val2 + "] != 1");
        }
        segLock.val2--;
        lock.reset();
        this.writeUnlockSegment(segLock);
    }

    public void forceResetControlLocks() throws BrumaException {
        SegmentLock segLock = this.readLockSegment(24L);
        segLock.val1 = 0;
        segLock.val2 = 0;
        this.writeUnlockSegment(segLock);
    }

    public RecordLock lockRecord(int mfn) throws BrumaException {
        if (mfn <= 0) {
            throw new BrumaException("lockRecord/mfn[" + mfn + "] <= 0");
        }
        Record.Status[] recStatus = new Record.Status[1];
        Record.ActiveStatus[] actStatus = new Record.ActiveStatus[1];
        long pos = this.mst.getMasterPosition(mfn, recStatus, actStatus);
        int counter = 0;
        SegmentLock segLock = null;
        boolean delLock = false;
        boolean sLock = false;
        if (recStatus[0] != Record.Status.ACTIVE) {
            throw new BrumaException("lockRecord/record is not active");
        }
        try {
            while (counter++ < this.reclTimes) {
                this.setDataEntryLock();
                delLock = true;
                segLock = this.readLockSegment(pos);
                sLock = true;
                pos = this.mst.getMasterPosition(mfn, recStatus, actStatus);
                if (recStatus[0] != Record.Status.ACTIVE) {
                    throw new BrumaException("lockRecord/record is not active");
                }
                if (segLock.val2 >= 0) {
                    segLock.val2 *= -1;
                    this.writeUnlockSegment(segLock);
                    sLock = false;
                    this.resetDataEntryLock();
                    delLock = false;
                    break;
                }
                this.releaseLockSegment(segLock);
                sLock = false;
                this.resetDataEntryLock();
                delLock = false;
            }
        }
        catch (BrumaException exc) {
            if (sLock) {
                this.releaseLockSegment(segLock);
            }
            if (delLock) {
                this.resetDataEntryLock();
            }
            throw exc;
        }
        if (counter == this.reclTimes) {
            throw new BrumaException("lockRecord/record locked by another");
        }
        return new RecordLock(mfn);
    }

    public void unlockRecord(RecordLock lock) throws BrumaException {
        if (lock == null) {
            throw new BrumaException("unlockRecord/null _lock");
        }
        Record.Status[] status = new Record.Status[1];
        Record.ActiveStatus[] actStatus = new Record.ActiveStatus[1];
        long pos = this.mst.getMasterPosition(lock.mfn, status, actStatus);
        SegmentLock segLock = null;
        boolean delLock = false;
        boolean sLock = false;
        if (status[0] != Record.Status.ACTIVE) {
            throw new BrumaException("unlockRecord/record is not active");
        }
        try {
            this.setDataEntryLock();
            delLock = true;
            segLock = this.readLockSegment(pos);
            sLock = true;
            pos = this.mst.getMasterPosition(lock.mfn, status, actStatus);
            if (status[0] != Record.Status.ACTIVE) {
                throw new BrumaException("unlockRecord/record is not active");
            }
            if (segLock.val2 >= 0) {
                throw new BrumaException("unlockRecord/record is not locked");
            }
            segLock.val2 *= -1;
            this.writeUnlockSegment(segLock);
            sLock = false;
            this.resetDataEntryLock();
            delLock = false;
        }
        catch (BrumaException exc) {
            if (sLock) {
                this.releaseLockSegment(segLock);
            }
            if (delLock) {
                this.resetDataEntryLock();
            }
            throw exc;
        }
    }

    public void forceUnlockRecord(int mfn) throws BrumaException {
        if (mfn <= 0) {
            throw new BrumaException("forceUnlockRecord/mfn[" + mfn + "] < 0");
        }
        Record.Status[] status = new Record.Status[1];
        Record.ActiveStatus[] actStatus = new Record.ActiveStatus[1];
        long pos = this.mst.getMasterPosition(mfn, status, actStatus);
        SegmentLock segLock = null;
        boolean sLock = false;
        try {
            segLock = this.readLockSegment(pos);
            sLock = true;
            pos = this.mst.getMasterPosition(mfn, status, actStatus);
            if (status[0] != Record.Status.ACTIVE) {
                throw new BrumaException("forceUnlockRecord/record is not active");
            }
            if (segLock.val2 >= 0) {
                throw new BrumaException("forceUnlockRecord/record is not locked");
            }
            segLock.val2 *= -1;
            this.writeUnlockSegment(segLock);
            sLock = false;
        }
        catch (BrumaException exc) {
            if (sLock) {
                this.releaseLockSegment(segLock);
            }
            throw exc;
        }
    }

    public void close() throws BrumaException {
        try {
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe.toString());
        }
    }

    public static boolean isRecordLockedByAnother(String ownerId, Record rec) throws BrumaException {
        assert (ownerId != null) : "isRecordLockedByAnother/null owner_id";
        assert (rec != null) : "isRecordLockedByAnother/null record";
        long ctime = new GregorianCalendar().getTimeInMillis();
        String field = rec.getField(9999, 1).getContent();
        boolean ret = false;
        if (field.length() != 0) {
            String[] sub = field.split("\\^\\w");
            if (sub.length != 3) {
                throw new BrumaException("isRecordLockedByAnother/invalid record field");
            }
            String ident = sub[1].trim();
            if (ident.length() == 0) {
                throw new BrumaException("isRecordLockedByAnother/invalid id lock field");
            }
            String time = sub[2].trim();
            if (time.length() == 0) {
                throw new BrumaException("isRecordLockedByAnother/invalid time lock field");
            }
            if (ident.compareTo(ownerId) != 0) {
                long ltime;
                try {
                    ltime = Long.parseLong(time);
                }
                catch (NumberFormatException _nfe) {
                    throw new BrumaException("isRecordLockedByAnother/" + _nfe.getMessage());
                }
                ret = ltime >= ctime;
            }
        }
        return ret;
    }

    static synchronized String getNewLockID() {
        return System.currentTimeMillis() + ":" + ++lockcount;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("\nusage: Lock <master> [--isFFI[");
            System.exit(1);
        }
        boolean isFFI = args.length > 1;
        Master mst = MasterFactory.getInstance(args[0]).setFFI(isFFI).open();
        Lock il = new Lock(mst);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String eMess = null;
        while (true) {
            block11: {
                System.out.println("-------------------------------------------------\n");
                System.err.println("  <option>: SDEL - set data entry lock");
                System.err.println("            RDEL - reset data entry lock");
                System.err.println("            SEWL - set exclusive write lock");
                System.err.println("            UFCTL - DEL & EWL unlock force");
                System.err.println("            LREC=<mfn> - record lock (mfn)");
                System.err.println("            UFREC=<mfn> - record unlock force (mfn)");
                System.err.println("            EXIT - exit the program");
                System.err.print("\n  option = ");
                try {
                    String opt = br.readLine();
                    if (opt.compareTo("SDEL") == 0) {
                        il.setDataEntryLock();
                        break block11;
                    }
                    if (opt.compareTo("RDEL") == 0) {
                        il.resetDataEntryLock();
                        break block11;
                    }
                    if (opt.compareTo("SEWL") == 0) {
                        il.setExclusiveWriteLock();
                        break block11;
                    }
                    if (opt.startsWith("UFCTL")) {
                        il.forceResetControlLocks();
                        break block11;
                    }
                    if (opt.startsWith("LREC=")) {
                        il.lockRecord(Integer.parseInt(opt.substring(5)));
                        break block11;
                    }
                    if (opt.startsWith("UFREC=")) {
                        il.forceUnlockRecord(Integer.parseInt(opt.substring(6)));
                        break block11;
                    }
                    if (opt.compareTo("EXIT") == 0) break;
                    throw new IllegalArgumentException("unknown operation - " + opt);
                }
                catch (Exception ex) {
                    eMess = ex.getMessage();
                }
            }
            System.out.print("  status: ");
            if (eMess == null) {
                System.out.println("success");
                continue;
            }
            System.out.println("failed - " + eMess);
        }
        mst.close();
        il.close();
    }

    public class RecordLock {
        private final int mfn;

        private RecordLock(int mfn) {
            this.mfn = mfn;
        }
    }

    public class EWLock {
        private boolean hasEWL = true;

        private EWLock() {
        }

        private boolean isUnlocked() {
            return !this.hasEWL;
        }

        private void reset() {
            this.hasEWL = false;
        }
    }

    public class SegmentLock {
        private long pos;
        private int len;
        private int val1;
        private int val2;
        private FileLock lock;

        private SegmentLock(long pos, int len) {
            assert (pos >= 0L) : "SegmentLock/pos < 0";
            assert (len >= 0) : "SegmentLock/len < 0";
            this.pos = pos;
            this.len = len;
            this.val1 = 0;
            this.val2 = 0;
            this.lock = null;
        }

        void reset() {
            this.pos = 0L;
            this.len = 0;
            this.val1 = 0;
            this.val2 = 0;
            this.lock = null;
        }

        boolean isUnlocked() {
            return this.lock == null;
        }
    }
}

