/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.BufferedXrfFile;
import bruma.master.Control;
import bruma.master.DbType;
import bruma.master.Field;
import bruma.master.Leader;
import bruma.master.Lock;
import bruma.master.MasterPlatformInfo;
import bruma.master.Record;
import bruma.master.RecordByteArray;
import bruma.master.XrfFile;
import bruma.utils.ISO8859OrIBM850;
import bruma.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Master
implements Iterable<Record> {
    public static final int MAXMFRL_ISIS = Short.MAX_VALUE;
    public static final int DEFMFRL_FFI = 0x100000;
    public static final int MAXMFRL_POSSIBLE = 0x4000000;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final String GUESS_ISO_IBM_ENCODING = "ISO-8859-1 or IBM850";
    static final int MSNVSPLT = 20;
    static final int MF_BLOCKSIZE = 512;
    private static final int CONTROL_SIZE = 32;
    private static final int LEADER_SIZE = 26;
    private static final int RECORD_LOCK_SIZE = 8;
    private final byte[] page;
    private MasterPlatformInfo info;
    private String dbName;
    private String encoding;
    private boolean swapped;
    private boolean autoCommit;
    private boolean multiUser;
    private int filler;
    private int neverSplit;
    private int neverSplitRec;
    private RecordByteArray rba;
    private RandomAccessFile raf;
    private FileChannel fc;
    private XrfFile xrf;
    private Lock lock;
    private boolean FFI;
    private int sysfile;
    private int shift;
    private int maxmfrl;
    private byte[] buffer;
    private ByteBuffer bBuffer;
    private String mstExtension;
    private String xrfExtension;

    Master(MasterPlatformInfo mpi) throws BrumaException {
        assert (mpi != null);
        int align = mpi.getDataAlignment();
        this.info = mpi;
        this.page = new byte[512];
        Arrays.fill(this.page, (byte)0);
        this.dbName = mpi.getMstName();
        this.encoding = mpi.getEncoding();
        this.swapped = mpi.isSwapped();
        this.autoCommit = mpi.isXrfWriteCommit();
        this.multiUser = false;
        this.filler = align == 0 ? 0 : 2;
        this.rba = null;
        this.raf = null;
        this.lock = null;
        this.FFI = mpi.isFfi();
        int ffiSize = this.FFI ? 2 : 0;
        this.neverSplit = (this.FFI ? 22 : 18) + this.filler;
        this.neverSplitRec = 512 - (4 + ffiSize + this.filler + 4 + 2 + ffiSize) - 1;
        this.sysfile = 0;
        this.shift = mpi.getShift();
        this.reallocBuffers(32);
        this.mstExtension = ".mst";
        this.xrfExtension = ".xrf";
    }

    private void reallocBuffers(int newSize) throws BrumaException {
        assert (newSize > 0);
        if (this.maxmfrl < newSize) {
            if (newSize > 0x4000000) {
                throw new BrumaException("mfrl[" + newSize + "] >" + 0x4000000);
            }
            if (!this.FFI && newSize > Short.MAX_VALUE) {
                throw new BrumaException("mfrl[" + newSize + "] >" + Short.MAX_VALUE);
            }
            int minAlloc = 512;
            int div = newSize / 512;
            int rem = newSize % 512;
            this.maxmfrl = div == 0 ? 512 : (rem == 0 ? div * 512 : (div + 1) * 512);
            this.buffer = new byte[this.maxmfrl];
            this.bBuffer = ByteBuffer.allocateDirect(this.maxmfrl).order(this.swapped ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
    }

    public static boolean exists(String dbName) throws BrumaException {
        boolean ret = false;
        if (dbName != null) {
            String name = Util.changeFileExtension(dbName, null);
            if (new File(name + ".mst").exists()) {
                if (new File(name + ".xrf").exists()) {
                    ret = true;
                } else if (new File(name + ".XRF").exists()) {
                    ret = true;
                }
            } else if (new File(name + ".MST").exists()) {
                if (new File(name + ".xrf").exists()) {
                    ret = true;
                } else if (new File(name + ".XRF").exists()) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    Master open() throws BrumaException {
        assert (this.info != null);
        try {
            File file = new File(this.dbName + ".mst");
            File xfile = new File(this.dbName + ".xrf");
            if (file.exists()) {
                this.mstExtension = ".mst";
            } else {
                file = new File(this.dbName + ".MST");
                if (file.exists()) {
                    this.mstExtension = ".MST";
                } else {
                    throw new BrumaException("open/missing master file : " + this.dbName);
                }
            }
            if (xfile.exists()) {
                this.xrfExtension = ".xrf";
            } else {
                xfile = new File(this.dbName + ".XRF");
                if (xfile.exists()) {
                    this.xrfExtension = ".XRF";
                } else {
                    throw new BrumaException("open/missing cross reference file : " + this.dbName);
                }
            }
            if (!file.canRead()) {
                throw new BrumaException("open/cant read master file : " + this.dbName);
            }
            String mode = file.canWrite() ? "rw" : "r";
            this.raf = new RandomAccessFile(file, mode);
            if (this.raf.length() < 512L) {
                throw new BrumaException("open/MF_BLOCKSIZE");
            }
            this.fc = this.raf.getChannel();
            DbType dbt = new DbType(this.fc);
            if (this.swapped != dbt.isSwapped()) {
                this.reallocBuffers(this.maxmfrl);
                this.swapped = dbt.isSwapped();
            }
            if (this.encoding.equals(GUESS_ISO_IBM_ENCODING)) {
                ISO8859OrIBM850 guess = new ISO8859OrIBM850(this.dbName, true);
                String encName = guess.guessEncoding();
                this.encoding = encName == null ? DEFAULT_ENCODING : encName;
            }
            Control ctl = this.getControlRecord();
            this.info.setSwapped(this.swapped);
            this.info.setShift(this.shift);
            this.sysfile = ctl.getMftype();
            if (this.sysfile != 0) {
                throw new IOException("open/unsupported master file type");
            }
            if (this.multiUser || !this.info.isInMemoryXrf()) {
                this.xrf = new XrfFile(this.dbName + this.xrfExtension, this.shift, this.swapped, false);
                if (this.multiUser) {
                    this.lock = new Lock(this);
                }
            } else {
                this.xrf = new BufferedXrfFile(this.dbName + this.xrfExtension, this.shift, this.swapped, false, ctl.getNxtmfn() - 1, this.autoCommit);
            }
            if (ctl.getNxtmfn() == 1) {
                this.FFI = false;
                this.filler = System.getProperty("os.name").startsWith("Win") ? 0 : 2;
                this.info.setDataAlignment(this.filler);
            } else {
                DbType.Type type = dbt.getType(this.xrf);
                if (!type.recognized) {
                    throw new IOException("open/could not recognize master file info");
                }
                this.FFI = !type.IsisStandard;
                this.filler = type.align == 0 ? 0 : 2;
                this.info.setDataAlignment(type.align);
            }
            this.info.setFfi(this.FFI);
            this.neverSplit = (this.FFI ? 22 : 18) + this.filler;
            int ffiSize = this.FFI ? 2 : 0;
            this.neverSplitRec = 512 - (4 + ffiSize + this.filler + 4 + 2 + ffiSize) - 1;
            this.rba = new RecordByteArray(this.FFI, this.swapped, this.filler, this.shift);
            this.reallocBuffers(this.FFI ? 0x100000 : Short.MAX_VALUE);
        }
        catch (IOException ioex) {
            try {
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new BrumaException(ioex);
        }
        return this;
    }

    Master create() throws BrumaException {
        try {
            File file = new File(this.dbName + ".mst");
            this.mstExtension = ".mst";
            this.xrfExtension = ".xrf";
            if (file.exists()) {
                throw new BrumaException("create/master file : " + this.dbName + " already created");
            }
            this.reallocBuffers(this.FFI ? 0x100000 : Short.MAX_VALUE);
            this.raf = new RandomAccessFile(file, "rw");
            this.fc = this.raf.getChannel();
            this.xrf = null;
            this.lock = null;
            if (this.encoding.equals(GUESS_ISO_IBM_ENCODING)) {
                this.encoding = DEFAULT_ENCODING;
            }
            this.rba = new RecordByteArray(this.FFI, this.swapped, this.filler, this.shift);
            this.sysfile = this.reset().getMftype();
            if (this.sysfile != 0) {
                throw new IOException("create/unsupported master file type");
            }
            if (this.multiUser || !this.info.isInMemoryXrf()) {
                if (this.multiUser) {
                    this.lock = new Lock(this);
                }
                this.xrf = new XrfFile(this.dbName + this.xrfExtension, this.shift, this.swapped, true);
            } else {
                this.xrf = new BufferedXrfFile(this.dbName + this.xrfExtension, this.shift, this.swapped, true, 0, this.autoCommit);
            }
        }
        catch (IOException ioex) {
            try {
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new BrumaException(ioex);
        }
        return this;
    }

    public boolean delete() throws BrumaException {
        boolean ret = true;
        if (Master.exists(this.dbName)) {
            ret = ret && new File(this.dbName + this.mstExtension).delete();
            ret = ret && new File(this.dbName + this.xrfExtension).delete();
        }
        return ret;
    }

    @Override
    public Iterator<Record> iterator() {
        MstIterator iter = null;
        if (this.raf != null) {
            try {
                iter = new MstIterator();
            }
            catch (BrumaException zex) {
                iter = null;
            }
        }
        return iter;
    }

    static int convertToShift(int maxGigaSize) {
        int ret;
        assert (maxGigaSize >= 0 && maxGigaSize % 2 == 0);
        if (maxGigaSize == 0) {
            ret = 0;
        } else {
            ret = 1;
            for (int cap = 1; cap < maxGigaSize; cap *= 2) {
                ++ret;
            }
        }
        return ret;
    }

    static int convertToGigaSize(int pshift) {
        assert (pshift > 0);
        int ret = 2;
        if (pshift < 2) {
            ret = 0;
        } else {
            for (int pow = 2; pow < pshift; ++pow) {
                ret *= 2;
            }
        }
        return ret;
    }

    public int getGigaSize() {
        int ret = 2;
        if (this.shift < 2) {
            ret = 0;
        } else {
            for (int pow = 2; pow < this.shift; ++pow) {
                ret *= 2;
            }
        }
        return ret;
    }

    public int getMaxRecSize() throws BrumaException {
        int max = 0;
        for (Record rec : this) {
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            int recLen = rec.getRecordLength(this.encoding, this.FFI);
            max = Math.max(max, recLen);
        }
        return max;
    }

    public int getDataAlignment() {
        return this.filler;
    }

    public XrfFile getXrf() {
        return this.xrf;
    }

    public void close() throws BrumaException {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.xrf != null) {
                this.xrf.close();
                this.xrf = null;
            }
            if (this.lock != null) {
                this.lock.close();
                this.lock = null;
            }
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe.toString());
        }
    }

    public int getShift() {
        return this.shift;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public boolean isFFI() {
        return this.FFI;
    }

    public boolean isMultiuser() {
        return this.multiUser;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMasterName() {
        return this.dbName;
    }

    private Control reset() throws BrumaException {
        int nxtmfp = this.adjustFilePos(64) + 1;
        Control ctl = new Control(0, 1, 1, nxtmfp, 0, 0, 0, 0, 0);
        try {
            this.raf.setLength(0L);
            this.bBuffer.clear();
            this.bBuffer.limit(512);
            this.bBuffer.put(this.page, 0, 512);
            this.bBuffer.rewind();
            if (this.fc.write(this.bBuffer, 0L) != 512) {
                throw new BrumaException("write error");
            }
            this.writeControlRecord(ctl);
            if (this.xrf != null) {
                this.xrf.reset();
            }
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe.toString());
        }
        return ctl;
    }

    public void unlock() throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (this.lock == null) {
            throw new BrumaException("unlock/mono user mode");
        }
        this.lock.forceResetControlLocks();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Control getControlRecord() throws BrumaException {
        Control ctl;
        Lock.SegmentLock sl = null;
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        try {
            if (this.lock != null) {
                sl = this.lock.lockSegment(0L, 32, true);
            }
            this.bBuffer.clear();
            this.bBuffer.limit(32);
            if (this.fc.read(this.bBuffer, 0L) != 32) {
                throw new BrumaException("read error");
            }
            this.bBuffer.rewind();
            ctl = new Control(this.bBuffer.getInt(), this.bBuffer.getInt(), this.bBuffer.getInt(), this.bBuffer.getShort(), this.bBuffer.getShort(), this.bBuffer.getInt(), this.bBuffer.getInt(), this.bBuffer.getInt(), this.bBuffer.getInt());
            this.shift = ctl.getMftype() / 256;
            ctl.setMftype(ctl.getMftype() & 0xFF);
            assert (this.shift >= 0) : "invalid db shift[" + this.shift + "]";
            if (this.lock == null) return ctl;
        }
        catch (IOException ioe) {
            try {
                throw new BrumaException(ioe.toString());
            }
            catch (Throwable throwable) {
                if (this.lock == null) throw throwable;
                this.lock.releaseLockSegment(sl);
                throw throwable;
            }
        }
        this.lock.releaseLockSegment(sl);
        return ctl;
    }

    public Lock.RecordLock lockRecord(Record record) throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (record == null) {
            throw new BrumaException("lockRecord/null record");
        }
        if (this.lock == null) {
            throw new BrumaException("lockRecord/mono user mode");
        }
        if (record.getStatus() != Record.Status.ACTIVE) {
            throw new BrumaException("lockRecord/record status is not active: " + (Object)((Object)record.getStatus()));
        }
        Lock.RecordLock rlock = this.lock.lockRecord(record.getMfn());
        record.setLockStatus(Record.LockStatus.LOCKED);
        return rlock;
    }

    public Record getLockRecord(int mfn, Lock.RecordLock[] recLock) throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (mfn <= 0) {
            throw new BrumaException("getLockRecord/id[" + mfn + "] <= 0");
        }
        if (this.lock == null) {
            throw new BrumaException("getLockRecord/mono user mode");
        }
        if (recLock == null) {
            throw new BrumaException("getLockRecord/null record lock array");
        }
        recLock[0] = this.lock.lockRecord(mfn);
        Record rec = this.getRecord(mfn);
        rec.setLockStatus(Record.LockStatus.LOCKED);
        return rec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Record getRecord(int mfn) throws BrumaException {
        Record record = null;
        Record.Status[] recStatus = new Record.Status[1];
        Record.ActiveStatus[] actStatus = new Record.ActiveStatus[1];
        int size = 4 + (this.FFI ? 4 : 2);
        Lock.SegmentLock sl = null;
        boolean locked = false;
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (mfn <= 0) {
            throw new BrumaException("getRecord/id[" + mfn + "] <= 0");
        }
        try {
            long position = this.getMasterPosition(mfn, recStatus, actStatus);
            if (actStatus[0] == Record.ActiveStatus.NEW) {
                actStatus[0] = Record.ActiveStatus.NORMAL;
            }
            if (recStatus[0] == Record.Status.PHYDEL) {
                record = new Record(this.shift, this.filler);
                record.setStatus(Record.Status.PHYDEL);
                record.setActiveStatus(null);
                record.setLockStatus(null);
                record.setMfn(mfn);
            } else {
                if (this.lock != null) {
                    sl = this.lock.lockSegment(position, 8, true);
                }
                this.bBuffer.clear();
                this.bBuffer.limit(size);
                if (this.fc.read(this.bBuffer, position) != size) {
                    throw new BrumaException("read/1 error");
                }
                this.bBuffer.rewind();
                int auxMfn = this.bBuffer.getInt();
                int mfrl = this.readInt(this.bBuffer);
                int aMfrl = Math.abs(mfrl);
                if (aMfrl < this.neverSplit) {
                    throw new BrumaException("mfrl[" + aMfrl + "] < " + this.neverSplit);
                }
                this.reallocBuffers(aMfrl);
                if (mfn != auxMfn) throw new BrumaException("getRecord/MST_FIL_BAD/[mfn=" + mfn + " != " + auxMfn + "]");
                if (mfrl < 0) {
                    locked = true;
                    mfrl *= -1;
                }
                this.bBuffer.clear();
                this.bBuffer.limit(mfrl);
                if (this.fc.read(this.bBuffer, position) != mfrl) {
                    throw new BrumaException("read/2 error");
                }
                this.bBuffer.rewind();
                this.bBuffer.get(this.buffer, 0, mfrl);
                record = this.rba.fromByteArray(this.buffer, this.encoding);
                record.setStatus(recStatus[0]);
                if (recStatus[0] == Record.Status.LOGDEL) {
                    record.setLockStatus(null);
                    record.setActiveStatus(null);
                } else {
                    if (locked) {
                        record.setLockStatus(Record.LockStatus.LOCKED);
                    } else {
                        record.setLockStatus(Record.LockStatus.NORMAL);
                    }
                    record.setActiveStatus(actStatus[0]);
                }
            }
            if (this.lock == null) return record;
        }
        catch (Exception ex) {
            try {
                throw new BrumaException("getRecord/" + ex);
            }
            catch (Throwable throwable) {
                if (this.lock == null) throw throwable;
                this.lock.releaseLockSegment(sl);
                throw throwable;
            }
        }
        this.lock.releaseLockSegment(sl);
        return record;
    }

    public void unlockRecord(Lock.RecordLock recLock) throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (recLock == null) {
            throw new BrumaException("unlockRecord/null lock");
        }
        if (this.lock == null) {
            throw new BrumaException("unlockRecord/mono user mode");
        }
        this.lock.unlockRecord(recLock);
    }

    public void forceUnlockRecord(int mfn) throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("master file is not opened");
        }
        if (this.lock == null) {
            throw new BrumaException("forceUnlockRecord/mono user mode");
        }
        if (mfn <= 0) {
            throw new BrumaException("forceUnlockRecord/mfn[" + mfn + "] < = 0");
        }
        this.lock.forceUnlockRecord(mfn);
    }

    private int readInt(ByteBuffer buffer) throws IOException {
        assert (buffer != null) : "readInt/null ByteBuffer";
        return this.FFI ? buffer.getInt() : (int)buffer.getShort();
    }

    public long getMasterPosition(int mfn, Record.Status[] recStatus, Record.ActiveStatus[] activeStatus) throws BrumaException {
        long pos;
        assert (mfn > 0) : "getMasterPosition/mfn[" + mfn + "] <= 0";
        assert (recStatus != null) : "getMasterPosition/null record status";
        assert (activeStatus != null) : "getMasterPosition/null record active status";
        if (this.sysfile == 0) {
            XrfFile.XrfInfo xinfo = this.xrf.readXrfInfo(mfn);
            long auxPos = Math.abs(xinfo.getBlock()) - 1;
            pos = (auxPos *= 512L) + (long)(xinfo.getOffset() & 0x1FF);
            recStatus[0] = xinfo.getStatus();
            activeStatus[0] = xinfo.getActStatus();
        } else {
            pos = mfn * 512;
            recStatus[0] = Record.Status.ACTIVE;
            activeStatus[0] = Record.ActiveStatus.NORMAL;
        }
        assert (pos >= 0L) : "mst file position[" + pos + "] < 0";
        return pos;
    }

    private Leader readLeader(long position) throws BrumaException {
        assert (position >= 0L) : "readLeader/position[" + position + "] < 0";
        Leader ret = new Leader();
        try {
            this.bBuffer.clear();
            this.bBuffer.limit(26);
            if (this.fc.read(this.bBuffer, position) != 26) {
                throw new BrumaException("read error");
            }
            this.bBuffer.rewind();
            ret.setMfn(this.bBuffer.getInt());
            ret.setMfrl(Math.abs(this.readInt(this.bBuffer)));
            this.reallocBuffers(ret.getMfrl());
            if (!this.FFI && this.filler != 0) {
                this.bBuffer.getShort();
            }
            ret.setMfbwb(this.bBuffer.getInt());
            ret.setMfbwp(this.bBuffer.getShort());
            if (this.FFI && this.filler != 0) {
                this.bBuffer.getShort();
            }
            ret.setBase(this.readInt(this.bBuffer));
            ret.setNvf(this.bBuffer.getShort());
            Record.Status status = this.bBuffer.getShort() == 0 ? Record.Status.ACTIVE : Record.Status.LOGDEL;
            ret.setStatus(status);
        }
        catch (IOException ioex) {
            throw new BrumaException(ioex.toString());
        }
        return ret;
    }

    private void writeControlRecord(Control ctl) throws BrumaException {
        assert (ctl != null) : "writeControlRecord/null control";
        int mftype = this.shift * 256 + ctl.getMftype();
        try {
            this.bBuffer.clear();
            this.bBuffer.limit(32);
            this.bBuffer.putInt(ctl.getCtlmfn());
            this.bBuffer.putInt(ctl.getNxtmfn());
            this.bBuffer.putInt(ctl.getNxtmfb());
            this.bBuffer.putShort((short)ctl.getNxtmfp());
            this.bBuffer.putShort((short)mftype);
            this.bBuffer.putInt(ctl.getReccnt());
            this.bBuffer.putInt(ctl.getMfcxx1());
            this.bBuffer.putInt(ctl.getMfcxx2());
            this.bBuffer.putInt(ctl.getMfcxx3());
            this.bBuffer.rewind();
            if (this.fc.write(this.bBuffer, 0L) != 32) {
                throw new BrumaException("writeControlRecord/write error");
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("writeControlRecord/" + ioe.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeRecord(Control ctl, Record record, int block, int offset, boolean wasNew) throws BrumaException {
        assert (ctl != null) : "writeRecord2/null control";
        assert (record != null) : "writeRecord2/null record";
        assert (block > 0) : "writeRecord2/block[" + block + "] <= 0";
        assert (offset >= 0) : "writeRecord2/offset[" + offset + "] < 0";
        boolean writeAtTheEnd = block == ctl.getNxtmfb() && offset == ctl.getNxtmfp() - 1;
        Record.Status status = record.getStatus();
        Record.ActiveStatus actStatus = record.getActiveStatus();
        int rem = 0;
        Lock.SegmentLock sl = null;
        try {
            int recLen;
            Leader leaders = record.getLeader(this.encoding, this.FFI);
            if (leaders.getMfn() > ctl.getNxtmfn()) {
                throw new BrumaException("id[" + leaders.getMfn() + "] > ctl.nxtmfn[" + ctl.getNxtmfn() + "]");
            }
            byte[] rec = this.rba.toByteArray(record, this.encoding);
            if (rec.length != (recLen = leaders.getMfrl())) {
                throw new BrumaException("rec.length[" + rec.length + "] != leaders.mfrl[" + recLen + "]");
            }
            if (recLen < this.neverSplit) {
                throw new BrumaException("mfrl[" + recLen + "] <" + this.neverSplit);
            }
            this.reallocBuffers(recLen);
            long filepos = (long)(block - 1) * 512L + (long)offset;
            assert (filepos > 0L) : "filepos=" + filepos;
            this.bBuffer.clear();
            this.bBuffer.limit(recLen);
            this.bBuffer.put(rec);
            this.bBuffer.rewind();
            if (this.lock != null) {
                sl = this.lock.lockSegment(filepos, 8, false);
            }
            if (this.fc.write(this.bBuffer, filepos) != recLen) {
                throw new BrumaException("write/1 error");
            }
            if (writeAtTheEnd) {
                rem = 512 - (int)((filepos + (long)rec.length) % 512L);
                assert (rem > 0 && rem <= 512) : "rem=" + rem;
                if (rem != 512) {
                    this.bBuffer.clear();
                    this.bBuffer.limit(rem);
                    this.bBuffer.put(this.page, 0, rem);
                    this.bBuffer.rewind();
                    if (this.fc.write(this.bBuffer, filepos + (long)recLen) != rem) {
                        throw new BrumaException("write/2 error");
                    }
                }
                ctl.setNxtmfb((int)((filepos += (long)recLen) / 512L) + 1);
                int nxtmfp = (int)(filepos % 512L) + 1;
                if (nxtmfp >= this.neverSplitRec) {
                    ctl.setNxtmfb(ctl.getNxtmfb() + 1);
                    nxtmfp = 1;
                }
                ctl.setNxtmfp(nxtmfp);
                this.writeControlRecord(ctl);
            }
            if (this.lock != null) {
                this.lock.releaseLockSegment(sl);
                sl = null;
            }
            if (status == Record.Status.ACTIVE) {
                if (actStatus == Record.ActiveStatus.NEW) {
                    XrfFile xrfFile = this.xrf;
                    xrfFile.getClass();
                    this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, leaders.getMfn(), block, offset + 1024, status, actStatus));
                } else {
                    XrfFile xrfFile = this.xrf;
                    xrfFile.getClass();
                    this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, leaders.getMfn(), block, offset + 512, status, actStatus));
                }
            } else if (status == Record.Status.LOGDEL) {
                if (wasNew) {
                    XrfFile xrfFile = this.xrf;
                    xrfFile.getClass();
                    this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, leaders.getMfn(), -block, offset + 1024, status, actStatus));
                } else {
                    XrfFile xrfFile = this.xrf;
                    xrfFile.getClass();
                    this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, leaders.getMfn(), -block, offset + 512, status, actStatus));
                }
            } else {
                XrfFile xrfFile = this.xrf;
                xrfFile.getClass();
                this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, leaders.getMfn(), -1, 0, status, actStatus));
            }
            if (this.lock == null || sl == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new BrumaException(ioe.toString());
            }
            catch (Throwable throwable) {
                if (this.lock == null || sl == null) throw throwable;
                this.lock.releaseLockSegment(sl);
                throw throwable;
            }
        }
        this.lock.releaseLockSegment(sl);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createNDeletedRecords(int recNum) throws BrumaException {
        assert (recNum > 0);
        Control ctl = null;
        int mfn = 0;
        Lock.SegmentLock sl = null;
        try {
            if (this.lock != null) {
                sl = this.lock.lockSegment(0L, 32, false);
            }
            ctl = this.getControlRecord();
            mfn = ctl.getNxtmfn();
            for (int counter = 0; counter < recNum; ++counter) {
                XrfFile xrfFile = this.xrf;
                xrfFile.getClass();
                this.xrf.writeXrfInfo(new XrfFile.XrfInfo(xrfFile, mfn, -1, 0, Record.Status.PHYDEL, null));
                ctl.setNxtmfn(++mfn);
            }
            this.writeControlRecord(ctl);
            if (sl == null) return;
        }
        catch (Throwable throwable) {
            if (sl == null) throw throwable;
            this.lock.releaseLockSegment(sl);
            throw throwable;
        }
        this.lock.releaseLockSegment(sl);
    }

    private int newRecord(Control ctl, Record record) throws BrumaException {
        assert (ctl != null) : "newRecord/null control";
        assert (record != null) : "newRecord/null record";
        int nxtmfn = ctl.getNxtmfn();
        int mfn = record.getMfn();
        assert (mfn == 0 || mfn >= nxtmfn) : "mfn[" + mfn + "] < " + nxtmfn;
        if (mfn == 0) {
            mfn = nxtmfn;
            record.setMfn(nxtmfn);
        }
        record.setStatus(Record.Status.ACTIVE);
        record.setActiveStatus(Record.ActiveStatus.NEW);
        record.setBlockNumber(0);
        record.setBlockPos(0);
        int dif = mfn - nxtmfn;
        if (dif > 0) {
            this.createNDeletedRecords(dif);
        }
        ctl.setNxtmfn(mfn + 1);
        this.writeRecord(ctl, record, ctl.getNxtmfb(), ctl.getNxtmfp() - 1, false);
        return mfn;
    }

    private int updateRecord(Control ctl, Record record) throws BrumaException {
        assert (ctl != null) : "updateRecord/null control";
        assert (record != null) : "updateRecord/null record";
        Record.Status[] status = new Record.Status[1];
        Record.ActiveStatus[] actStatus = new Record.ActiveStatus[1];
        int mfn = record.getMfn();
        long fpos = this.getMasterPosition(mfn, status, actStatus);
        if (status[0] != Record.Status.ACTIVE) {
            throw new BrumaException("updateRecord/record is deleted");
        }
        int bl = (int)(fpos / 512L + 1L);
        int pos = (int)(fpos % 512L);
        Leader leader = this.readLeader(fpos);
        boolean wasNew = false;
        record.setBlockNumber(leader.getMfbwb());
        record.setBlockPos(leader.getMfbwp());
        if (record.getStatus() == Record.Status.ACTIVE) {
            if (actStatus[0] == Record.ActiveStatus.PENDING) {
                record.setActiveStatus(Record.ActiveStatus.PENDING);
            } else if (actStatus[0] == Record.ActiveStatus.NEW) {
                record.setActiveStatus(Record.ActiveStatus.NEW);
                wasNew = true;
            } else {
                record.setActiveStatus(Record.ActiveStatus.PENDING);
            }
        } else if (actStatus[0] == Record.ActiveStatus.NEW) {
            wasNew = true;
        }
        if (leader.getMfrl() < record.getRecordLength(this.encoding, this.FFI)) {
            this.writeRecord(ctl, record, ctl.getNxtmfb(), ctl.getNxtmfp() - 1, wasNew);
        } else {
            this.writeRecord(ctl, record, bl, pos, wasNew);
        }
        return mfn;
    }

    private int adjustFilePos(int fpos) {
        assert (fpos > 0);
        int nfpos = fpos;
        if (this.shift > 0) {
            int vtot = 1;
            for (int pow = 1; pow <= this.shift; ++pow) {
                vtot *= 2;
            }
            --vtot;
            while ((nfpos & vtot) != 0) {
                ++nfpos;
            }
        }
        return nfpos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeRecord(Record record) throws BrumaException {
        int mfn;
        block13: {
            boolean rl;
            Lock.RecordLock recLock;
            block14: {
                recLock = null;
                Lock.SegmentLock sl = null;
                boolean del = false;
                rl = false;
                if (this.raf == null) {
                    throw new BrumaException("writeRecord/master file is not opened");
                }
                if (record == null) {
                    throw new BrumaException("writeRecord/null record");
                }
                record.setShift(this.shift);
                record.setFiller(this.filler);
                int len = record.getRecordLength(this.encoding, this.FFI);
                this.reallocBuffers(len);
                mfn = record.getMfn();
                if (mfn < 0) {
                    throw new BrumaException("writeRecord/id out of range < 0");
                }
                if (this.lock != null) {
                    this.lock.setDataEntryLock();
                    del = true;
                    sl = this.lock.lockSegment(0L, 32, false);
                }
                try {
                    Control ctl = this.getControlRecord();
                    int nxtmfn = ctl.getNxtmfn();
                    if (mfn == 0 || mfn >= nxtmfn) {
                        mfn = this.newRecord(ctl, record);
                    } else {
                        if (this.lock != null) {
                            recLock = this.lock.lockRecord(mfn);
                            rl = true;
                        }
                        mfn = this.updateRecord(ctl, record);
                    }
                    if (this.lock == null || !del) break block13;
                    if (sl == null) break block14;
                }
                catch (Throwable throwable) {
                    if (this.lock != null && del) {
                        if (sl != null) {
                            this.lock.releaseLockSegment(sl);
                        }
                        if (rl) {
                            this.lock.unlockRecord(recLock);
                        }
                        this.lock.resetDataEntryLock();
                    }
                    throw throwable;
                }
                this.lock.releaseLockSegment(sl);
            }
            if (rl) {
                this.lock.unlockRecord(recLock);
            }
            this.lock.resetDataEntryLock();
        }
        return mfn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int mfn) throws BrumaException {
        if (this.raf == null) {
            throw new BrumaException("deleteRecord/master file is not opened");
        }
        if (mfn <= 0) {
            throw new BrumaException("deleteRecord/mfn <= 0");
        }
        Lock.RecordLock[] recLock = null;
        boolean delock = false;
        boolean rlock = false;
        try {
            Record rec;
            if (this.lock == null) {
                rec = this.getRecord(mfn);
            } else {
                recLock = new Lock.RecordLock[1];
                this.lock.setDataEntryLock();
                delock = true;
                rec = this.getLockRecord(mfn, recLock);
                rlock = true;
            }
            if (rec.getStatus() != Record.Status.ACTIVE) {
                throw new BrumaException("deleteRecord/record status is not active: " + (Object)((Object)rec.getStatus()));
            }
            rec.setStatus(Record.Status.LOGDEL);
            rec.setActiveStatus(null);
            this.writeRecord(rec);
        }
        finally {
            if (this.lock != null) {
                if (rlock) {
                    this.unlockRecord(recLock[0]);
                }
                if (delock) {
                    this.lock.resetDataEntryLock();
                }
            }
        }
    }

    public List<Integer> regExpSearch(String expression, int maxHits) throws BrumaException {
        if (expression == null) {
            throw new BrumaException("null regular expression");
        }
        if (maxHits < 1) {
            throw new BrumaException("maxHits <= 0");
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Matcher mat = Pattern.compile(expression).matcher("");
        int curHits = 0;
        block0: for (Record rec : this) {
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            for (Field fld : rec) {
                mat.reset(fld.getContent());
                if (!mat.find()) continue;
                if (++curHits > maxHits) continue block0;
                ret.add(rec.getMfn());
            }
        }
        return ret;
    }

    public Record newRecord() throws BrumaException {
        return new Record(this.shift, this.filler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MstIterator
    implements Iterator<Record> {
        private final int lastMfn;
        private int curMfn;
        private Record rec;

        private MstIterator() throws BrumaException {
            this.lastMfn = Master.this.getControlRecord().getNxtmfn() - 1;
            this.curMfn = 0;
        }

        @Override
        public boolean hasNext() {
            return this.curMfn + 1 <= this.lastMfn;
        }

        @Override
        public Record next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.rec = Master.this.getRecord(++this.curMfn);
            }
            catch (BrumaException zex) {
                this.rec = null;
                zex.printStackTrace();
            }
            return this.rec;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

