/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Master;
import bruma.master.MasterPlatformInfo;
import bruma.utils.ISO8859OrIBM850;
import bruma.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class MasterFactory {
    public static final String VERSION = "1.0";
    private final MasterPlatformInfo info;

    private MasterFactory(String dbName) throws BrumaException {
        assert (dbName != null);
        this.info = new MasterPlatformInfo(dbName);
    }

    public static MasterFactory getInstance(File dbProfile) throws IOException, BrumaException {
        if (dbProfile == null) {
            throw new IllegalArgumentException();
        }
        Properties props = new Properties();
        BufferedReader reader = new BufferedReader(new FileReader(dbProfile));
        props.load(reader);
        String dbName = props.getProperty("DBNAME");
        if (dbName == null) {
            throw new IOException("null database name");
        }
        MasterFactory factory = new MasterFactory(Util.changeFileExtension(dbName, null));
        String prop = props.getProperty("ENCODING");
        if (prop != null) {
            factory.setEncoding(prop);
        }
        if ((prop = props.getProperty("SWAPPED")) != null) {
            factory.setSwapped(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("FFI")) != null) {
            factory.setFFI(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("MAXGIGASIZE")) != null) {
            factory.setMaxGigaSize(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("DATAALIGNMENT")) != null) {
            factory.setDataAlignment(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("INMEMORYXRF")) != null) {
            factory.setInMemoryXrf(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("XRFWRITECOMMIT")) != null) {
            factory.setXrfWriteCommit(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("MULTIUSER")) != null) {
            factory.setMultiuser(Boolean.parseBoolean(prop));
        }
        reader.close();
        return factory;
    }

    public static MasterFactory getInstance(String dbName) throws BrumaException {
        if (dbName == null) {
            throw new IllegalArgumentException();
        }
        return new MasterFactory(Util.changeFileExtension(dbName, null));
    }

    public MasterFactory setEncoding(String encoding) throws BrumaException {
        if (encoding == null) {
            throw new BrumaException("null encoding");
        }
        String encod = encoding;
        if (encod.equals("ISO-8859-1 or IBM850")) {
            ISO8859OrIBM850 guess = new ISO8859OrIBM850(this.info.getMstName(), true);
            String encName = guess.guessEncoding();
            encod = encName == null ? "ISO-8859-1" : encName;
        }
        this.info.setEncoding(encod);
        return this;
    }

    public MasterFactory setSwapped(boolean swapped) {
        this.info.setSwapped(swapped);
        return this;
    }

    public MasterFactory setFFI(boolean ffi) {
        this.info.setFfi(ffi);
        return this;
    }

    public MasterFactory setMaxGigaSize(int size) {
        if (size < 0 || size % 2 != 0) {
            throw new IllegalArgumentException("size is negative or not multiple of 2");
        }
        this.info.setShift(Master.convertToShift(size));
        return this;
    }

    public int getDataAlignment() {
        return this.info.getDataAlignment();
    }

    public MasterFactory setDataAlignment(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("val is negative");
        }
        this.info.setDataAlignment(val);
        return this;
    }

    public boolean isInMemoryXrf() {
        return this.info.isInMemoryXrf();
    }

    public MasterFactory setInMemoryXrf(boolean opt) {
        this.info.setInMemoryXrf(opt);
        return this;
    }

    public boolean isXrfWriteCommit() {
        return this.info.isXrfWriteCommit();
    }

    public MasterFactory setXrfWriteCommit(boolean opt) {
        this.info.setXrfWriteCommit(opt);
        return this;
    }

    public boolean isMultiuser() {
        return this.info.isMultiuser();
    }

    public MasterFactory setMultiuser(boolean opt) {
        if (opt) {
            throw new IllegalArgumentException("feature not implemented");
        }
        return this;
    }

    public MasterFactory asAnotherMaster(Master other) throws BrumaException {
        if (other == null) {
            throw new BrumaException("null master");
        }
        this.setDataAlignment(other.getDataAlignment());
        this.setEncoding(other.getEncoding());
        this.setFFI(other.isFFI());
        this.setMaxGigaSize(other.getGigaSize());
        this.setMultiuser(other.isMultiuser());
        this.setSwapped(other.isSwapped());
        return this;
    }

    public Master open() throws BrumaException {
        return new Master(this.info).open();
    }

    public Master create() throws BrumaException {
        return new Master(this.info).create();
    }

    public boolean exists() throws BrumaException {
        return Master.exists(this.info.getMstName());
    }

    public Master forceCreate() throws BrumaException {
        Master mst = new Master(this.info);
        mst.delete();
        return mst.create();
    }
}

