/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.master.Master;
import java.nio.ByteOrder;

public class MasterPlatformInfo {
    private final String mstName;
    private String encoding;
    private boolean swapped;
    private boolean ffi;
    private int shift;
    private boolean multiuser;
    private int dataAlignment;
    private boolean inMemoryXrf;
    private boolean xrfWriteCommit;

    MasterPlatformInfo(String mstName) {
        assert (mstName != null);
        this.mstName = mstName;
        this.encoding = "ISO-8859-1 or IBM850";
        this.swapped = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        this.ffi = false;
        this.shift = 0;
        this.multiuser = false;
        this.dataAlignment = System.getProperty("os.name").startsWith("Win") ? 0 : 2;
        this.inMemoryXrf = true;
        this.xrfWriteCommit = false;
    }

    public String getMstName() {
        return this.mstName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String encoding) {
        assert (encoding != null);
        this.encoding = encoding;
    }

    public boolean isFfi() {
        return this.ffi;
    }

    void setFfi(boolean ffi) {
        this.ffi = ffi;
        if (ffi) {
            if (this.shift == 0) {
                this.shift = 2;
            }
        } else {
            this.shift = 0;
        }
    }

    public boolean isMultiuser() {
        return this.multiuser;
    }

    void setMultiuser(boolean multiuser) {
        this.multiuser = multiuser;
    }

    public int getShift() {
        return this.shift;
    }

    public int getMaxGigaSize() {
        return Master.convertToGigaSize(this.shift);
    }

    void setShift(int shift) {
        assert (shift >= 0);
        this.shift = shift;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    void setSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    public int getDataAlignment() {
        return this.dataAlignment;
    }

    void setDataAlignment(int val) {
        assert (val >= 0 && val % 2 == 0);
        this.dataAlignment = val;
    }

    public boolean isInMemoryXrf() {
        return this.inMemoryXrf;
    }

    void setInMemoryXrf(boolean opt) {
        this.inMemoryXrf = opt;
    }

    public boolean isXrfWriteCommit() {
        return this.xrfWriteCommit;
    }

    void setXrfWriteCommit(boolean opt) {
        this.xrfWriteCommit = opt;
    }
}

