/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.DirEntry;
import bruma.master.Field;
import bruma.master.Leader;
import bruma.master.Subfield;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record
implements Iterable<Field> {
    public static final int DEFAULT_SHIFT = 3;
    public static final int ISIS_STANDARD_SHIFT = 0;
    private final List<Field> fields;
    private final String separator;
    private int filler;
    private int shift;
    private Status status;
    private ActiveStatus actStatus;
    private LockStatus lckStatus;
    private int mfn;
    private int mfbwb;
    private int mfbwp;
    private Map<Integer, String> tags;

    public Record() throws BrumaException {
        this(0, !System.getProperty("os.name").startsWith("Win") ? 2 : 0);
    }

    public Record(int shift, int filler) throws BrumaException {
        if (shift < 0) {
            throw new BrumaException("illegal shift[" + shift + "]");
        }
        if (filler < 0) {
            throw new BrumaException("illegal shift[" + filler + "]");
        }
        this.shift = shift;
        this.fields = new ArrayList<Field>(50);
        this.status = Status.ACTIVE;
        this.actStatus = ActiveStatus.NORMAL;
        this.lckStatus = LockStatus.NORMAL;
        this.mfn = 0;
        this.mfbwb = 0;
        this.mfbwp = 0;
        this.filler = filler;
        this.separator = System.getProperty("line.separator");
        this.tags = null;
    }

    public static Record fromString(String xml) throws BrumaException {
        return Record.fromString(xml, 0, !System.getProperty("os.name").startsWith("Win") ? 2 : 0);
    }

    public static Record fromString(String xml, int shift, int filler) throws BrumaException {
        if (xml == null) {
            throw new IllegalArgumentException("null xml");
        }
        Matcher openRecMat = Pattern.compile("(?i)\\s*<\\s*record(\\s+mfn='\\d+')?(\\s+nvf='\\d+')?(\\s+status='(.+?)')?\\s*>\\s*").matcher(xml);
        Matcher closeRecMat = Pattern.compile("(?i)\\s*<\\s*/\\s*record\\s*>\\s*").matcher(xml);
        Matcher fldMat = Pattern.compile("<\\s*(\\d+)\\s*>((?s)(.*?))<\\s*/\\s*\\1\\s*>").matcher(xml);
        Matcher tagMat = Pattern.compile("<\\s*(\\d+)\\s*>").matcher("");
        Record rec = new Record(shift, filler);
        int len = xml.length();
        int curPos = 0;
        boolean hasOpenRec = false;
        if (openRecMat.find(curPos)) {
            curPos = openRecMat.end();
            hasOpenRec = true;
        }
        while (true) {
            char ch;
            if (curPos < len && ((ch = xml.charAt(curPos)) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                ++curPos;
                continue;
            }
            if (curPos == len) {
                if (!hasOpenRec) break;
                throw new BrumaException("parse error: missing </record>");
            }
            if (!fldMat.find(curPos)) break;
            if (fldMat.start() > curPos) {
                throw new BrumaException("parse error pos:" + curPos);
            }
            int tag = Integer.parseInt(fldMat.group(1));
            tagMat.reset(fldMat.group(2));
            if (tagMat.find()) {
                throw new BrumaException("parse error:" + fldMat.group(2));
            }
            rec.addField(tag, fldMat.group(3));
            curPos = fldMat.end();
        }
        if (closeRecMat.find(curPos)) {
            if (!hasOpenRec) {
                throw new BrumaException("parse error: missing <record>");
            }
            curPos = closeRecMat.end();
            if (curPos != len) {
                throw new BrumaException("parse error pos:" + curPos);
            }
        }
        return rec;
    }

    public int getRecordLength(String encoding, boolean isFFI) throws BrumaException {
        assert (encoding != null);
        int size = this.fields.size();
        int ret = (isFFI ? 22 : 18) + this.filler + size * (isFFI ? 10 + this.filler : 6);
        try {
            for (Field field : this.fields) {
                ret += field.getContent().getBytes(encoding).length;
            }
        }
        catch (Exception ex) {
            throw new BrumaException(ex);
        }
        return ret + this.getFillSize(ret);
    }

    int getFillSize(int recordLength) {
        int addrBegin = this.shift == 0 ? 2 : 1 << this.shift;
        return recordLength % addrBegin == 0 ? 0 : addrBegin - recordLength % addrBegin;
    }

    int getBlockNumber() {
        return this.mfbwb;
    }

    void setBlockNumber(int mfbwb) {
        assert (mfbwb >= 0);
        this.mfbwb = mfbwb;
    }

    int getBlockPos() {
        return this.mfbwp;
    }

    void setBlockPos(int mfbwp) {
        assert (mfbwp >= 0);
        this.mfbwp = mfbwp;
    }

    public int getMfn() {
        return this.mfn;
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status stat) {
        this.status = stat;
    }

    public ActiveStatus getActiveStatus() {
        return this.actStatus;
    }

    void setActiveStatus(ActiveStatus stat) {
        this.actStatus = stat;
    }

    public LockStatus getLockStatus() {
        return this.lckStatus;
    }

    void setLockStatus(LockStatus stat) {
        this.lckStatus = stat;
    }

    public void setShift(int shift) {
        assert (shift >= 0);
        this.shift = shift;
    }

    public void setFiller(int filler) {
        assert (filler >= 0);
        this.filler = filler;
    }

    public List<Integer> getRecordTags() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Field field : this.fields) {
            ret.add(field.getId());
        }
        return ret;
    }

    public List<String> getRecordTagString() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Field field : this.fields) {
            ret.add(field.getTagStr());
        }
        return ret;
    }

    public int getNvf() {
        return this.fields.size();
    }

    public Leader getLeader(String encoding, boolean isFFI) throws BrumaException {
        int size = this.fields.size();
        int recLen = this.getRecordLength(encoding, isFFI);
        int auxBase = (isFFI ? 22 : 18) + this.filler + size * (isFFI ? 10 + this.filler : 6);
        return new Leader(this.mfn, recLen + this.getFillSize(recLen), this.mfbwb, this.mfbwp, auxBase, size, this.status);
    }

    public DirEntry getDirectoryEntry(int pos) throws BrumaException {
        if (pos < 0 || pos >= this.fields.size()) {
            throw new BrumaException("position[" + pos + "] is out of range [0, " + (this.fields.size() - 1) + "]");
        }
        Field field = this.fields.get(pos);
        return new DirEntry(field.getId(), field.getContent().length());
    }

    public int getFieldOccs(int tag) throws BrumaException {
        if (tag <= 0) {
            throw new BrumaException("parameter out of range tag[" + tag + "] <= 0");
        }
        int len = this.fields.size();
        int occ = 0;
        for (int pos = 0; pos < len; ++pos) {
            Field field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getId() != tag) continue;
            ++occ;
        }
        return occ;
    }

    public Field getField(int pos) throws BrumaException {
        if (pos < 0 || pos >= this.fields.size()) {
            throw new BrumaException("parameter out of range [0, " + (this.fields.size() - 1) + "]");
        }
        return this.fields.get(pos);
    }

    public Field getField(int tag, int occ) throws BrumaException {
        int len = this.fields.size();
        Field ret = null;
        int auxOcc = 0;
        if (tag <= 0) {
            throw new BrumaException("parameter out of range tag[" + tag + "] <= 0");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            Field field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getId() != tag || ++auxOcc != occ) continue;
            ret = field;
            break;
        }
        return ret;
    }

    public Field getField(String tagStr, int occ) throws BrumaException {
        int len = this.fields.size();
        Field ret = null;
        int auxOcc = 0;
        if (this.tags == null) {
            throw new BrumaException("tag strings are not available to this record");
        }
        if (tagStr == null) {
            throw new BrumaException("null tagStr");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            Field field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (!field.getTagStr().equals(tagStr) || ++auxOcc != occ) continue;
            ret = field;
            break;
        }
        return ret;
    }

    public List<Field> getFieldList(int tag) throws BrumaException {
        ArrayList<Field> ret = new ArrayList<Field>();
        int len = this.fields.size();
        if (tag <= 0) {
            throw new BrumaException("parameter out of range tag[" + tag + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            Field field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getId() != tag) continue;
            ret.add(field);
        }
        return ret;
    }

    public List<Field> getFieldList(String tagStr) throws BrumaException {
        ArrayList<Field> ret = new ArrayList<Field>();
        int len = this.fields.size();
        if (this.tags == null) {
            throw new BrumaException("tag strings are not available to this record");
        }
        if (tagStr == null) {
            throw new BrumaException("null tagStr");
        }
        for (int pos = 0; pos < len; ++pos) {
            Field field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (!field.getTagStr().equals(tagStr)) continue;
            ret.add(field);
        }
        return ret;
    }

    public String getFieldWithTag(int pos) throws BrumaException {
        if (pos < 0 || pos >= this.fields.size()) {
            throw new BrumaException("parameter out of range [0, " + (this.fields.size() - 1) + "]");
        }
        Field field = this.fields.get(pos);
        return field == null ? null : field.toString();
    }

    public String getFieldXML(int pos) throws BrumaException {
        if (pos < 0 || pos >= this.fields.size()) {
            throw new BrumaException("parameter out of range [0, " + (this.fields.size() - 1) + "]");
        }
        Field field = this.fields.get(pos);
        return field == null ? null : field.toXML();
    }

    public String getFieldWithTag(int tag, int occ) throws BrumaException {
        int len = this.fields.size();
        Field field = null;
        int auxOcc = 0;
        if (tag <= 0) {
            throw new BrumaException("parameter out of range tag[" + tag + "] <= 0");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getId() == tag && ++auxOcc == occ) break;
        }
        return field == null ? null : field.toString();
    }

    public String getFieldWithTag(String tagStr, int occ) throws BrumaException {
        int len = this.fields.size();
        Field field = null;
        int auxOcc = 0;
        if (this.tags == null) {
            throw new BrumaException("tag strings are not available to this record");
        }
        if (tagStr == null) {
            throw new BrumaException("null tagStr");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getTagStr().equals(tagStr) && ++auxOcc == occ) break;
        }
        return field == null ? null : field.toString();
    }

    public String getFieldXML(int tag, int occ) throws BrumaException {
        int len = this.fields.size();
        Field field = null;
        int auxOcc = 0;
        if (tag <= 0) {
            throw new BrumaException("parameter out of range tag[" + tag + "] <= 0");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getId() == tag && ++auxOcc == occ) break;
        }
        return field == null ? null : field.toXML();
    }

    public String getFieldXML(String tagStr, int occ) throws BrumaException {
        int len = this.fields.size();
        Field field = null;
        int auxOcc = 0;
        if (tagStr == null) {
            throw new BrumaException("null tagStr");
        }
        if (occ <= 0) {
            throw new BrumaException("parameter out of range occ[" + occ + "] <= 0");
        }
        for (int pos = 0; pos < len; ++pos) {
            field = this.fields.get(pos);
            if (field == null) {
                throw new BrumaException("null field");
            }
            if (field.getTagStr().equals(tagStr) && ++auxOcc == occ) break;
        }
        return field == null ? null : field.toXML();
    }

    public List<Field> getFields() throws BrumaException {
        return this.fields;
    }

    public String getFieldsWithTags() throws BrumaException {
        StringBuilder buf = new StringBuilder();
        int len = this.fields.size();
        for (int counter = 0; counter < len; ++counter) {
            String fld = this.getFieldWithTag(counter);
            assert (fld != null);
            buf.append(fld);
            buf.append(this.separator);
        }
        return buf.toString();
    }

    public String getFieldsXML() throws BrumaException {
        StringBuilder buf = new StringBuilder();
        int len = this.fields.size();
        for (int counter = 0; counter < len; ++counter) {
            String fld = this.getFieldXML(counter);
            assert (fld != null);
            buf.append(fld);
            buf.append(this.separator);
        }
        return buf.toString();
    }

    public Record addField(Field field) throws BrumaException {
        if (field == null) {
            throw new BrumaException("null field");
        }
        this.fields.add(field);
        return this;
    }

    public Record addField(int tag, String field) throws BrumaException {
        if (tag <= 0 || tag > 99999) {
            throw new BrumaException("tag[" + tag + "] parameter out of range[1,9999]");
        }
        if (field == null) {
            throw new BrumaException("null field content");
        }
        this.fields.add(new Field(tag, field));
        return this;
    }

    public Record addField(String strId, String field) throws BrumaException {
        if (strId == null) {
            throw new BrumaException("null strId");
        }
        if (field == null) {
            throw new BrumaException("null field content");
        }
        this.fields.add(new Field(strId, field));
        return this;
    }

    public Record addFields(List<Field> fields) throws BrumaException {
        if (fields == null) {
            throw new BrumaException("null field list");
        }
        for (Field field : fields) {
            if (field == null) continue;
            this.addField(field.getId(), field.getContent());
        }
        return this;
    }

    public Record deleteField(int tag, int occ) throws BrumaException {
        int auxOcc = 0;
        if (tag <= 0 || tag > 9999) {
            throw new BrumaException("tag[" + tag + "] parameter out of range[1," + 9999 + "]");
        }
        if (occ < 0) {
            throw new BrumaException("occ[" + occ + "] parameter out of range < 0");
        }
        Iterator<Field> i = this.fields.iterator();
        while (i.hasNext()) {
            Field field = i.next();
            if (field.getId() != tag || occ != ++auxOcc && occ != 0) continue;
            i.remove();
            if (occ != auxOcc) continue;
            break;
        }
        return this;
    }

    public Record deleteFields() {
        this.fields.clear();
        return this;
    }

    public Record setMfn(int mfn) throws BrumaException {
        if (mfn < 0) {
            throw new BrumaException("mfn[" + mfn + "] out of range < 0");
        }
        this.mfn = mfn;
        return this;
    }

    public Record changeToNew() {
        this.mfn = 0;
        this.status = Status.ACTIVE;
        this.actStatus = ActiveStatus.NEW;
        this.fields.clear();
        return this;
    }

    public Record sortFields() {
        Collections.sort(this.fields);
        return this;
    }

    @Override
    public Iterator<Field> iterator() {
        Iterator<Field> ret;
        try {
            ret = this.getFields().iterator();
        }
        catch (BrumaException ze) {
            ret = null;
        }
        return ret;
    }

    public Record setTags(Map<Integer, String> tags) {
        this.tags = tags;
        return this;
    }

    public String toXML() throws BrumaException {
        StringBuilder buf = new StringBuilder();
        int len = this.fields.size();
        buf.append("<record mfn='");
        buf.append(this.mfn);
        buf.append("' nvf='");
        buf.append(this.getNvf());
        buf.append("' status='");
        buf.append((Object)this.status);
        buf.append("'>");
        buf.append(this.separator);
        for (int counter = 0; counter < len; ++counter) {
            String fld = this.getFieldXML(counter);
            assert (fld != null);
            buf.append("  ");
            buf.append(fld);
            buf.append(this.separator);
        }
        buf.append("</record>");
        buf.append(this.separator);
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int len = this.fields.size();
        buf.append("<record mfn='");
        buf.append(this.mfn);
        buf.append("' nvf='");
        buf.append(this.getNvf());
        buf.append("' status='");
        buf.append((Object)this.status);
        buf.append("'>");
        buf.append(this.separator);
        for (int counter = 0; counter < len; ++counter) {
            String fld;
            try {
                fld = this.getFieldWithTag(counter);
            }
            catch (BrumaException ex) {
                return null;
            }
            assert (fld != null);
            buf.append("  ");
            buf.append(fld);
            buf.append(this.separator);
        }
        buf.append("</record>");
        buf.append(this.separator);
        return buf.toString();
    }

    public String toJSON() throws BrumaException {
        StringBuilder builder = new StringBuilder();
        ArrayList<Field> sFields = new ArrayList<Field>();
        ArrayList<Subfield> sSubFields = new ArrayList<Subfield>();
        boolean firstFld = true;
        boolean firstSub = true;
        int lastFldId = 0;
        char lstSubId = '\u0000';
        for (Field fld : this.fields) {
            sFields.add(fld);
        }
        Collections.sort(sFields);
        builder.append("{\n  \"mfn\" : \"");
        builder.append(this.mfn);
        builder.append("\",\n  \"nvf\" : ");
        builder.append(this.getNvf());
        builder.append("");
        for (Field fld : sFields) {
            if (fld.getId() == lastFldId) {
                builder.append(",\n    {      ");
            } else {
                lastFldId = fld.getId();
                if (firstFld) {
                    firstFld = false;
                    builder.append(",");
                } else {
                    builder.append("\n  ],");
                }
                builder.append("\n  \"v");
                builder.append(fld.getId());
                builder.append("\" : [\n    {      ");
            }
            sSubFields.clear();
            lstSubId = '\u0000';
            firstSub = true;
            for (Subfield sub : fld.getSubfields()) {
                sSubFields.add(sub);
            }
            Collections.sort(sSubFields);
            for (Subfield sub : sSubFields) {
                if (sub.getId() == lstSubId) {
                    builder.append(", ");
                } else {
                    lstSubId = sub.getId();
                    if (firstSub) {
                        firstSub = false;
                    } else {
                        builder.append("],");
                    }
                    builder.append("\n      \"");
                    builder.append(sub.getId());
                    builder.append("\" : [");
                }
                builder.append("\"");
                builder.append(sub.getContent().replace("\"", "&quot;"));
                builder.append("\"");
            }
            if (!sSubFields.isEmpty()) {
                builder.append("]");
            }
            builder.append("\n    }");
        }
        if (!sFields.isEmpty()) {
            builder.append("\n  ]");
        }
        builder.append("\n}");
        return builder.toString();
    }

    public String toJSON2() throws BrumaException {
        StringBuilder builder = new StringBuilder();
        boolean firstFld = true;
        boolean firstSub = true;
        builder.append("{\n  \"mfn\" : \"");
        builder.append(this.mfn);
        builder.append("\",\n  \"nvf\" : ");
        builder.append(this.getNvf());
        builder.append(",\n  \"fields\" : [");
        for (Field fld : this.fields) {
            if (firstFld) {
                firstFld = false;
            } else {
                builder.append(",");
            }
            builder.append("\n    {\n      \"v");
            builder.append(fld.getId());
            builder.append("\" : [");
            firstSub = true;
            for (Subfield sub : fld.getSubfields()) {
                if (firstSub) {
                    firstSub = false;
                } else {
                    builder.append(",");
                }
                builder.append("\n        {\"");
                builder.append(sub.getId());
                builder.append("\" : \"");
                builder.append(sub.getContent().replace("\"", "&quot;"));
                builder.append("\"}");
            }
            builder.append("\n      ]\n    }");
        }
        builder.append("\n  ]\n}");
        return builder.toString();
    }

    public String toJSON3(int idTag) throws BrumaException {
        List fldLst;
        String string;
        Field f;
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, ArrayList<Field>> flds = new TreeMap<Integer, ArrayList<Field>>();
        TreeMap subflds = new TreeMap();
        int cur = 0;
        int rtag = this.mfn;
        if (idTag > 0 && (f = this.getField(idTag, 1)) != null && (string = f.getContent()) != null && !string.isEmpty()) {
            rtag = Integer.parseInt(string);
        }
        builder.append("  {\n    \"_id\" : \"");
        builder.append(Integer.toString(rtag));
        builder.append("\",\n    \"nvf\" : ");
        builder.append(this.getNvf());
        for (Field field : this.fields) {
            fldLst = (ArrayList<Field>)flds.get(field.getId());
            if (fldLst == null) {
                fldLst = new ArrayList<Field>();
                flds.put(field.getId(), (ArrayList<Field>)fldLst);
            }
            fldLst.add(field);
        }
        int size = flds.size();
        for (Map.Entry entry : flds.entrySet()) {
            Integer itag = (Integer)entry.getKey();
            fldLst = (List)entry.getValue();
            if (++cur <= size) {
                builder.append(",");
            }
            builder.append("\n    ");
            if (this.tags == null) {
                builder.append("\"v");
                builder.append(itag);
            } else {
                String stag = this.tags.get(itag);
                builder.append("\"");
                if (stag == null) {
                    builder.append("v");
                    builder.append(itag);
                } else {
                    builder.append(stag);
                }
            }
            builder.append("\" : ");
            if (fldLst.size() > 1) {
                builder.append("[");
            }
            boolean fldFirst = true;
            for (Field fld : fldLst) {
                List subFldLst;
                if (fldFirst) {
                    fldFirst = false;
                } else {
                    builder.append(",");
                }
                builder.append("\n      {");
                subflds.clear();
                for (Subfield subfield : fld) {
                    subFldLst = (ArrayList<Subfield>)subflds.get(Character.valueOf(subfield.getId()));
                    if (subFldLst == null) {
                        subFldLst = new ArrayList<Subfield>();
                        subflds.put(Character.valueOf(subfield.getId()), subFldLst);
                    }
                    subFldLst.add(subfield);
                }
                boolean subFirst = true;
                for (Map.Entry entry2 : subflds.entrySet()) {
                    subFldLst = (List)entry2.getValue();
                    boolean subMulti = subFldLst.size() > 1;
                    boolean subMultiFirst = true;
                    if (subFirst) {
                        subFirst = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append("\n         \"");
                    builder.append(entry2.getKey());
                    builder.append("\" : ");
                    if (subMulti) {
                        builder.append("[");
                    }
                    for (Subfield sub : subFldLst) {
                        if (subMulti) {
                            if (subMultiFirst) {
                                subMultiFirst = false;
                            } else {
                                builder.append(", ");
                            }
                        }
                        builder.append("\"");
                        builder.append(sub.getContent().replace("\\", "\\\\").replace("\"", "\\\""));
                        builder.append("\"");
                    }
                    if (!subMulti) continue;
                    builder.append("]");
                }
                builder.append("\n      }");
            }
            if (fldLst.size() <= 1) continue;
            builder.append("\n    ]");
        }
        builder.append("\n  }");
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockStatus {
        NORMAL,
        LOCKED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActiveStatus {
        NORMAL,
        NEW,
        PENDING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        LOGDEL,
        PHYDEL;

    }
}

