/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Record;
import java.util.Arrays;
import java.util.List;

class RecordByteArray {
    private final boolean isFFI;
    private final boolean swapped;
    private final int filler;
    private final int shift;
    private byte[] buffer;

    RecordByteArray(boolean isFFI, boolean swapped, int filler, int shift) {
        assert (filler == 0 || filler == 2);
        assert (shift >= 0);
        this.isFFI = isFFI;
        this.swapped = swapped;
        this.filler = filler;
        this.shift = shift;
        this.buffer = new byte[isFFI ? 0x100000 : Short.MAX_VALUE];
    }

    Record fromByteArray(byte[] rec, String encoding) throws BrumaException {
        assert (rec != null);
        assert (encoding != null);
        Record record = new Record(this.shift, this.filler);
        Record.Status recStatus = Record.Status.ACTIVE;
        int[] index = new int[]{0};
        try {
            int mfn = this.readInt(rec, index);
            record.setMfn(mfn);
            this.readShInt(rec, index);
            if (!this.isFFI && this.filler != 0) {
                index[0] = index[0] + 2;
            }
            int mfbwb = this.readInt(rec, index);
            record.setBlockNumber(mfbwb);
            short mfbwp = this.readShort(rec, index);
            record.setBlockPos(mfbwp);
            if (this.isFFI && this.filler != 0) {
                this.readShort(rec, index);
            }
            int base = this.readShInt(rec, index);
            int nvf = this.readShort(rec, index);
            short status = this.readShort(rec, index);
            if (status == 0) {
                recStatus = Record.Status.ACTIVE;
            } else if (status == 1) {
                recStatus = Record.Status.LOGDEL;
            } else {
                throw new BrumaException("fromByteArray/invalid status[" + status + "]");
            }
            record.setStatus(recStatus);
            for (int counter = 0; counter < nvf; ++counter) {
                short tag = this.readShort(rec, index);
                if (this.isFFI && this.filler != 0) {
                    index[0] = index[0] + 2;
                }
                int pos = this.readShInt(rec, index);
                int len = this.readShInt(rec, index);
                int fpos = base + pos;
                try {
                    record.addField(tag, new String(rec, fpos, len, encoding));
                    continue;
                }
                catch (StringIndexOutOfBoundsException siobe) {
                    System.out.println("mfn=" + mfn + " tag=" + tag + " fpos=" + fpos + " pos=" + pos + " len=" + len + " reclen=" + rec.length + " encod=" + encoding);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BrumaException("fromByteArray/" + ex);
        }
        return record;
    }

    byte[] toByteArray(Record record, String encoding) throws BrumaException {
        assert (record != null);
        assert (encoding != null);
        record.setShift(this.shift);
        record.setFiller(this.filler);
        int recLen = record.getRecordLength(encoding, this.isFFI);
        int fill = record.getFillSize(recLen);
        List<Field> fields = record.getFields();
        int size = fields.size();
        Record.Status recStatus = record.getStatus();
        byte[] rec = new byte[recLen + fill];
        int[] index = new int[1];
        int auxIndex = 0;
        int pos = 0;
        index[0] = 0;
        try {
            if (this.buffer.length < recLen) {
                this.buffer = new byte[recLen];
            }
            short status = (short)(recStatus != Record.Status.ACTIVE ? 1 : 0);
            this.writeInt(record.getMfn(), rec, index);
            this.writeShInt(recLen + fill, rec, index);
            if (!this.isFFI && this.filler != 0) {
                this.writeShort((short)0, rec, index);
            }
            this.writeInt(record.getBlockNumber(), rec, index);
            this.writeShort((short)record.getBlockPos(), rec, index);
            if (this.isFFI && this.filler != 0) {
                this.writeShort((short)0, rec, index);
            }
            this.writeShInt((this.isFFI ? 22 : 18) + this.filler + size * (this.isFFI ? 10 + this.filler : 6), rec, index);
            this.writeShort((short)size, rec, index);
            this.writeShort(status, rec, index);
            for (int counter = 0; counter < size; ++counter) {
                Field field = fields.get(counter);
                byte[] fld = field.getContent().getBytes(encoding);
                this.writeShort((short)field.getId(), rec, index);
                if (this.isFFI && this.filler != 0) {
                    this.writeShort((short)0, rec, index);
                }
                this.writeShInt(pos, rec, index);
                this.writeShInt(fld.length, rec, index);
                System.arraycopy(fld, 0, this.buffer, auxIndex, fld.length);
                auxIndex += fld.length;
                pos += fld.length;
            }
            System.arraycopy(this.buffer, 0, rec, index[0], auxIndex);
            index[0] = index[0] + auxIndex;
            if (fill > 0) {
                Arrays.fill(rec, index[0], index[0] + fill, (byte)32);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BrumaException(ex);
        }
        return rec;
    }

    private short readShort(byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        short ret = 0;
        for (int i = 0; i < 2; ++i) {
            ret = this.swapped ? (short)(ret + ((buffer[idx + i] & 0xFF) << i * 8)) : (short)(ret + ((buffer[idx + i] & 0xFF) << (2 - i - 1) * 8));
        }
        index[0] = index[0] + 2;
        return ret;
    }

    private void writeShort(short shortVal, byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        if (this.swapped) {
            buffer[idx] = (byte)(shortVal & 0xFF);
            buffer[idx + 1] = (byte)((shortVal & 0xFF00) >>> 8);
        } else {
            buffer[idx] = (byte)((shortVal & 0xFF00) >>> 8);
            buffer[idx + 1] = (byte)(shortVal & 0xFF);
        }
        index[0] = index[0] + 2;
    }

    private int readInt(byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.swapped) {
                ret += (buffer[idx + i] & 0xFF) << i * 8;
                continue;
            }
            ret += (buffer[idx + i] & 0xFF) << (4 - i - 1) * 8;
        }
        index[0] = index[0] + 4;
        return ret;
    }

    private void writeInt(int intVal, byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        for (int i = 0; i < 4; ++i) {
            buffer[idx + i] = this.swapped ? (byte)(intVal >>> i * 8 & 0xFF) : (byte)(intVal >>> (4 - i - 1) * 8 & 0xFF);
        }
        index[0] = index[0] + 4;
    }

    private int readShInt(byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        int ret = 0;
        int size = this.isFFI ? 4 : 2;
        for (int i = 0; i < size; ++i) {
            if (this.swapped) {
                ret += (buffer[idx + i] & 0xFF) << i * 8;
                continue;
            }
            ret += (buffer[idx + i] & 0xFF) << (size - i - 1) * 8;
        }
        index[0] = index[0] + size;
        return ret;
    }

    private void writeShInt(int intVal, byte[] buffer, int[] index) {
        assert (buffer != null);
        assert (index != null);
        assert (index[0] >= 0);
        int idx = index[0];
        int size = this.isFFI ? 4 : 2;
        for (int i = 0; i < size; ++i) {
            int auxShift = this.swapped ? i * 8 : (size - i - 1) * 8;
            int aux = (intVal & 255 << auxShift) >> auxShift;
            buffer[idx + i] = (byte)aux;
        }
        index[0] = index[0] + size;
    }
}

