/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subfield
implements Comparable<Subfield> {
    public static final char FIRST_SUB_ID = '_';
    private final char id;
    private final String content;

    public Subfield(char id, String content) throws BrumaException {
        if (id < '\u0000') {
            throw new BrumaException("id < 0");
        }
        if (content == null) {
            throw new BrumaException("null content");
        }
        this.id = (char)(id == '\u0000' ? 95 : (int)id);
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public char getId() {
        return this.id;
    }

    public String toString() {
        String ret = this.id == '_' ? this.content : "^" + this.id + this.content;
        return ret;
    }

    @Override
    public int compareTo(Subfield other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return this.getId() - other.getId();
    }

    public String toJSON() {
        String subContent = this.content.replace("\"", "\\\"");
        String ret = this.id == '_' ? "          { \"id\": \"*\", \"content\": \"" + subContent + "\" }" : "          { \"id\": \"" + this.id + "\" \"content\":  \"" + subContent + "\" }";
        return ret;
    }

    public void toJSON(StringBuilder in) throws BrumaException {
        if (in == null) {
            throw new BrumaException("null in");
        }
        String subContent = this.content.replace("\"", "\\\"");
        if (this.id == '_') {
            in.append("          { \"id\": \"*\", \"content\": \"");
        } else {
            in.append("          { \"id\": \"");
            in.append(this.id);
            in.append("\", \"content\":  \"");
        }
        in.append(subContent);
        in.append("\" }");
    }
}

