/*
 * Decompiled with CFR 0.152.
 */
package bruma.master;

import bruma.BrumaException;
import bruma.master.Record;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class XrfFile {
    private static final int MF_BLOCKSIZE = 512;
    static final int XRF_BLOCKSIZE = 512;
    static final int XRF_PTRSIZE = 4;
    static final int XRF_NRINBUFFER = 127;
    private static final int XRF_BUFSIZE = 512;
    private final byte[] page;
    final int shift;
    final FileChannel fc;
    private RandomAccessFile raf;
    ByteBuffer bBuffer;
    boolean swapped;

    XrfFile(String dbasename, int shift, boolean swapped, boolean create) throws BrumaException {
        if (dbasename == null) {
            throw new BrumaException("XrfFile/null dbname");
        }
        if (shift < 0) {
            throw new BrumaException("XrfFile/invalid shift[" + shift + "] value");
        }
        this.shift = shift;
        this.swapped = swapped;
        this.page = new byte[512];
        this.bBuffer = ByteBuffer.allocate(512).order(swapped ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        try {
            File file = new File(dbasename);
            if (file.exists() && file.isFile()) {
                if (file.length() < 512L) {
                    throw new BrumaException("XrfFile/XRF_BLOCKSIZE");
                }
            } else if (!create) {
                throw new BrumaException("XrfFile/missing " + dbasename + " file");
            }
            String mode = !file.isFile() || file.canWrite() ? "rw" : "r";
            Arrays.fill(this.page, (byte)0);
            this.raf = new RandomAccessFile(file, mode);
            this.fc = this.raf.getChannel();
            if (create) {
                this.reset();
            }
        }
        catch (IOException ioe) {
            try {
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (IOException ioe2) {
                throw new BrumaException("XrfFile/" + ioe2.getMessage());
            }
            throw new BrumaException("XrfFile/" + ioe.getMessage());
        }
    }

    void close() throws BrumaException {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("close/" + ioe.getMessage());
        }
    }

    void reset() throws BrumaException {
        try {
            this.raf.setLength(0L);
            this.bBuffer.clear();
            this.bBuffer.limit(512);
            this.bBuffer.putInt(-1);
            this.bBuffer.put(this.page, 0, 508);
            this.bBuffer.rewind();
            if (this.fc.write(this.bBuffer, 0L) != 512) {
                throw new IOException("reset/write error");
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("reset/" + ioe.getMessage());
        }
    }

    public XrfInfo readXrfInfo(int mfn) throws BrumaException {
        int packedMfp;
        if (mfn <= 0) {
            throw new BrumaException("readXrfInfo/mfn <= 0");
        }
        try {
            this.bBuffer.clear();
            this.bBuffer.limit(4);
            if (this.fc.read(this.bBuffer, this.calcXrfPos(mfn)) != 4) {
                throw new IOException("reset/read error");
            }
            this.bBuffer.rewind();
            packedMfp = this.bBuffer.getInt();
        }
        catch (IOException ioe) {
            throw new BrumaException("getXrfInfo/" + ioe.getMessage());
        }
        return this.readXrfInfoAux(mfn, packedMfp);
    }

    protected XrfInfo readXrfInfoAux(int mfn, int pckMfn) throws BrumaException {
        Record.Status status;
        boolean isNew;
        if (mfn <= 0) {
            throw new BrumaException("readXrfInfoAux/mfn <= 0");
        }
        if (pckMfn == 0) {
            throw new BrumaException("readXrfInfoAux/pckMfn == 0");
        }
        int omax = 1023;
        int rshift = 11 - this.shift;
        Record.ActiveStatus actStatus = null;
        int packedMfp = pckMfn;
        boolean positiveBlock = true;
        if (packedMfp < 0) {
            packedMfp *= -1;
            positiveBlock = false;
        }
        int block = packedMfp >>> rshift;
        int offset = packedMfp & 1023 >>> this.shift;
        offset <<= this.shift;
        boolean pending = (packedMfp & 1536 >>> this.shift) > 0;
        boolean bl = isNew = (packedMfp & 1024 >>> this.shift) > 0;
        if (block == 0) {
            throw new BrumaException("getXrfInfo/XRF_FIL_BAD");
        }
        if (positiveBlock) {
            status = Record.Status.ACTIVE;
            actStatus = isNew ? Record.ActiveStatus.NEW : (pending ? Record.ActiveStatus.PENDING : Record.ActiveStatus.NORMAL);
        } else {
            status = block == 1 && offset == 0 ? Record.Status.PHYDEL : Record.Status.LOGDEL;
        }
        return new XrfInfo(mfn, block, offset, status, actStatus);
    }

    public int writeXrfInfo(XrfInfo info) throws BrumaException {
        int packedMfp;
        if (info == null) {
            throw new BrumaException("writeXrfInfo/null info");
        }
        int block = Math.abs(info.block);
        int bmax = 2 << 21 + this.shift - 1;
        int lshift = 11 - this.shift;
        if (info.mfn <= 0) {
            throw new BrumaException("writeMstPos/mfn <= 0");
        }
        if (info.offset < 0 || info.offset >= 2048) {
            throw new BrumaException("writeMstPos/invalid offset[" + info.offset + "] value");
        }
        if (block > bmax) {
            throw new BrumaException("writeMstPos/block[" + info.block + "]");
        }
        try {
            int blk = (info.mfn - 1) / 127;
            int pos = (info.mfn - 1) % 127 * 4 + 4;
            int len = (int)this.raf.length();
            int lblk = len / 4 / 128 - 1;
            long blkPos = blk * 512;
            long filePos = blkPos + (long)pos;
            if (blk > lblk + 1) {
                throw new BrumaException("writeMstPos/illegal argument id value = " + info.mfn);
            }
            packedMfp = (block << lshift) + (info.offset >>> this.shift);
            if (info.block < 0) {
                packedMfp = -packedMfp;
            }
            if (pos == 508) {
                if (blk == lblk) {
                    this.bBuffer.clear();
                    this.bBuffer.limit(4);
                    this.bBuffer.putInt(blk + 1);
                    this.bBuffer.rewind();
                    if (this.fc.write(this.bBuffer, blkPos) != 4) {
                        throw new IOException("writeMstPos/1/write error");
                    }
                }
                this.bBuffer.clear();
                this.bBuffer.limit(4);
                this.bBuffer.putInt(packedMfp);
                this.bBuffer.rewind();
                if (this.fc.write(this.bBuffer, filePos) != 4) {
                    throw new IOException("writeMstPos/2/write error");
                }
                if (blk == lblk) {
                    this.bBuffer.clear();
                    this.bBuffer.limit(512);
                    this.bBuffer.putInt(-1 * (blk + 2));
                    this.bBuffer.put(this.page, 0, 508);
                    this.bBuffer.rewind();
                    if (this.fc.write(this.bBuffer, filePos + 4L) != 512) {
                        throw new IOException("writeMstPos/3/write error");
                    }
                }
            } else {
                this.bBuffer.clear();
                this.bBuffer.limit(4);
                this.bBuffer.putInt(packedMfp);
                this.bBuffer.rewind();
                if (this.fc.write(this.bBuffer, filePos) != 4) {
                    throw new IOException("writeMstPos/4/write error");
                }
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("writeMstPos/" + ioe.getMessage());
        }
        return packedMfp;
    }

    private int calcXrfPos(int mfn) throws BrumaException {
        assert (mfn > 0);
        int quot = (mfn - 1) / 127;
        int rem = (mfn - 1) % 127;
        int pos = quot * 512 + (rem + 1) * 4;
        try {
            if ((long)pos > this.raf.length()) {
                throw new BrumaException("calcXrfPos/id[" + mfn + "] too big");
            }
        }
        catch (IOException ioe) {
            throw new BrumaException("calcXrfPos/" + ioe.getMessage());
        }
        return pos;
    }

    public class XrfInfo {
        private int mfn;
        private int block;
        private int offset;
        private Record.Status status;
        private Record.ActiveStatus actStatus;

        XrfInfo(int mfn, int block, int offset, Record.Status status, Record.ActiveStatus actStatus) {
            assert (mfn > 0);
            this.mfn = mfn;
            this.block = block;
            this.offset = offset;
            this.status = status;
            this.actStatus = actStatus;
        }

        public void setBlock(int block) {
            this.block = block;
        }

        public int getBlock() {
            return this.block;
        }

        public int getMfn() {
            return this.mfn;
        }

        public void setMfn(int mfn) {
            this.mfn = mfn;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public Record.ActiveStatus getActStatus() {
            return this.actStatus;
        }

        public void setActStatus(Record.ActiveStatus actStatus) {
            this.actStatus = actStatus;
        }

        public void setStatus(Record.Status status) {
            this.status = status;
        }

        public Record.Status getStatus() {
            return this.status;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("mfn=" + this.mfn);
            sb.append(" block=" + this.block);
            sb.append(" offset=" + this.offset);
            sb.append(" status=" + (Object)((Object)this.status));
            sb.append(" active_status=" + (Object)((Object)this.actStatus));
            return sb.toString();
        }
    }
}

