/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.BrumaException;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.master.XrfFile;

public class ChangeXrf2New {
    private ChangeXrf2New() {
    }

    public static void change(String dbname, boolean isFFI) throws BrumaException {
        if (dbname == null) {
            throw new IllegalArgumentException();
        }
        Master mst = MasterFactory.getInstance(dbname).setFFI(isFFI).setInMemoryXrf(false).open();
        int next = mst.getControlRecord().getNxtmfn();
        XrfFile xrf = mst.getXrf();
        int tell = 10000;
        for (int mfn = 1; mfn < next; ++mfn) {
            XrfFile.XrfInfo info;
            if (mfn % tell == 0) {
                System.out.println("+++" + mfn);
            }
            if ((info = xrf.readXrfInfo(mfn)).getStatus() != Record.Status.ACTIVE || info.getActStatus() == Record.ActiveStatus.NEW) continue;
            info.setActStatus(Record.ActiveStatus.NEW);
            info.setOffset(info.getOffset() + 1024);
            xrf.writeXrfInfo(info);
        }
        mst.close();
    }

    private static void usage() {
        System.err.println("usage: ChangeXrf2New <dbname> [--isFFI]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 1) {
            ChangeXrf2New.usage();
        }
        boolean isFFI = args.length > 1 && args[1].equals("--isFFI");
        ChangeXrf2New.change(args[0], isFFI);
    }
}

