/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.BrumaException;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.nio.ByteOrder;
import java.util.GregorianCalendar;

public class CopyMaster {
    private CopyMaster() {
    }

    private static void usage() {
        System.err.println("usage: CopyMaster <dbFrom> <dbTo> \n            [--from=<mfn>]\n            [--to=<mfn>]\n            [--fromEncoding=<charSet>]\n            [--toIsFFI]\n            [{--toDbLinux|--toDbWin}]\n            [--toEncoding=<charSet>]\n            [--toMaxGigaSize=<n>]\n            [--tell=<n>]\n            [--adjustMfn]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 2) {
            CopyMaster.usage();
        }
        long itime = new GregorianCalendar().getTimeInMillis();
        int from = 1;
        int to = 0;
        String fromEncoding = "ISO-8859-1";
        boolean toIsFFI = false;
        boolean toDbLinux = false;
        boolean toDbWin = false;
        String toEncoding = null;
        int toMaxGigaSize = -1;
        int toFiller = 0;
        int toShift = 0;
        int tell = Integer.MAX_VALUE;
        boolean adjustMfn = false;
        int adjust = 0;
        int cur = 0;
        for (int idx = 2; idx < args.length; ++idx) {
            if (args[idx].startsWith("--from=")) {
                from = Integer.parseInt(args[idx].substring(7));
                continue;
            }
            if (args[idx].startsWith("--to=")) {
                to = Integer.parseInt(args[idx].substring(5));
                continue;
            }
            if (args[idx].startsWith("--fromEncoding=")) {
                fromEncoding = args[idx].substring(15);
                continue;
            }
            if (args[idx].equals("--toIsFFI")) {
                toIsFFI = true;
                continue;
            }
            if (args[idx].equals("--toDbLinux")) {
                toDbLinux = true;
                continue;
            }
            if (args[idx].equals("--toDbWin")) {
                toDbWin = true;
                continue;
            }
            if (args[idx].startsWith("--toEncoding=")) {
                toEncoding = args[idx].substring(13);
                continue;
            }
            if (args[idx].startsWith("--toMaxGigaSize=")) {
                toMaxGigaSize = Integer.parseInt(args[idx].substring(16));
                continue;
            }
            if (args[idx].startsWith("--tell=")) {
                tell = Integer.parseInt(args[idx].substring(7));
                continue;
            }
            if (args[idx].equals("--adjustMfn")) {
                adjustMfn = true;
                continue;
            }
            CopyMaster.usage();
        }
        boolean toAlignment = toDbLinux || !toDbWin && !System.getProperty("os.name").startsWith("Win");
        int toAlignmentVal = toAlignment ? 4 : 2;
        boolean swapBytes = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        Master fromMf = MasterFactory.getInstance(args[0]).setEncoding(fromEncoding).open();
        if (toMaxGigaSize == -1) {
            toMaxGigaSize = fromMf.getGigaSize();
        }
        if (to == 0) {
            to = fromMf.getControlRecord().getNxtmfn() - 1;
        }
        if (adjustMfn) {
            adjust = from - 1;
        }
        if (toEncoding == null) {
            toEncoding = fromMf.getEncoding();
        }
        Master toMf = MasterFactory.getInstance(args[1]).setFFI(toIsFFI).setEncoding(toEncoding).setDataAlignment(toAlignmentVal).setSwapped(swapBytes).setMaxGigaSize(toMaxGigaSize).create();
        toFiller = toAlignment ? 2 : 0;
        toShift = toMf.getShift();
        for (int mfn = from; mfn <= to; ++mfn) {
            Record rec = fromMf.getRecord(mfn);
            rec.setMfn(mfn - adjust);
            rec.setFiller(toFiller);
            rec.setShift(toShift);
            toMf.writeRecord(rec);
            if (++cur % tell != 0) continue;
            System.out.println("+++" + cur);
        }
        fromMf.close();
        toMf.close();
        long ctime = new GregorianCalendar().getTimeInMillis();
        System.out.println("Elapsed time : " + (ctime - itime) / 1000L + "s");
    }
}

