/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.master.Leader;
import bruma.master.SwapBytes;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DbType {
    private final RandomAccessFile raf;
    private final SwapBytes sb;

    private Leader readIsisWin() throws IOException {
        Leader leader = new Leader();
        this.raf.seek(64L);
        leader.setMfn(this.sb.swap(this.raf.readInt()));
        leader.setMfrl(this.sb.swap(this.raf.readShort()));
        leader.setMfbwb(this.sb.swap(this.raf.readInt()));
        leader.setMfbwp(this.sb.swap(this.raf.readShort()));
        short base = this.sb.swap(this.raf.readShort());
        leader.setBase(base);
        short nvf = this.sb.swap(this.raf.readShort());
        leader.setNvf(nvf);
        int auxBase = 18 + nvf * 6;
        System.out.println("readIsisWin()=" + (base == auxBase));
        return leader;
    }

    private Leader readIsisLinux() throws IOException {
        Leader leader = new Leader();
        this.raf.seek(64L);
        leader.setMfn(this.sb.swap(this.raf.readInt()));
        leader.setMfrl(this.sb.swap(this.raf.readShort()));
        this.raf.readShort();
        leader.setMfbwb(this.sb.swap(this.raf.readInt()));
        leader.setMfbwp(this.sb.swap(this.raf.readShort()));
        short base = this.sb.swap(this.raf.readShort());
        leader.setBase(base);
        short nvf = this.sb.swap(this.raf.readShort());
        leader.setNvf(nvf);
        int auxBase = 18 + nvf * 6;
        System.out.println("readIsisLinux()=" + (base == auxBase));
        return leader;
    }

    private Leader readFfiWin() throws IOException {
        Leader leader = new Leader();
        this.raf.seek(64L);
        leader.setMfn(this.sb.swap(this.raf.readInt()));
        leader.setMfrl(this.sb.swap(this.raf.readInt()));
        leader.setMfbwb(this.sb.swap(this.raf.readInt()));
        leader.setMfbwp(this.sb.swap(this.raf.readShort()));
        int base = this.sb.swap(this.raf.readInt());
        leader.setBase(base);
        short nvf = this.sb.swap(this.raf.readShort());
        leader.setNvf(nvf);
        int auxBase = 24 + nvf * 12;
        System.out.println("readFfiWin()=" + (base == auxBase));
        return leader;
    }

    private Leader readFfiLinux() throws IOException {
        Leader leader = new Leader();
        this.raf.seek(64L);
        leader.setMfn(this.sb.swap(this.raf.readInt()));
        leader.setMfrl(this.sb.swap(this.raf.readInt()));
        leader.setMfbwb(this.sb.swap(this.raf.readInt()));
        leader.setMfbwp(this.sb.swap(this.raf.readShort()));
        this.raf.readShort();
        int base = this.sb.swap(this.raf.readInt());
        leader.setBase(base);
        short nvf = this.sb.swap(this.raf.readShort());
        leader.setNvf(nvf);
        int auxBase = 24 + nvf * 12;
        System.out.println("readFfiLinux()=" + (base == auxBase));
        return leader;
    }

    public DbType(String dbname, boolean swap) throws IOException {
        if (dbname == null) {
            throw new IllegalArgumentException();
        }
        this.raf = new RandomAccessFile(dbname, "r");
        this.sb = new SwapBytes(swap);
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public void printReport() throws IOException {
        System.out.println("Isis Windows version");
        System.out.println(this.readIsisWin());
        System.out.println();
        System.out.println("Isis Linux version");
        System.out.println(this.readIsisLinux());
        System.out.println();
        System.out.println("FFI Windows version");
        System.out.println(this.readFfiWin());
        System.out.println();
        System.out.println("FFI Linux version");
        System.out.println(this.readFfiLinux());
    }

    private static void usage() {
        System.err.println("usage: DbType <dbName> [--noswap]");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            DbType.usage();
        }
        boolean swapp = args.length <= 1 || !args[1].equals("--noswap");
        DbType dbt = new DbType(args[0], swapp);
        dbt.printReport();
        dbt.close();
    }
}

