/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.BrumaException;
import bruma.impexp.AbstractMasterExport;
import bruma.impexp.ISO2709Export;
import bruma.impexp.IdMasterExport;
import bruma.impexp.JSONMasterExport;
import bruma.impexp.XmlMasterExport;
import bruma.master.Master;
import bruma.master.MasterFactory;

public class ExportMaster {
    private static void usage() {
        System.err.println("usage: ExportMaster mst=<mstName>\nout=<outFile> outType={iso2709|id|json|xml}\n\t\t    [from=<int>] [to=<int>] [tell=<num>]\n\t\t    [mstEncod=<encoding>] [idTag=<tag>] [outEncod=<encoding>]\n\t\t    [--useFDT]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        AbstractMasterExport ame;
        if (args.length < 3) {
            ExportMaster.usage();
        }
        String mst = null;
        String out = null;
        String outType = null;
        String mstEncod = "ISO-8859-1";
        String outEncod = null;
        int idTag = 0;
        int tell = Integer.MAX_VALUE;
        int from = 1;
        int to = Integer.MAX_VALUE;
        boolean useFDT = false;
        for (int index = 1; index < args.length; ++index) {
            if (args[index].startsWith("mst=")) {
                mst = args[index].substring(4);
                continue;
            }
            if (args[index].startsWith("out=")) {
                out = args[index].substring(4);
                continue;
            }
            if (args[index].startsWith("outType=")) {
                outType = args[index].substring(8);
                continue;
            }
            if (args[index].startsWith("mstEncod=")) {
                mstEncod = args[index].substring(9);
                continue;
            }
            if (args[index].startsWith("outEncod=")) {
                outEncod = args[index].substring(9);
                continue;
            }
            if (args[index].startsWith("--useFDT")) {
                useFDT = true;
                continue;
            }
            if (args[index].startsWith("idTag=")) {
                idTag = Integer.parseInt(args[index].substring(6));
                continue;
            }
            if (args[index].startsWith("tell=")) {
                tell = Integer.parseInt(args[index].substring(5));
                continue;
            }
            if (args[index].startsWith("from=")) {
                from = Integer.parseInt(args[index].substring(5));
                continue;
            }
            if (args[index].startsWith("to=")) {
                to = Integer.parseInt(args[index].substring(3));
                continue;
            }
            ExportMaster.usage();
        }
        if (mst == null) {
            throw new BrumaException("null master");
        }
        if (out == null) {
            throw new BrumaException("null output file");
        }
        if (tell < 1) {
            throw new BrumaException("tell < 1");
        }
        if (from < 1) {
            throw new BrumaException("from < 1");
        }
        if (from > to) {
            throw new BrumaException("from > to");
        }
        if (outType == null) {
            throw new BrumaException("null output file type");
        }
        if (outType.equals("json")) {
            outEncod = "UTF-8";
        }
        Master imst = MasterFactory.getInstance(mst).setEncoding(mstEncod).open();
        if (outType.equals("iso2709")) {
            ame = new ISO2709Export(imst, out, outEncod);
        } else if (outType.equals("id")) {
            ame = new IdMasterExport(imst, out, outEncod);
        } else if (outType.equals("xml")) {
            ame = new XmlMasterExport(imst, out, outEncod, useFDT);
        } else if (outType.equals("json")) {
            ame = new JSONMasterExport(imst, out, outEncod, useFDT, idTag);
        } else {
            imst.close();
            throw new BrumaException("invalid output file type [" + outType + "]");
        }
        ame.export(from, to, tell);
    }
}

