/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.tools.SendJsonDocumentsPool;
import bruma.utils.TimeString;
import bruma.utils.Util;
import bruma.utils.ZeFDT;
import java.io.File;
import java.util.Map;

public class Isis2Couch {
    public static final String DEFAULT_COUCH_HOST = "localhost";
    public static final int DEFAULT_COUCH_PORT = 5984;
    private static final int MAX_BUFFER_SIZE = 0x400000;

    private static void usage() {
        System.err.println("usage: Isis2Couch -isisMaster=<name> -couchDbName=<name>\n[-encod=<encoding>] [-from=<num>] [-to=<num>] [-idTag=<num>]\n[-couchHost=<host>] [-couchPort=<port>] \n[-threads=<num>] [-tell=<num>] [--useFDT]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Isis2Couch.usage();
        }
        System.out.println("\n== Isis2Couch ==\n\n");
        String isisMaster = null;
        String encoding = "ISO-8859-1 or IBM850";
        int from = 1;
        int to = Integer.MAX_VALUE;
        String couchHost = DEFAULT_COUCH_HOST;
        int couchPort = 5984;
        String couchDbName = null;
        int tell = Integer.MAX_VALUE;
        boolean allOrNothing = false;
        boolean useFDT = false;
        int idTag = 0;
        int threads = 1;
        for (int index = 0; index < args.length; ++index) {
            if (args[index].startsWith("-isisMaster=")) {
                isisMaster = args[index].substring(12);
                continue;
            }
            if (args[index].startsWith("-encod=")) {
                encoding = args[index].substring(7);
                continue;
            }
            if (args[index].startsWith("-from=")) {
                from = Integer.parseInt(args[index].substring(6));
                continue;
            }
            if (args[index].startsWith("-to=")) {
                to = Integer.parseInt(args[index].substring(4));
                continue;
            }
            if (args[index].startsWith("-couchHost=")) {
                couchHost = args[index].substring(11);
                continue;
            }
            if (args[index].startsWith("-couchPort=")) {
                couchPort = Integer.parseInt(args[index].substring(11));
                continue;
            }
            if (args[index].startsWith("-couchDbName=")) {
                couchDbName = args[index].substring(13);
                continue;
            }
            if (args[index].startsWith("-threads=")) {
                threads = Integer.parseInt(args[index].substring(9));
                continue;
            }
            if (args[index].startsWith("-tell=")) {
                tell = Integer.parseInt(args[index].substring(6));
                continue;
            }
            if (args[index].startsWith("-idTag=")) {
                idTag = Integer.parseInt(args[index].substring(7));
                continue;
            }
            if (args[index].equals("--AllOrNothing")) {
                allOrNothing = true;
                continue;
            }
            if (args[index].equals("--useFDT")) {
                useFDT = true;
                continue;
            }
            System.err.println("unknown: " + args[index] + "\n");
            Isis2Couch.usage();
        }
        if (isisMaster == null) {
            throw new IllegalArgumentException("null isisMaster");
        }
        if (to < from) {
            throw new IllegalArgumentException("to < from");
        }
        if (threads < 1) {
            throw new IllegalArgumentException("threads < 1");
        }
        if (couchDbName == null) {
            throw new IllegalArgumentException("null couchDbName");
        }
        Master mst = MasterFactory.getInstance(isisMaster).setEncoding(encoding).open();
        int xto = Math.min(to, mst.getControlRecord().getNxtmfn() - 1);
        String fileName = Util.changeFileExtension(mst.getMasterName(), "fdt");
        boolean hasFdt = new File(fileName).isFile();
        Map<Integer, String> tags = useFDT && hasFdt ? new ZeFDT().fromFile(mst.getMasterName()).getFieldDescriptionMap() : null;
        StringBuilder builder = new StringBuilder("{\n");
        TimeString ts = new TimeString();
        SendJsonDocumentsPool pThreads = new SendJsonDocumentsPool(couchHost, Integer.toString(couchPort), couchDbName, threads);
        if (allOrNothing) {
            builder.append(" \"all_or_nothing\": true,\n");
        }
        builder.append(" \"docs\": [\n");
        ts.start();
        for (int mfn = from; mfn <= xto; ++mfn) {
            Record rec;
            if (mfn % tell == 0) {
                System.out.println("+++" + mfn + " - " + ts.getTime());
            }
            if ((rec = mst.getRecord(mfn)).getStatus() != Record.Status.ACTIVE) continue;
            builder.append(rec.setTags(tags).toJSON3(idTag));
            if (rec.getMfn() == xto) {
                builder.append(",");
            }
            builder.append("\n");
            if (builder.length() < 0x400000) continue;
            builder.append(" ]\n}\n");
            pThreads.sendDocuments(builder.toString());
            builder.setLength(0);
            builder.append("{\n \"docs\": [\n");
        }
        if (builder.length() > 13) {
            builder.append(" ]\n}\n");
            pThreads.sendDocuments(builder.toString());
        }
        pThreads.finishSending();
        System.out.println("total time = " + ts.getTime());
        mst.close();
    }
}

