/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class RepRec {
    final Master mst;
    final Map<String, Integer> map;
    final Writer out;

    public RepRec(String mstName, String encoding, String outFile) throws BrumaException {
        if (mstName == null) {
            throw new BrumaException("null mstName");
        }
        if (encoding == null) {
            throw new BrumaException("null encoding");
        }
        if (outFile == null) {
            throw new BrumaException("null outFile");
        }
        this.mst = MasterFactory.getInstance(mstName).setEncoding(encoding).open();
        this.map = new HashMap<String, Integer>();
        try {
            this.out = new BufferedWriter(new FileWriter(outFile));
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
    }

    public void close() throws BrumaException {
        this.mst.close();
        try {
            this.out.close();
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
    }

    public void check(int tell) throws BrumaException {
        assert (tell >= 0);
        int tell2 = tell == 0 ? Integer.MAX_VALUE : tell;
        for (Record rec : this.mst) {
            int mfn = rec.getMfn();
            if (mfn % tell2 == 0) {
                System.err.println("++" + mfn);
            }
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            Record recOut = this.sortFields(this.stripWhites(rec));
            String fields = recOut.getFieldsWithTags();
            String md5 = this.geraHashString(fields, "MD5");
            String sha1 = this.geraHashString(fields, "SHA-1");
            this.putHashString(mfn, md5 + sha1);
        }
    }

    private Record stripWhites(Record in) throws BrumaException {
        Record ret = new Record();
        for (Field fld : in) {
            String content = fld.getContent().replaceAll("\\s+", "").toUpperCase();
            ret.addField(fld.getId(), content);
        }
        return ret;
    }

    private Record sortFields(Record in) throws BrumaException {
        Record ret = new Record();
        TreeSet<Integer> tags = new TreeSet<Integer>();
        for (Integer tag : in.getRecordTags()) {
            tags.add(tag);
        }
        for (Integer tag : tags) {
            List<Field> fields = in.getFieldList(tag);
            ArrayList<String> contents = new ArrayList<String>();
            for (Field fld : fields) {
                contents.add(fld.getContent());
            }
            Collections.sort(contents, String.CASE_INSENSITIVE_ORDER);
            for (String content : contents) {
                ret.addField(tag, content);
            }
        }
        return ret;
    }

    private String geraHashString(String in, String algorithm) throws BrumaException {
        String ret;
        assert (in != null);
        assert (algorithm != null);
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            BigInteger hash = new BigInteger(1, md.digest(in.getBytes()));
            ret = hash.toString(16);
        }
        catch (Exception ex) {
            throw new BrumaException(ex);
        }
        return ret;
    }

    private void putHashString(int mfn, String in) throws BrumaException {
        assert (mfn > 0);
        assert (in != null);
        Integer smfn = this.map.get(in);
        if (smfn == null) {
            this.map.put(in, mfn);
        } else {
            try {
                this.out.write("records " + mfn + " and " + smfn + " seems to be the same\n");
            }
            catch (Exception ex) {
                throw new BrumaException(ex);
            }
        }
    }

    private static final void usage() {
        System.err.println("usage: RepRec <dbname> <encoding> <outfile> [<tell>]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 3) {
            RepRec.usage();
        }
        RepRec rr = new RepRec(args[0], args[1], args[2]);
        int tell = args.length > 3 ? Integer.parseInt(args[3]) : 0;
        rr.check(tell);
        rr.close();
    }
}

