/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

class SendJsonDocuments
extends Thread {
    private final String couchHost;
    private final String couchPort;
    private final String couchDbName;
    private final Integer lock;
    private boolean finished;
    private String docs;

    SendJsonDocuments(String couchHost, String couchPort, String couchDbName) {
        assert (couchHost != null);
        assert (couchDbName != null);
        this.couchHost = couchHost;
        this.couchPort = couchPort;
        this.couchDbName = couchDbName;
        this.lock = new Integer(0);
        this.docs = null;
        this.finished = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDocuments(String docs) throws Exception {
        assert (docs != null);
        Integer n = this.lock;
        synchronized (n) {
            this.docs = docs;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishSending() {
        this.finished = true;
        Integer n = this.lock;
        synchronized (n) {
            this.lock.notifyAll();
        }
    }

    boolean isFree() {
        return this.docs == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Integer n = this.lock;
                synchronized (n) {
                    this.lock.wait();
                }
                if (this.finished) break;
                assert (this.docs != null);
                URL url = new URL("http://" + this.couchHost + ":" + this.couchPort + "/" + this.couchDbName + "/_bulk_docs");
                URLConnection connection = url.openConnection();
                connection.setRequestProperty("CONTENT-TYPE", "application/json");
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                StringBuilder builder = new StringBuilder();
                System.out.println("sending [" + this.docs.length() + " bytes] ...");
                out.write(this.docs);
                out.flush();
                out.close();
                char[] buffer = new char[100];
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                if (reader.read(buffer) == -1) {
                    throw new IOException("read error");
                }
                builder.append(buffer);
                builder.append(" ...");
                reader.close();
                System.out.println("... data sent: OK => " + builder.toString());
            }
            catch (Exception ex) {
                Logger.getLogger(SendJsonDocuments.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.docs = null;
        }
    }
}

