/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.tools.SendJsonDocuments;
import java.util.logging.Level;
import java.util.logging.Logger;

class SendJsonDocumentsPool {
    static final int DEFAULT_THREADS = 1;
    private final String couchHost;
    private final String couchPort;
    private final String couchDbName;
    private final int threadNum;
    private final SendJsonDocuments[] threads;
    private int curIndex;

    SendJsonDocumentsPool(String couchHost, String couchPort, String couchDbName, int threadNum) {
        assert (couchHost != null);
        assert (couchDbName != null);
        assert (threadNum > 0);
        this.couchHost = couchHost;
        this.couchPort = couchPort;
        this.couchDbName = couchDbName;
        this.threadNum = threadNum;
        this.threads = new SendJsonDocuments[threadNum];
        this.curIndex = 0;
        for (int counter = 0; counter < threadNum; ++counter) {
            this.threads[counter] = new SendJsonDocuments(couchHost, couchPort, couchDbName);
            this.threads[counter].start();
        }
    }

    void sendDocuments(String docs) throws Exception {
        assert (docs != null);
        int auxIndex = this.curIndex;
        while (true) {
            if (this.threads[auxIndex].isFree()) break;
            if (++auxIndex >= this.threadNum) {
                auxIndex = 0;
            }
            if (auxIndex != this.curIndex) continue;
            Thread.sleep(1000L);
        }
        this.threads[auxIndex].sendDocuments(docs);
        this.curIndex = auxIndex;
    }

    void finishSending() {
        while (true) {
            int total = 0;
            for (int index = 0; index < this.threadNum; ++index) {
                if (!this.threads[index].isFree()) continue;
                this.threads[index].finishSending();
                ++total;
            }
            if (total == this.threadNum) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SendJsonDocumentsPool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

