/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools;

import bruma.BrumaException;
import bruma.master.Control;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.master.Subfield;
import bruma.utils.ZeFDT;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    private int active = 0;
    private int deleted = 0;
    private int minrl = Integer.MAX_VALUE;
    private int maxrl = 0;
    private long totrl = 0L;

    public String tab(String dbname, String encoding, int from, int to, int tag, int tell) throws BrumaException {
        if (dbname == null) {
            throw new BrumaException("null dbname");
        }
        if (encoding == null) {
            throw new BrumaException("null encoding");
        }
        if (from < 0) {
            throw new BrumaException("from < 0");
        }
        if (to < from) {
            throw new BrumaException("to < from");
        }
        if (tag < 0) {
            throw new BrumaException("tag < 0");
        }
        if (tell < 0) {
            throw new BrumaException("tell < 0");
        }
        Master mst = MasterFactory.getInstance(dbname).setEncoding(encoding).open();
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        Control control = mst.getControlRecord();
        int first = Math.min(from, control.getNxtmfn() - 1);
        int last = Math.min(to, control.getNxtmfn() - 1);
        int ntell = tell == 0 ? Integer.MAX_VALUE : tell;
        int cur = 0;
        for (int mfn = first; mfn <= last; ++mfn) {
            Record rec = mst.getRecord(mfn);
            if (++cur % ntell == 0) {
                Logger.getLogger(Statistics.class.getName()).log(Level.INFO, "++" + cur);
            }
            if (rec.getStatus() != Record.Status.ACTIVE) continue;
            for (Field fld : rec.getFieldList(tag)) {
                String field = fld.getContent().trim();
                Integer total = (Integer)map.get(field);
                if (total == null) {
                    total = 0;
                }
                total = total + 1;
                map.put(field, total);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append("[" + entry.getValue() + "] : " + (String)entry.getKey() + "\n");
        }
        mst.close();
        return sb.toString();
    }

    public String stat(String dbname, String encoding, int from, int to, int tell) throws BrumaException {
        if (dbname == null) {
            throw new BrumaException("null dbname");
        }
        if (encoding == null) {
            throw new BrumaException("null encoding");
        }
        if (from < 0) {
            throw new BrumaException("from < 0");
        }
        if (to < from) {
            throw new BrumaException("to < from");
        }
        if (tell < 0) {
            throw new BrumaException("tell < 0");
        }
        Master mst = MasterFactory.getInstance(dbname).setEncoding(encoding).open();
        TreeMap<Integer, Profile> fldProf = new TreeMap<Integer, Profile>();
        HashMap<Integer, Integer> fieldsInRec = new HashMap<Integer, Integer>();
        TreeMap<Character, Integer> characters = new TreeMap<Character, Integer>();
        Control control = mst.getControlRecord();
        int first = Math.min(from, control.getNxtmfn() - 1);
        int last = Math.min(to, control.getNxtmfn() - 1);
        int ntell = tell == 0 ? Integer.MAX_VALUE : tell;
        int cur = 0;
        this.active = 0;
        this.deleted = 0;
        this.maxrl = 0;
        this.minrl = Integer.MAX_VALUE;
        this.totrl = 0L;
        for (int mfn = first; mfn <= last; ++mfn) {
            Record rec = mst.getRecord(mfn);
            if (++cur % ntell == 0) {
                Logger.getLogger(Statistics.class.getName()).log(Level.INFO, "++" + cur);
            }
            if (rec.getStatus() == Record.Status.ACTIVE) {
                Profile prof;
                ++this.active;
                int len = rec.getRecordLength(mst.getEncoding(), mst.isFFI());
                this.maxrl = Math.max(this.maxrl, len);
                this.minrl = Math.min(this.minrl, len);
                this.totrl += (long)len;
                fieldsInRec.clear();
                for (Field field : rec) {
                    int tag = field.getId();
                    String content = field.getContent();
                    Integer amount = content.length();
                    prof = (Profile)fldProf.get(tag);
                    if (prof == null) {
                        prof = new Profile();
                        fldProf.put(tag, prof);
                    }
                    ++prof.total;
                    prof.minLen = Math.min(prof.minLen, amount);
                    prof.maxLen = Math.max(prof.maxLen, amount);
                    prof.totLen += (long)amount.intValue();
                    if (prof.sub == null) {
                        prof.sub = new TreeMap<Character, Profile>();
                    }
                    this.parseSubFields(field, characters, prof.sub);
                    if (prof.type != text_type.ALPHANUM) {
                        for (Profile subProf : prof.sub.values()) {
                            if (subProf.type == text_type.NUMERIC) {
                                if (prof.type == text_type.ALPHA) {
                                    prof.type = text_type.ALPHANUM;
                                    break;
                                }
                                prof.type = text_type.NUMERIC;
                                continue;
                            }
                            if (subProf.type == text_type.ALPHA) {
                                if (prof.type == text_type.NUMERIC) {
                                    prof.type = text_type.ALPHANUM;
                                    break;
                                }
                                prof.type = text_type.ALPHA;
                                continue;
                            }
                            if (subProf.type != text_type.ALPHANUM) continue;
                            prof.type = text_type.ALPHANUM;
                            break;
                        }
                    }
                    if ((amount = (Integer)fieldsInRec.get(tag)) == null) {
                        amount = 0;
                        ++prof.presenceTimes;
                    }
                    fieldsInRec.put(tag, amount + 1);
                }
                for (Map.Entry entry : fieldsInRec.entrySet()) {
                    prof = (Profile)fldProf.get(entry.getKey());
                    prof.minTimes = Math.min(prof.minTimes, (Integer)entry.getValue());
                    prof.maxTimes = Math.max(prof.maxTimes, (Integer)entry.getValue());
                }
                continue;
            }
            ++this.deleted;
        }
        String ret = this.showResults(mst, control, characters, fldProf);
        mst.close();
        return ret;
    }

    private void parseSubFields(Field field, Map<Character, Integer> characters, Map<Character, Profile> subProf) {
        Profile prof;
        assert (field != null);
        assert (characters != null);
        assert (subProf != null);
        HashMap<Character, Integer> tot = new HashMap<Character, Integer>();
        for (Subfield subfield : field) {
            Character ch = Character.valueOf(Character.toLowerCase(subfield.getId()));
            String content = subfield.getContent();
            int length = content.length();
            prof = subProf.get(ch);
            if (prof == null) {
                prof = new Profile();
                subProf.put(ch, prof);
            }
            ++prof.total;
            prof.minLen = Math.min(prof.minLen, length);
            prof.maxLen = Math.max(prof.maxLen, length);
            prof.totLen += (long)length;
            Integer amount = (Integer)tot.get(ch);
            if (amount == null) {
                amount = 0;
                ++prof.presenceTimes;
            }
            amount = amount + 1;
            tot.put(ch, amount);
            char[] arr$ = content.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character ch2 = Character.valueOf(arr$[i$]);
                amount = characters.get(ch2);
                if (amount == null) {
                    amount = 0;
                }
                Integer n = amount;
                Integer n2 = amount = Integer.valueOf(amount + 1);
                characters.put(ch2, amount);
                if (prof.type == text_type.ALPHANUM) continue;
                if (Character.isDigit(ch2.charValue())) {
                    if (prof.type == text_type.ALPHA) {
                        prof.type = text_type.ALPHANUM;
                        continue;
                    }
                    prof.type = text_type.NUMERIC;
                    continue;
                }
                prof.type = prof.type == text_type.NUMERIC ? text_type.ALPHANUM : text_type.ALPHA;
            }
        }
        for (Map.Entry entry : tot.entrySet()) {
            prof = subProf.get(entry.getKey());
            prof.minTimes = Math.min(prof.minTimes, (Integer)entry.getValue());
            prof.maxTimes = Math.max(prof.maxTimes, (Integer)entry.getValue());
        }
    }

    private String alignResult(List<String> elems, int colSize, boolean alignRight) {
        assert (elems != null);
        assert (colSize > 0);
        String whites = "                                               ";
        StringBuilder sb = new StringBuilder();
        for (String elem : elems) {
            int size = elem.length();
            if (size < colSize) {
                String filler = "                                               ".substring(0, colSize - size);
                if (alignRight) {
                    sb.append(filler);
                    sb.append(elem);
                    continue;
                }
                sb.append(elem);
                sb.append(filler);
                continue;
            }
            sb.append(elem);
        }
        return sb.toString();
    }

    private String paddingWhites(String in, int outSize) {
        assert (in != null) : "paddingWhites/null in";
        assert (outSize > 0) : "paddingWhites/outSize <= 0";
        String ret = in;
        if (in.length() < outSize) {
            StringBuilder out = new StringBuilder(in);
            int rem = outSize - in.length();
            if (rem > 0) {
                char[] whites = new char[rem];
                Arrays.fill(whites, ' ');
                out.append(whites);
            }
            ret = out.toString();
        }
        return ret;
    }

    private String showResults(Master mst, Control control, Map<Character, Integer> characters, Map<Integer, Profile> profiles) throws BrumaException {
        String fname;
        int total;
        int presence;
        Profile prof;
        HashMap<Integer, String> fnames;
        assert (mst != null);
        assert (control != null);
        assert (characters != null);
        assert (profiles != null);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> elems = new ArrayList<String>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Elem
        implements Comparable<Elem> {
            Integer tot;
            Character val;

            public Elem(Integer tot, Character val) {
                this.tot = tot;
                this.val = val;
            }

            @Override
            public int compareTo(Elem o) {
                if (o == null) {
                    throw new NullPointerException("null Elem");
                }
                return this.tot == o.tot ? this.val.compareTo(o.val) : this.tot - o.tot;
            }
        }
        TreeSet<Elem> chts = new TreeSet<Elem>();
        String encoding = mst.getEncoding();
        ZeFDT fdt = new ZeFDT();
        File mstFile = new File(mst.getMasterName());
        int totalRec = this.active + this.deleted;
        int colSize = 10;
        int size = mst.getGigaSize();
        int totChar = 0;
        boolean presenceAll = this.active == totalRec;
        try {
            fdt.fromFile(mst.getMasterName());
            fnames = new HashMap<Integer, String>();
            for (ZeFDT.ZeFDTField zeFDTField : fdt.getFieldDescriptions()) {
                fnames.put(zeFDTField.getTag(), zeFDTField.getDescription());
            }
        }
        catch (Exception ex) {
            fnames = null;
        }
        sb.append("\nAnalysis Date: " + new Date() + "\n");
        sb.append("\n\nDatabase:\n");
        sb.append("   dbname = " + mstFile.getAbsolutePath() + "\n");
        sb.append("   platform = " + (mst.getDataAlignment() == 0 ? "Windows" : "Linux") + "\n");
        sb.append("   encoding = " + encoding + "\n");
        sb.append("   ffi = " + mst.isFFI() + "\n");
        sb.append("   swapped = " + mst.isSwapped() + "\n");
        sb.append("   max size = ");
        if (size == 0) {
            sb.append("512 megabytes\n");
        } else {
            sb.append(mst.getGigaSize() + " gigabytes\n");
        }
        sb.append("   next mfn = " + control.getNxtmfn() + "\n");
        sb.append("   data entry lock (DEL) = " + control.getMfcxx2() + "\n");
        sb.append("   exclusive write lock (EWL) = " + control.getMfcxx3() + "\n");
        sb.append("\n\nRecords:\n");
        sb.append(String.format("   active records = " + (presenceAll ? "(A) " : "") + "%1$d (%2$.2f%%)", this.active, Float.valueOf((float)this.active / (float)totalRec * 100.0f)) + "\n");
        sb.append(String.format("   deleted records = %1$d (%2$.2f%%)", this.deleted, Float.valueOf((float)this.deleted / (float)totalRec * 100.0f)) + "\n");
        sb.append("   max record size = " + this.maxrl + "\n");
        sb.append("   min record size = " + this.minrl + "\n");
        sb.append("   avg record size = " + this.totrl / (long)this.active + "\n");
        sb.append("\n\nFields:\n");
        elems.clear();
        elems.add("name");
        elems.add("tag");
        elems.add("presence");
        elems.add("presence%");
        elems.add("ausence");
        elems.add("ausence%");
        elems.add("occ");
        elems.add("minTimes");
        elems.add("maxTimes");
        elems.add("minLen");
        elems.add("maxLen");
        elems.add("avgLen");
        elems.add("type");
        sb.append(this.alignResult(elems, colSize, true));
        sb.append("\n\n");
        for (Map.Entry entry : profiles.entrySet()) {
            prof = (Profile)entry.getValue();
            presence = prof.presenceTimes;
            total = prof.total;
            presenceAll = presence == totalRec;
            elems.clear();
            String string = fname = fnames == null ? null : (String)fnames.get(entry.getKey());
            fname = fname == null ? "" : (fname.length() > colSize ? fname.substring(0, colSize) : fname);
            elems.add(fname);
            elems.add(((Integer)entry.getKey()).toString());
            elems.add((presenceAll ? "(A) " : "") + Integer.toString(presence));
            elems.add(String.format("%1$4.2f%%", Float.valueOf(100.0f * ((float)presence / (float)totalRec))));
            elems.add(Integer.toString(totalRec - presence));
            elems.add(String.format("%1$4.2f%%", Float.valueOf(100.0f * ((float)(totalRec - presence) / (float)totalRec))));
            elems.add(Integer.toString(prof.total));
            elems.add(Integer.toString(prof.minTimes));
            elems.add(Integer.toString(prof.maxTimes));
            elems.add(Integer.toString(prof.minLen));
            elems.add(Integer.toString(prof.maxLen));
            elems.add(Long.toString(prof.totLen / (long)prof.total));
            elems.add(prof.type.toString());
            sb.append(this.alignResult(elems, colSize, true));
            sb.append("\n");
        }
        sb.append("\n\nSubfields:\n");
        elems.clear();
        elems.add("fld tag");
        elems.add("subf id");
        elems.add("presence");
        elems.add("presence%");
        elems.add("ausence");
        elems.add("ausence%");
        elems.add("occ");
        elems.add("minTimes");
        elems.add("maxTimes");
        elems.add("minLen");
        elems.add("maxLen");
        elems.add("avgLen");
        elems.add("type");
        sb.append(this.alignResult(elems, colSize, true));
        sb.append("\n\n");
        for (Map.Entry entry : profiles.entrySet()) {
            prof = (Profile)entry.getValue();
            int tag = (Integer)entry.getKey();
            total = prof.total;
            for (Map.Entry<Character, Profile> sentry : prof.sub.entrySet()) {
                prof = sentry.getValue();
                presence = prof.presenceTimes;
                presenceAll = presence == total;
                elems.clear();
                elems.add(Integer.toString(tag));
                elems.add(sentry.getKey().toString());
                elems.add((presenceAll ? "(A) " : "") + Integer.toString(presence));
                elems.add(String.format("%1$4.2f%%", Float.valueOf(100.0f * ((float)presence / (float)total))));
                elems.add(Integer.toString(total - presence));
                elems.add(String.format("%1$4.2f%%", Float.valueOf(100.0f * ((float)(total - presence) / (float)total))));
                elems.add(Integer.toString(prof.total));
                elems.add(Integer.toString(prof.minTimes));
                elems.add(Integer.toString(prof.maxTimes));
                elems.add(Integer.toString(prof.minLen));
                elems.add(Integer.toString(prof.maxLen));
                elems.add(Long.toString(prof.totLen / (long)prof.total));
                elems.add(prof.type.toString());
                sb.append(this.alignResult(elems, colSize, true));
                sb.append("\n");
            }
        }
        sb.append("\n\nCharacters:\n");
        elems.clear();
        elems.add("char");
        elems.add("val(Unicode)");
        elems.add("val(" + encoding + ")");
        elems.add("times");
        elems.add("times%");
        sb.append(this.alignResult(elems, colSize + 7, true));
        sb.append("\n");
        for (Map.Entry entry : characters.entrySet()) {
            chts.add(new Elem((Integer)entry.getValue(), (Character)entry.getKey()));
            totChar += ((Integer)entry.getValue()).intValue();
        }
        for (Elem elem : chts) {
            Character ch = elem.val;
            String sch = ch.toString();
            char val = ch.charValue();
            elems.clear();
            elems.add(ch.toString());
            elems.add(Integer.toString(val));
            try {
                elems.add(Integer.toString(0xFF & sch.getBytes(encoding)[0]));
            }
            catch (UnsupportedEncodingException ex) {
                elems.add("");
            }
            elems.add(elem.tot.toString());
            elems.add(String.format("%1$4.2f%%", Float.valueOf(100.0f * ((float)elem.tot.intValue() / (float)totChar))));
            sb.append(this.alignResult(elems, colSize + 7, true));
            sb.append("\n");
        }
        fname = mstFile.getName();
        fname = fname.length() > 3 ? fname.substring(0, 3) : fname;
        sb.append("\n\nField Definition Table (FDT):\n\n");
        sb.append("W:" + fname + "   \n");
        sb.append("F:" + fname + "   \n");
        sb.append("S:" + fname + "   \n");
        sb.append("***\n");
        for (Map.Entry entry : profiles.entrySet()) {
            String string = fname = fnames == null ? null : (String)fnames.get(entry.getKey());
            fname = fname == null ? "field_" + ((Integer)entry.getKey()).toString() : (fname.length() > 30 ? fname.substring(0, colSize) : fname);
            sb.append(this.paddingWhites(fname, 30));
            prof = (Profile)entry.getValue();
            String subfields = "";
            for (Character subId : prof.sub.keySet()) {
                if (subId.charValue() == '*') continue;
                subfields = subfields + subId;
            }
            sb.append(this.paddingWhites(subfields, 20));
            sb.append(Integer.toString((Integer)entry.getKey()) + " ");
            sb.append(Integer.toString(prof.maxLen) + " ");
            sb.append(Integer.toString(prof.type.ordinal()) + " ");
            sb.append(prof.maxTimes > 1 ? "1" : "0");
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void usage() {
        System.err.println("usage: Statistics <dbname> [encoding=<encoding>] [from=<from>][to=<to>][tab=<tag>][tell=<tell>]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 1) {
            Statistics.usage();
        }
        Statistics sta = new Statistics();
        String encoding = "ISO-8859-1 or IBM850";
        int from = 1;
        int to = Integer.MAX_VALUE;
        int tag = 0;
        int tell = Integer.MAX_VALUE;
        for (int counter = 2; counter < args.length; ++counter) {
            if (args[counter].startsWith("encoding=")) {
                encoding = args[counter].substring(9);
                continue;
            }
            if (args[counter].startsWith("from=")) {
                from = Integer.parseInt(args[counter].substring(5));
                continue;
            }
            if (args[counter].startsWith("to=")) {
                to = Integer.parseInt(args[counter].substring(3));
                continue;
            }
            if (args[counter].startsWith("tab=")) {
                tag = Integer.parseInt(args[counter].substring(4));
                continue;
            }
            if (args[counter].startsWith("tell=")) {
                tell = Integer.parseInt(args[counter].substring(5));
                continue;
            }
            Statistics.usage();
        }
        String out = tag == 0 ? sta.stat(args[0], encoding, from, to, tell) : sta.tab(args[0], encoding, from, to, tag, tell);
        System.out.println(out);
    }

    private class Profile {
        int total = 0;
        int presenceTimes = 0;
        int minTimes = Integer.MAX_VALUE;
        int maxTimes = 0;
        int minLen = Integer.MAX_VALUE;
        int maxLen = 0;
        long totLen = 0L;
        text_type type = text_type.UNKNOWN;
        Map<Character, Profile> sub = null;

        private Profile() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum text_type {
        ALPHANUM,
        ALPHA,
        NUMERIC,
        UNKNOWN;

    }
}

