/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools.lupa;

import bruma.BrumaException;
import bruma.impexp.AbstractMasterExport;
import bruma.impexp.ISO2709Export;
import bruma.impexp.IdMasterExport;
import bruma.impexp.IsisMasterExport;
import bruma.impexp.JSONMasterExport;
import bruma.impexp.XmlMasterExport;
import bruma.iterator.AbstractRecordIterator;
import bruma.iterator.ISO2709RecordIterator;
import bruma.iterator.IdFileRecordIterator;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import bruma.tools.Statistics;
import bruma.tools.lupa.FilterProfile;
import bruma.tools.lupa.OpenProfile;
import bruma.tools.lupa.Search;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Lupa
extends JFrame {
    private OpenProfile openProf;
    private OpenProfile lastOpenProf;
    private FilterProfile filterProf;
    private FilterProfile lastFilterProf;
    private int mfn;
    private int lastMfn;
    private Master master;
    private Search search;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCancel;
    private JButton jButtonCancel2;
    private JButton jButtonCreate;
    private JButton jButtonDelete;
    private JButton jButtonExport;
    private JButton jButtonExportCancel;
    private JButton jButtonExportOk;
    private JButton jButtonExportOpen;
    private JButton jButtonFilter;
    private JButton jButtonGizmo;
    private JButton jButtonGizmoCancel;
    private JButton jButtonGizmoOk;
    private JButton jButtonImport;
    private JButton jButtonImportCancel;
    private JButton jButtonImportOk;
    private JButton jButtonMstOpen;
    private JButton jButtonNew;
    private JButton jButtonNextHit;
    private JButton jButtonOk;
    private JButton jButtonOk2;
    private JButton jButtonOpen;
    private JButton jButtonOpenGizmo;
    private JButton jButtonOpenImport;
    private JButton jButtonOutputDb;
    private JButton jButtonPrevHit;
    private JButton jButtonRegExp;
    private JButton jButtonSearch;
    private JButton jButtonSearchCancel;
    private JButton jButtonStat;
    private JButton jButtonStatCancel;
    private JButton jButtonStatistics;
    private JButton jButtonUpdate;
    private JCheckBox jCheckBoxAllTags;
    private JCheckBox jCheckBoxExportDeleted;
    private JCheckBox jCheckBoxExportFFI;
    private JCheckBox jCheckBoxExportSwapped;
    private JCheckBox jCheckBoxFFI;
    private JCheckBox jCheckBoxIgnoreCase;
    private JCheckBox jCheckBoxRegExp;
    private JCheckBox jCheckBoxShowAll;
    private JCheckBox jCheckBoxSortFields;
    private JCheckBox jCheckBoxSwapped;
    private JComboBox jComboBoxAlignment;
    private JComboBox jComboBoxCharEncoding;
    private JComboBox jComboBoxEncoding;
    private JComboBox jComboBoxExportAlignment;
    private JComboBox jComboBoxExportEncoding;
    private JComboBox jComboBoxExportMstSize;
    private JComboBox jComboBoxGigaSize;
    private JDialog jDialogExport;
    private JDialog jDialogFilter;
    private JDialog jDialogGizmo;
    private JDialog jDialogImport;
    private JDialog jDialogOpenDb;
    private JDialog jDialogSearch;
    private JDialog jDialogStat;
    private JLabel jInputFileLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelAlignment;
    private JLabel jLabelCharEnc;
    private JLabel jLabelCurMfn;
    private JLabel jLabelDataAlignment;
    private JLabel jLabelDbEncoding;
    private JLabel jLabelEncoding;
    private JLabel jLabelExportAlignment;
    private JLabel jLabelExportEncoding;
    private JLabel jLabelExportFile;
    private JLabel jLabelExportMstSize;
    private JLabel jLabelGigaSize;
    private JLabel jLabelHitsFound;
    private JLabel jLabelIsisType;
    private JLabel jLabelLock;
    private JLabel jLabelMaster;
    private JLabel jLabelMaxSize;
    private JLabel jLabelMfnBegin;
    private JLabel jLabelMfnEnd;
    private JLabel jLabelMstName;
    private JLabel jLabelOutputDb;
    private JLabel jLabelStatus;
    private JLabel jLabelSwapped;
    private JRadioButton jRadioButtonDatabase;
    private JRadioButton jRadioButtonFields;
    private JRadioButton jRadioButtonRecord;
    private JRadioButton jRadioField;
    private JScrollBar jScrollBarMfn;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneDump;
    private JTextArea jTextAreaDump;
    private JTextArea jTextAreaFields;
    private JTextArea jTextAreaStat;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;
    private JTextField jTextField9;
    private JTextField jTextFieldSearch;
    private JTextField jTextFieldSearchTags;
    private JTextField jTextFieldTag;

    public Lupa() {
        this.initComponents();
        this.myInitComponents();
    }

    private void myInitComponents() {
        this.openProf = new OpenProfile();
        this.lastOpenProf = null;
        this.filterProf = new FilterProfile();
        this.lastFilterProf = null;
        this.mfn = 0;
        this.lastMfn = 0;
        this.master = null;
        this.jComboBoxEncoding.addItem("ISO-8859-1 or IBM850");
        for (String encoding : Charset.availableCharsets().keySet()) {
            this.jComboBoxEncoding.addItem(encoding);
        }
        for (String encoding : Charset.availableCharsets().keySet()) {
            this.jComboBoxExportEncoding.addItem(encoding);
        }
        for (String encoding : Charset.availableCharsets().keySet()) {
            this.jComboBoxCharEncoding.addItem(encoding);
        }
        this.openProf.setEncoding("ISO-8859-1 or IBM850");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/bruma/tools/lupa/lupa.png"));
        this.setIconImage(icon.getImage());
        this.clearFrame();
    }

    private void updateOpen() {
        String path = "";
        boolean create = this.openProf.isCreate();
        if (this.openProf.getMaster() == null) {
            this.jButtonOk.setEnabled(false);
        } else {
            try {
                path = this.openProf.getMaster().getCanonicalPath();
                this.jButtonOk.setEnabled(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.jLabelMstName.setText(path);
        this.jCheckBoxSwapped.setSelected(this.openProf.isSwapped());
        this.jCheckBoxFFI.setSelected(this.openProf.isFFI());
        if (create) {
            this.jDialogOpenDb.setTitle("Create Master");
            this.jLabelGigaSize.setVisible(true);
            this.jComboBoxGigaSize.setVisible(true);
            this.jComboBoxGigaSize.setSelectedItem(Integer.toString(this.openProf.getGigasize()));
            this.jCheckBoxSwapped.setVisible(true);
            this.jCheckBoxFFI.setVisible(true);
            this.jLabelAlignment.setVisible(true);
            this.jComboBoxAlignment.setVisible(true);
            this.jComboBoxEncoding.setSelectedItem("ISO-8859-1");
        } else {
            this.jDialogOpenDb.setTitle("Open Master");
            this.jLabelGigaSize.setVisible(false);
            this.jComboBoxGigaSize.setVisible(false);
            this.jCheckBoxSwapped.setVisible(false);
            this.jCheckBoxFFI.setVisible(false);
            this.jLabelAlignment.setVisible(false);
            this.jComboBoxAlignment.setVisible(false);
            this.jComboBoxEncoding.setSelectedItem(this.openProf.getEncoding());
        }
        this.jComboBoxAlignment.setSelectedItem(Integer.toString(this.openProf.getAlignment()));
        if (create) {
            this.jButtonMstOpen.setText("Create...");
            this.jComboBoxGigaSize.setEnabled(true);
            this.jDialogOpenDb.setSize(630, 300);
        } else {
            this.jButtonMstOpen.setText("Open...");
            this.jComboBoxGigaSize.setEnabled(false);
            this.jDialogOpenDb.setSize(600, 230);
        }
    }

    private void clearFrame() {
        this.jScrollBarMfn.setMinimum(0);
        this.jScrollBarMfn.setMaximum(0);
        this.jScrollBarMfn.setValue(0);
        this.jLabelMfnBegin.setText("0");
        this.jLabelMfnEnd.setText("0");
        this.jLabelCurMfn.setText("0");
        this.jLabelStatus.setText("deleted");
        this.jLabelLock.setVisible(false);
        this.jLabelDbEncoding.setText("");
        this.jLabelIsisType.setText("");
        this.jLabelDataAlignment.setText("");
        this.jLabelSwapped.setText("");
        this.jLabelMaxSize.setText("");
        this.openProf = new OpenProfile();
        this.lastOpenProf = null;
        this.openProf.setEncoding("ISO-8859-1 or IBM850");
        this.jTextAreaDump.setText("");
        this.jCheckBoxShowAll.setSelected(true);
        this.setTitle("Lupa (1.0)");
    }

    private void updateFrame() {
        File mfile = this.openProf.getMaster();
        if (mfile != null) {
            try {
                if (this.master != null) {
                    this.master.close();
                }
                MasterFactory mfac = MasterFactory.getInstance(mfile.getPath()).setEncoding(this.openProf.getEncoding()).setFFI(this.openProf.isFFI()).setInMemoryXrf(this.openProf.isInmemory()).setXrfWriteCommit(true).setMaxGigaSize(this.openProf.getGigasize()).setSwapped(this.openProf.isSwapped()).setDataAlignment(this.openProf.getAlignment());
                if (this.openProf.isCreate()) {
                    this.master = mfac.create();
                    Record rec = this.master.newRecord();
                    rec.addField(1, "new record");
                    this.master.writeRecord(rec);
                } else {
                    this.master = mfac.open();
                }
                this.setTitle("Lupa (1.0) [" + this.master.getMasterName() + "]");
                this.lastMfn = this.master.getControlRecord().getNxtmfn() - 1;
                this.mfn = 1;
                this.jScrollBarMfn.setMinimum(1);
                this.jScrollBarMfn.setMaximum(this.lastMfn);
                this.jLabelMfnBegin.setText("1");
                this.jLabelMfnEnd.setText(Integer.toString(this.lastMfn));
                this.jLabelCurMfn.setText("1");
                this.jLabelDbEncoding.setText(this.master.getEncoding());
                this.jLabelMaxSize.setText("Max size: " + this.master.getGigaSize());
                this.jLabelIsisType.setText(this.master.isFFI() ? "Isis FFI" : "Isis Standard");
                this.jLabelDataAlignment.setText("Data alignment: " + this.master.getDataAlignment());
                this.jLabelSwapped.setText(this.master.isSwapped() ? "Swapped bytes" : "Direct bytes");
                this.jScrollBarMfn.setValue(1);
                this.filterProf = new FilterProfile();
                this.lastFilterProf = null;
                this.showRecord();
            }
            catch (Exception ex) {
                this.mfn = 0;
                this.master = null;
                this.clearFrame();
                JOptionPane.showMessageDialog(this, ex.toString(), "Open/Create error", 0);
            }
        }
    }

    private void showRecord() {
        if (this.mfn > 0 && this.mfn <= this.lastMfn) {
            try {
                Record rec = this.master.getRecord(this.mfn);
                Set<Integer> tags = this.filterProf.getShowFields();
                this.jLabelCurMfn.setText(Integer.toString(this.mfn));
                this.jLabelStatus.setText(rec.getStatus().toString());
                if (!tags.isEmpty()) {
                    Iterator<Field> iterator = rec.getFields().iterator();
                    while (iterator.hasNext()) {
                        if (tags.contains(iterator.next().getId())) continue;
                        iterator.remove();
                    }
                }
                if (this.filterProf.isSortFields()) {
                    rec.sortFields();
                }
                this.jTextAreaDump.setText(rec.toString());
                if (rec.getStatus() == Record.Status.ACTIVE && rec.getLockStatus() == Record.LockStatus.LOCKED) {
                    this.jLabelLock.setVisible(true);
                } else {
                    this.jLabelLock.setVisible(false);
                }
            }
            catch (BrumaException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Show record error", 0);
            }
        }
    }

    private void initComponents() {
        this.jDialogOpenDb = new JDialog();
        this.jLabelMaster = new JLabel();
        this.jButtonMstOpen = new JButton();
        this.jCheckBoxSwapped = new JCheckBox();
        this.jComboBoxEncoding = new JComboBox();
        this.jLabelEncoding = new JLabel();
        this.jLabelGigaSize = new JLabel();
        this.jLabelAlignment = new JLabel();
        this.jComboBoxGigaSize = new JComboBox();
        this.jComboBoxAlignment = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jLabelMstName = new JLabel();
        this.jCheckBoxFFI = new JCheckBox();
        this.jDialogFilter = new JDialog();
        this.jCheckBoxSortFields = new JCheckBox();
        this.jCheckBoxShowAll = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaFields = new JTextArea();
        this.jButtonOk2 = new JButton();
        this.jButtonCancel2 = new JButton();
        this.jDialogImport = new JDialog();
        this.jLabel2 = new JLabel();
        this.jButtonImportOk = new JButton();
        this.jButtonImportCancel = new JButton();
        this.jButtonOpenImport = new JButton();
        this.jInputFileLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabelOutputDb = new JLabel();
        this.jButtonOutputDb = new JButton();
        this.jLabelCharEnc = new JLabel();
        this.jComboBoxCharEncoding = new JComboBox();
        this.jDialogSearch = new JDialog();
        this.jLabel4 = new JLabel();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonPrevHit = new JButton();
        this.jButtonNextHit = new JButton();
        this.jButtonSearchCancel = new JButton();
        this.jCheckBoxRegExp = new JCheckBox();
        this.jCheckBoxIgnoreCase = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldSearchTags = new JTextField();
        this.jCheckBoxAllTags = new JCheckBox();
        this.jLabelHitsFound = new JLabel();
        this.jDialogExport = new JDialog();
        this.jLabel6 = new JLabel();
        this.jLabelExportFile = new JLabel();
        this.jButtonExportOpen = new JButton();
        this.jLabelExportEncoding = new JLabel();
        this.jComboBoxExportEncoding = new JComboBox();
        this.jLabelExportAlignment = new JLabel();
        this.jComboBoxExportAlignment = new JComboBox();
        this.jLabelExportMstSize = new JLabel();
        this.jComboBoxExportMstSize = new JComboBox();
        this.jCheckBoxExportSwapped = new JCheckBox();
        this.jButtonExportOk = new JButton();
        this.jButtonExportCancel = new JButton();
        this.jCheckBoxExportDeleted = new JCheckBox();
        this.jCheckBoxExportFFI = new JCheckBox();
        this.jDialogStat = new JDialog();
        this.jRadioButtonDatabase = new JRadioButton();
        this.jRadioField = new JRadioButton();
        this.jTextFieldTag = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaStat = new JTextArea();
        this.jButtonStat = new JButton();
        this.jButtonStatCancel = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.jDialogGizmo = new JDialog();
        this.jButtonGizmoCancel = new JButton();
        this.jButtonGizmoOk = new JButton();
        this.jLabel7 = new JLabel();
        this.jButtonOpenGizmo = new JButton();
        this.jRadioButtonRecord = new JRadioButton();
        this.jRadioButtonFields = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jTextField5 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jTextField7 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jTextField9 = new JTextField();
        this.buttonGroup2 = new ButtonGroup();
        this.jScrollPaneDump = new JScrollPane();
        this.jTextAreaDump = new JTextArea();
        this.jButtonNew = new JButton();
        this.jButtonUpdate = new JButton();
        this.jButtonDelete = new JButton();
        this.jLabelMfnBegin = new JLabel();
        this.jLabelMfnEnd = new JLabel();
        this.jButtonOpen = new JButton();
        this.jScrollBarMfn = new JScrollBar();
        this.jLabelCurMfn = new JLabel();
        this.jLabelStatus = new JLabel();
        this.jButtonCreate = new JButton();
        this.jLabelLock = new JLabel();
        this.jLabelIsisType = new JLabel();
        this.jLabelDataAlignment = new JLabel();
        this.jLabelSwapped = new JLabel();
        this.jLabelDbEncoding = new JLabel();
        this.jLabelMaxSize = new JLabel();
        this.jButtonFilter = new JButton();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jButtonRegExp = new JButton();
        this.jButtonStatistics = new JButton();
        this.jButtonGizmo = new JButton();
        this.jDialogOpenDb.setTitle("Master File");
        this.jDialogOpenDb.setMinimumSize(new Dimension(400, 230));
        this.jDialogOpenDb.setModal(true);
        this.jDialogOpenDb.setName("dialogOpen");
        this.jDialogOpenDb.setResizable(false);
        this.jLabelMaster.setText("Master:");
        this.jButtonMstOpen.setText("Open...");
        this.jButtonMstOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonMstOpenActionPerformed(evt);
            }
        });
        this.jCheckBoxSwapped.setSelected(true);
        this.jCheckBoxSwapped.setText("Swapped bytes");
        this.jCheckBoxSwapped.setToolTipText("Intell CPU - swapped bytes [yes]");
        this.jCheckBoxSwapped.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jCheckBoxSwappedItemStateChanged(evt);
            }
        });
        this.jCheckBoxSwapped.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jCheckBoxSwappedActionPerformed(evt);
            }
        });
        this.jComboBoxEncoding.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jComboBoxEncodingItemStateChanged(evt);
            }
        });
        this.jLabelEncoding.setText("Character encoding:");
        this.jLabelGigaSize.setText("Max master size (gigabytes):");
        this.jLabelAlignment.setText("Memory word alignment:");
        this.jLabelAlignment.setToolTipText("0 (Windows 32 bits); 2 (Linux 32 bits); 4");
        this.jComboBoxGigaSize.setModel(new DefaultComboBoxModel<String>(new String[]{"0 [512 megabytes]", "2", "4", "8", "16", "32", "64", "128", "256", "512"}));
        this.jComboBoxGigaSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jComboBoxGigaSizeItemStateChanged(evt);
            }
        });
        this.jComboBoxAlignment.setModel(new DefaultComboBoxModel<String>(new String[]{"0 [Windows 32 bits]", "2 [Linux 32 bits]", "4", "8"}));
        this.jComboBoxAlignment.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jComboBoxAlignmentItemStateChanged(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jLabelMstName.setText("xxxxxxx");
        this.jCheckBoxFFI.setText("FFI");
        this.jCheckBoxFFI.setToolTipText(" big size records");
        GroupLayout jDialogOpenDbLayout = new GroupLayout(this.jDialogOpenDb.getContentPane());
        this.jDialogOpenDb.getContentPane().setLayout(jDialogOpenDbLayout);
        jDialogOpenDbLayout.setHorizontalGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogOpenDbLayout.createSequentialGroup().addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogOpenDbLayout.createSequentialGroup().addContainerGap().addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelEncoding).addComponent(this.jLabelAlignment).addComponent(this.jLabelGigaSize)).addGap(27, 27, 27).addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxGigaSize, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxAlignment, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxEncoding, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jDialogOpenDbLayout.createSequentialGroup().addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jDialogOpenDbLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelMaster).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMstName, -2, 407, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE).addComponent(this.jButtonMstOpen)).addGroup(jDialogOpenDbLayout.createSequentialGroup().addComponent(this.jButtonCancel, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk, -2, 80, -2))).addGap(19, 19, 19)).addGroup(jDialogOpenDbLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxFFI)).addGroup(jDialogOpenDbLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSwapped))).addContainerGap()));
        jDialogOpenDbLayout.setVerticalGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogOpenDbLayout.createSequentialGroup().addContainerGap().addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMaster).addComponent(this.jLabelMstName, -2, 21, -2).addComponent(this.jButtonMstOpen)).addGap(12, 12, 12).addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEncoding).addComponent(this.jComboBoxEncoding, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAlignment).addComponent(this.jComboBoxAlignment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGigaSize).addComponent(this.jComboBoxGigaSize, -2, 24, -2)).addGap(18, 18, 18).addComponent(this.jCheckBoxFFI).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSwapped).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jDialogOpenDbLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
        this.jDialogFilter.setTitle("Show Fields");
        this.jDialogFilter.setMinimumSize(new Dimension(483, 338));
        this.jDialogFilter.setModal(true);
        this.jDialogFilter.setName("dialogFilter");
        this.jCheckBoxSortFields.setText("Sort fields");
        this.jCheckBoxShowAll.setText("Show all fields");
        this.jCheckBoxShowAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jCheckBoxShowAllItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Tags of fields to be showed");
        this.jTextAreaFields.setColumns(20);
        this.jTextAreaFields.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaFields);
        this.jButtonOk2.setText("OK");
        this.jButtonOk2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonOk2ActionPerformed(evt);
            }
        });
        this.jButtonCancel2.setText("Cancel");
        this.jButtonCancel2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonCancel2ActionPerformed(evt);
            }
        });
        GroupLayout jDialogFilterLayout = new GroupLayout(this.jDialogFilter.getContentPane());
        this.jDialogFilter.getContentPane().setLayout(jDialogFilterLayout);
        jDialogFilterLayout.setHorizontalGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogFilterLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogFilterLayout.createSequentialGroup().addGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxShowAll).addComponent(this.jCheckBoxSortFields)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 317, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jDialogFilterLayout.createSequentialGroup().addGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE).addGroup(jDialogFilterLayout.createSequentialGroup().addComponent(this.jButtonCancel2, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk2, -2, 76, -2))).addGap(27, 27, 27)).addComponent(this.jLabel1, -2, 205, -2)).addContainerGap()));
        jDialogFilterLayout.setVerticalGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogFilterLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSortFields).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowAll).addGap(24, 24, 24).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 181, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel2).addComponent(this.jButtonOk2)).addContainerGap()));
        this.jDialogImport.setTitle("Import dabase");
        this.jDialogImport.setMinimumSize(new Dimension(610, 210));
        this.jDialogImport.setModal(true);
        this.jDialogImport.setResizable(false);
        this.jLabel2.setText("Input file: ");
        this.jButtonImportOk.setText("OK");
        this.jButtonImportOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonImportOkActionPerformed(evt);
            }
        });
        this.jButtonImportCancel.setText("Cancel");
        this.jButtonImportCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonImportCancelActionPerformed(evt);
            }
        });
        this.jButtonOpenImport.setText("Open...");
        this.jButtonOpenImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonOpenImportActionPerformed(evt);
            }
        });
        this.jInputFileLabel.setText("jLabel3");
        this.jLabel3.setText("Output db:");
        this.jLabelOutputDb.setText("jLabel6");
        this.jButtonOutputDb.setText("Open...");
        this.jButtonOutputDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonOutputDbActionPerformed(evt);
            }
        });
        this.jLabelCharEnc.setText("Character encoding:");
        GroupLayout jDialogImportLayout = new GroupLayout(this.jDialogImport.getContentPane());
        this.jDialogImport.getContentPane().setLayout(jDialogImportLayout);
        jDialogImportLayout.setHorizontalGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogImportLayout.createSequentialGroup().addContainerGap().addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jDialogImportLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelOutputDb, -1, 389, Short.MAX_VALUE)).addGroup(jDialogImportLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInputFileLabel, -1, 401, Short.MAX_VALUE)).addComponent(this.jButtonImportCancel, -2, 82, -2).addGroup(GroupLayout.Alignment.LEADING, jDialogImportLayout.createSequentialGroup().addComponent(this.jLabelCharEnc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxCharEncoding, -2, 232, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonImportOk, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonOpenImport, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOutputDb, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jDialogImportLayout.setVerticalGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogImportLayout.createSequentialGroup().addContainerGap().addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogImportLayout.createSequentialGroup().addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jInputFileLabel, -2, 21, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCharEnc).addComponent(this.jComboBoxCharEncoding, -2, -1, -2))).addComponent(this.jButtonOpenImport)).addGap(18, 18, 18).addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabelOutputDb, -2, 18, -2)).addComponent(this.jButtonOutputDb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jDialogImportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonImportOk).addComponent(this.jButtonImportCancel)).addContainerGap()));
        this.jDialogSearch.setTitle("Text Search");
        this.jDialogSearch.setLocationByPlatform(true);
        this.jDialogSearch.setMinimumSize(new Dimension(440, 310));
        this.jDialogSearch.setModal(true);
        this.jDialogSearch.setResizable(false);
        this.jLabel4.setText("Expression:");
        this.jTextFieldSearch.setMinimumSize(new Dimension(12, 27));
        this.jTextFieldSearch.setPreferredSize(new Dimension(12, 25));
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonPrevHit.setText("<<");
        this.jButtonPrevHit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonPrevHitActionPerformed(evt);
            }
        });
        this.jButtonNextHit.setText(">>");
        this.jButtonNextHit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonNextHitActionPerformed(evt);
            }
        });
        this.jButtonSearchCancel.setText("Cancel");
        this.jButtonSearchCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonSearchCancelActionPerformed(evt);
            }
        });
        this.jCheckBoxRegExp.setText("Regular Expression");
        this.jCheckBoxIgnoreCase.setText("Ignore case");
        this.jLabel5.setText("Only in these field tags:");
        this.jTextFieldSearchTags.setMinimumSize(new Dimension(12, 42));
        this.jTextFieldSearchTags.setPreferredSize(new Dimension(12, 25));
        this.jTextFieldSearchTags.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent evt) {
                Lupa.this.jTextFieldSearchTagsInputMethodTextChanged(evt);
            }

            public void caretPositionChanged(InputMethodEvent evt) {
            }
        });
        this.jCheckBoxAllTags.setText("All field tags");
        this.jCheckBoxAllTags.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Lupa.this.jCheckBoxAllTagsStateChanged(evt);
            }
        });
        this.jLabelHitsFound.setFont(new Font("DejaVu Sans", 0, 10));
        this.jLabelHitsFound.setForeground(Color.blue);
        this.jLabelHitsFound.setHorizontalAlignment(4);
        this.jLabelHitsFound.setText("jLabel6");
        GroupLayout jDialogSearchLayout = new GroupLayout(this.jDialogSearch.getContentPane());
        this.jDialogSearch.getContentPane().setLayout(jDialogSearchLayout);
        jDialogSearchLayout.setHorizontalGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialogSearchLayout.createSequentialGroup().addContainerGap(181, Short.MAX_VALUE).addComponent(this.jButtonPrevHit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNextHit).addGap(165, 165, 165)).addGroup(jDialogSearchLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 83, -2).addGroup(jDialogSearchLayout.createSequentialGroup().addGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jDialogSearchLayout.createSequentialGroup().addComponent(this.jCheckBoxAllTags).addGap(39, 39, 39).addComponent(this.jLabelHitsFound, -1, -1, Short.MAX_VALUE)).addComponent(this.jTextFieldSearch, GroupLayout.Alignment.LEADING, -1, 288, Short.MAX_VALUE).addComponent(this.jCheckBoxRegExp, GroupLayout.Alignment.LEADING, -2, 181, -2).addComponent(this.jCheckBoxIgnoreCase, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSearchTags, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch)).addComponent(this.jLabel5, -2, 214, -2)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jDialogSearchLayout.createSequentialGroup().addContainerGap(325, Short.MAX_VALUE).addComponent(this.jButtonSearchCancel, -2, 89, -2).addContainerGap()));
        jDialogSearchLayout.setVerticalGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogSearchLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jButtonSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxRegExp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIgnoreCase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSearchTags, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAllTags).addComponent(this.jLabelHitsFound)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(jDialogSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNextHit).addComponent(this.jButtonPrevHit)).addGap(4, 4, 4).addComponent(this.jButtonSearchCancel).addContainerGap()));
        this.jDialogExport.setTitle("Export database");
        this.jDialogExport.setMinimumSize(new Dimension(650, 220));
        this.jDialogExport.setModal(true);
        this.jLabel6.setText("Output file:");
        this.jButtonExportOpen.setText("Open...");
        this.jButtonExportOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonExportOpenActionPerformed(evt);
            }
        });
        this.jLabelExportEncoding.setText("Character encoding:");
        this.jLabelExportAlignment.setText("Memory word alignment:");
        this.jComboBoxExportAlignment.setModel(new DefaultComboBoxModel<String>(new String[]{"0 [Windows 32 bits]", "2 [Linux 32 bits]", "4", "8"}));
        this.jLabelExportMstSize.setText("Max master size (gigabytes):");
        this.jComboBoxExportMstSize.setModel(new DefaultComboBoxModel<String>(new String[]{"0 [512 megabytes]", "2", "4", "8", "16", "32", "64", "128", "256", "512"}));
        this.jCheckBoxExportSwapped.setSelected(true);
        this.jCheckBoxExportSwapped.setText("Swapped bytes");
        this.jButtonExportOk.setText("OK");
        this.jButtonExportOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonExportOkActionPerformed(evt);
            }
        });
        this.jButtonExportCancel.setText("Cancel");
        this.jButtonExportCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonExportCancelActionPerformed(evt);
            }
        });
        this.jCheckBoxExportDeleted.setSelected(true);
        this.jCheckBoxExportDeleted.setText("Export deleted records");
        this.jCheckBoxExportFFI.setText("FFI");
        this.jCheckBoxExportFFI.setToolTipText("big size records");
        GroupLayout jDialogExportLayout = new GroupLayout(this.jDialogExport.getContentPane());
        this.jDialogExport.getContentPane().setLayout(jDialogExportLayout);
        jDialogExportLayout.setHorizontalGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportLayout.createSequentialGroup().addContainerGap().addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jDialogExportLayout.createSequentialGroup().addComponent(this.jLabelExportMstSize, -2, 211, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxExportMstSize, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jDialogExportLayout.createSequentialGroup().addComponent(this.jLabelExportAlignment, -2, 183, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxExportAlignment, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jDialogExportLayout.createSequentialGroup().addComponent(this.jLabelExportEncoding, -2, 154, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxExportEncoding, -2, 214, -2))).addComponent(this.jCheckBoxExportFFI).addComponent(this.jCheckBoxExportSwapped).addGroup(GroupLayout.Alignment.TRAILING, jDialogExportLayout.createSequentialGroup().addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jDialogExportLayout.createSequentialGroup().addComponent(this.jLabel6, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelExportFile, -2, 436, -2)).addGroup(jDialogExportLayout.createSequentialGroup().addComponent(this.jCheckBoxExportDeleted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 327, Short.MAX_VALUE).addComponent(this.jButtonExportCancel))).addGap(10, 10, 10).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonExportOk, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExportOpen, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jDialogExportLayout.setVerticalGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportLayout.createSequentialGroup().addContainerGap().addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabelExportFile).addComponent(this.jButtonExportOpen)).addGap(18, 18, 18).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExportEncoding).addComponent(this.jComboBoxExportEncoding, -2, -1, -2)).addGap(18, 18, 18).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExportAlignment).addComponent(this.jComboBoxExportAlignment, -2, -1, -2)).addGap(18, 18, 18).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExportMstSize).addComponent(this.jComboBoxExportMstSize, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jCheckBoxExportFFI).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxExportSwapped).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 61, Short.MAX_VALUE).addGroup(jDialogExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonExportOk).addComponent(this.jButtonExportCancel)).addContainerGap()).addGroup(jDialogExportLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxExportDeleted).addContainerGap()))));
        this.jDialogExport.getAccessibleContext().setAccessibleParent(null);
        this.jDialogStat.setTitle("Statistics");
        this.jDialogStat.setMinimumSize(new Dimension(700, 500));
        this.jDialogStat.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.buttonGroup1.add(this.jRadioButtonDatabase);
        this.jRadioButtonDatabase.setSelected(true);
        this.jRadioButtonDatabase.setText("Database");
        this.jRadioButtonDatabase.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Lupa.this.jRadioButtonDatabaseItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioField);
        this.jRadioField.setText("Field tag");
        this.jTextAreaStat.setColumns(20);
        this.jTextAreaStat.setFont(new Font("Monospaced", 0, 12));
        this.jTextAreaStat.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaStat);
        this.jButtonStat.setText("Start");
        this.jButtonStat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonStatActionPerformed(evt);
            }
        });
        this.jButtonStatCancel.setText("Cancel");
        this.jButtonStatCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonStatCancelActionPerformed(evt);
            }
        });
        GroupLayout jDialogStatLayout = new GroupLayout(this.jDialogStat.getContentPane());
        this.jDialogStat.getContentPane().setLayout(jDialogStatLayout);
        jDialogStatLayout.setHorizontalGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogStatLayout.createSequentialGroup().addContainerGap().addGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 925, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jDialogStatLayout.createSequentialGroup().addComponent(this.jRadioField).addGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogStatLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 658, Short.MAX_VALUE).addComponent(this.jButtonStatCancel, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStat, -2, 91, -2)).addGroup(jDialogStatLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldTag, -2, 54, -2)))).addComponent(this.jRadioButtonDatabase)).addContainerGap()));
        jDialogStatLayout.setVerticalGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogStatLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonDatabase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioField).addComponent(this.jTextFieldTag, -2, -1, -2)).addGap(22, 22, 22).addComponent(this.jScrollPane2, -1, 520, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jDialogStatLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStat).addComponent(this.jButtonStatCancel)).addContainerGap()));
        this.jDialogGizmo.setModal(true);
        this.jDialogGizmo.setResizable(false);
        this.jButtonGizmoCancel.setText("Cancel");
        this.jButtonGizmoOk.setText("OK");
        this.jLabel7.setText("jLabel7");
        this.jButtonOpenGizmo.setText("Open...");
        this.jRadioButtonRecord.setText("Registro inteiro");
        this.jRadioButtonFields.setText("Alguns campos");
        this.jLabel8.setText("Aplica\u00e7\u00e3o do gizmo:");
        this.jLabel9.setText("Gizmo via arquivo:");
        this.jLabel10.setText("Gizmo via campos");
        this.jLabel11.setText("Texto origem:");
        this.jLabel12.setText("Texto destino:");
        GroupLayout jDialogGizmoLayout = new GroupLayout(this.jDialogGizmo.getContentPane());
        this.jDialogGizmo.getContentPane().setLayout(jDialogGizmoLayout);
        jDialogGizmoLayout.setHorizontalGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogGizmoLayout.createSequentialGroup().addContainerGap().addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialogGizmoLayout.createSequentialGroup().addComponent(this.jButtonGizmoOk, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGizmoCancel, -2, 77, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jDialogGizmoLayout.createSequentialGroup().addComponent(this.jLabel7, -1, 667, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOpenGizmo, -2, 72, -2).addContainerGap()).addGroup(jDialogGizmoLayout.createSequentialGroup().addComponent(this.jLabel9).addContainerGap(645, Short.MAX_VALUE)).addGroup(jDialogGizmoLayout.createSequentialGroup().addComponent(this.jLabel8).addContainerGap(635, Short.MAX_VALUE)).addGroup(jDialogGizmoLayout.createSequentialGroup().addComponent(this.jRadioButtonRecord).addContainerGap(643, Short.MAX_VALUE)).addGroup(jDialogGizmoLayout.createSequentialGroup().addComponent(this.jLabel10, -1, 122, Short.MAX_VALUE).addGap(641, 641, 641)).addGroup(jDialogGizmoLayout.createSequentialGroup().addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jDialogGizmoLayout.createSequentialGroup().addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel11).addComponent(this.jTextField2, -1, 353, Short.MAX_VALUE).addComponent(this.jTextField4).addComponent(this.jTextField6).addComponent(this.jTextField8)).addGap(23, 23, 23).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField9).addComponent(this.jTextField7).addComponent(this.jLabel12).addComponent(this.jTextField3, -1, 338, Short.MAX_VALUE).addComponent(this.jTextField5))).addGroup(GroupLayout.Alignment.LEADING, jDialogGizmoLayout.createSequentialGroup().addComponent(this.jRadioButtonFields).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1))).addContainerGap(49, Short.MAX_VALUE)))));
        jDialogGizmoLayout.setVerticalGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialogGizmoLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addGap(12, 12, 12).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jButtonOpenGizmo)).addGap(24, 24, 24).addComponent(this.jLabel8).addGap(12, 12, 12).addComponent(this.jRadioButtonRecord).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogGizmoLayout.createSequentialGroup().addComponent(this.jRadioButtonFields).addGap(44, 44, 44).addComponent(this.jLabel10)).addComponent(this.jTextField1, -2, -1, -2)).addGap(18, 18, 18).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel12)).addGap(13, 13, 13).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jTextField3, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField6, -2, -1, -2).addComponent(this.jTextField7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField8, -2, -1, -2).addComponent(this.jTextField9, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addGroup(jDialogGizmoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonGizmoCancel).addComponent(this.jButtonGizmoOk)).addContainerGap()));
        this.setDefaultCloseOperation(3);
        this.jTextAreaDump.setColumns(20);
        this.jTextAreaDump.setFont(new Font("Arial Unicode MS", 0, 13));
        this.jTextAreaDump.setRows(5);
        this.jScrollPaneDump.setViewportView(this.jTextAreaDump);
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonUpdate.setText("Update");
        this.jButtonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonUpdateActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jLabelMfnBegin.setFont(new Font("Tahoma", 0, 18));
        this.jLabelMfnBegin.setText("0");
        this.jLabelMfnEnd.setFont(new Font("Tahoma", 0, 18));
        this.jLabelMfnEnd.setText("000000");
        this.jButtonOpen.setText("Open...");
        this.jButtonOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonOpenActionPerformed(evt);
            }
        });
        this.jScrollBarMfn.setOrientation(0);
        this.jScrollBarMfn.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                Lupa.this.jScrollBarMfnAdjustmentValueChanged(evt);
            }
        });
        this.jLabelCurMfn.setFont(new Font("Tahoma", 0, 18));
        this.jLabelCurMfn.setHorizontalAlignment(0);
        this.jLabelCurMfn.setText("000000");
        this.jLabelCurMfn.setHorizontalTextPosition(0);
        this.jLabelStatus.setHorizontalAlignment(0);
        this.jLabelStatus.setText("deleted");
        this.jLabelStatus.setHorizontalTextPosition(0);
        this.jButtonCreate.setText("Create...");
        this.jButtonCreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jLabelLock.setIcon(new ImageIcon(this.getClass().getResource("/bruma/tools/lupa/images.jpg")));
        this.jLabelIsisType.setFont(new Font("Tahoma", 0, 10));
        this.jLabelIsisType.setForeground(new Color(0, 0, 153));
        this.jLabelIsisType.setText("Isis Standard");
        this.jLabelDataAlignment.setFont(new Font("Tahoma", 0, 10));
        this.jLabelDataAlignment.setForeground(new Color(0, 0, 153));
        this.jLabelDataAlignment.setText("Data Alignment: 0");
        this.jLabelSwapped.setFont(new Font("Tahoma", 0, 10));
        this.jLabelSwapped.setForeground(new Color(0, 0, 153));
        this.jLabelSwapped.setText("Swapped bytes");
        this.jLabelDbEncoding.setFont(new Font("Tahoma", 0, 10));
        this.jLabelDbEncoding.setForeground(new Color(0, 0, 153));
        this.jLabelDbEncoding.setText("ISO8859-1");
        this.jLabelMaxSize.setFont(new Font("Tahoma", 0, 10));
        this.jLabelMaxSize.setForeground(new Color(0, 0, 153));
        this.jLabelMaxSize.setText("Max size : 00");
        this.jButtonFilter.setText("Filter");
        this.jButtonFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonFilterActionPerformed(evt);
            }
        });
        this.jButtonImport.setText("Import...");
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonImportActionPerformed(evt);
            }
        });
        this.jButtonExport.setText("Export...");
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jButtonRegExp.setText("Search");
        this.jButtonRegExp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonRegExpActionPerformed(evt);
            }
        });
        this.jButtonStatistics.setText("Statistics");
        this.jButtonStatistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Lupa.this.jButtonStatisticsActionPerformed(evt);
            }
        });
        this.jButtonGizmo.setText("Gizmo");
        this.jButtonGizmo.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelLock, -2, 8, -2).addComponent(this.jLabelMaxSize).addComponent(this.jLabelDbEncoding).addComponent(this.jLabelIsisType).addComponent(this.jLabelDataAlignment, -2, 104, -2).addComponent(this.jLabelSwapped).addComponent(this.jLabelStatus, -2, 69, -2).addComponent(this.jLabelCurMfn, -2, 87, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelMfnBegin).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollBarMfn, -1, 628, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMfnEnd).addGap(1, 1, 1)).addComponent(this.jScrollPaneDump, -1, 730, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonGizmo, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOpen, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCreate, GroupLayout.Alignment.CENTER, -2, 99, -2).addComponent(this.jButtonImport, GroupLayout.Alignment.CENTER, -2, 99, -2).addComponent(this.jButtonExport, GroupLayout.Alignment.CENTER, -2, 99, -2).addComponent(this.jButtonNew, GroupLayout.Alignment.CENTER, -2, 100, -2).addComponent(this.jButtonUpdate, GroupLayout.Alignment.CENTER, -2, 100, -2).addComponent(this.jButtonDelete, GroupLayout.Alignment.CENTER, -2, 100, -2).addComponent(this.jButtonFilter, GroupLayout.Alignment.CENTER, -2, 100, -2).addComponent(this.jButtonRegExp, GroupLayout.Alignment.CENTER, -2, 100, -2).addComponent(this.jButtonStatistics, -1, 101, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExport).addGap(22, 22, 22).addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addGap(18, 18, 18).addComponent(this.jButtonFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRegExp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStatistics).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGizmo).addGap(197, 197, 197).addComponent(this.jLabelLock, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jLabelMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDbEncoding).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelIsisType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDataAlignment, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSwapped).addGap(18, 18, 18).addComponent(this.jLabelStatus)).addComponent(this.jScrollPaneDump, -1, 784, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMfnBegin).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMfnEnd).addComponent(this.jLabelCurMfn, -2, 24, -2)).addComponent(this.jScrollBarMfn, -2, 25, -2)).addContainerGap()));
        this.jButtonUpdate.getAccessibleContext().setAccessibleName("jButtonUpdate");
        this.jButtonDelete.getAccessibleContext().setAccessibleName("jButtonDelete");
        this.jLabelMfnBegin.getAccessibleContext().setAccessibleName("jLabelBegin");
        this.jLabelMfnEnd.getAccessibleContext().setAccessibleName("jLabelEnd");
        this.jButtonOpen.getAccessibleContext().setAccessibleName("jButtonOpen");
        this.jButtonFilter.getAccessibleContext().setAccessibleName("jButtonFilter");
        this.pack();
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        if (this.master != null) {
            try {
                if (!this.filterProf.getShowFields().isEmpty()) {
                    throw new BrumaException("'Show all fields' Filter option should be checked.");
                }
                Record rec = Record.fromString(this.jTextAreaDump.getText());
                rec.setMfn(this.mfn);
                this.master.writeRecord(rec);
            }
            catch (BrumaException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Update record error", 0);
            }
        }
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        if (this.master != null) {
            try {
                Record rec = this.master.newRecord();
                rec.addField(1, "new record");
                this.master.writeRecord(rec);
                this.jTextAreaDump.setText("");
                this.jScrollBarMfn.setMaximum(++this.lastMfn);
                this.jLabelMfnBegin.setText("1");
                this.jLabelMfnEnd.setText(Integer.toString(this.lastMfn));
                this.jLabelCurMfn.setText(Integer.toString(this.lastMfn));
                this.mfn = this.lastMfn;
                this.jScrollBarMfn.setValue(this.lastMfn);
            }
            catch (BrumaException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "New record error", 0);
            }
        }
    }

    private void jCheckBoxSwappedActionPerformed(ActionEvent evt) {
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        this.lastOpenProf = this.openProf;
        this.openProf = new OpenProfile();
        this.openProf.setMstDir(this.lastOpenProf.getMstDir());
        this.openProf.setCreate(false);
        this.updateOpen();
        this.jDialogOpenDb.setVisible(true);
    }

    private void jButtonMstOpenActionPerformed(ActionEvent evt) {
        int returnVal;
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Isis Master", "mst");
        File dir = this.openProf.getMstDir();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(dir);
        this.jButtonOk.setEnabled(false);
        int n = returnVal = this.openProf.isCreate() ? chooser.showSaveDialog(this) : chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.openProf.setMaster(chooser.getSelectedFile());
            this.updateOpen();
        } else {
            this.jButtonOk.setEnabled(chooser.getSelectedFile() != null);
        }
    }

    private void jCheckBoxSwappedItemStateChanged(ItemEvent evt) {
        this.openProf.setSwapped(!this.openProf.isSwapped());
    }

    private void jComboBoxEncodingItemStateChanged(ItemEvent evt) {
        this.openProf.setEncoding((String)evt.getItem());
    }

    private void jComboBoxAlignmentItemStateChanged(ItemEvent evt) {
        String[] split = ((String)evt.getItem()).split("\\s+", 2);
        this.openProf.setAlignment(Integer.parseInt(split[0]));
    }

    private void jComboBoxGigaSizeItemStateChanged(ItemEvent evt) {
        String[] split = ((String)evt.getItem()).split("\\s+", 2);
        this.openProf.setGigasize(Integer.parseInt(split[0]));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.openProf = this.lastOpenProf;
        this.lastOpenProf = new OpenProfile();
        this.lastOpenProf.setMstDir(this.openProf.getMstDir());
        this.jDialogOpenDb.setVisible(false);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.openProf.getMaster() == null) {
            this.openProf = this.lastOpenProf;
        }
        this.lastOpenProf = new OpenProfile();
        this.lastOpenProf.setMstDir(this.openProf.getMstDir());
        this.jDialogOpenDb.setVisible(false);
        this.updateFrame();
    }

    private void jScrollBarMfnAdjustmentValueChanged(AdjustmentEvent evt) {
        if (this.master != null) {
            this.mfn = evt.getValue();
            this.showRecord();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.mfn > 0) {
            try {
                this.master.deleteRecord(this.mfn);
                this.showRecord();
            }
            catch (BrumaException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Delete record error", 0);
            }
        }
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.lastOpenProf = this.openProf;
        this.openProf = new OpenProfile();
        this.openProf.setMstDir(this.lastOpenProf.getMstDir());
        this.openProf.setCreate(true);
        this.updateOpen();
        this.jDialogOpenDb.setVisible(true);
    }

    private void jButtonFilterActionPerformed(ActionEvent evt) {
        int num = 0;
        StringBuilder builder = new StringBuilder();
        this.lastFilterProf = this.filterProf;
        this.filterProf = new FilterProfile();
        this.filterProf.setSortFields(this.lastFilterProf.isSortFields());
        Set<Integer> tags = this.lastFilterProf.getShowFields();
        this.filterProf.setShowFields(tags);
        for (Integer tag : tags) {
            if (++num % 10 == 0) {
                builder.append("\n");
            }
            builder.append(tag + " ");
        }
        this.jCheckBoxSortFields.setSelected(this.lastFilterProf.isSortFields());
        this.jCheckBoxShowAll.setSelected(tags.isEmpty());
        this.jTextAreaFields.setText(builder.toString());
        this.jDialogFilter.setVisible(true);
    }

    private void jButtonCancel2ActionPerformed(ActionEvent evt) {
        this.filterProf = this.lastFilterProf;
        this.jDialogFilter.setVisible(false);
    }

    private void jButtonOk2ActionPerformed(ActionEvent evt) {
        String text = this.jTextAreaFields.getText().trim();
        Set<Integer> tags = this.filterProf.getShowFields();
        tags.clear();
        if (!text.isEmpty()) {
            String[] split;
            for (String tag : split = text.split("[^\\d]+")) {
                tags.add(new Integer(tag));
            }
        }
        this.filterProf.setSortFields(this.jCheckBoxSortFields.isSelected());
        this.jDialogFilter.setVisible(false);
        this.showRecord();
    }

    private void jCheckBoxShowAllItemStateChanged(ItemEvent evt) {
        if (this.jCheckBoxShowAll.isSelected()) {
            this.jTextAreaFields.setText("");
        }
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        this.jInputFileLabel.setText("");
        this.jLabelOutputDb.setText("");
        this.jComboBoxCharEncoding.setSelectedItem("ISO-8859-1 or IBM850");
        this.jButtonImportOk.setEnabled(false);
        this.jDialogImport.setVisible(true);
    }

    private void jButtonImportCancelActionPerformed(ActionEvent evt) {
        this.jInputFileLabel.setText("");
        this.jLabelOutputDb.setText("");
        this.jDialogImport.setVisible(false);
        this.clearFrame();
    }

    private void jButtonOpenImportActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filterIso = new FileNameExtensionFilter("Import file ISO2709", "iso");
        FileNameExtensionFilter filterId = new FileNameExtensionFilter("Import file ID", "id");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(filterIso);
        chooser.addChoosableFileFilter(filterId);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.jInputFileLabel.setText(chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Open file error", 0);
            }
            this.jButtonImportOk.setEnabled(!this.jInputFileLabel.getText().isEmpty() && !this.jLabelOutputDb.getText().isEmpty());
        }
    }

    private void jButtonImportOkActionPerformed(ActionEvent evt) {
        String fName = this.jInputFileLabel.getText();
        String encoding = (String)this.jComboBoxCharEncoding.getSelectedItem();
        AbstractRecordIterator iterator = fName.endsWith(".iso") ? new ISO2709RecordIterator(fName, encoding) : new IdFileRecordIterator(new File(fName), encoding);
        int auxmfn = 0;
        try {
            if (iterator == null) {
                throw new BrumaException("open import file error");
            }
            for (Record rec : iterator) {
                rec.setMfn(++auxmfn);
                this.master.writeRecord(rec);
            }
            this.lastMfn = this.master.getControlRecord().getNxtmfn() - 1;
            this.mfn = 1;
            this.jScrollBarMfn.setMinimum(1);
            this.jScrollBarMfn.setMaximum(this.lastMfn);
            this.jLabelMfnBegin.setText("1");
            this.jLabelMfnEnd.setText(Integer.toString(this.lastMfn));
            this.jLabelCurMfn.setText("1");
            this.jLabelDbEncoding.setText(this.master.getEncoding());
            this.jLabelMaxSize.setText("Max size: " + this.master.getGigaSize());
            this.jLabelIsisType.setText(this.master.isFFI() ? "Isis FFI" : "Isis Standard");
            this.jLabelDataAlignment.setText("Data alignment: " + this.master.getDataAlignment());
            this.jLabelSwapped.setText(this.master.isSwapped() ? "Swapped bytes" : "Direct bytes");
            this.jScrollBarMfn.setValue(1);
            this.jDialogImport.setVisible(false);
            this.filterProf = new FilterProfile();
            this.lastFilterProf = null;
            this.showRecord();
        }
        catch (BrumaException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Import file error", 0);
        }
    }

    private void jButtonPrevHitActionPerformed(ActionEvent evt) {
        if (this.search != null && this.search.hasPrevious()) {
            this.jScrollBarMfn.setValue(this.search.getPrevious());
            this.jLabelHitsFound.setText("Hits:" + (this.search.getCurrent() + 1) + "/" + this.search.numOfHits());
        }
    }

    private void jButtonRegExpActionPerformed(ActionEvent evt) {
        this.jTextFieldSearch.setText("");
        this.jCheckBoxIgnoreCase.setSelected(false);
        this.jCheckBoxRegExp.setSelected(false);
        this.jTextFieldSearchTags.setText("");
        this.jCheckBoxAllTags.setSelected(true);
        this.jLabelHitsFound.setText("");
        this.jDialogSearch.setVisible(true);
    }

    private void jButtonSearchCancelActionPerformed(ActionEvent evt) {
        this.jDialogSearch.setVisible(false);
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        String exp = this.jTextFieldSearch.getText().trim();
        if (!exp.isEmpty() && this.master != null) {
            String content;
            HashSet<Integer> tags = null;
            if (!this.jCheckBoxAllTags.isSelected() && !(content = this.jTextFieldSearchTags.getText().trim()).isEmpty()) {
                tags = new HashSet<Integer>();
                for (String tag : content.split("[^\\d]+")) {
                    tags.add(Integer.valueOf(tag));
                }
            }
            try {
                if (this.search == null) {
                    this.search = new Search(this.master);
                }
                if (this.jCheckBoxRegExp.isSelected()) {
                    this.search.searchRegExp(exp, tags, this.jCheckBoxIgnoreCase.isSelected());
                } else {
                    this.search.search(exp, tags, this.jCheckBoxIgnoreCase.isSelected());
                }
                if (this.search.hasNext()) {
                    this.jScrollBarMfn.setValue(this.search.getNext());
                }
                this.jLabelHitsFound.setText("Hits:" + (this.search.getCurrent() + 1) + "/" + this.search.numOfHits());
            }
            catch (BrumaException zex) {
                JOptionPane.showMessageDialog(this, zex.getMessage(), "Search error", 0);
            }
        }
    }

    private void jButtonNextHitActionPerformed(ActionEvent evt) {
        if (this.search != null && this.search.hasNext()) {
            this.jScrollBarMfn.setValue(this.search.getNext());
            this.jLabelHitsFound.setText("Hits:" + (this.search.getCurrent() + 1) + "/" + this.search.numOfHits());
        }
    }

    private void jButtonOutputDbActionPerformed(ActionEvent evt) {
        this.jButtonCreateActionPerformed(null);
        if (this.openProf == this.lastOpenProf) {
            this.jLabelOutputDb.setText("");
        } else {
            this.jLabelOutputDb.setText(this.openProf.getMaster().getPath());
        }
        this.jButtonImportOk.setEnabled(!this.jInputFileLabel.getText().isEmpty() && !this.jLabelOutputDb.getText().isEmpty());
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.master != null) {
            this.jLabelExportFile.setText("");
            this.jComboBoxExportEncoding.setSelectedItem("ISO-8859-1");
            this.jLabelExportAlignment.setVisible(true);
            this.jComboBoxExportAlignment.setVisible(true);
            this.jLabelExportMstSize.setVisible(true);
            this.jComboBoxExportMstSize.setVisible(true);
            this.jCheckBoxExportSwapped.setVisible(true);
            this.jLabelExportAlignment.setVisible(false);
            this.jComboBoxExportAlignment.setVisible(false);
            this.jLabelExportMstSize.setVisible(false);
            this.jComboBoxExportMstSize.setVisible(false);
            this.jCheckBoxExportSwapped.setVisible(false);
            this.jCheckBoxExportFFI.setVisible(false);
            this.jCheckBoxExportDeleted.setVisible(false);
            this.jDialogExport.setSize(new Dimension(650, 220));
            this.jDialogExport.setVisible(true);
        }
    }

    private void jButtonExportOpenActionPerformed(ActionEvent evt) {
        String auxName;
        FileNameExtensionFilter filterIsis = new FileNameExtensionFilter("Isis Master", "mst");
        FileNameExtensionFilter filterIso = new FileNameExtensionFilter("ISO 2708", "iso");
        FileNameExtensionFilter filterId = new FileNameExtensionFilter("Id File", "id");
        FileNameExtensionFilter filterXml = new FileNameExtensionFilter("XML", "xml");
        FileNameExtensionFilter filterJSON = new FileNameExtensionFilter("JSON", "json");
        File dir = this.openProf.getMstDir();
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(filterIso);
        chooser.addChoosableFileFilter(filterId);
        chooser.addChoosableFileFilter(filterXml);
        chooser.addChoosableFileFilter(filterJSON);
        chooser.setFileFilter(filterIsis);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(dir);
        this.jButtonExportOk.setEnabled(false);
        chooser.showSaveDialog(this);
        FileNameExtensionFilter filter = (FileNameExtensionFilter)chooser.getFileFilter();
        try {
            auxName = chooser.getSelectedFile() == null ? "" : chooser.getSelectedFile().getCanonicalPath();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ioe.getMessage(), null, 0);
            auxName = "";
        }
        String selectedExtension = filter.getExtensions()[0];
        String selectedFile = auxName.matches("[^\\.]+\\.[^\\.]+") ? auxName : (auxName.isEmpty() ? auxName : auxName + "." + selectedExtension);
        this.jLabelExportFile.setText(selectedFile);
        if (selectedFile.endsWith(".mst")) {
            this.jLabelExportAlignment.setVisible(true);
            this.jComboBoxExportAlignment.setVisible(true);
            this.jLabelExportMstSize.setVisible(true);
            this.jComboBoxExportMstSize.setVisible(true);
            this.jCheckBoxExportSwapped.setVisible(true);
            this.jCheckBoxExportFFI.setVisible(true);
            this.jCheckBoxExportDeleted.setVisible(true);
            this.jDialogExport.setSize(new Dimension(650, 335));
        } else {
            this.jLabelExportAlignment.setVisible(false);
            this.jComboBoxExportAlignment.setVisible(false);
            this.jLabelExportMstSize.setVisible(false);
            this.jComboBoxExportMstSize.setVisible(false);
            this.jCheckBoxExportSwapped.setVisible(false);
            this.jCheckBoxExportFFI.setVisible(false);
            this.jCheckBoxExportDeleted.setVisible(false);
            this.jDialogExport.setSize(new Dimension(650, 220));
        }
        this.jButtonExportOk.setEnabled(!selectedFile.isEmpty());
    }

    private void jButtonExportOkActionPerformed(ActionEvent evt) {
        String selectedFile = this.jLabelExportFile.getText();
        String selectedExtension = selectedFile.substring(selectedFile.lastIndexOf(46) + 1);
        if (!selectedFile.isEmpty()) {
            this.exportDatabase(selectedFile, selectedExtension);
        }
        this.jDialogExport.setVisible(false);
    }

    private void jButtonExportCancelActionPerformed(ActionEvent evt) {
        this.jDialogExport.setVisible(false);
    }

    private void jButtonStatisticsActionPerformed(ActionEvent evt) {
        this.jTextAreaStat.setText("");
        this.jDialogStat.setVisible(true);
    }

    private void jRadioButtonDatabaseItemStateChanged(ItemEvent evt) {
        this.jTextFieldTag.setText(null);
    }

    private void jButtonStatActionPerformed(ActionEvent evt) {
        String out = "";
        Statistics stat = new Statistics();
        try {
            if (this.jRadioButtonDatabase.isSelected()) {
                if (this.master != null) {
                    out = stat.stat(this.master.getMasterName(), this.master.getEncoding(), 1, Integer.MAX_VALUE, 0);
                }
            } else if (!this.jTextFieldTag.getText().isEmpty()) {
                int tag = Integer.parseInt(this.jTextFieldTag.getText());
                out = stat.tab(this.master.getMasterName(), this.master.getEncoding(), 1, Integer.MAX_VALUE, tag, 0);
            }
        }
        catch (Exception ex) {
            out = ex.toString();
        }
        this.jTextAreaStat.setText(out);
    }

    private void jButtonStatCancelActionPerformed(ActionEvent evt) {
        this.jDialogStat.setVisible(false);
    }

    private void jCheckBoxAllTagsStateChanged(ChangeEvent evt) {
    }

    private void jTextFieldSearchTagsInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void exportDatabase(String outFile, String extension) {
        assert (outFile != null);
        assert (extension != null);
        AbstractMasterExport export = null;
        String toEncoding = (String)this.jComboBoxExportEncoding.getSelectedItem();
        try {
            if (extension.equals("mst")) {
                int dataAlignment = Integer.parseInt(((String)this.jComboBoxExportAlignment.getSelectedItem()).split("\\s+", 2)[0]);
                int maxGigaSize = Integer.parseInt(((String)this.jComboBoxExportMstSize.getSelectedItem()).split("\\s+", 2)[0]);
                export = new IsisMasterExport(this.master, outFile, this.jCheckBoxExportFFI.isSelected(), dataAlignment, toEncoding, maxGigaSize, this.jCheckBoxExportSwapped.isSelected(), this.jCheckBoxExportDeleted.isSelected());
            } else if (extension.equals("iso")) {
                export = new ISO2709Export(this.master, outFile, toEncoding);
            } else if (extension.equals("id")) {
                export = new IdMasterExport(this.master, outFile, toEncoding);
            } else if (extension.equals("xml")) {
                export = new XmlMasterExport(this.master, outFile, toEncoding, true);
            } else if (extension.equals("json")) {
                export = new JSONMasterExport(this.master, outFile, toEncoding, true, 0);
            }
            if (export != null) {
                export.export(-1);
            }
        }
        catch (BrumaException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Export error", 0);
        }
        this.jDialogExport.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Lupa().setVisible(true);
            }
        });
    }
}

