/*
 * Decompiled with CFR 0.152.
 */
package bruma.tools.lupa;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Search {
    public static final int MAX_HITS = 1000;
    private final Master mst;
    private final List<Integer> hits;
    private int max;
    private int current;
    private Matcher mat;

    public Search(Master mst) throws BrumaException {
        if (mst == null) {
            throw new BrumaException("null master");
        }
        this.mst = mst;
        this.hits = new ArrayList<Integer>();
        this.clear();
    }

    private void clear() {
        this.max = 0;
        this.current = -1;
        this.mat = null;
        this.hits.clear();
    }

    public void searchRegExp(String exp, Set<Integer> tags, boolean ignoreCase) throws BrumaException {
        if (exp == null) {
            throw new BrumaException("null expression");
        }
        this.clear();
        this.mat = Pattern.compile(exp, ignoreCase ? 2 : 0).matcher("");
        for (Record rec : this.mst) {
            if (rec.getStatus() == Record.Status.ACTIVE) {
                for (Field fld : rec) {
                    if (tags != null && !tags.contains(fld.getId())) continue;
                    this.mat.reset(fld.getContent());
                    if (!this.mat.find() || this.max >= 1000) continue;
                    this.hits.add(rec.getMfn());
                    ++this.max;
                    break;
                }
            }
            if (this.max != 1000) continue;
            break;
        }
    }

    public void search(String exp, Set<Integer> tags, boolean ignoreCase) throws BrumaException {
        this.searchRegExp(Pattern.quote(exp), tags, ignoreCase);
    }

    public int numOfHits() {
        return this.hits.size();
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean hasNext() {
        return this.current < this.max - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public int getNext() {
        int ret = -1;
        if (this.hasNext()) {
            ret = this.hits.get(++this.current);
        }
        return ret;
    }

    public int getPrevious() {
        int ret = -1;
        if (this.hasPrevious()) {
            ret = this.hits.get(--this.current);
        }
        return ret;
    }
}

