/*
 * Decompiled with CFR 0.152.
 */
package bruma.utils;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gizmo {
    private ElementCollection elemCol;
    private Pattern pat;

    public Gizmo(String in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        this.elemCol = new ElementCollection();
        this.pat = Pattern.compile("\\[([^\\,]+),([^\\]]+)");
        this.insertConvertion(in);
    }

    public Gizmo(File in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String line = null;
        this.elemCol = new ElementCollection();
        this.pat = Pattern.compile("\\[([^\\,]+),([^\\]]+)");
        while ((line = reader.readLine()) != null) {
            this.insertConvertion(line);
        }
        reader.close();
    }

    private void insertConvertion(String in) {
        assert (in != null);
        Matcher mat = this.pat.matcher(in);
        int index = 0;
        while (mat.find()) {
            this.elemCol.addElement(new Element(mat.group(1), mat.group(2), --index));
        }
    }

    public String gizmo(String in) throws BrumaException {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        Element elem = null;
        int len = 0;
        int curPos = 0;
        if (in == null) {
            throw new BrumaException("null in");
        }
        if (in.length() > 0) {
            this.elemCol.reset();
            this.elemCol.adjustElements(in, curPos);
            while (this.elemCol.total() > 0) {
                if (first) {
                    first = false;
                } else {
                    out.append("\n");
                }
                elem = this.elemCol.getLower();
                if (elem.begin > curPos) {
                    out.append(in, curPos, elem.begin);
                }
                out.append(elem.toKey);
                curPos = elem.end + 1;
                this.elemCol.adjustElements(in, curPos);
            }
            if (curPos < len - 1) {
                out.append(in, curPos, len);
            }
        }
        return out.toString();
    }

    public Record gizmoFields(int[] tags, Record rec) throws BrumaException {
        if (tags == null) {
            throw new BrumaException("null tags");
        }
        if (rec == null) {
            throw new BrumaException("null rec");
        }
        Record out = new Record();
        for (Field fld : rec) {
            int tag = fld.getId();
            String field = fld.getContent();
            if (Arrays.binarySearch(tags, tag) > 0) {
                field = this.gizmo(field);
            }
            out.addField(tag, field);
        }
        return out;
    }

    public Record gizmoRecord(Record rec) throws BrumaException {
        if (rec == null) {
            throw new BrumaException("null rec");
        }
        Record out = new Record();
        for (Field fld : rec) {
            out.addField(fld.getId(), this.gizmo(fld.getContent()));
        }
        return out;
    }

    private class ElementCollection {
        private List<Element> list = new ArrayList<Element>();
        private int total = 0;

        ElementCollection() {
        }

        void addElement(Element elem) {
            assert (elem != null);
            this.list.add(elem);
        }

        void reset() {
            for (Element elem : this.list) {
                elem.begin = -1;
                elem.end = elem.begin + elem.len - 1;
            }
        }

        Element getLower() {
            Element ret = null;
            int min = Integer.MAX_VALUE;
            int begin = 0;
            for (Element elem : this.list) {
                begin = elem.begin;
                if (begin < 0 || begin >= min) continue;
                min = begin;
                ret = elem;
                break;
            }
            return ret;
        }

        Element getSamePos(int pos) {
            assert (pos >= 0);
            Element ret = null;
            for (Element elem : this.list) {
                if (elem.begin != pos) continue;
                ret = elem;
                break;
            }
            return ret;
        }

        int total() {
            return this.total;
        }

        void adjustElements(String in, int initPos) {
            assert (in != null);
            assert (initPos >= 0);
            for (Element elem : this.list) {
                this.adjustElement(in, initPos, elem);
            }
        }

        void adjustElement(String in, int initPos, Element elem) {
            assert (in != null);
            assert (elem != null);
            assert (initPos >= 0);
            Element other = null;
            for (int pos = initPos; elem.begin < pos; pos += other.len) {
                if ((pos = in.indexOf(elem.fromKey, pos)) == -1) {
                    if (elem.begin >= 0 && this.total > 0) {
                        --this.total;
                    }
                    elem.setBegin(-1);
                    break;
                }
                other = this.getSamePos(pos);
                if (other != null && elem.fromKey.compareTo(other.fromKey) <= 0) continue;
                if (elem.begin < 0) {
                    ++this.total;
                }
                elem.setBegin(pos);
                if (other == null) break;
                this.adjustElement(in, elem.end + 1, other);
                break;
            }
        }
    }

    private class Element {
        String fromKey;
        String toKey;
        int begin;
        int end;
        int len;

        Element(String fromKey, String toKey, int beginPos) {
            assert (fromKey != null);
            assert (toKey != null);
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.setBegin(beginPos);
        }

        void setBegin(int beginPos) {
            this.begin = beginPos;
            this.len = this.fromKey.length();
            this.end = this.begin + this.len - 1;
        }
    }
}

