/*
 * Decompiled with CFR 0.152.
 */
package bruma.utils;

import bruma.BrumaException;
import bruma.master.Field;
import bruma.master.Master;
import bruma.master.MasterFactory;
import bruma.master.Record;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public class ISO8859OrIBM850 {
    public static final int[] values_8859_1 = new int[]{192, 193, 194, 195, 196, 197, 200, 201, 202, 203, 204, 205, 206, 207, 209, 213, 217, 218, 219, 220, 221, 225, 231, 232, 238, 239, 241, 242, 243, 244, 245, 246, 249, 250, 251, 251};
    public static final int[] values_850 = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 144, 147, 148, 149, 150, 151, 152, 153, 154, 160, 161, 162, 163, 164, 165, 181, 182, 183, 198, 215, 216, 229};
    public static final int DIFF_RANGE = 20;
    public static final int SMART_MAX_CHECKED = 50000;
    int count_8859_1;
    int count_850;
    int count_rec;
    final boolean smart;
    final String mstName;
    final Set<Integer> set_88591;
    final Set<Integer> set_850;

    public ISO8859OrIBM850(String mstName, boolean smart) throws BrumaException {
        if (mstName == null) {
            throw new BrumaException("null master name");
        }
        this.count_8859_1 = 0;
        this.count_850 = 0;
        this.count_rec = 0;
        this.set_88591 = new HashSet<Integer>();
        this.set_850 = new HashSet<Integer>();
        this.mstName = mstName;
        this.smart = smart;
        for (int value : values_8859_1) {
            this.set_88591.add(value);
        }
        for (int value : values_850) {
            this.set_850.add(value);
        }
    }

    public int get88591Count() {
        return this.count_8859_1;
    }

    public int get850Count() {
        return this.count_850;
    }

    public String guessEncoding() throws BrumaException {
        Master mst = MasterFactory.getInstance(this.mstName).setEncoding("ISO-8859-1").open();
        this.count_rec = 0;
        for (Record rec : mst) {
            if (rec.getStatus() == Record.Status.ACTIVE) {
                if (this.smart) {
                    ++this.count_rec;
                }
                for (Field fld : rec) {
                    this.addText(fld.getContent());
                }
            }
            if (!this.smart || !this.canGuess()) continue;
            break;
        }
        mst.close();
        Charset encoding = this.guessResult();
        return encoding == null ? null : encoding.displayName();
    }

    private boolean canGuess() {
        return this.count_rec > 50000 || Math.abs(this.count_8859_1 - this.count_850) > 20;
    }

    private Charset guessResult() {
        Charset ret = null;
        if (this.canGuess()) {
            ret = this.count_8859_1 < this.count_850 ? Charset.forName("IBM850") : Charset.forName("ISO8859-1");
        }
        return ret;
    }

    private void addText(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char val = str.charAt(pos);
            if (this.set_88591.contains(val)) {
                ++this.count_8859_1;
                continue;
            }
            if (!this.set_850.contains(val)) continue;
            ++this.count_850;
        }
    }

    private static void usage() {
        System.err.println("usage: Iso8859Or850 <dbname> [--smart]");
        System.exit(1);
    }

    public static void main(String[] args) throws BrumaException {
        if (args.length < 1) {
            ISO8859OrIBM850.usage();
        }
        boolean smart = args.length > 1 && args[1].equals("--smart");
        ISO8859OrIBM850 what = new ISO8859OrIBM850(args[0], smart);
        System.out.println("Possible encoding: " + what.guessEncoding());
    }
}

